/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.ui;

import com.gc5.iSMA_IO.devices.BIsmaCommonIoDevice;
import com.gc5.iSMA_IO.devices.BIsmaIoDevice;
import com.gc5.iSMA_IO.devices.BIsmaRemoteDevice;
import com.gc5.iSMA_IO.devices.DeviceTypes;
import com.gc5.iSMA_IO.points.BAnalogOutputProxyExt;
import com.gc5.iSMA_IO.points.BDigitalInputCounterProxyExt;
import com.gc5.iSMA_IO.points.BDigitalInputProxyExt;
import com.gc5.iSMA_IO.points.BDigitalOutputProxyExt;
import com.gc5.iSMA_IO.points.BDigitalUniversalInputProxyExt;
import com.gc5.iSMA_IO.points.BIsmaInputProxyExt;
import com.gc5.iSMA_IO.points.BIsmaIoDigitalInputCounterPoint;
import com.gc5.iSMA_IO.points.BIsmaIoProxyExt;
import com.gc5.iSMA_IO.points.BIsmaOutputProxyExt;
import com.gc5.iSMA_IO.points.BIsmaSwitchBaseProxyExt;
import com.gc5.iSMA_IO.points.BModbusProxyExt;
import com.gc5.iSMA_IO.points.BNumericPointProxyExt;
import com.gc5.iSMA_IO.points.BPointFolder;
import com.gc5.iSMA_IO.points.BUniversalInputProxyExt;
import java.util.ArrayList;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTagDictionary;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;
import javax.baja.workbench.mgr.folder.FolderModel;
import javax.baja.workbench.mgr.folder.FolderState;

@NiagaraType(agent={@AgentOn(types={"iSMA_IO:IsmaIoDevice", "iSMA_IO:PointFolder"})})
public class BIsmaPointManager
extends BPointManager {
    public static final Type TYPE = Sys.loadType(BIsmaPointManager.class);

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new PointModel(this);
    }

    protected MgrController makeController() {
        return new PointController(this);
    }

    protected MgrState makeState() {
        return new PointState();
    }

    protected MgrTagDictionary makeTagDictionary() {
        return null;
    }

    public Type getTargetType() {
        return BControlPoint.TYPE;
    }

    protected void selectMatchingTag(int learnRow) {
    }

    class IsmaPointBaseMgrColumnProp
    extends MgrColumn.Prop {
        IsmaPointBaseMgrColumnProp(Property prop, int flags) {
            super(prop, flags);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows != null) {
                for (int i = 1; i < rows.length; ++i) {
                    BComponent baseComp = rows[i].getTarget();
                    if (baseComp instanceof BControlPoint && ((BControlPoint)baseComp).getProxyExt() != null && ((BControlPoint)baseComp).getProxyExt().getType().is(((BControlPoint)rows[0].getTarget()).getProxyExt().getType())) continue;
                    return null;
                }
                return super.toEditor(rows, colIndex, currentEditor);
            }
            return null;
        }
    }

    class IsmaPointMgrColumnProp
    extends MgrColumn.Prop {
        BComplex myProxyExtCplx;
        boolean singleEdit;

        IsmaPointMgrColumnProp(Property[] props, int flags) {
            super(props[0], flags);
            this.singleEdit = false;
            this.props = props;
        }

        IsmaPointMgrColumnProp(String name, Property[] props, int flags) {
            super(name, props[0], flags);
            this.singleEdit = false;
            this.props = props;
        }

        IsmaPointMgrColumnProp(String name, Property[] props, int flags, boolean singleEdit) {
            super(name, props[0], flags);
            this.singleEdit = false;
            this.props = props;
            this.singleEdit = singleEdit;
        }

        boolean updatePropAndCheckProp(BComplex c) {
            BValue myProxyExt = c.get(BControlPoint.proxyExt);
            if (myProxyExt != null && myProxyExt instanceof BComplex) {
                BComplex proxyExtCplx = (BComplex)myProxyExt;
                for (Property p : this.props) {
                    if (!proxyExtCplx.getType().is(p.getDeclaringType()) || proxyExtCplx.getProperty(p.getName()) == null) continue;
                    this.prop = p;
                    this.myProxyExtCplx = proxyExtCplx;
                    return true;
                }
            }
            return false;
        }

        public Object get(Object row) {
            BComplex complex = (BComplex)row;
            if (this.updatePropAndCheckProp(complex)) {
                return this.myProxyExtCplx.get(this.prop).newCopy();
            }
            return BString.make((String)"");
        }

        public BValue load(MgrEditRow row) {
            if (this.updatePropAndCheckProp((BComplex)row.getTarget())) {
                return this.myProxyExtCplx.get(this.prop).newCopy();
            }
            return BString.make((String)"");
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows != null) {
                if (this.singleEdit && rows.length > 1) {
                    return null;
                }
                if (this.updatePropAndCheckProp((BComplex)rows[0].getTarget())) {
                    for (int i = 1; i < rows.length; ++i) {
                        BComponent baseComp = rows[i].getTarget();
                        if (baseComp instanceof BControlPoint && ((BControlPoint)baseComp).getProxyExt() != null && ((BControlPoint)baseComp).getProxyExt().getProperty(this.prop.getName()) != null && ((BControlPoint)baseComp).getProxyExt().getType().is(((BControlPoint)rows[0].getTarget()).getProxyExt().getType())) continue;
                        return null;
                    }
                    return super.toEditor(rows, colIndex, currentEditor);
                }
            }
            return null;
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            if (row instanceof BComplex && this.updatePropAndCheckProp((BComplex)row)) {
                return super.toDisplayString(row, value, cx);
            }
            return "";
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BComponent target;
            BValue old;
            if (this.updatePropAndCheckProp((BComplex)row.getTarget()) && this.myProxyExtCplx instanceof BComponent && !(old = (target = (BComponent)this.myProxyExtCplx).get(this.prop)).equivalent((Object)value)) {
                target.set(this.prop, value.newCopy(), cx);
            }
        }
    }

    class IsmaPointMgrColumnOut
    extends MgrColumn.ToString {
        protected IsmaPointMgrColumnOut(String displayName, int flags) {
            super(displayName, flags);
        }

        public Object get(Object row) {
            if (row instanceof BComplex && !((BComplex)row).getType().is(BPointFolder.TYPE)) {
                return ((BComponent)row).toString((Context)null);
            }
            return BString.make((String)"");
        }
    }

    class PointType {
        private MgrTypeInfo mgrTypeInfo;
        private String name;

        PointType(MgrTypeInfo mgrTypeInfo, String name) {
            this.mgrTypeInfo = mgrTypeInfo;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public MgrTypeInfo getMgrTypeInfo() {
            return this.mgrTypeInfo;
        }
    }

    class PointState
    extends FolderState {
    }

    class PointModel
    extends FolderModel {
        final PointType DIGITAL_INPUT;
        final PointType DIGITAL_OUTPUT;
        final PointType UNIVERSAL_INPUT;
        final PointType ANALOG_OUTPUT;
        final PointType DIGITAL_INPUT_COUNTER;
        final PointType DIGITAL_UNIVERSAL_INPUT;
        private ArrayList<PointType> PointTypeList;
        private int selectedIndex;
        String lexOut;
        Type proxyExtType;
        Type pointFolderType;
        boolean hasIoPoints;
        boolean isLocalDevice;

        public PointModel(BIsmaPointManager manager) {
            super((BFolderManager)manager);
            this.DIGITAL_INPUT = new PointType(MgrTypeInfo.make((BComponent)new BBooleanPoint()), "DigitalInput");
            this.DIGITAL_OUTPUT = new PointType(MgrTypeInfo.make((BComponent)new BBooleanWritable()), "DigitalOutput");
            this.UNIVERSAL_INPUT = new PointType(MgrTypeInfo.make((BComponent)new BNumericPoint()), "UniversalInput");
            this.ANALOG_OUTPUT = new PointType(MgrTypeInfo.make((BComponent)new BNumericWritable()), "AnalogOutput");
            this.DIGITAL_INPUT_COUNTER = new PointType(MgrTypeInfo.make((BComponent)new BNumericPoint()), "DigitalInputCounter");
            this.DIGITAL_UNIVERSAL_INPUT = new PointType(MgrTypeInfo.make((BComponent)new BBooleanWritable()), "DigitalUniversalInput");
            this.selectedIndex = -1;
            this.hasIoPoints = true;
            this.isLocalDevice = false;
            this.lexOut = "Out";
            this.proxyExtType = BIsmaIoProxyExt.TYPE;
            this.pointFolderType = BPointFolder.TYPE;
        }

        protected String makeTableTitle() {
            return TYPE.getDisplayName((Context)null);
        }

        public Type getFolderType() {
            return this.pointFolderType;
        }

        public Type getBaseNewType() {
            return BControlPoint.TYPE;
        }

        public int getSubscribeDepth() {
            return 2;
        }

        public int getSelectedIndex() {
            return this.selectedIndex;
        }

        public void setSelectedIndex(int selectedIndex) {
            this.selectedIndex = selectedIndex;
        }

        public ArrayList<PointType> getPointTypeList() {
            return this.PointTypeList;
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Path(2), new MgrColumn.Name(), new MgrColumn.Type(), new IsmaPointMgrColumnOut(this.lexOut, 0), new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BIsmaIoProxyExt.enabled}, 3), new IsmaPointBaseMgrColumnProp(BControlPoint.facets, 3), new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BIsmaIoProxyExt.status}, 6), new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BIsmaIoProxyExt.faultCause}, 4), new IsmaPointMgrColumnProp("Address", new Property[]{BIsmaInputProxyExt.inputNumber, BIsmaOutputProxyExt.outputNumber, BModbusProxyExt.dataAddress}, 1, true), new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BIsmaIoProxyExt.pollFrequency}, 3), new IsmaPointMgrColumnProp("Work type", new Property[]{BUniversalInputProxyExt.inputType, BAnalogOutputProxyExt.AnalogType, BNumericPointProxyExt.dataType}, 3), new IsmaPointMgrColumnProp(new Property[]{BUniversalInputProxyExt.resolution}, 3), new IsmaPointMgrColumnProp(new Property[]{BUniversalInputProxyExt.filterTime}, 3), new IsmaPointMgrColumnProp(new Property[]{BUniversalInputProxyExt.resistanceOffset}, 3), new IsmaPointMgrColumnProp(new Property[]{BUniversalInputProxyExt.linearConversion, BAnalogOutputProxyExt.linearConversion, BNumericPointProxyExt.linearConversion}, 3), new IsmaPointMgrColumnProp("Polarity Conversion", new Property[]{BUniversalInputProxyExt.polarityConversion, BDigitalInputProxyExt.polarityConversion, BDigitalOutputProxyExt.polarityConversion}, 3)};
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BControlPoint.TYPE, this.pointFolderType};
        }

        public boolean accept(BComponent c) {
            return c instanceof BControlPoint ? ((BControlPoint)c).getProxyExt().getType().is(this.proxyExtType) && !((BControlPoint)c).getProxyExt().getType().is(BIsmaSwitchBaseProxyExt.TYPE) : true;
        }

        public void load(BComponent target) {
            BComplex parent;
            this.proxyExtType = BIsmaIoProxyExt.TYPE;
            this.pointFolderType = BPointFolder.TYPE;
            BComponent parentComponent = target;
            while (parentComponent != null && !parentComponent.getType().is(BIsmaCommonIoDevice.TYPE) && (parent = parentComponent.getParent()) != null) {
                parentComponent = parent.getParentComponent();
            }
            if (parentComponent instanceof BIsmaRemoteDevice) {
                this.hasIoPoints = DeviceTypes.hasIO((String)((BIsmaRemoteDevice)parentComponent).getDeviceType());
            }
            this.isLocalDevice = parentComponent instanceof BIsmaIoDevice;
            super.load(target);
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BBooleanPoint pt = null;
            BNullProxyExt ext = new BNullProxyExt();
            if (this.getSelectedIndex() == this.getPointTypeList().indexOf(this.DIGITAL_INPUT)) {
                pt = new BBooleanPoint();
                ext = new BDigitalInputProxyExt();
            } else if (this.getSelectedIndex() == this.getPointTypeList().indexOf(this.DIGITAL_OUTPUT)) {
                pt = new BBooleanWritable();
                ext = new BDigitalOutputProxyExt();
            } else if (this.getSelectedIndex() == this.getPointTypeList().indexOf(this.UNIVERSAL_INPUT)) {
                pt = new BNumericPoint();
                ext = new BUniversalInputProxyExt();
            } else if (this.getSelectedIndex() == this.getPointTypeList().indexOf(this.ANALOG_OUTPUT)) {
                pt = new BNumericWritable();
                ext = new BAnalogOutputProxyExt();
            } else if (this.getSelectedIndex() == this.getPointTypeList().indexOf(this.DIGITAL_INPUT_COUNTER)) {
                pt = new BIsmaIoDigitalInputCounterPoint();
                ext = new BDigitalInputCounterProxyExt();
            } else if (this.getSelectedIndex() == this.getPointTypeList().indexOf(this.DIGITAL_UNIVERSAL_INPUT)) {
                pt = new BBooleanPoint();
                ext = new BDigitalUniversalInputProxyExt();
            }
            pt.setProxyExt((BAbstractProxyExt)ext);
            return pt;
        }

        public MgrTypeInfo[] getNewTypes() {
            this.PointTypeList = new ArrayList();
            if (this.hasIoPoints) {
                this.PointTypeList.add(this.DIGITAL_INPUT);
                this.PointTypeList.add(this.DIGITAL_OUTPUT);
                this.PointTypeList.add(this.UNIVERSAL_INPUT);
                this.PointTypeList.add(this.ANALOG_OUTPUT);
                this.PointTypeList.add(this.DIGITAL_INPUT_COUNTER);
                this.PointTypeList.add(this.DIGITAL_UNIVERSAL_INPUT);
            }
            ArrayList<MgrTypeInfo> list = new ArrayList<MgrTypeInfo>();
            for (PointType p : this.PointTypeList) {
                list.add(p.getMgrTypeInfo());
            }
            return list.toArray(new MgrTypeInfo[list.size()]);
        }

        void mapPointFacets(MgrEditRow row, MgrColumn col, Object source) {
            BFacets orig = (BFacets)row.getCell(col);
            BFacets facets = this.mapPointFacets(orig, source);
            row.setCell(col, (BValue)facets);
        }

        BFacets mapPointFacets(BFacets orig, Object source) {
            if (source instanceof BIBoolean) {
                return ((BIBoolean)source).getBooleanFacets();
            }
            if (source instanceof BINumeric) {
                return ((BINumeric)source).getNumericFacets();
            }
            return source instanceof BIEnum ? ((BIEnum)source).getEnumFacets() : BFacets.make((BFacets)orig);
        }
    }

    class PointController
    extends FolderController {
        String errorMsg;

        public PointController(BPointManager manager) {
            super((BFolderManager)manager);
            this.errorMsg = "unknown";
        }

        public MgrEdit promptForNew(Context cx) throws Exception {
            MgrTypeInfo[] types = this.getManager().getModel().getNewTypes();
            if (types == null) {
                BDialog.error((BWidget)this.getManager(), (Object)"Must override BAbstractManager.getNewTypes()");
                return null;
            }
            BListDropDown typeField = new BListDropDown();
            if (this.getManager().getModel() instanceof PointModel) {
                for (int i = 0; i < types.length; ++i) {
                    typeField.getList().addItem((Object)((PointModel)this.getManager().getModel()).getPointTypeList().get(i).getName());
                }
            }
            typeField.setSelectedIndex(0);
            BTextField countField = new BTextField("1", 6);
            BListDropDown dataType = new BListDropDown();
            dataType.setSelectedIndex(0);
            BGridPane grid = new BGridPane(2);
            grid.add((String)null, (BValue)new BLabel("Type"));
            grid.add((String)null, (BValue)typeField);
            grid.add((String)null, (BValue)new BLabel("Count"));
            grid.add((String)null, (BValue)countField);
            String title = this.newCommand.getLabel();
            MgrTypeInfo type = null;
            PointType selectedPointType = null;
            int count = 0;
            boolean done = false;
            while (!done) {
                int r = BDialog.open((BWidget)this.getManager(), (String)title, (Object)grid, (int)3);
                if (r == 2) {
                    return null;
                }
                if (this.getManager().getModel() instanceof PointModel) {
                    selectedPointType = ((PointModel)this.getManager().getModel()).getPointTypeList().get(typeField.getSelectedIndex());
                    type = selectedPointType.getMgrTypeInfo();
                    ((PointModel)this.getManager().getModel()).setSelectedIndex(typeField.getSelectedIndex());
                }
                count = Integer.parseInt(countField.getText());
                done = true;
            }
            MgrEdit edit = this.makeEdit(title);
            for (int ixx = 0; ixx < count; ++ixx) {
                BComponent comp = this.getManager().getModel().newInstance(type);
                MgrEditRow row = new MgrEditRow(comp, null, types);
                edit.addRow(row);
                if (comp instanceof BControlPoint) {
                    BAbstractProxyExt ext = ((BControlPoint)comp).getProxyExt();
                    if (ext instanceof BIsmaIoProxyExt) {
                        row.setDefaultName(SlotPath.escape((String)selectedPointType.getName()));
                        continue;
                    }
                    row.setDefaultName(SlotPath.escape((String)(selectedPointType.getName() + ixx)));
                    continue;
                }
                row.setDefaultName(SlotPath.escape((String)(selectedPointType.getName() + ixx)));
            }
            return edit;
        }
    }
}

