/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.points;

import com.gc5.iSMA_IO.devices.BIsmaCommonIoDevice;
import com.gc5.iSMA_IO.enums.BCustomTable;
import com.gc5.iSMA_IO.enums.BLinearConversion;
import com.gc5.iSMA_IO.enums.BUISensorType;
import com.gc5.iSMA_IO.enums.Modbus.ModbusUISensorModel;
import com.gc5.iSMA_IO.enums.Modbus.UISensors;
import com.gc5.iSMA_IO.enums.SerialParameters.BPolarity;
import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.messages.ModbusReadRequest;
import com.gc5.iSMA_IO.messages.ModbusWriteCoilsRequest;
import com.gc5.iSMA_IO.messages.ModbusWriteRequest;
import com.gc5.iSMA_IO.points.BIsmaInputProxyExt;
import java.lang.reflect.Method;
import javax.baja.control.BNumericPoint;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="inputType", type="BUISensorType", flags=0, defaultValue="BUISensorType.voltage"), @NiagaraProperty(name="resolution", type="boolean", flags=0, defaultValue="false", facets={@Facet(name="BFacets.FALSE_TEXT", value="\"12bit\""), @Facet(name="BFacets.TRUE_TEXT", value="\"16bit\"")}), @NiagaraProperty(name="filterTime", type="int", flags=0, defaultValue="2", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="60")}), @NiagaraProperty(name="resistanceOffset", type="int", defaultValue="0"), @NiagaraProperty(name="linearConversion", type="BLinearConversion", flags=0, defaultValue="new BLinearConversion()"), @NiagaraProperty(name="polarityConversion", type="BPolarity", defaultValue="BPolarity.Default", flags=8)})
public class BUniversalInputProxyExt
extends BIsmaInputProxyExt {
    public static final Property inputType = BUniversalInputProxyExt.newProperty((int)0, (BValue)BUISensorType.voltage, null);
    public static final Property resolution = BUniversalInputProxyExt.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((BFacets)BFacets.make((String)"falseText", (String)"12bit"), (BFacets)BFacets.make((String)"trueText", (String)"16bit")));
    public static final Property filterTime = BUniversalInputProxyExt.newProperty((int)0, (int)2, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)60)));
    public static final Property resistanceOffset = BUniversalInputProxyExt.newProperty((int)0, (int)0, null);
    public static final Property linearConversion = BUniversalInputProxyExt.newProperty((int)0, (BValue)new BLinearConversion(), null);
    public static final Property polarityConversion = BUniversalInputProxyExt.newProperty((int)8, (BValue)BPolarity.Default, null);
    public static final Type TYPE = Sys.loadType(BUniversalInputProxyExt.class);
    int baseRegisterAddress;
    int registerStep = 1;
    int registersQuantity = 1;
    int confOffset = 300;
    final int voltageStartingRegister = 86;
    final int digitalStartingRegister = 16;
    final int resistanceStartingRegister = 102;
    boolean customTableActive = false;
    Property customTableProperty;
    BCustomTable custTab = null;
    private final BFacets defFacetsDigital = BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0);
    private final BFacets defFacetsVoltage = BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"volt"), (int)2);
    private final BFacets defFacetsCurrent = BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"milliampere"), (int)0);
    private final BFacets defFacetsResistance = BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"ohm"), (int)0);
    private final BFacets defFacetsTempCels = BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"celsius"), (int)1);
    private final BFacets defFacetsTempFahr = BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"fahrenheit"), (int)1);
    BUISensorType oldInputType = this.getInputType();

    public BUISensorType getInputType() {
        return (BUISensorType)this.get(inputType);
    }

    public void setInputType(BUISensorType v) {
        this.set(inputType, (BValue)v, null);
    }

    public boolean getResolution() {
        return this.getBoolean(resolution);
    }

    public void setResolution(boolean v) {
        this.setBoolean(resolution, v, null);
    }

    public int getFilterTime() {
        return this.getInt(filterTime);
    }

    public void setFilterTime(int v) {
        this.setInt(filterTime, v, null);
    }

    public int getResistanceOffset() {
        return this.getInt(resistanceOffset);
    }

    public void setResistanceOffset(int v) {
        this.setInt(resistanceOffset, v, null);
    }

    public BLinearConversion getLinearConversion() {
        return (BLinearConversion)this.get(linearConversion);
    }

    public void setLinearConversion(BLinearConversion v) {
        this.set(linearConversion, (BValue)v, null);
    }

    public BPolarity getPolarityConversion() {
        return (BPolarity)this.get(polarityConversion);
    }

    public void setPolarityConversion(BPolarity v) {
        this.set(polarityConversion, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (!this.isRunning() || this.parentComponent == null) {
            return;
        }
        this.setConfigParams();
        if (this.parentComponent.deviceIsReady) {
            this.setPointToReady();
        } else {
            this.waitingForDevice = true;
        }
    }

    void sendConfigurationOfSensorType() {
        if (!(this.parentComponent instanceof BIsmaCommonIoDevice)) {
            return;
        }
        BUISensorType sensorType = this.getInputType();
        ModbusUISensorModel model = UISensors.getModbusUiSensorModel(sensorType, this.parentComponent);
        if (model == null) {
            return;
        }
        try {
            Method m = BUniversalInputProxyExt.class.getMethod("callRead", ModbusMessage.class);
            this.parentComponent.addRequest(new ModbusWriteRequest(this, m, this.parentComponent.devAddr, 6, this.getConfigAddress(), 1, new int[]{model.value}));
        }
        catch (Exception e) {
            log.severe(e.getLocalizedMessage());
        }
    }

    public int getConfigAddress() {
        int startingAddressOfUIConfiguration = 150;
        int startingAddressOfLargerUiConfiguration = 450;
        return this.getAddress() <= 8 ? startingAddressOfUIConfiguration + this.getAddress() - 1 : startingAddressOfLargerUiConfiguration + this.getAddress() - 9;
    }

    void sendConfigurationOfResolution() {
        if (!(this.parentComponent instanceof BIsmaCommonIoDevice)) {
            return;
        }
        if (UISensors.listOf16BitSenors.contains((Object)this.getInputType())) {
            this.setResolution(true);
        }
        int[] configuration = new int[]{this.getResolution() ? 1 : 0};
        try {
            this.parentComponent.addRequest(new ModbusWriteCoilsRequest(this, null, this.parentComponent.devAddr, 2656 + this.getAddress() - 1, 1, configuration));
        }
        catch (Exception e) {
            log.severe(e.getLocalizedMessage());
        }
    }

    void sendConfigurationOfFilter() {
        if (!(this.parentComponent instanceof BIsmaCommonIoDevice)) {
            return;
        }
        try {
            Method m = BUniversalInputProxyExt.class.getMethod("callRead", ModbusMessage.class);
            this.parentComponent.addRequest(new ModbusWriteRequest(this, m, this.parentComponent.devAddr, 6, this.getFilterAddress(), 1, new int[]{this.getFilterTime()}));
        }
        catch (Exception e) {
            log.severe(e.getLocalizedMessage());
        }
    }

    public int getFilterAddress() {
        int startingAddressOfFilterConfiguration = 158;
        int startingAddressOfLargerFilterConfiguration = 458;
        return this.getAddress() <= 8 ? startingAddressOfFilterConfiguration + this.getAddress() - 1 : startingAddressOfLargerFilterConfiguration + this.getAddress() - 9;
    }

    @Override
    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(property, context);
        if (property == inputType) {
            this.setConfigParams();
            this.sendConfigurationOfSensorType();
            this.setMyPointsDefaultFacets();
            this.changeResolution();
            this.doPoll();
        }
        if (property == resistanceOffset || property == BLinearConversion.scale || property == BLinearConversion.offset || property == polarityConversion) {
            this.doPoll();
        }
        if (property == resolution) {
            this.sendConfigurationOfResolution();
            this.doPoll();
        }
        if (property == filterTime) {
            this.sendConfigurationOfFilter();
            this.doPoll();
        }
    }

    @Override
    public void sendConfigurations() {
        this.sendConfigurationOfSensorType();
        this.sendConfigurationOfResolution();
        this.sendConfigurationOfFilter();
    }

    @Override
    public ModbusMessage makeMpm() {
        ModbusReadRequest tempMm = null;
        int presentAddress = this.getAddress() - 1;
        presentAddress = presentAddress < 8 ? this.registerStep * presentAddress : this.confOffset + this.registerStep * (presentAddress - 8);
        try {
            Method m = BUniversalInputProxyExt.class.getMethod("setOutputValues", ModbusMessage.class);
            tempMm = new ModbusReadRequest(this, m, this.parentComponent.devAddr, 3, this.baseRegisterAddress + presentAddress, this.registersQuantity);
        }
        catch (Exception e) {
            log.severe(e.getLocalizedMessage());
        }
        return tempMm;
    }

    @Override
    public boolean setOutputValues(ModbusMessage mm) {
        if (!super.setOutputValues(mm)) {
            return false;
        }
        BUISensorType sensorType = this.getInputType();
        if (sensorType.equals((Object)BUISensorType.voltage) || sensorType.equals((Object)BUISensorType.current)) {
            this.temporaryStatusValueForOutputSlot = this.myPoint.getFacets().getFacet("units").equals((Object)BUnit.getUnit((String)"millivolt")) ? new BStatusNumeric((double)mm.getRegister(0)) : (this.myPoint.getFacets().getFacet("units").equals((Object)BUnit.getUnit((String)"milliampere")) ? new BStatusNumeric((double)mm.getRegister(0) / 200.0) : new BStatusNumeric((double)mm.getRegister(0) / 1000.0));
        } else if (sensorType.equals((Object)BUISensorType.digital)) {
            int baseOutputValue = mm.getRegister(0) >>> this.getAddress() - 1 & 1;
            this.temporaryStatusValueForOutputSlot = new BStatusNumeric(this.getPolarityConversion() == BPolarity.Default ? (double)baseOutputValue : (double)(~baseOutputValue & 1));
        } else if (sensorType.equals((Object)BUISensorType.resistance) || sensorType.equals((Object)BUISensorType.customTable)) {
            int hiByte = mm.getRegister(1);
            int loByte = mm.getRegister(0);
            int resistance = this.calculateResistanceFromRegistersValues(hiByte, loByte);
            this.temporaryStatusValueForOutputSlot = new BStatusNumeric((double)resistance);
        } else {
            int hiByte = mm.getRegister(1);
            int loByte = mm.getRegister(0);
            float temperature = this.getTemperature(this.calculateResistanceFromRegistersValues(hiByte, loByte), sensorType);
            this.temporaryStatusValueForOutputSlot = new BStatusNumeric((double)temperature);
        }
        this.myPoint.doExecute();
        return true;
    }

    private int calculateResistanceFromRegistersValues(int high, int low) {
        int resistance = (high << 16) + low + this.getResistanceOffset();
        if (resistance < 0) {
            resistance = 0;
        }
        return resistance;
    }

    protected float getTemperature(int resistance, BUISensorType sensorType) {
        int i;
        int tempCoefficient;
        ModbusUISensorModel sensorModel = UISensors.getModbusUiSensorModel(sensorType);
        if (sensorModel == null || sensorModel.temperatureSensorModel == null || sensorModel.unit == UISensors.TemperatureUnit.None) {
            return resistance;
        }
        int tempMin = sensorModel.temperatureSensorModel.minimumTemperature;
        int tempMax = sensorModel.temperatureSensorModel.maximumTemperature;
        int tempStep = sensorModel.temperatureSensorModel.step;
        int size = sensorModel.temperatureSensorModel.tableSize;
        int[] sensorTable = sensorModel.temperatureSensorModel.sensorTable;
        int negativeCoefficient = -1;
        boolean positiveCoefficient = true;
        int n = tempCoefficient = tempStep < 0 ? -1 : 1;
        if (tempCoefficient == 1 && resistance < sensorTable[0]) {
            return -3276.8f;
        }
        if (tempCoefficient == -1) {
            tempStep = -tempStep;
            if (resistance > sensorTable[0]) {
                return -3276.8f;
            }
        }
        int temperature = 0;
        for (i = 1; i <= size; ++i) {
            if ((tempCoefficient != 1 || resistance > sensorTable[i]) && (tempCoefficient != -1 || resistance < sensorTable[i])) continue;
            int temperature1 = ((i - 1) * tempStep + tempMin) * 10;
            int temperature2 = (i * tempStep + tempMin) * 10;
            int resistance1 = sensorTable[i - 1];
            int resistance2 = sensorTable[i];
            temperature = (temperature2 - temperature1) * (resistance - resistance1) / (resistance2 - resistance1) + temperature1;
            break;
        }
        if (i > size) {
            temperature = Short.MAX_VALUE;
        }
        return (float)temperature / 10.0f;
    }

    public void onExecute(BStatusValue out, Context cx) {
        BStatusNumeric statusValueForOutputSlot;
        if (this.temporaryStatusValueForOutputSlot == null) {
            this.setTemporaryStatusValueForOutputSlot((BStatusValue)new BStatusNumeric());
        }
        double tempNumVal = ((BStatusNumeric)this.temporaryStatusValueForOutputSlot).getNumeric();
        if (this.customTableActive) {
            this.custTab.calculate(tempNumVal);
            statusValueForOutputSlot = new BStatusNumeric((tempNumVal * this.custTab.getFactorA() + this.custTab.getFactorB()) * this.getLinearConversion().getScale() + this.getLinearConversion().getOffset());
        } else {
            statusValueForOutputSlot = new BStatusNumeric(tempNumVal * this.getLinearConversion().getScale() + this.getLinearConversion().getOffset());
        }
        statusValueForOutputSlot.setStatus(out.getStatus());
        if (!this.getStatus().equals((Object)BStatus.ok)) {
            statusValueForOutputSlot.setStatus(this.getStatus());
            statusValueForOutputSlot.setStatusNull(true);
        }
        out.copyFrom((BComplex)statusValueForOutputSlot);
    }

    @Override
    public void setMyPointsDefaultFacets() {
        if (this.myPoint == null) {
            return;
        }
        BUISensorType sensorType = this.getInputType();
        if (sensorType.equals((Object)BUISensorType.voltage)) {
            this.myPoint.setFacets(this.defFacetsVoltage);
        } else if (sensorType.equals((Object)BUISensorType.current)) {
            this.myPoint.setFacets(this.defFacetsCurrent);
        } else if (sensorType.equals((Object)BUISensorType.digital)) {
            this.myPoint.setFacets(this.defFacetsDigital);
        } else if (sensorType.equals((Object)BUISensorType.resistance)) {
            this.myPoint.setFacets(this.defFacetsResistance);
        } else if (!sensorType.equals((Object)BUISensorType.customTable)) {
            ModbusUISensorModel model = UISensors.getModbusUiSensorModel(sensorType);
            switch (model.unit) {
                default: {
                    this.myPoint.setFacets(this.defFacetsTempCels);
                    break;
                }
                case Fahrenheit: {
                    this.myPoint.setFacets(this.defFacetsTempFahr);
                }
            }
        }
    }

    private void changeResolution() {
        if (!UISensors.listOf16BitSenors.contains((Object)this.getInputType())) {
            return;
        }
        if (!this.getResolution()) {
            this.setResolution(true);
        }
    }

    @Override
    boolean isIOPoint() {
        return true;
    }

    private void setConfigParams() {
        BUISensorType sensorType = this.getInputType();
        if (!sensorType.equals(25)) {
            this.customTableActive = false;
            this.customTableProperty = null;
        }
        if (sensorType.equals((Object)BUISensorType.voltage) || sensorType.equals((Object)BUISensorType.current)) {
            this.baseRegisterAddress = 86;
            this.registerStep = 1;
            this.registersQuantity = 1;
            this.confOffset = 300;
        } else if (sensorType.equals((Object)BUISensorType.digital)) {
            this.baseRegisterAddress = 16;
            this.registerStep = 0;
            this.registersQuantity = 1;
            this.confOffset = 0;
        } else {
            if (sensorType.equals((Object)BUISensorType.customTable)) {
                this.getSetCustomTable();
            }
            this.baseRegisterAddress = 102;
            this.registerStep = 2;
            this.registersQuantity = 2;
            this.confOffset = 300;
        }
    }

    void getSetCustomTable() {
        for (Property p : this.getDynamicPropertiesArray()) {
            if (!(p.getDefaultValue() instanceof BCustomTable)) continue;
            this.customTableProperty = p;
            this.custTab = (BCustomTable)this.get(p);
            this.customTableActive = true;
        }
        if (!this.customTableActive) {
            this.custTab = new BCustomTable();
            this.customTableProperty = this.add("Custom$20Table", (BValue)this.custTab, 0, null);
            this.customTableActive = true;
        }
    }

    @Override
    public int getAddress() {
        return this.getInputNumber();
    }

    @Override
    public int getMaxAddress() {
        if (this.parentComponent == null) {
            return -1;
        }
        return this.parentComponent.getUIQuantity();
    }

    @Override
    void setMyPointAddress() {
        int myNum = this.getFirstFreeNumber(1, this.parentComponent.getUIQuantity());
        this.setInputNumber(myNum);
    }

    @Override
    public int getPointQuantity() {
        return this.parentComponent.getUIQuantity();
    }

    @Override
    Type getPointType() {
        return BNumericPoint.TYPE;
    }
}

