/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.points;

import com.gc5.iSMA_IO.devices.BIsmaCommonIoDevice;
import com.gc5.iSMA_IO.devices.BIsmaRemoteDevice;
import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.messages.ModbusReadRequest;
import com.gc5.iSMA_IO.messages.ModbusWriteStringRequest;
import com.gc5.iSMA_IO.points.BModbusProxyExt;
import com.gc5.iSMA_IO.points.IWritablePoint;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import javax.baja.control.BStringWritable;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraAction(name="forceWrite")
public class BStringWritableProxyExt
extends BModbusProxyExt
implements IWritablePoint {
    public static final Action forceWrite = BStringWritableProxyExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BStringWritableProxyExt.class);
    private final int stringArrayLength = 4;
    public boolean forcedWriting = false;
    String oldValue = null;

    public void forceWrite() {
        this.invoke(forceWrite, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void InitializeVariables() {
        if (this.parentComponent instanceof BIsmaRemoteDevice && !((BIsmaRemoteDevice)this.parentComponent).getWriteOnStart()) {
            this.oldValue = this.getInActiveLevel().getValue();
        }
    }

    @Override
    Type getPointType() {
        return BStringWritable.TYPE;
    }

    @Override
    public void sendConfigurations() {
    }

    @Override
    public void doForceWrite() {
        if (this.parentComponent == null) {
            return;
        }
        this.writeValue(true);
    }

    public void writeValue(boolean forcedWriting) {
        String value;
        BStatusString inSlotsActivLevel = this.getInActiveLevel();
        if (this.getEnabled() && !inSlotsActivLevel.getStatus().isNull() && this.isRunning() && this.parentComponent instanceof BIsmaCommonIoDevice && (!(value = inSlotsActivLevel.getValue()).equals(this.oldValue) || forcedWriting)) {
            this.oldValue = value;
            try {
                Method m = BStringWritableProxyExt.class.getMethod("callRead", ModbusMessage.class);
                this.parentComponent.addRequest(new ModbusWriteStringRequest(this, m, this.parentComponent.devAddr, this.getDataAddress(), this.convertStringToRegisters(value)));
            }
            catch (Exception e) {
                log.severe(e.getLocalizedMessage());
            }
        }
    }

    private int[] convertStringToRegisters(String value) {
        value = value.toUpperCase();
        byte[] valueArray = value.getBytes();
        byte[] dataToSend = new byte[4];
        System.arraycopy(valueArray, 0, dataToSend, 0, valueArray.length > 4 ? 4 : valueArray.length);
        return new int[]{dataToSend[0], dataToSend[1], dataToSend[2], dataToSend[3]};
    }

    BStatusString getInActiveLevel() {
        try {
            for (int i = 1; i < 17; ++i) {
                Method getIn = ((BStringWritable)this.getParent().getParentComponent()).getClass().getMethod("getIn" + i, null);
                BStatusString inVal = (BStatusString)getIn.invoke((Object)this.getParent().getParentComponent(), null);
                if (inVal.getStatus().isNull()) continue;
                return inVal;
            }
        }
        catch (Exception e) {
            log.severe("Getting active level problem: " + e.getLocalizedMessage());
        }
        return ((BStringWritable)this.getParent().getParentComponent()).getFallback();
    }

    private byte[] changeOrderOfArray(byte[] array) {
        return new byte[]{array[1], array[0], array[3], array[2]};
    }

    @Override
    public ModbusMessage makeMpm() {
        ModbusReadRequest tempModbusMessage = null;
        try {
            Method m = BStringWritableProxyExt.class.getMethod("setOutputValues", ModbusMessage.class);
            int regCount = 2;
            tempModbusMessage = new ModbusReadRequest(this, m, this.parentComponent.devAddr, 3, this.getDataAddress(), regCount);
        }
        catch (Exception e) {
            log.severe(e.getLocalizedMessage());
        }
        return tempModbusMessage;
    }

    @Override
    public boolean setOutputValues(ModbusMessage mm) {
        if (!super.setOutputValues(mm)) {
            return false;
        }
        int[] registers = mm.getRegisters();
        byte[] value = this.intToByteArray((registers[1] << 16) + registers[0]);
        byte[] valueRev = this.changeOrderOfArray(value);
        String val = new String(valueRev, StandardCharsets.US_ASCII).toUpperCase();
        this.temporaryStatusValueForOutputSlot = new BStatusString(val);
        this.myPoint.doExecute();
        return true;
    }

    private byte[] intToByteArray(int value) {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(value);
            return buffer.array();
        }
        catch (Exception ex) {
            log.severe("Wrong value " + value + " read from string register");
            return new byte[]{0, 0, 0, 0};
        }
    }

    public void onExecute(BStatusValue out, Context cx) {
        BStatus stat;
        if (this.isPointReady) {
            this.writeValue(false);
        }
        if (this.temporaryStatusValueForOutputSlot == null) {
            this.setTemporaryStatusValueForOutputSlot((BStatusValue)new BStatusString());
        }
        if ((stat = out.getStatus()).isNull()) {
            stat = BStatus.ok;
        }
        this.temporaryStatusValueForOutputSlot.copyFrom((BComplex)new BStatusString(((BStatusString)this.temporaryStatusValueForOutputSlot).getValue(), stat));
        if (!this.getStatus().equals((Object)BStatus.ok)) {
            this.temporaryStatusValueForOutputSlot.setStatus(this.getStatus());
            this.temporaryStatusValueForOutputSlot.setStatusNull(true);
        }
        out.copyFrom((BComplex)this.temporaryStatusValueForOutputSlot);
    }

    @Override
    protected void onUp() {
        super.onUp();
        if (this.parentComponent instanceof BIsmaRemoteDevice && ((BIsmaRemoteDevice)this.parentComponent).getWriteOnUp()) {
            this.doForceWrite();
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (this.parentComponent instanceof BIsmaRemoteDevice && ((BIsmaRemoteDevice)this.parentComponent).getWriteOnStart()) {
            this.doForceWrite();
        }
    }

    @Override
    protected void onEnable() {
        super.onEnable();
        if (this.parentComponent instanceof BIsmaRemoteDevice && ((BIsmaRemoteDevice)this.parentComponent).getWriteOnEnabled()) {
            this.doForceWrite();
        }
    }
}

