/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.points;

import com.gc5.iSMA_IO.devices.BIsmaCommonIoDevice;
import com.gc5.iSMA_IO.devices.BIsmaIoDevice;
import com.gc5.iSMA_IO.devices.BIsmaRemoteDevice;
import com.gc5.iSMA_IO.devices.IDeviceListener;
import com.gc5.iSMA_IO.enums.BPollFreqConf;
import com.gc5.iSMA_IO.enums.Utilities.Statuses;
import com.gc5.iSMA_IO.licenses.BShadowPoint;
import com.gc5.iSMA_IO.messages.IIsmaIoComponent;
import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.networks.BIsmaRemoteIpNetwork;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="poll", flags=4), @NiagaraAction(name="forceWriteConfig", flags=256), @NiagaraAction(name="forceRead", flags=256)})
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", flags=65, defaultValue="BStatus.disabled"), @NiagaraProperty(name="faultCause", type="String", flags=65, defaultValue=""), @NiagaraProperty(name="enabled", type="boolean", flags=264, defaultValue="false"), @NiagaraProperty(name="pollFrequency", type="BPollFreqConf", flags=0, defaultValue="BPollFreqConf.normal")})
public abstract class BIsmaIoProxyExt
extends BAbstractProxyExt
implements BIStatus,
IIsmaIoComponent,
IDeviceListener {
    public static final Property status = BIsmaIoProxyExt.newProperty((int)65, (BValue)BStatus.disabled, null);
    public static final Property faultCause = BIsmaIoProxyExt.newProperty((int)65, (String)"", null);
    public static final Property enabled = BIsmaIoProxyExt.newProperty((int)264, (boolean)false, null);
    public static final Property pollFrequency = BIsmaIoProxyExt.newProperty((int)0, (BValue)BPollFreqConf.normal, null);
    public static final Action poll = BIsmaIoProxyExt.newAction((int)4, null);
    public static final Action forceWriteConfig = BIsmaIoProxyExt.newAction((int)256, null);
    public static final Action forceRead = BIsmaIoProxyExt.newAction((int)256, null);
    public static final Type TYPE = Sys.loadType(BIsmaIoProxyExt.class);
    Property shadowPointProp = null;
    private boolean inPointLimitRange = true;
    BControlPoint myPoint = null;
    boolean valueRestored = false;
    boolean responseParsedProperly = true;
    boolean waitingForDevice = false;
    boolean isPointReady = false;
    private boolean subscriptionEnabled = false;
    private ModbusMessage mpm;
    public BIsmaCommonIoDevice parentComponent = null;
    BStatusValue temporaryStatusValueForOutputSlot;
    protected Statuses pointStatus = Statuses.OK;
    protected Statuses oldPointStatus = Statuses.OK;
    public static final Logger log = Logger.getLogger("iSMA_IO::iSMAIOProxyExt");

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BPollFreqConf getPollFrequency() {
        return (BPollFreqConf)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFreqConf v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    public void poll() {
        this.invoke(poll, null, null);
    }

    public void forceWriteConfig() {
        this.invoke(forceWriteConfig, null, null);
    }

    public void forceRead() {
        this.invoke(forceRead, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (!this.isRunning() || !this.validateParent().booleanValue()) {
            return;
        }
        this.registerPointToDevice();
        this.setMyPoint();
        if (!this.checkDuplicatedPoint()) {
            this.checkMyPointsFacets();
        }
        this.updateStatus();
        this.checkAndSubscribePointToDevice();
    }

    protected Boolean validateParent() {
        this.parentComponent = this.getProperParent();
        if (this.parentComponent == null) {
            this.updatePointStatus(Statuses.BAD_PARENT);
            return false;
        }
        return true;
    }

    private void checkAndSubscribePointToDevice() {
        if (this.parentComponent instanceof BIsmaCommonIoDevice && this.parentComponent.isSubscribed()) {
            this.pointSubscribed();
        }
    }

    private void registerPointToDevice() {
        if (this.parentComponent instanceof BIsmaCommonIoDevice) {
            try {
                this.parentComponent.addListener(this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void unregisterPointFromDevice() {
        if (this.parentComponent instanceof BIsmaCommonIoDevice) {
            try {
                this.parentComponent.removeListener(this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.unregisterPointFromDevice();
        this.UpdateSiblingsPointsStatus();
        this.pointUnsubscribed();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning() || this.parentComponent == null) {
            return;
        }
        if (property == pollFrequency) {
            this.updatePolling();
        }
        if (property != faultCause && property != status) {
            this.updateStatus();
        }
        if (property == status) {
            this.generateEvent();
        }
    }

    protected void onEnable() {
        this.makeSendConfigurations();
        this.doPoll();
    }

    protected void onStart() {
        if (this.getAddress() == -1) {
            this.setMyPointAddress();
        }
        this.setMaxIONumber();
        this.updateStatus();
        this.makeSendConfigurations();
        this.doPoll(this.getStatus().equals((Object)BStatus.ok));
    }

    protected void onUp() {
        this.makeSendConfigurations();
        this.doPoll();
    }

    protected void makeSendConfigurations() {
        if (this.isSendingConfigAllowed()) {
            this.sendConfigurations();
        }
    }

    protected boolean isSendingConfigAllowed() {
        if (this.parentComponent != null && this.parentComponent.getNetwork() instanceof BIsmaRemoteIpNetwork) {
            return ((BIsmaRemoteIpNetwork)this.parentComponent.getNetwork()).getEnabledConfig();
        }
        return true;
    }

    private void generateEvent() {
        if (this.pointStatus != Statuses.OK || this.pointStatus == this.oldPointStatus) {
            return;
        }
        if (this.oldPointStatus.equals(Statuses.DISABLED) || this.oldPointStatus.equals(Statuses.PARENT_DISABLED)) {
            this.onEnable();
        } else {
            this.onUp();
        }
    }

    public void doPoll() {
        this.doPoll(false);
    }

    public void doPoll(boolean force) {
        if (!(this.parentComponent != null && (force || this.subscriptionEnabled && this.getStatus() == BStatus.ok && this.isRunning()))) {
            return;
        }
        this.mpm = this.makeMpm();
        if (this.mpm != null) {
            if (force) {
                this.mpm.setAsForceRequest();
            }
            this.parentComponent.addRequest(this.mpm);
        }
    }

    public void doForceWriteConfig() {
        this.sendConfigurations();
    }

    public void doForceRead() {
        this.doPoll(true);
    }

    @Override
    public void deviceReturned() {
    }

    @Override
    public void deviceStarted(BIsmaCommonIoDevice device) {
        this.setMyPoint();
        this.updateStatus();
        if (device.getType().is(BIsmaIoDevice.TYPE)) {
            this.restoreLastValue();
        }
    }

    @Override
    public void devicePinged() {
        this.setMaxIONumber();
        if (this.getStatus().isFault() || this.getStatus().isDown()) {
            this.sendPingRequest();
        }
    }

    protected void sendPingRequest() {
        try {
            ModbusMessage pingMessage = this.makeMpm();
            if (pingMessage != null) {
                pingMessage.setAsPingRequest();
                this.parentComponent.addRequest(pingMessage);
            }
        }
        catch (Exception ex) {
            log.severe(ex.getLocalizedMessage());
        }
    }

    @Override
    public BPollFreqConf getPointPollFreqConf() {
        return this.getPollFrequency();
    }

    @Override
    public final void updatePolling() {
        if (this.parentComponent == null || !this.subscriptionEnabled) {
            return;
        }
        this.parentComponent.updateSubscribedPoint(this);
    }

    void manageShadowPoint(boolean shouldBe) {
        this.shadowPointProp = null;
        for (Property myProp : this.getPropertiesArray()) {
            if (!myProp.getType().is(BShadowPoint.TYPE)) continue;
            this.shadowPointProp = myProp;
        }
        if (this.shadowPointProp == null && shouldBe) {
            this.shadowPointProp = this.add("shadowPoint?", (BValue)new BShadowPoint(), 6);
        } else if (this.shadowPointProp != null && !shouldBe) {
            this.remove(this.shadowPointProp);
        }
    }

    protected void updatePointStatus(Statuses passedStatus) {
        if (passedStatus == Statuses.BAD_PARENT) {
            this.pointStatus = passedStatus;
            this.manageShadowPoint(true);
        } else {
            this.inPointLimitRange = true;
            BStatus parentStatus = this.parentComponent.getStatus();
            this.oldPointStatus = this.pointStatus;
            this.manageShadowPoint(this.parentComponent.getType().is(BIsmaRemoteDevice.TYPE));
            if (this.shadowPointProp != null && ((BShadowPoint)this.get(this.shadowPointProp)).getStatus().isFault() && ((BShadowPoint)this.get(this.shadowPointProp)).getFaultCause().startsWith("Exceeded point limit for ")) {
                this.inPointLimitRange = false;
                this.pointStatus = Statuses.EXCEEDED_POINT_LIMIT = new Statuses(((BShadowPoint)this.get(this.shadowPointProp)).getFaultCause(), BStatus.fault);
            } else {
                this.pointStatus = !this.getEnabled() ? Statuses.DISABLED : (parentStatus.equals((Object)BStatus.disabled) ? Statuses.PARENT_DISABLED : (this.checkDuplicatedPoint() ? Statuses.DUPLICATED : (parentStatus.equals((Object)BStatus.fault) ? Statuses.PARENT_NOT_OK : (parentStatus.equals((Object)BStatus.down) ? Statuses.PARENT_DOWN : (this.isRunning() && this.isIOPoint() && (this.getAddress() < 1 || this.getAddress() > this.getMaxAddress()) ? Statuses.INVALID_TYPE : (!this.responseParsedProperly ? Statuses.POINT_DOWN : (passedStatus != Statuses.STATUS_UNKNOWN_YET ? passedStatus : Statuses.OK)))))));
            }
        }
        this.setStatus(this.pointStatus.getStatus());
        this.setFaultCause(this.pointStatus.getMessage());
    }

    void updateStatus() {
        this.updatePointStatus(Statuses.STATUS_UNKNOWN_YET);
        this.myPoint.doExecute();
    }

    @Override
    public void deviceUpdated(Property property) {
        if (!this.validateParent().booleanValue() || property == BIsmaRemoteDevice.faultCause) {
            return;
        }
        this.updateStatus();
        if (property == BIsmaRemoteDevice.deviceAddress) {
            this.makeSendConfigurations();
        }
    }

    @Override
    public void deviceConfirmed() {
        if (this.waitingForDevice) {
            this.setPointToReady();
            this.waitingForDevice = false;
        }
    }

    protected void setPointToReady() {
        this.onStart();
        this.isPointReady = true;
    }

    protected boolean checkDuplicatedPoint() {
        if (this.parentComponent == null) {
            return false;
        }
        ArrayList<IDeviceListener> deviceListeners = this.parentComponent.getListeners();
        for (IDeviceListener listener : deviceListeners) {
            BIsmaIoProxyExt point;
            if (!(listener instanceof BIsmaIoProxyExt) || (point = (BIsmaIoProxyExt)listener) == this || !point.getClass().getTypeName().equals(this.getClass().getTypeName()) || point.getAddress() != this.getAddress() || !point.getStatus().isOk()) continue;
            return true;
        }
        return false;
    }

    protected BIsmaCommonIoDevice getProperParent() {
        BComponent parentComponent = this.getParent().getParent().getParentComponent();
        while (parentComponent != null && !parentComponent.getType().is(BIsmaCommonIoDevice.TYPE)) {
            BComplex parent = parentComponent.getParent();
            if (parent != null) {
                parentComponent = parent.getParentComponent();
                continue;
            }
            return null;
        }
        if (parentComponent != null && parentComponent.getType().is(BIsmaCommonIoDevice.TYPE)) {
            return (BIsmaCommonIoDevice)parentComponent;
        }
        return null;
    }

    protected void UpdateSiblingsPointsStatus() {
        if (this.parentComponent == null) {
            return;
        }
        ArrayList<IDeviceListener> deviceListeners = this.parentComponent.getListeners();
        for (IDeviceListener listener : deviceListeners) {
            if (!(listener instanceof BIsmaIoProxyExt) || listener.equals(this) || !((BIsmaIoProxyExt)listener).getStatus().isFault()) continue;
            ((BIsmaIoProxyExt)listener).updateStatus();
        }
    }

    int getFirstFreeNumber(int min, int max) {
        if (this.parentComponent == null) {
            return -1;
        }
        boolean[] usedNumbers = new boolean[max];
        for (IDeviceListener listener : this.parentComponent.getListeners()) {
            int pointAddress;
            if (!listener.getClass().getTypeName().equals(this.getClass().getTypeName()) || (pointAddress = ((BIsmaIoProxyExt)listener).getAddress()) <= min - 1 || pointAddress > usedNumbers.length) continue;
            usedNumbers[pointAddress - min] = true;
        }
        for (int i = 0; i < max; ++i) {
            if (usedNumbers[i]) continue;
            return i + min;
        }
        return -1;
    }

    void setMyPoint() {
        Type type = this.getPointType();
        BComplex parent = this.getParent();
        if (parent == null) {
            return;
        }
        BComponent parentComp = parent.getParentComponent();
        if (parentComp == null) {
            return;
        }
        if (parentComp.getType().is(type)) {
            this.myPoint = (BControlPoint)parentComp;
        }
    }

    public boolean callRead(ModbusMessage mm) {
        if (!mm.parseResponse()) {
            return false;
        }
        this.doPoll();
        return true;
    }

    abstract Type getPointType();

    abstract int getMaxAddress();

    @Override
    public boolean setOutputValues(ModbusMessage mm) {
        boolean result = mm.parseResponse();
        if (result != this.responseParsedProperly) {
            this.responseParsedProperly = result;
            this.updateStatus();
        }
        return result;
    }

    public void pointSubscribed() {
        this.subscriptionEnabled = true;
        if (this.parentComponent != null) {
            this.parentComponent.startPolling(this);
        }
    }

    public void pointUnsubscribed() {
        this.subscriptionEnabled = false;
        if (this.parentComponent != null) {
            this.parentComponent.stopPolling(this);
        }
    }

    abstract int getAddress();

    abstract void setMyPointAddress();

    public abstract void setMaxIONumber();

    public void setMyPointsDefaultFacets() {
    }

    public void checkMyPointsFacets() {
        if (this.myPoint == null) {
            return;
        }
        BUnit unit = (BUnit)this.myPoint.getFacets().get("units");
        if (unit == BUnit.NULL) {
            this.setMyPointsDefaultFacets();
        }
    }

    public void restoreLastValue() {
    }

    abstract boolean isIOPoint();

    protected void setTemporaryStatusValueForOutputSlot(BStatusValue bStatusValue) {
        this.temporaryStatusValueForOutputSlot = bStatusValue;
    }

    public boolean isInPointLimitRange() {
        return this.inPointLimitRange;
    }
}

