/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.points;

import com.gc5.iSMA_IO.devices.BIsmaCommonIoDevice;
import com.gc5.iSMA_IO.devices.BIsmaRemoteDevice;
import com.gc5.iSMA_IO.enums.Modbus.BDataType;
import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.messages.ModbusWriteCoilsRequest;
import com.gc5.iSMA_IO.points.BEnumBitsPointProxyExt;
import com.gc5.iSMA_IO.points.IWritablePoint;
import java.lang.reflect.Method;
import javax.baja.control.BEnumWritable;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="enabled", type="boolean", flags=264, defaultValue="false", override=true)
@NiagaraAction(name="forceWrite")
public class BEnumBitsWritableProxyExt
extends BEnumBitsPointProxyExt
implements IWritablePoint {
    public static final Property enabled = BEnumBitsWritableProxyExt.newProperty((int)264, (boolean)false, null);
    public static final Action forceWrite = BEnumBitsWritableProxyExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BEnumBitsWritableProxyExt.class);
    public boolean forcedWriting = false;
    Integer oldValue = null;

    public void forceWrite() {
        this.invoke(forceWrite, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void InitializeVariables() {
        if (this.parentComponent instanceof BIsmaRemoteDevice && !((BIsmaRemoteDevice)this.parentComponent).getWriteOnStart()) {
            this.oldValue = this.getInActiveLevel().getEnum().getOrdinal();
        }
    }

    @Override
    public void doForceWrite() {
        if (this.parentComponent == null) {
            return;
        }
        this.writeValue(true);
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (this.parentComponent instanceof BIsmaRemoteDevice && ((BIsmaRemoteDevice)this.parentComponent).getWriteOnStart()) {
            this.doForceWrite();
        }
    }

    @Override
    protected void onEnable() {
        super.onEnable();
        if (this.parentComponent instanceof BIsmaRemoteDevice && ((BIsmaRemoteDevice)this.parentComponent).getWriteOnEnabled()) {
            this.doForceWrite();
        }
    }

    @Override
    protected void onUp() {
        super.onUp();
        if (this.parentComponent instanceof BIsmaRemoteDevice && ((BIsmaRemoteDevice)this.parentComponent).getWriteOnUp()) {
            this.doForceWrite();
        }
    }

    public void writeValue(boolean forcedWriting) {
        Integer value;
        BStatusEnum inSlotsActivLevel = this.getInActiveLevel();
        if (this.getEnabled() && !inSlotsActivLevel.getStatus().isNull() && this.isRunning() && this.parentComponent instanceof BIsmaCommonIoDevice && (!(value = Integer.valueOf(inSlotsActivLevel.getEnum().getOrdinal())).equals(this.oldValue) || forcedWriting)) {
            this.oldValue = value;
            try {
                Method m = BEnumBitsWritableProxyExt.class.getMethod("callRead", ModbusMessage.class);
                this.parentComponent.addRequest(new ModbusWriteCoilsRequest(this, m, this.parentComponent.devAddr, this.getDataAddress() * 16 + this.getBeginningBit(), this.getNumberOfBits(), this.convertNumericToRegisters(BDataType.UnsignedInteger, value.intValue())));
            }
            catch (Exception e) {
                log.severe(e.getLocalizedMessage());
            }
        }
    }

    @Override
    Type getPointType() {
        return BEnumWritable.TYPE;
    }

    BStatusEnum getInActiveLevel() {
        try {
            for (int i = 1; i < 17; ++i) {
                Method getIn = ((BEnumWritable)this.getParent().getParentComponent()).getClass().getMethod("getIn" + i, null);
                BStatusEnum inVal = (BStatusEnum)getIn.invoke((Object)this.getParent().getParentComponent(), null);
                if (inVal.getStatus().isNull()) continue;
                return inVal;
            }
        }
        catch (Exception e) {
            log.severe("Getting active level problem: " + e.getLocalizedMessage());
        }
        return ((BEnumWritable)this.getParent().getParentComponent()).getFallback();
    }

    @Override
    public void onExecute(BStatusValue out, Context cx) {
        BStatus stat;
        if (this.isPointReady) {
            this.writeValue(false);
        }
        if (this.temporaryStatusValueForOutputSlot == null) {
            this.setTemporaryStatusValueForOutputSlot((BStatusValue)new BStatusEnum());
        }
        if ((stat = out.getStatus()).isNull()) {
            stat = BStatus.ok;
        }
        this.temporaryStatusValueForOutputSlot.copyFrom((BComplex)new BStatusEnum(((BStatusEnum)this.temporaryStatusValueForOutputSlot).getEnum(), stat));
        if (!this.getStatus().equals((Object)BStatus.ok)) {
            this.temporaryStatusValueForOutputSlot.setStatus(this.getStatus());
            this.temporaryStatusValueForOutputSlot.setStatusNull(true);
        }
        out.copyFrom((BComplex)this.temporaryStatusValueForOutputSlot);
    }
}

