/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.points;

import com.gc5.iSMA_IO.devices.BIsmaCommonIoDevice;
import com.gc5.iSMA_IO.enums.BUISensorType;
import com.gc5.iSMA_IO.enums.Modbus.ModbusUISensorModel;
import com.gc5.iSMA_IO.enums.Modbus.UISensors;
import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.messages.ModbusReadRequest;
import com.gc5.iSMA_IO.messages.ModbusWriteRequest;
import com.gc5.iSMA_IO.points.BDigitalInputProxyExt;
import java.lang.reflect.Method;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BDigitalUniversalInputProxyExt
extends BDigitalInputProxyExt {
    public static final Type TYPE = Sys.loadType(BDigitalUniversalInputProxyExt.class);
    final int universalDigitalStartingRegister = 16;

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public ModbusMessage makeMpm() {
        ModbusReadRequest tempMm = null;
        try {
            Method m = BDigitalInputProxyExt.class.getMethod("setOutputValues", ModbusMessage.class);
            tempMm = new ModbusReadRequest(this, m, this.parentComponent.devAddr, 3, 16, 1);
        }
        catch (Exception e) {
            log.severe(e.getLocalizedMessage());
        }
        return tempMm;
    }

    @Override
    public int getMaxAddress() {
        if (this.parentComponent == null) {
            return -1;
        }
        return this.parentComponent.getUIQuantity();
    }

    @Override
    public void sendConfigurations() {
        this.sendConfigurationOfSensorType();
    }

    void sendConfigurationOfSensorType() {
        if (!(this.parentComponent instanceof BIsmaCommonIoDevice)) {
            return;
        }
        BUISensorType sensorType = BUISensorType.digital;
        ModbusUISensorModel model = UISensors.getModbusUiSensorModel(sensorType, this.parentComponent);
        if (model == null) {
            return;
        }
        try {
            Method m = BDigitalUniversalInputProxyExt.class.getMethod("callRead", ModbusMessage.class);
            this.parentComponent.addRequest(new ModbusWriteRequest(this, m, this.parentComponent.devAddr, 6, this.getConfigAddress(), 1, new int[]{model.value}));
        }
        catch (Exception e) {
            log.severe(e.getLocalizedMessage());
        }
    }

    public int getConfigAddress() {
        int startingAddressOfUIConfiguration = 150;
        int startingAddressOfLargerUiConfiguration = 450;
        return this.getAddress() <= 8 ? startingAddressOfUIConfiguration + this.getAddress() - 1 : startingAddressOfLargerUiConfiguration + this.getAddress() - 9;
    }

    @Override
    void setMyPointAddress() {
        int myNum = this.getFirstFreeNumber(1, this.parentComponent.getUIQuantity());
        this.setInputNumber(myNum);
    }

    @Override
    public int getPointQuantity() {
        return this.parentComponent.getUIQuantity();
    }
}

