/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.points;

import com.gc5.iSMA_IO.enums.SerialParameters.BPolarity;
import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.messages.ModbusReadRequest;
import com.gc5.iSMA_IO.points.BIsmaInputProxyExt;
import java.lang.reflect.Method;
import javax.baja.control.BBooleanPoint;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="polarityConversion", type="BPolarity", defaultValue="BPolarity.Default", flags=8)
public class BDigitalInputProxyExt
extends BIsmaInputProxyExt {
    public static final Property polarityConversion = BDigitalInputProxyExt.newProperty((int)8, (BValue)BPolarity.Default, null);
    public static final Type TYPE = Sys.loadType(BDigitalInputProxyExt.class);

    public BPolarity getPolarityConversion() {
        return (BPolarity)this.get(polarityConversion);
    }

    public void setPolarityConversion(BPolarity v) {
        this.set(polarityConversion, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (!this.isRunning() || this.parentComponent == null) {
            return;
        }
        if (this.parentComponent.deviceIsReady) {
            this.setPointToReady();
        } else {
            this.waitingForDevice = true;
        }
    }

    @Override
    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(property, context);
        if (property == polarityConversion) {
            this.doPoll();
        }
    }

    @Override
    Type getPointType() {
        return BBooleanPoint.TYPE;
    }

    @Override
    public void sendConfigurations() {
    }

    @Override
    public ModbusMessage makeMpm() {
        ModbusReadRequest tempMm = null;
        try {
            Method m = BDigitalInputProxyExt.class.getMethod("setOutputValues", ModbusMessage.class);
            tempMm = new ModbusReadRequest(this, m, this.parentComponent.devAddr, 3, 15, 1);
        }
        catch (Exception e) {
            log.severe(e.getLocalizedMessage());
        }
        return tempMm;
    }

    @Override
    public boolean setOutputValues(ModbusMessage mm) {
        if (!super.setOutputValues(mm)) {
            return false;
        }
        this.temporaryStatusValueForOutputSlot = (mm.getRegister(0) >>> this.getAddress() - 1 & 1) != 0 ? new BStatusBoolean(this.getPolarityConversion() == BPolarity.Default) : new BStatusBoolean(this.getPolarityConversion() != BPolarity.Default);
        this.myPoint.doExecute();
        return true;
    }

    public void onExecute(BStatusValue out, Context cx) {
        if (this.temporaryStatusValueForOutputSlot == null) {
            this.setTemporaryStatusValueForOutputSlot((BStatusValue)new BStatusBoolean());
        }
        this.temporaryStatusValueForOutputSlot.setStatus(out.getStatus());
        if (!this.getStatus().equals((Object)BStatus.ok)) {
            this.temporaryStatusValueForOutputSlot.setStatus(this.getStatus());
            this.temporaryStatusValueForOutputSlot.setStatusNull(true);
        }
        out.copyFrom((BComplex)this.temporaryStatusValueForOutputSlot);
    }

    @Override
    public int getAddress() {
        return this.getInputNumber();
    }

    @Override
    public int getMaxAddress() {
        if (this.parentComponent == null) {
            return -1;
        }
        return this.parentComponent.getDIQuantity();
    }

    @Override
    void setMyPointAddress() {
        int myNum = this.getFirstFreeNumber(1, this.parentComponent.getDIQuantity());
        this.setInputNumber(myNum);
    }

    @Override
    public int getPointQuantity() {
        return this.parentComponent.getDIQuantity();
    }

    @Override
    boolean isIOPoint() {
        return true;
    }
}

