/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.points;

import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.messages.ModbusReadRequest;
import com.gc5.iSMA_IO.messages.ModbusWriteRequest;
import com.gc5.iSMA_IO.points.BIsmaInputProxyExt;
import com.gc5.iSMA_IO.points.BIsmaIoDigitalInputCounterPoint;
import java.lang.reflect.Method;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", flags=264, defaultValue="false"), @NiagaraProperty(name="valueSaved", type="int", flags=68, defaultValue="0")})
public class BDigitalInputCounterProxyExt
extends BIsmaInputProxyExt {
    public static final Property enabled = BDigitalInputCounterProxyExt.newProperty((int)264, (boolean)false, null);
    public static final Property valueSaved = BDigitalInputCounterProxyExt.newProperty((int)68, (int)0, null);
    public static final Type TYPE = Sys.loadType(BDigitalInputCounterProxyExt.class);
    public boolean presetValueToWrite = false;
    public int presetValue = -1;

    @Override
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Override
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public int getValueSaved() {
        return this.getInt(valueSaved);
    }

    public void setValueSaved(int v) {
        this.setInt(valueSaved, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void sendConfigurations() {
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (!this.isRunning() || this.parentComponent == null) {
            return;
        }
        if (this.parentComponent.deviceIsReady) {
            this.setPointToReady();
        } else {
            this.waitingForDevice = true;
        }
    }

    void sendPresetValue() {
        int[] valueToPreset = new int[2];
        if (this.presetValueToWrite) {
            valueToPreset[0] = this.presetValue & 0xFFFF;
            valueToPreset[1] = this.presetValue >>> 16;
            try {
                Method m = BDigitalInputCounterProxyExt.class.getMethod("callRead", ModbusMessage.class);
                this.parentComponent.addRequest(new ModbusWriteRequest(this, m, this.parentComponent.devAddr, 16, 22 + (this.getAddress() - 1) * 2, 2, valueToPreset));
                this.presetValueToWrite = false;
            }
            catch (Exception e) {
                log.severe(e.getLocalizedMessage());
            }
        }
    }

    @Override
    public ModbusMessage makeMpm() {
        ModbusReadRequest tempMm = null;
        try {
            Method m = BDigitalInputCounterProxyExt.class.getMethod("setOutputValues", ModbusMessage.class);
            tempMm = new ModbusReadRequest(this, m, this.parentComponent.devAddr, 3, 22 + (this.getAddress() - 1) * 2, 2);
        }
        catch (Exception e) {
            log.severe(e.getLocalizedMessage());
        }
        return tempMm;
    }

    @Override
    public boolean setOutputValues(ModbusMessage mm) {
        if (!super.setOutputValues(mm)) {
            return false;
        }
        this.temporaryStatusValueForOutputSlot = new BStatusNumeric((double)((mm.getRegister(1) << 16) + mm.getRegister(0)));
        this.myPoint.doExecute();
        return true;
    }

    public void onExecute(BStatusValue out, Context cx) {
        if (this.temporaryStatusValueForOutputSlot == null) {
            this.setTemporaryStatusValueForOutputSlot((BStatusValue)new BStatusNumeric());
        }
        this.temporaryStatusValueForOutputSlot.setStatus(out.getStatus());
        if (!this.getStatus().equals((Object)BStatus.ok)) {
            this.temporaryStatusValueForOutputSlot.setStatus(this.getStatus());
            this.temporaryStatusValueForOutputSlot.setStatusNull(true);
        }
        out.copyFrom((BComplex)this.temporaryStatusValueForOutputSlot);
        if (this.valueRestored) {
            this.setValueSaved((int)((BStatusNumeric)this.temporaryStatusValueForOutputSlot).getNumeric());
        }
    }

    @Override
    public int getAddress() {
        return this.getInputNumber();
    }

    @Override
    public int getMaxAddress() {
        if (this.parentComponent == null) {
            return -1;
        }
        return this.parentComponent.getDIQuantity();
    }

    @Override
    public void restoreLastValue() {
        if (this.getValueSaved() != 0) {
            ((BIsmaIoDigitalInputCounterPoint)this.myPoint).doSet(BDouble.make((double)this.getValueSaved()));
        }
        this.valueRestored = true;
    }

    @Override
    boolean isIOPoint() {
        return true;
    }

    @Override
    void setMyPointAddress() {
        int myNum = this.getFirstFreeNumber(1, this.parentComponent.getDIQuantity());
        this.setInputNumber(myNum);
    }

    @Override
    public int getPointQuantity() {
        return this.parentComponent.getDIQuantity();
    }

    @Override
    Type getPointType() {
        return BIsmaIoDigitalInputCounterPoint.TYPE;
    }
}

