/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.points;

import com.gc5.iSMA_IO.devices.BIsmaCommonIoDevice;
import com.gc5.iSMA_IO.devices.BIsmaRemoteDevice;
import com.gc5.iSMA_IO.enums.BAOType;
import com.gc5.iSMA_IO.enums.BLinearConversion;
import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.messages.ModbusReadRequest;
import com.gc5.iSMA_IO.messages.ModbusWriteRequest;
import com.gc5.iSMA_IO.points.BIsmaOutputProxyExt;
import java.lang.reflect.Method;
import javax.baja.control.BNumericWritable;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="AnalogType", type="BAOType", flags=0, defaultValue="BAOType.voltage"), @NiagaraProperty(name="linearConversion", type="BLinearConversion", flags=0, defaultValue="new BLinearConversion()")})
public class BAnalogOutputProxyExt
extends BIsmaOutputProxyExt {
    public static final Property AnalogType = BAnalogOutputProxyExt.newProperty((int)0, (BValue)BAOType.voltage, null);
    public static final Property linearConversion = BAnalogOutputProxyExt.newProperty((int)0, (BValue)new BLinearConversion(), null);
    public static final Type TYPE = Sys.loadType(BAnalogOutputProxyExt.class);
    final int aoFirstPartQty = 6;
    Double oldValue = null;
    Property defaultValueProperty = null;
    BAOType oldAnalogType = this.getAnalogType();
    private final BFacets defFacetsVoltage = BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"volt"), (int)2);
    private final BFacets defFacetsPWM = BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"percent"), (int)0);

    public BAOType getAnalogType() {
        return (BAOType)this.get(AnalogType);
    }

    public void setAnalogType(BAOType v) {
        this.set(AnalogType, (BValue)v, null);
    }

    public BLinearConversion getLinearConversion() {
        return (BLinearConversion)this.get(linearConversion);
    }

    public void setLinearConversion(BLinearConversion v) {
        this.set(linearConversion, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(property, context);
        if (property == AnalogType) {
            this.sendAnalogTypeConf();
            this.setMyPointsDefaultFacets();
            this.doPoll();
        }
        if (property == this.defaultValueProperty && this.parentComponent instanceof BIsmaRemoteDevice) {
            this.sendDefaultValueConf();
            this.doPoll();
        }
        if (property == BLinearConversion.scale || property == BLinearConversion.offset) {
            this.writeValue(true);
        }
    }

    @Override
    public void sendConfigurations() {
        this.sendAnalogTypeConf();
        if (this.parentComponent instanceof BIsmaRemoteDevice) {
            this.sendDefaultValueConf();
        }
    }

    void sendDefaultValueConf() {
        int regAddress = this.getAddress() - 1;
        regAddress = AOConfReg.defaultStateStartReg.getValue() + regAddress;
        try {
            this.parentComponent.addRequest(new ModbusWriteRequest(this, null, this.parentComponent.devAddr, 6, regAddress, 1, this.numericToIntArray(this.getDouble(this.defaultValueProperty))));
        }
        catch (Exception e) {
            log.severe(e.getLocalizedMessage());
        }
    }

    void sendAnalogTypeConf() {
        if (!(this.parentComponent instanceof BIsmaCommonIoDevice)) {
            return;
        }
        int regAddress = this.getAddress() - 1;
        regAddress = regAddress < 6 ? AOConfReg.firstPartStartReg.getValue() + regAddress : AOConfReg.secondPartStartReg.getValue() + regAddress - 6;
        int[] conf = new int[1];
        if (this.getAnalogType().equals((Object)BAOType.voltage)) {
            conf[0] = 0;
        } else if (this.getAnalogType().equals((Object)BAOType.pwm1hz)) {
            conf[0] = 1;
        } else if (this.getAnalogType().equals((Object)BAOType.pwm10hz)) {
            conf[0] = 2;
        } else if (this.getAnalogType().equals((Object)BAOType.pwm100hz)) {
            conf[0] = 3;
        } else if (this.getAnalogType().equals((Object)BAOType.pwm01hz)) {
            conf[0] = 4;
        } else if (this.getAnalogType().equals((Object)BAOType.pwm001hz)) {
            conf[0] = 5;
        }
        try {
            this.parentComponent.addRequest(new ModbusWriteRequest(this, null, this.parentComponent.devAddr, 6, regAddress, 1, conf));
        }
        catch (Exception e) {
            log.severe(e.getLocalizedMessage());
        }
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (!this.isRunning() || this.parentComponent == null) {
            return;
        }
        this.InitializeVariables();
        this.dynamicDefaultValueSlot();
        if (this.parentComponent.deviceIsReady) {
            this.setPointToReady();
        } else {
            this.waitingForDevice = true;
        }
    }

    private void InitializeVariables() {
        if (this.parentComponent instanceof BIsmaRemoteDevice && !((BIsmaRemoteDevice)this.parentComponent).getWriteOnStart()) {
            this.oldValue = this.getInActiveLevel().getNumeric();
        }
    }

    private void dynamicDefaultValueSlot() {
        Slot slot = this.getSlot("DefaultValue");
        if (slot != null) {
            if (this.parentComponent instanceof BIsmaRemoteDevice) {
                this.defaultValueProperty = slot.asProperty();
            } else {
                this.remove(slot.asProperty());
            }
            return;
        }
        if (this.parentComponent instanceof BIsmaRemoteDevice) {
            this.defaultValueProperty = this.add("DefaultValue", (BValue)BDouble.DEFAULT, 0, (Context)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)0.0)), (BFacets)BFacets.make((String)"max", (BIDataValue)BDouble.make((double)10.0))));
            this.setDisplayName(this.defaultValueProperty.asProperty(), BFormat.make((String)"Default Value"), null);
        }
    }

    int[] numericToIntArray(double val) {
        int[] values = new int[]{this.getAnalogType() == BAOType.voltage && this.myPoint.getFacets().getFacet("units").equals((Object)BUnit.getUnit((String)"volt")) ? (int)(val * 1000.0) : (int)val};
        if (values[0] < 0) {
            values[0] = 0;
        }
        if (values[0] > 10000) {
            values[0] = 10000;
        }
        return values;
    }

    @Override
    public void writeValue(boolean forcedWriting) {
        Double value;
        BStatusNumeric inSlotsActivLevel = this.getInActiveLevel();
        if (this.getEnabled() && !inSlotsActivLevel.getStatus().isNull() && this.isRunning() && this.parentComponent instanceof BIsmaCommonIoDevice && (!(value = Double.valueOf(this.getValueWithLinearConversion(inSlotsActivLevel.getNumeric()))).equals(this.oldValue) || forcedWriting)) {
            this.oldValue = value;
            try {
                Method m = BAnalogOutputProxyExt.class.getMethod("callRead", ModbusMessage.class);
                this.parentComponent.addRequest(new ModbusWriteRequest(this, m, this.parentComponent.devAddr, 16, this.getRegisterAddress(), 1, this.numericToIntArray(value)));
            }
            catch (Exception e) {
                log.severe(e.getLocalizedMessage());
            }
        }
    }

    private double getValueWithLinearConversion(double value) {
        double scale = this.getLinearConversion().getScale();
        double offset = this.getLinearConversion().getOffset();
        if (scale == 0.0) {
            return 0.0;
        }
        return (value - offset) / scale;
    }

    int getRegisterAddress() {
        int regAddress = this.getAddress();
        if (--regAddress < 6) {
            return AOValReg.firstPartStartReg.getValue() + regAddress;
        }
        return AOValReg.secondPartStartReg.getValue() + regAddress - 6;
    }

    @Override
    public boolean setOutputValues(ModbusMessage mm) {
        if (!super.setOutputValues(mm)) {
            return false;
        }
        double val = 0.0;
        val = this.myPoint.getFacets().getFacet("units").equals((Object)BUnit.getUnit((String)"volt")) ? (double)mm.getRegisters()[0] / 1000.0 : (double)mm.getRegisters()[0];
        this.temporaryStatusValueForOutputSlot = new BStatusNumeric(val);
        this.myPoint.doExecute();
        return true;
    }

    @Override
    public ModbusMessage makeMpm() {
        try {
            Method m = BAnalogOutputProxyExt.class.getMethod("setOutputValues", ModbusMessage.class);
            return new ModbusReadRequest(this, m, this.parentComponent.devAddr, 3, this.getRegisterAddress(), 1);
        }
        catch (Exception e) {
            log.severe(e.getLocalizedMessage());
            return null;
        }
    }

    BStatusNumeric getInActiveLevel() {
        try {
            for (int i = 1; i < 17; ++i) {
                Method getIn = ((BNumericWritable)this.getParent().getParentComponent()).getClass().getMethod("getIn" + i, null);
                BStatusNumeric inVal = (BStatusNumeric)getIn.invoke((Object)this.getParent().getParentComponent(), null);
                if (inVal.getStatus().isNull()) continue;
                return inVal;
            }
        }
        catch (Exception e) {
            log.severe("Getting active level problem: " + e.getLocalizedMessage());
        }
        return ((BNumericWritable)this.getParent().getParentComponent()).getFallback();
    }

    public void onExecute(BStatusValue out, Context cx) {
        BStatus stat;
        if (this.isPointReady) {
            this.writeValue(false);
        }
        if ((stat = out.getStatus()).isNull()) {
            stat = BStatus.ok;
        }
        if (this.temporaryStatusValueForOutputSlot == null) {
            this.setTemporaryStatusValueForOutputSlot((BStatusValue)new BStatusNumeric());
        }
        BStatusNumeric statusValueForOutputSlot = !(this.temporaryStatusValueForOutputSlot instanceof BStatusNumeric) || this.getLinearConversion().getScale() == 0.0 ? new BStatusNumeric(0.0) : new BStatusNumeric(((BStatusNumeric)this.temporaryStatusValueForOutputSlot).getNumeric() * this.getLinearConversion().getScale() + this.getLinearConversion().getOffset());
        statusValueForOutputSlot.copyFrom((BComplex)new BStatusNumeric(statusValueForOutputSlot.getNumeric(), stat));
        if (!this.getStatus().equals((Object)BStatus.ok)) {
            statusValueForOutputSlot.setStatus(this.getStatus());
            statusValueForOutputSlot.setStatusNull(true);
        }
        out.copyFrom((BComplex)statusValueForOutputSlot);
    }

    @Override
    public void setMyPointsDefaultFacets() {
        if (this.myPoint == null) {
            return;
        }
        if (this.getAnalogType().equals((Object)BAOType.voltage)) {
            this.myPoint.setFacets(this.defFacetsVoltage);
        } else {
            this.myPoint.setFacets(this.defFacetsPWM);
        }
    }

    @Override
    boolean isIOPoint() {
        return true;
    }

    @Override
    void setMyPointAddress() {
        int myNum = this.getFirstFreeNumber(1, this.parentComponent.getAOQuantity());
        this.setOutputNumber(myNum);
    }

    @Override
    public int getAddress() {
        return this.getOutputNumber();
    }

    @Override
    public int getMaxAddress() {
        if (this.parentComponent == null) {
            return -1;
        }
        return this.parentComponent.getAOQuantity();
    }

    @Override
    Type getPointType() {
        return BNumericWritable.TYPE;
    }

    @Override
    public int getPointQuantity() {
        return this.parentComponent.getAOQuantity();
    }

    static enum AOConfReg {
        firstPartStartReg(167),
        secondPartStartReg(224),
        defaultStateStartReg(144);

        private final int value;

        private AOConfReg(int newValue) {
            this.value = newValue;
        }

        public int getValue() {
            return this.value;
        }
    }

    static enum AOValReg {
        firstPartStartReg(120),
        secondPartStartReg(220);

        private final int value;

        private AOValReg(int newValue) {
            this.value = newValue;
        }

        public int getValue() {
            return this.value;
        }
    }
}

