/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.networks;

import com.gc5.iSMA_IO.comm.BasicComm;
import com.gc5.iSMA_IO.devices.BIsmaCommonIoDevice;
import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.networks.BIsmaNetwork;
import com.gc5.iSMA_IO.networks.CircularBuffer;
import com.gc5.iSMA_IO.points.BIsmaIoProxyExt;
import java.io.IOException;
import java.net.SocketException;
import java.util.logging.Logger;
import javax.baja.status.BStatus;

public class PollingThread
implements Runnable {
    private Thread t;
    BasicComm comm;
    volatile boolean stopThread = false;
    private int retryCount;
    private CircularBuffer requests = new CircularBuffer(2048);
    private static final Logger log = Logger.getLogger("iSMA_IO::PollingThread");

    PollingThread(BasicComm c) {
        this(c, 3);
    }

    PollingThread(BasicComm c, int retryCount) {
        this.comm = c;
        this.retryCount = retryCount;
    }

    void stopThread() {
        this.stopThread = true;
        try {
            this.t.join();
        }
        catch (InterruptedException ie) {
            log.severe(ie.getLocalizedMessage());
        }
        finally {
            if (this.comm != null) {
                this.comm.close();
            }
        }
    }

    public void start() {
        if (this.t == null) {
            this.t = new Thread(this);
            this.t.start();
        }
    }

    @Override
    public void run() {
        while (!this.stopThread) {
            try {
                int repeatTry;
                ModbusMessage mm = this.requests.get();
                if (mm == null) {
                    Thread.sleep(10L);
                    continue;
                }
                long start = System.nanoTime();
                Thread.sleep(0L, 243056);
                byte[] myFrame = mm.getFrame();
                boolean badCommRS = false;
                boolean outStreamProblem = false;
                for (repeatTry = 0; repeatTry < this.retryCount; ++repeatTry) {
                    try {
                        outStreamProblem = false;
                        if (!this.comm.write(myFrame)) {
                            outStreamProblem = true;
                            log.warning("Unsuccessful write to device with address " + (myFrame[0] & 0xFF));
                            continue;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        mm.setOutput();
                        break;
                    }
                    try {
                        badCommRS = false;
                        mm.prepareResponseArray(this.comm.receive());
                    }
                    catch (SocketException ex) {
                        log.fine("Connection reset triggered by: " + ex.getMessage());
                        this.networkFeedback(mm);
                        continue;
                    }
                    catch (IOException ex) {
                        badCommRS = true;
                    }
                    if (mm.setOutput()) break;
                    log.severe("Response error: " + (Object)((Object)mm.getResponseError()) + " from device with address " + (myFrame[0] & 0xFF));
                }
                if (repeatTry >= this.retryCount) {
                    log.severe("Writing problem or response error: " + (Object)((Object)mm.getResponseError()) + " for device with address " + (myFrame[0] & 0xFF));
                    boolean sendFeedback = outStreamProblem ? true : !badCommRS;
                    if (!sendFeedback) continue;
                    this.networkFeedback(mm);
                    continue;
                }
                long diff = (System.nanoTime() - start) / 1000000L;
                log.finest("Cycle takes: " + diff + " ms");
                long l = System.nanoTime();
            }
            catch (Exception ie) {
                log.severe("Error : " + ie.getMessage());
            }
        }
        log.fine("Thread stopped");
    }

    private void networkFeedback(ModbusMessage modbusMessage) {
        BIsmaNetwork network = this.comm.getCommunicationModel().network;
        if (network != null) {
            network.transmissionFailed(modbusMessage);
        }
    }

    public void addRequest(ModbusMessage modbusMessage) {
        try {
            if (!this.validateModbusMessage(modbusMessage)) {
                return;
            }
            this.requests.put(modbusMessage);
        }
        catch (Exception ie) {
            log.severe(ie.getLocalizedMessage());
        }
    }

    private boolean validateModbusMessage(ModbusMessage modbusMessage) {
        Object object = modbusMessage.getObject();
        if (object instanceof BIsmaIoProxyExt) {
            return this.validateComponent((BIsmaIoProxyExt)object, modbusMessage);
        }
        if (object instanceof BIsmaCommonIoDevice) {
            return this.validateDevice((BIsmaCommonIoDevice)object);
        }
        return object instanceof BIsmaNetwork;
    }

    private boolean validateDevice(BIsmaCommonIoDevice device) {
        return device != null && device.isInDeviceLimitRange() && device.getNetwork() != null && device.getNetwork().getStatus().isOk() && !device.getStatus().equals((Object)BStatus.disabled);
    }

    private boolean validateComponent(BIsmaIoProxyExt component, ModbusMessage modbusMessage) {
        if (component == null || !component.isInPointLimitRange() || component.getStatus().equals((Object)BStatus.disabled) || component.parentComponent == null || !component.parentComponent.getStatus().equals((Object)BStatus.ok)) {
            return false;
        }
        if (modbusMessage.isPingRequest() || modbusMessage.isForceRequest()) {
            return true;
        }
        return component.getStatus().equals((Object)BStatus.ok);
    }

    public CircularBuffer getBuffer() {
        return this.requests;
    }

    public static Logger getLogger() {
        return log;
    }
}

