/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.networks;

import com.gc5.iSMA_IO.comm.SerialComm;
import com.gc5.iSMA_IO.devices.BIsmaRemoteDevice;
import com.gc5.iSMA_IO.enums.SerialParameters.BBaudrates;
import com.gc5.iSMA_IO.enums.SerialParameters.BDataBits;
import com.gc5.iSMA_IO.enums.SerialParameters.BParityBits;
import com.gc5.iSMA_IO.enums.SerialParameters.BStopBits;
import com.gc5.iSMA_IO.enums.Utilities.Statuses;
import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.models.SerialCommunicationParametersModel;
import com.gc5.iSMA_IO.networks.BIsmaNetwork;
import com.gc5.iSMA_IO.networks.INetworkListener;
import com.gc5.iSMA_IO.networks.PollingThread;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraAction(name="pingDevices", flags=4)
@NiagaraProperties(value={@NiagaraProperty(name="portCOM", type="String", defaultValue="COM1"), @NiagaraProperty(name="baudRate", type="BBaudrates", defaultValue="BBaudrates.Baud_115200"), @NiagaraProperty(name="dataBits", type="BDataBits", defaultValue="BDataBits.DataBits8"), @NiagaraProperty(name="stopBits", type="BStopBits", defaultValue="BStopBits.StopBits1"), @NiagaraProperty(name="parityBits", type="BParityBits", defaultValue="BParityBits.None"), @NiagaraProperty(name="pingFrequency", type="BRelTime", defaultValue="BRelTime.make(300000L)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(minimumPingFrequencyValue)"), @Facet(name="BFacets.MAX", value="BRelTime.make(maximumPingFrequencyValue)")}), @NiagaraProperty(name="retryCount", type="int", defaultValue="2", facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="10")}), @NiagaraProperty(name="responseTimeout", type="int", defaultValue="100", facets={@Facet(name="BFacets.MIN", value="30"), @Facet(name="BFacets.MAX", value="3000"), @Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"millisecond\")")})})
public class BIsmaRemoteSerialNetwork
extends BIsmaNetwork {
    private static long minimumPingFrequencyValue = 1000L;
    private static long maximumPingFrequencyValue = 86400000L;
    public static final Property portCOM = BIsmaRemoteSerialNetwork.newProperty((int)0, (String)"COM1", null);
    public static final Property baudRate = BIsmaRemoteSerialNetwork.newProperty((int)0, (BValue)BBaudrates.Baud_115200, null);
    public static final Property dataBits = BIsmaRemoteSerialNetwork.newProperty((int)0, (BValue)BDataBits.DataBits8, null);
    public static final Property stopBits = BIsmaRemoteSerialNetwork.newProperty((int)0, (BValue)BStopBits.StopBits1, null);
    public static final Property parityBits = BIsmaRemoteSerialNetwork.newProperty((int)0, (BValue)BParityBits.None, null);
    public static final Property pingFrequency = BIsmaRemoteSerialNetwork.newProperty((int)0, (BValue)BRelTime.make((long)300000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)minimumPingFrequencyValue)), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.make((long)maximumPingFrequencyValue))));
    public static final Property retryCount = BIsmaRemoteSerialNetwork.newProperty((int)0, (int)2, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)10)));
    public static final Property responseTimeout = BIsmaRemoteSerialNetwork.newProperty((int)0, (int)100, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)30), (BFacets)BFacets.make((String)"max", (int)3000)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond"))));
    public static final Action pingDevices = BIsmaRemoteSerialNetwork.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BIsmaRemoteSerialNetwork.class);
    private boolean couldNotOpenComPort = false;
    protected boolean networkStarted = false;
    private static String[] serialPortsList = null;
    private static int numberOfSerialPorts = 0;
    private static ArrayList<BIsmaRemoteSerialNetwork> ismaRemoteSerialNetworks = new ArrayList();
    private PollingThread pollingThread;
    protected final Logger log = Logger.getLogger("iSMA_IO::iSMAIOSerialNetwork");

    public String getPortCOM() {
        return this.getString(portCOM);
    }

    public void setPortCOM(String v) {
        this.setString(portCOM, v, null);
    }

    public BBaudrates getBaudRate() {
        return (BBaudrates)this.get(baudRate);
    }

    public void setBaudRate(BBaudrates v) {
        this.set(baudRate, (BValue)v, null);
    }

    public BDataBits getDataBits() {
        return (BDataBits)this.get(dataBits);
    }

    public void setDataBits(BDataBits v) {
        this.set(dataBits, (BValue)v, null);
    }

    public BStopBits getStopBits() {
        return (BStopBits)this.get(stopBits);
    }

    public void setStopBits(BStopBits v) {
        this.set(stopBits, (BValue)v, null);
    }

    public BParityBits getParityBits() {
        return (BParityBits)this.get(parityBits);
    }

    public void setParityBits(BParityBits v) {
        this.set(parityBits, (BValue)v, null);
    }

    public BRelTime getPingFrequency() {
        return (BRelTime)this.get(pingFrequency);
    }

    public void setPingFrequency(BRelTime v) {
        this.set(pingFrequency, (BValue)v, null);
    }

    public int getRetryCount() {
        return this.getInt(retryCount);
    }

    public void setRetryCount(int v) {
        this.setInt(retryCount, v, null);
    }

    public int getResponseTimeout() {
        return this.getInt(responseTimeout);
    }

    public void setResponseTimeout(int v) {
        this.setInt(responseTimeout, v, null);
    }

    public void pingDevices() {
        this.invoke(pingDevices, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void addRequest(ModbusMessage modbusMessage) {
        if (this.pollingThread != null) {
            this.pollingThread.addRequest(modbusMessage);
        }
    }

    @Override
    public void started() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        BIsmaRemoteSerialNetwork.getAvailableSerialPorts();
        super.started();
        this.pollDevicesClock = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getPingFrequency(), (Action)pingDevices, null);
        if (this.validateComPort() && !this.checkDuplicatedComPort()) {
            this.getCommunicationParametersModel();
            this.startTransmission();
        }
        ismaRemoteSerialNetworks.add(this);
        this.networkStarted = true;
    }

    private boolean checkDuplicatedComPort() {
        for (BIsmaRemoteSerialNetwork remoteSerialNetwork : ismaRemoteSerialNetworks) {
            if (remoteSerialNetwork.equals((Object)this) || !remoteSerialNetwork.getStatus().isOk() || !remoteSerialNetwork.getPortCOM().toUpperCase().equals(this.getPortCOM().toUpperCase())) continue;
            this.networkStatus = Statuses.DUPLICATED_PORT;
            this.setStatusAndFaultCauseSlots();
            return true;
        }
        return false;
    }

    private boolean validateComPort() {
        if (serialPortsList == null) {
            return false;
        }
        return Arrays.asList(serialPortsList).contains(this.getPortCOM());
    }

    private static void getAvailableSerialPorts() {
        if (serialPortsList != null) {
            return;
        }
        serialPortsList = SerialComm.getSerialPorts();
        if (serialPortsList == null) {
            return;
        }
        numberOfSerialPorts = serialPortsList.length;
    }

    @Override
    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (!this.networkStarted || !this.validHardware || property == status || property == faultCause) {
            return;
        }
        if (property == enabled && !this.getEnabled()) {
            this.stopTransmission();
            this.updateNetworkStatus();
            this.notifyObservers(x -> x.networkUpdated(property));
            return;
        }
        if (property == pingFrequency && this.validatePingFrequencyValue()) {
            this.restartDevicesPollingClock();
        }
        if (property == enabled || property == portCOM || property == baudRate || property == dataBits || property == stopBits || property == parityBits || property == retryCount || property == responseTimeout) {
            try {
                if (this.validateComPort() && !this.checkDuplicatedComPort()) {
                    this.getCommunicationParametersModel();
                    this.startTransmission();
                    this.restartDevicesPollingClock();
                } else {
                    this.stopTransmission();
                }
            }
            catch (Exception e) {
                this.stopTransmission();
                this.log.severe(e.getLocalizedMessage());
            }
        }
        this.updateNetworkStatus();
        this.notifyObservers(x -> x.networkUpdated(property));
    }

    @Override
    public void transmissionFailed(ModbusMessage mm) {
    }

    private boolean validatePingFrequencyValue() {
        BRelTime pingFrequency = this.getPingFrequency();
        return pingFrequency.getMillis() >= minimumPingFrequencyValue && pingFrequency.getMillis() <= maximumPingFrequencyValue;
    }

    private void restartDevicesPollingClock() {
        if (this.pollDevicesClock != null) {
            try {
                this.pollDevicesClock.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.doPingDevices();
        this.pollDevicesClock = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getPingFrequency(), (Action)pingDevices, null);
    }

    private SerialCommunicationParametersModel getCommunicationParametersModel() {
        return new SerialCommunicationParametersModel(this.getPortCOM(), this.getBaudRate().getTag(), this.getDataBits().getTag(), this.getStopBits().getTag(), this.getParityBits().getTag(), this.getResponseTimeout(), this);
    }

    private void startTransmission() {
        if (!this.getEnabled()) {
            return;
        }
        try {
            this.stopTransmission();
            this.pollingThread = new PollingThread(new SerialComm(this.getCommunicationParametersModel()), this.getRetryCount());
            this.pollingThread.start();
            this.couldNotOpenComPort = false;
        }
        catch (Exception ex) {
            if (this.pollingThread != null) {
                this.pollingThread.stopThread();
            }
            this.couldNotOpenComPort = true;
            this.updateNetworkStatus();
            this.log.severe(ex.getLocalizedMessage());
        }
    }

    private void stopTransmission() {
        if (this.pollingThread != null) {
            this.pollingThread.stopThread();
        }
    }

    public void doPingDevices() {
        for (INetworkListener listener : this.listeners) {
            ((BIsmaRemoteDevice)listener).pingDevice();
        }
    }

    @Override
    public void updateNetworkStatus() {
        this.networkStatus = !this.getEnabled() ? Statuses.DISABLED : (!this.validHardware ? Statuses.INVALID_HARDWARE : (!this.validateComPort() ? Statuses.INVALID_PORT : (this.couldNotOpenComPort ? Statuses.COULD_NOT_OPEN_COM_PORT : (this.checkDuplicatedComPort() ? Statuses.DUPLICATED_PORT : Statuses.OK))));
        this.setStatusAndFaultCauseSlots();
    }

    @Override
    boolean checkDuplicatedNetwork() {
        return false;
    }

    @Override
    public void stopped() throws Exception {
        if (this.pollingThread != null) {
            this.pollingThread.stopThread();
        }
        super.stopped();
        ismaRemoteSerialNetworks.remove((Object)this);
    }
}

