/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.messages;

import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.messages.ModbusOutputStream;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;

public class ModbusWriteStringRequest
extends ModbusMessage {
    int[] registers = new int[4];
    int registersQuantity = 4;
    ModbusMessage.responseStatus responseError = ModbusMessage.responseStatus.Ok;

    public ModbusWriteStringRequest(Object object, Method method, int devAddr, int start, int[] valuesToWrite) {
        this.deviceAddress = devAddr;
        this.functionCode = 16;
        this.startAddress = start;
        this.object = object;
        this.method = method;
        this.validateRegisters(valuesToWrite);
    }

    private void validateRegisters(int[] valuesToWrite) {
        if (valuesToWrite == null) {
            this.registers = new int[4];
        }
        System.arraycopy(valuesToWrite, 0, this.registers, 0, valuesToWrite.length > this.registersQuantity ? this.registersQuantity : valuesToWrite.length);
    }

    @Override
    public byte[] getFrame() {
        ModbusOutputStream modOut = new ModbusOutputStream();
        modOut.write((byte)this.deviceAddress);
        modOut.write(16);
        modOut.write((byte)((this.startAddress & 0xFF00) >> 8));
        modOut.write((byte)(this.startAddress & 0xFF));
        modOut.write(0);
        modOut.write(2);
        modOut.write(4);
        modOut.write((byte)this.registers[0]);
        modOut.write((byte)this.registers[1]);
        modOut.write((byte)this.registers[2]);
        modOut.write((byte)this.registers[3]);
        return modOut.toByteArray();
    }

    @Override
    public int getExpectedBytes() {
        return 5 + this.numberPoints * 2;
    }

    @Override
    public boolean parseResponse() {
        int lo;
        if (this.response == null) {
            this.responseError = ModbusMessage.responseStatus.NoResponse;
            return false;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(this.response);
        if (is.read() != this.deviceAddress) {
            this.responseError = ModbusMessage.responseStatus.InvalidAddress;
            return false;
        }
        if (is.read() != this.functionCode) {
            this.responseError = ModbusMessage.responseStatus.InvalidFunction;
            return false;
        }
        int hi = is.read();
        int startingAdr = (hi << 8) + (lo = is.read());
        if (startingAdr != this.startAddress) {
            this.responseError = ModbusMessage.responseStatus.InvalidStartAddress;
            return false;
        }
        this.registers = new int[this.numberPoints];
        for (int i = 0; i < this.numberPoints; ++i) {
            hi = is.read();
            lo = is.read();
            this.registers[i] = (hi << 8) + lo;
        }
        return true;
    }

    @Override
    public ModbusMessage.responseStatus getResponseError() {
        return this.responseError;
    }

    @Override
    public int getRegister(int i) {
        return this.registers[i];
    }
}

