/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.enums.Modbus;

import com.gc5.iSMA_IO.devices.BIsmaCommonIoDevice;
import com.gc5.iSMA_IO.devices.BIsmaIoDevice;
import com.gc5.iSMA_IO.devices.BIsmaRemoteDevice;
import com.gc5.iSMA_IO.devices.DeviceTypes;
import com.gc5.iSMA_IO.enums.BUISensorType;
import com.gc5.iSMA_IO.enums.Modbus.ModbusUISensorModel;
import com.gc5.iSMA_IO.enums.Modbus.TemperatureSensorModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UISensors {
    public static final int lowestTemperature = Short.MIN_VALUE;
    public static final int highestTemperature = Short.MAX_VALUE;
    public static final String firmwareVersionWithFahrenheitSensors = "6.3";
    private static Map<BUISensorType, ModbusUISensorModel> modbusUiSensorsModels;
    public static final ArrayList<BUISensorType> listOfTemperatureSensors;
    public static final ArrayList<BUISensorType> listOf16BitSenors;

    public static ModbusUISensorModel getModbusUiSensorModel(BUISensorType sensorType) {
        if (!modbusUiSensorsModels.containsKey((Object)sensorType)) {
            return null;
        }
        return modbusUiSensorsModels.get((Object)sensorType);
    }

    public static ModbusUISensorModel getModbusUiSensorModel(BUISensorType sensorType, BIsmaCommonIoDevice parentComponent) {
        boolean isW0202;
        boolean bl = isW0202 = parentComponent instanceof BIsmaRemoteDevice && ((BIsmaRemoteDevice)parentComponent).getDeviceType().equals(DeviceTypes.getDeviceType(80));
        if (listOfTemperatureSensors.contains((Object)sensorType) && (parentComponent instanceof BIsmaIoDevice || parentComponent instanceof BIsmaRemoteDevice && !UISensors.isVersionNewer(((BIsmaRemoteDevice)parentComponent).getFirmwareVersion()) || isW0202)) {
            if (listOf16BitSenors.contains((Object)sensorType)) {
                return isW0202 ? modbusUiSensorsModels.get((Object)BUISensorType.voltage) : modbusUiSensorsModels.get((Object)BUISensorType.tempPt1000);
            }
            return modbusUiSensorsModels.get((Object)BUISensorType.tempNtc10k3a1);
        }
        return UISensors.getModbusUiSensorModel(sensorType);
    }

    public static boolean isVersionNewer(String version) {
        int[] testVersion = UISensors.getVersion(version);
        int[] fahrenheitVersion = UISensors.getVersion(firmwareVersionWithFahrenheitSensors);
        if (testVersion == null || fahrenheitVersion == null) {
            return false;
        }
        for (int i = 0; i < testVersion.length; ++i) {
            if (testVersion[i] == fahrenheitVersion[i]) continue;
            return testVersion[i] > fahrenheitVersion[i];
        }
        return true;
    }

    private static int[] getVersion(String version) {
        if (version == null) {
            return null;
        }
        Matcher m = Pattern.compile("(\\d+)\\.(\\d+)").matcher(version);
        if (!m.matches()) {
            return null;
        }
        return new int[]{Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2))};
    }

    static {
        HashMap<BUISensorType, ModbusUISensorModel> _modbusUiSensorsModels = new HashMap<BUISensorType, ModbusUISensorModel>();
        _modbusUiSensorsModels.put(BUISensorType.voltage, new ModbusUISensorModel(0, TemperatureUnit.None, TemperatureSensorModel.getModel(BUISensorType.voltage)));
        _modbusUiSensorsModels.put(BUISensorType.current, new ModbusUISensorModel(0, TemperatureUnit.None, TemperatureSensorModel.getModel(BUISensorType.current)));
        _modbusUiSensorsModels.put(BUISensorType.digital, new ModbusUISensorModel(126, TemperatureUnit.None, TemperatureSensorModel.getModel(BUISensorType.digital)));
        _modbusUiSensorsModels.put(BUISensorType.resistance, new ModbusUISensorModel(126, TemperatureUnit.None, TemperatureSensorModel.getModel(BUISensorType.resistance)));
        _modbusUiSensorsModels.put(BUISensorType.tempNtc10k3a1, new ModbusUISensorModel(1, TemperatureUnit.Celsius, TemperatureSensorModel.getModel(BUISensorType.tempNtc10k3a1)));
        _modbusUiSensorsModels.put(BUISensorType.tempNtc10k4a1, new ModbusUISensorModel(2, TemperatureUnit.Celsius, TemperatureSensorModel.getModel(BUISensorType.tempNtc10k4a1)));
        _modbusUiSensorsModels.put(BUISensorType.tempNtc10kCarel, new ModbusUISensorModel(3, TemperatureUnit.Celsius, TemperatureSensorModel.getModel(BUISensorType.tempNtc10kCarel)));
        _modbusUiSensorsModels.put(BUISensorType.tempNtc20k6a1, new ModbusUISensorModel(4, TemperatureUnit.Celsius, TemperatureSensorModel.getModel(BUISensorType.tempNtc20k6a1)));
        _modbusUiSensorsModels.put(BUISensorType.tempNtc22k3a1, new ModbusUISensorModel(5, TemperatureUnit.Celsius, TemperatureSensorModel.getModel(BUISensorType.tempNtc22k3a1)));
        _modbusUiSensorsModels.put(BUISensorType.tempNtc3k3a1, new ModbusUISensorModel(6, TemperatureUnit.Celsius, TemperatureSensorModel.getModel(BUISensorType.tempNtc3k3a1)));
        _modbusUiSensorsModels.put(BUISensorType.tempNtc30k6a1, new ModbusUISensorModel(7, TemperatureUnit.Celsius, TemperatureSensorModel.getModel(BUISensorType.tempNtc30k6a1)));
        _modbusUiSensorsModels.put(BUISensorType.tempSie1, new ModbusUISensorModel(8, TemperatureUnit.Celsius, TemperatureSensorModel.getModel(BUISensorType.tempSie1)));
        _modbusUiSensorsModels.put(BUISensorType.tempTac1, new ModbusUISensorModel(9, TemperatureUnit.Celsius, TemperatureSensorModel.getModel(BUISensorType.tempTac1)));
        _modbusUiSensorsModels.put(BUISensorType.tempSat1, new ModbusUISensorModel(10, TemperatureUnit.Celsius, TemperatureSensorModel.getModel(BUISensorType.tempSat1)));
        _modbusUiSensorsModels.put(BUISensorType.tempPt1000, new ModbusUISensorModel(16, TemperatureUnit.Celsius, TemperatureSensorModel.getModel(BUISensorType.tempPt1000)));
        _modbusUiSensorsModels.put(BUISensorType.tempNi1000, new ModbusUISensorModel(17, TemperatureUnit.Celsius, TemperatureSensorModel.getModel(BUISensorType.tempNi1000)));
        _modbusUiSensorsModels.put(BUISensorType.tempNi100021C, new ModbusUISensorModel(18, TemperatureUnit.Celsius, TemperatureSensorModel.getModel(BUISensorType.tempNi100021C)));
        _modbusUiSensorsModels.put(BUISensorType.tempNi1000LG, new ModbusUISensorModel(19, TemperatureUnit.Celsius, TemperatureSensorModel.getModel(BUISensorType.tempNi1000LG)));
        _modbusUiSensorsModels.put(BUISensorType.tempNtc10kType2DegF, new ModbusUISensorModel(20, TemperatureUnit.Fahrenheit, TemperatureSensorModel.getModel(BUISensorType.tempNtc10kType2DegF)));
        _modbusUiSensorsModels.put(BUISensorType.tempNtc10kType3DegF, new ModbusUISensorModel(21, TemperatureUnit.Fahrenheit, TemperatureSensorModel.getModel(BUISensorType.tempNtc10kType3DegF)));
        _modbusUiSensorsModels.put(BUISensorType.tempNtc20kDegF, new ModbusUISensorModel(22, TemperatureUnit.Fahrenheit, TemperatureSensorModel.getModel(BUISensorType.tempNtc20kDegF)));
        _modbusUiSensorsModels.put(BUISensorType.tempNtc3kDegF, new ModbusUISensorModel(23, TemperatureUnit.Fahrenheit, TemperatureSensorModel.getModel(BUISensorType.tempNtc3kDegF)));
        _modbusUiSensorsModels.put(BUISensorType.tempPt1000DegF, new ModbusUISensorModel(24, TemperatureUnit.Fahrenheit, TemperatureSensorModel.getModel(BUISensorType.tempPt1000DegF)));
        _modbusUiSensorsModels.put(BUISensorType.tempNi1000DegF, new ModbusUISensorModel(25, TemperatureUnit.Fahrenheit, TemperatureSensorModel.getModel(BUISensorType.tempNi1000DegF)));
        _modbusUiSensorsModels.put(BUISensorType.tempNi100070DegF, new ModbusUISensorModel(26, TemperatureUnit.Fahrenheit, TemperatureSensorModel.getModel(BUISensorType.tempNi100070DegF)));
        _modbusUiSensorsModels.put(BUISensorType.customTable, new ModbusUISensorModel(126, TemperatureUnit.None, TemperatureSensorModel.getModel(BUISensorType.resistance)));
        modbusUiSensorsModels = Collections.unmodifiableMap(_modbusUiSensorsModels);
        listOfTemperatureSensors = new ArrayList<BUISensorType>(Arrays.asList(BUISensorType.tempNtc10k3a1, BUISensorType.tempNtc10k4a1, BUISensorType.tempNtc10kCarel, BUISensorType.tempNtc20k6a1, BUISensorType.tempNtc22k3a1, BUISensorType.tempNtc3k3a1, BUISensorType.tempNtc30k6a1, BUISensorType.tempSie1, BUISensorType.tempTac1, BUISensorType.tempSat1, BUISensorType.tempPt1000, BUISensorType.tempNi1000, BUISensorType.tempNi100021C, BUISensorType.tempNi1000LG, BUISensorType.tempNtc10kType2DegF, BUISensorType.tempNtc10kType3DegF, BUISensorType.tempNtc20kDegF, BUISensorType.tempNtc3kDegF, BUISensorType.tempPt1000DegF, BUISensorType.tempNi1000DegF, BUISensorType.tempNi100070DegF));
        listOf16BitSenors = new ArrayList<BUISensorType>(Arrays.asList(BUISensorType.tempPt1000, BUISensorType.tempNi1000, BUISensorType.tempNi100021C, BUISensorType.tempNi1000LG, BUISensorType.tempPt1000DegF, BUISensorType.tempNi1000DegF, BUISensorType.tempNi100070DegF));
    }

    public class Values {
        public static final int voltage = 0;
        public static final int current = 0;
        public static final int defaultForNtcSensor = 1;
        public static final int defaultForPtNiSensor = 16;
        public static final int tempNtc10k3a1 = 1;
        public static final int tempNtc10k4a1 = 2;
        public static final int tempNtc10kCarel = 3;
        public static final int tempNtc20k6a1 = 4;
        public static final int tempNtc22k3a1 = 5;
        public static final int tempNtc3k3a1 = 6;
        public static final int tempNtc30k6a1 = 7;
        public static final int tempSie1 = 8;
        public static final int tempTac1 = 9;
        public static final int tempSat1 = 10;
        public static final int tempPt1000 = 16;
        public static final int tempNi1000 = 17;
        public static final int tempNi100021C = 18;
        public static final int tempNi1000LG = 19;
        public static final int tempNtc10kType2F = 20;
        public static final int tempNtc10kType3F = 21;
        public static final int tempNtc20kF = 22;
        public static final int tempNtc3kF = 23;
        public static final int tempPt1000F = 24;
        public static final int tempNi1000F = 25;
        public static final int tempNi100070F = 26;
        public static final int digital = 126;
        public static final int resistance = 126;
    }

    public static enum TemperatureUnit {
        Celsius,
        Fahrenheit,
        None;

    }
}

