/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.enums.Modbus;

import com.gc5.iSMA_IO.enums.BUISensorType;
import java.util.HashMap;
import java.util.Map;

public class TemperatureSensorModel {
    public final int minimumTemperature;
    public final int maximumTemperature;
    public final int step;
    public final int tableSize;
    public final int[] sensorTable;
    private static final Map<BUISensorType, TemperatureSensorModel> listOfModels = new HashMap<BUISensorType, TemperatureSensorModel>(){
        {
            this.put(BUISensorType.tempNtc10k3a1, new TemperatureSensorModel(-50, 125, -5, TemperatureSensorModel.getTempNtc10k3a1()));
            this.put(BUISensorType.tempNtc10k4a1, new TemperatureSensorModel(-50, 125, -5, TemperatureSensorModel.getTempNtc10k4a1()));
            this.put(BUISensorType.tempNtc10kCarel, new TemperatureSensorModel(-50, 125, -5, TemperatureSensorModel.getTempNtc10kCarel()));
            this.put(BUISensorType.tempNtc20k6a1, new TemperatureSensorModel(-40, 125, -5, TemperatureSensorModel.getTempNtc20k6a1()));
            this.put(BUISensorType.tempNtc22k3a1, new TemperatureSensorModel(-50, 125, -5, TemperatureSensorModel.getTempNtc22k3a1()));
            this.put(BUISensorType.tempNtc3k3a1, new TemperatureSensorModel(-50, 125, -5, TemperatureSensorModel.getTempNtc3k3a1()));
            this.put(BUISensorType.tempNtc30k6a1, new TemperatureSensorModel(-30, 125, -5, TemperatureSensorModel.getTempNtc30k6a1()));
            this.put(BUISensorType.tempSie1, new TemperatureSensorModel(-50, 125, -5, TemperatureSensorModel.getTempSie1()));
            this.put(BUISensorType.tempTac1, new TemperatureSensorModel(-40, 125, -5, TemperatureSensorModel.getTempTac1()));
            this.put(BUISensorType.tempSat1, new TemperatureSensorModel(-50, 125, -5, TemperatureSensorModel.getTempSat1()));
            this.put(BUISensorType.tempPt1000, new TemperatureSensorModel(-50, 400, 10, TemperatureSensorModel.getTempPt1000()));
            this.put(BUISensorType.tempNi1000, new TemperatureSensorModel(-50, 150, 10, TemperatureSensorModel.getTempNi1000()));
            this.put(BUISensorType.tempNi100021C, new TemperatureSensorModel(-40, 110, 10, TemperatureSensorModel.getTempNi100021C()));
            this.put(BUISensorType.tempNi1000LG, new TemperatureSensorModel(-50, 150, 10, TemperatureSensorModel.getTempNi1000LG()));
            this.put(BUISensorType.tempNtc10kType2DegF, new TemperatureSensorModel(-40, 250, -5, TemperatureSensorModel.getTempNtc10kType2DegF()));
            this.put(BUISensorType.tempNtc10kType3DegF, new TemperatureSensorModel(-40, 250, -5, TemperatureSensorModel.getTempNtc10kType3DegF()));
            this.put(BUISensorType.tempNtc20kDegF, new TemperatureSensorModel(-40, 250, -5, TemperatureSensorModel.getTempNtc20kDegF()));
            this.put(BUISensorType.tempNtc3kDegF, new TemperatureSensorModel(-40, 250, -5, TemperatureSensorModel.getTempNtc3kDegF()));
            this.put(BUISensorType.tempPt1000DegF, new TemperatureSensorModel(-40, 250, 10, TemperatureSensorModel.getTempPt1000DegF()));
            this.put(BUISensorType.tempNi1000DegF, new TemperatureSensorModel(-40, 250, 10, TemperatureSensorModel.getTempNi1000DegF()));
            this.put(BUISensorType.tempNi100070DegF, new TemperatureSensorModel(-40, 250, 10, TemperatureSensorModel.getTempNi100070DegF()));
        }
    };
    private static final int tempNtc10k3a1_Min = -50;
    private static final int tempNtc10k3a1_Max = 125;
    private static final int tempNtc10k3a1_Step = -5;
    private static final int tempNtc10k4a1_Min = -50;
    private static final int tempNtc10k4a1_Max = 125;
    private static final int tempNtc10k4a1_Step = -5;
    private static final int tempNtc10kCarel_Min = -50;
    private static final int tempNtc10kCarel_Max = 125;
    private static final int tempNtc10kCarel_Step = -5;
    private static final int tempNtc20k6a1_Min = -40;
    private static final int tempNtc20k6a1_Max = 125;
    private static final int tempNtc20k6a1_Step = -5;
    private static final int tempNtc22k3a1_Min = -50;
    private static final int tempNtc22k3a1_Max = 125;
    private static final int tempNtc22k3a1_Step = -5;
    private static final int tempNtc3k3a1_Min = -50;
    private static final int tempNtc3k3a1_Max = 125;
    private static final int tempNtc3k3a1_Step = -5;
    private static final int tempNtc30k6a1_Min = -30;
    private static final int tempNtc30k6a1_Max = 125;
    private static final int tempNtc30k6a1_Step = -5;
    private static final int tempSie1_Min = -50;
    private static final int tempSie1_Max = 125;
    private static final int tempSie1_Step = -5;
    private static final int tempTac1_Min = -40;
    private static final int tempTac1_Max = 125;
    private static final int tempTac1_Step = -5;
    private static final int tempSat1_Min = -50;
    private static final int tempSat1_Max = 125;
    private static final int tempSat1_Step = -5;
    private static final int tempPt1000_Min = -50;
    private static final int tempPt1000_Max = 400;
    private static final int tempPt1000_Step = 10;
    private static final int tempNi1000_Min = -50;
    private static final int tempNi1000_Max = 150;
    private static final int tempNi1000_Step = 10;
    private static final int tempNi100021C_Min = -40;
    private static final int tempNi100021C_Max = 110;
    private static final int tempNi100021C_Step = 10;
    private static final int tempNi1000LG_Min = -50;
    private static final int tempNi1000LG_Max = 150;
    private static final int tempNi1000LG_Step = 10;
    private static final int tempNtc10kType2DegF_Min = -40;
    private static final int tempNtc10kType2DegF_Max = 250;
    private static final int tempNtc10kType2DegF_Step = -5;
    private static final int tempNtc10kType3DegF_Min = -40;
    private static final int tempNtc10kType3DegF_Max = 250;
    private static final int tempNtc10kType3DegF_Step = -5;
    private static final int tempNtc20kDegF_Min = -40;
    private static final int tempNtc20kDegF_Max = 250;
    private static final int tempNtc20kDegF_Step = -5;
    private static final int tempNtc3kDegF_Min = -40;
    private static final int tempNtc3kDegF_Max = 250;
    private static final int tempNtc3kDegF_Step = -5;
    private static final int tempPt1000DegF_Min = -40;
    private static final int tempPt1000DegF_Max = 250;
    private static final int tempPt1000DegF_Step = 10;
    private static final int tempNi1000DegF_Min = -40;
    private static final int tempNi1000DegF_Max = 250;
    private static final int tempNi1000DegF_Step = 10;
    private static final int tempNi100070DegF_Min = -40;
    private static final int tempNi100070DegF_Max = 250;
    private static final int tempNi100070DegF_Step = 10;

    private TemperatureSensorModel(int minimumTemperature, int maximumTemperature, int step, int[] sensorTable) {
        this.minimumTemperature = minimumTemperature;
        this.maximumTemperature = maximumTemperature;
        this.step = step;
        this.sensorTable = sensorTable;
        this.tableSize = (maximumTemperature - minimumTemperature) / Math.abs(step);
    }

    public static TemperatureSensorModel getModel(BUISensorType sensorType) {
        if (!listOfModels.containsKey((Object)sensorType)) {
            return null;
        }
        return listOfModels.get((Object)sensorType);
    }

    private static int[] getTempNtc10k3a1() {
        return new int[]{667828, 491749, 335671, 241840, 176683, 131251, 96974, 72895, 55298, 42314, 32650, 25396, 19904, 15714, 12494, 10000, 8056, 6530, 5325, 4367, 3601, 2985, 2487, 2082, 1751, 1480, 1256, 1070, 916, 787, 678, 587, 510, 444, 388, 340};
    }

    private static int[] getTempNtc10k4a1() {
        return new int[]{441667, 330749, 239831, 181532, 135233, 105081, 78930, 61030, 47549, 37316, 29490, 23462, 18787, 15136, 12268, 10000, 8197, 6754, 5594, 4656, 3893, 3271, 2760, 2339, 1990, 1700, 1458, 1255, 1084, 939, 817, 713, 624, 547, 482, 426};
    }

    private static int[] getTempNtc10kCarel() {
        return new int[]{329500, 247700, 188500, 144100, 111300, 86430, 67770, 53410, 42470, 33900, 27280, 22050, 17960, 14690, 12090, 10000, 8313, 6940, 5827, 4912, 4161, 3536, 3020, 2588, 2228, 1924, 1668, 1451, 1266, 1108, 973, 857, 758, 672, 597, 531};
    }

    private static int[] getTempNtc20k6a1() {
        return new int[]{806800, 574400, 413400, 300400, 220600, 163480, 122260, 92220, 70140, 53780, 41540, 32340, 25340, 20000, 15886, 12698, 10212, 8260, 6718, 5494, 4518, 3732, 3098, 2586, 2166, 1823, 1541, 1308, 1114, 953, 818, 704, 609, 528};
    }

    private static int[] getTempNtc22k3a1() {
        return new int[]{150395, 112994, 75593, 57691, 39789, 30814, 21839, 16416, 12453, 9529, 7353, 5719, 4482, 3539, 2814, 2252, 1814, 1471, 1199, 983, 811, 672, 560, 469, 395, 333, 283, 241, 206, 177, 153, 132, 115, 100, 88, 77};
    }

    private static int[] getTempNtc3k3a1() {
        return new int[]{200348, 150524, 100701, 76853, 53005, 41048, 29092, 21868, 16589, 12694, 9795, 7619, 5971, 4714, 3748, 3000, 2417, 1959, 1598, 1310, 1080, 896, 746, 625, 526, 444, 377, 321, 275, 236, 204, 176, 153, 133, 117, 102};
    }

    private static int[] getTempNtc30k6a1() {
        return new int[]{622911, 477393, 331876, 245785, 183697, 138502, 105305, 80713, 62347, 48511, 38019, 30000, 23828, 19046, 15317, 12390, 10079, 8243, 6777, 5600, 4650, 3879, 3251, 2737, 2313, 1963, 1672, 1430, 1228, 1058, 915, 793};
    }

    private static int[] getTempSie1() {
        return new int[]{10732, 10624, 10517, 10344, 10172, 9913, 9654, 9320, 8933, 8496, 8044, 7489, 6938, 6370, 5798, 5238, 4696, 4185, 3707, 3271, 2875, 2521, 2206, 1929, 1685, 1472, 1287, 1127, 986, 866, 760, 670, 590, 522, 462, 410};
    }

    private static int[] getTempTac1() {
        return new int[]{39024, 29358, 22284, 17073, 13192, 10276, 8068, 6382, 5085, 4078, 3294, 2676, 2188, 1800, 1488, 1237, 1034, 869, 733, 622, 529, 453, 389, 335, 290, 252, 220, 192, 169, 149, 131, 116, 103, 92};
    }

    private static int[] getTempSat1() {
        return new int[]{9719, 9652, 9584, 9467, 9349, 9159, 8968, 8708, 8396, 8031, 7614, 7150, 6649, 6121, 5580, 5039, 4513, 4012, 3545, 3117, 2730, 2386, 2082, 1816, 1585, 1385, 1213, 1064, 937, 828, 734, 654, 585, 525, 474, 429};
    }

    private static int[] getTempPt1000() {
        return new int[]{8031, 8427, 8822, 9216, 9609, 10000, 10390, 10779, 11167, 11554, 11940, 12324, 12708, 13090, 13471, 13851, 14229, 14607, 14983, 15358, 15733, 16105, 16477, 16848, 17217, 17586, 17953, 18319, 18684, 19047, 19410, 19771, 20131, 20490, 20848, 21205, 21561, 21915, 22268, 22621, 22972, 23321, 23670, 24018, 24364, 24709};
    }

    private static int[] getTempNi1000() {
        return new int[]{7426, 7913, 8415, 8930, 9458, 10000, 10555, 11124, 11706, 12301, 12911, 13534, 14172, 14825, 15494, 16178, 16879, 17598, 18334, 19090, 19866};
    }

    private static int[] getTempNi100021C() {
        return new int[]{6993, 7455, 7928, 8412, 8910, 9420, 9943, 10478, 11026, 11585, 12158, 12743, 13343, 14078, 14731, 15240};
    }

    private static int[] getTempNi1000LG() {
        return new int[]{7909, 8308, 8717, 9135, 9562, 10000, 10448, 10907, 11376, 11857, 12350, 12854, 13371, 13901, 14444, 15000, 15570, 16154, 16752, 17365, 17993};
    }

    private static int[] getTempNtc10kType2DegF() {
        return new int[]{336095, 279921, 233942, 196184, 165062, 139324, 117968, 100192, 85346, 72910, 62464, 53660, 46222, 39919, 34563, 30001, 26104, 22767, 19903, 17439, 15313, 13476, 11884, 10501, 9298, 8249, 7333, 6530, 5826, 5208, 4663, 4182, 3757, 3381, 3047, 2751, 2487, 2252, 2042, 1855, 1687, 1536, 1401, 1279, 1169, 1070, 981, 901, 827, 761, 701, 646, 597, 551, 510, 472, 438, 406, 377};
    }

    private static int[] getTempNtc10kType3DegF() {
        return new int[]{239831, 203801, 173631, 148378, 127139, 109226, 94078, 81235, 70317, 61012, 53063, 46255, 40411, 35382, 31046, 27298, 24051, 21234, 18782, 16646, 14780, 13148, 11717, 10459, 9353, 8378, 7517, 6755, 6080, 5481, 4948, 4474, 4051, 3673, 3335, 3032, 2761, 2517, 2297, 2100, 1921, 1760, 1615, 1453, 1363, 1255, 1156, 1066, 985, 910, 842, 780, 723, 671, 623, 580, 540, 503, 469};
    }

    private static int[] getTempNtc20kDegF() {
        return new int[]{817605, 674624, 558679, 464299, 387186, 323956, 271927, 228972, 193390, 163823, 139177, 118571, 101293, 86764, 74511, 64152, 55369, 47904, 41543, 36109, 31457, 27464, 24029, 21068, 18509, 16294, 14372, 12700, 11244, 9974, 8862, 7888, 7034, 6282, 5620, 5036, 4519, 4062, 3657, 3297, 2976, 2691, 2436, 2209, 2005, 1823, 1659, 1512, 1379, 1260, 1153, 1055, 967, 888, 816, 750, 691, 637, 588};
    }

    private static int[] getTempNtc3kDegF() {
        return new int[]{100618, 83827, 70079, 58783, 49468, 41763, 35367, 30042, 25593, 21866, 18735, 16096, 13865, 11975, 10369, 9000, 7831, 6830, 5971, 5232, 4594, 4043, 3565, 3150, 2789, 2475, 2200, 1959, 1748, 1562, 1399, 1254, 1127, 1014, 914, 825, 746, 676, 613, 556, 506, 461, 420, 384, 351, 321, 294, 270, 248, 228, 210, 194, 179, 165, 153, 142, 131, 122, 113};
    }

    private static final int[] getTempPt1000DegF() {
        return new int[]{8427, 8647, 8866, 9085, 9303, 9522, 9739, 9957, 10174, 10390, 10607, 10822, 11038, 11253, 11468, 11683, 11897, 12111, 12324, 12537, 12750, 12962, 13174, 13386, 13597, 13808, 14018, 14229, 14438, 14648};
    }

    private static int[] getTempNi1000DegF() {
        return new int[]{7913, 8189, 8471, 8756, 9046, 9339, 9637, 9939, 10245, 10555, 10869, 11187, 11510, 11836, 12167, 12502, 12841, 13185, 13534, 13885, 14242, 14603, 14970, 15341, 15717, 16098, 16484, 16879, 17273, 17676};
    }

    private static int[] getTempNi100070DegF() {
        return new int[]{6993, 7248, 7507, 7769, 8034, 8303, 8577, 8854, 9135, 9420, 9709, 10002, 10299, 10599, 10903, 11211, 11522, 11838, 12158, 12481, 12809, 13142, 13479, 13820, 14170, 14520, 14870, 15240, 15600, 15970};
    }
}

