/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.devices;

import com.gc5.iSMA_IO.devices.BIsmaRemoteDevice;
import com.gc5.iSMA_IO.devices.DeviceCapabilities;
import com.gc5.iSMA_IO.devices.DeviceTypes;
import com.gc5.iSMA_IO.devices.IDeviceListener;
import com.gc5.iSMA_IO.enums.BPollFreqConf;
import com.gc5.iSMA_IO.enums.Utilities.Statuses;
import com.gc5.iSMA_IO.licenses.BShadowDevice;
import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.messages.ModbusReadRequest;
import com.gc5.iSMA_IO.networks.BIsmaNetwork;
import com.gc5.iSMA_IO.networks.INetworkListener;
import com.gc5.iSMA_IO.points.BIsmaIoProxyExt;
import com.gc5.iSMA_IO.points.PollingThreadModel;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", flags=65, defaultValue="BStatus.ok"), @NiagaraProperty(name="faultCause", type="String", flags=65, defaultValue=""), @NiagaraProperty(name="enabled", type="boolean", flags=264, defaultValue="true"), @NiagaraProperty(name="fastRate", type="BRelTime", flags=0, defaultValue="BRelTime.make(1000L)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(100L)"), @Facet(name="\"showMilliseconds\"", value="BBoolean.TRUE")}), @NiagaraProperty(name="normalRate", type="BRelTime", flags=0, defaultValue="BRelTime.make(5000L)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(100L)"), @Facet(name="\"showMilliseconds\"", value="BBoolean.TRUE")}), @NiagaraProperty(name="slowRate", type="BRelTime", flags=0, defaultValue="BRelTime.make(30000L)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(100L)"), @Facet(name="\"showMilliseconds\"", value="BBoolean.TRUE")})})
public abstract class BIsmaCommonIoDevice
extends BComponent
implements INetworkListener,
BIStatus {
    public static final Property status = BIsmaCommonIoDevice.newProperty((int)65, (BValue)BStatus.ok, null);
    public static final Property faultCause = BIsmaCommonIoDevice.newProperty((int)65, (String)"", null);
    public static final Property enabled = BIsmaCommonIoDevice.newProperty((int)264, (boolean)true, null);
    public static final Property fastRate = BIsmaCommonIoDevice.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)100L)), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE)));
    public static final Property normalRate = BIsmaCommonIoDevice.newProperty((int)0, (BValue)BRelTime.make((long)5000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)100L)), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE)));
    public static final Property slowRate = BIsmaCommonIoDevice.newProperty((int)0, (BValue)BRelTime.make((long)30000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)100L)), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE)));
    public static final Type TYPE = Sys.loadType(BIsmaCommonIoDevice.class);
    private final List<IDeviceListener> listeners = new ArrayList<IDeviceListener>();
    protected BIsmaNetwork network;
    protected boolean validParent;
    protected Statuses deviceStatus = Statuses.DEVICE_DOWN;
    public int devAddr = 1;
    protected final Logger log = Logger.getLogger("iSMA_IO::iSMACommonIODevice");
    DeviceCapabilities deviceCapabilities = new DeviceCapabilities("Unknown", 0, 0, 0, 0);
    public boolean deviceIsReady = false;
    private ArrayList<BIsmaIoProxyExt> fastPollingPoints = new ArrayList();
    private ArrayList<BIsmaIoProxyExt> normalPollingPoints = new ArrayList();
    private ArrayList<BIsmaIoProxyExt> slowPollingPoints = new ArrayList();
    Property shadowDevProp = null;
    private boolean inDeviceLimitRange = true;
    public String pathToNetwork = "";
    private Thread fastPollingThread = null;
    private Thread normalPollingThread = null;
    private Thread slowPollingThread = null;
    private volatile boolean fastPollingThreadFailed = false;
    private volatile boolean normalPollingThreadFailed = false;
    private volatile boolean slowPollingThreadFailed = false;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BRelTime getFastRate() {
        return (BRelTime)this.get(fastRate);
    }

    public void setFastRate(BRelTime v) {
        this.set(fastRate, (BValue)v, null);
    }

    public BRelTime getNormalRate() {
        return (BRelTime)this.get(normalRate);
    }

    public void setNormalRate(BRelTime v) {
        this.set(normalRate, (BValue)v, null);
    }

    public BRelTime getSlowRate() {
        return (BRelTime)this.get(slowRate);
    }

    public void setSlowRate(BRelTime v) {
        this.set(slowRate, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        this.devAddr = this.getDevAddr();
        this.network = this.getNetwork();
        this.setPathToNetwork();
        this.updateDeviceStatus(Statuses.STATUS_UNKNOWN_YET);
        this.registerDeviceToNetwork();
        this.sendDeviceTypeVersionReq();
    }

    private void registerDeviceToNetwork() {
        if (this.network instanceof BIsmaNetwork) {
            try {
                this.network.addListener(this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property != faultCause && property != status) {
            this.updateDeviceStatus(Statuses.STATUS_UNKNOWN_YET);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Consumer<IDeviceListener> func) {
        List<IDeviceListener> list = this.listeners;
        synchronized (list) {
            Iterator<IDeviceListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                IDeviceListener obj = iterator.next();
                if (obj == null) {
                    iterator.remove();
                    continue;
                }
                func.accept(obj);
            }
        }
    }

    public ArrayList<IDeviceListener> getListeners() {
        return new ArrayList<IDeviceListener>(this.listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IDeviceListener listener) {
        List<IDeviceListener> list = this.listeners;
        synchronized (list) {
            if (this.checkListenerPresent(listener)) {
                throw new IllegalArgumentException(listener + " already added to the list of listeners.");
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IDeviceListener listener) {
        List<IDeviceListener> list = this.listeners;
        synchronized (list) {
            if (!this.checkListenerPresent(listener)) {
                throw new IllegalArgumentException(listener + " not found in the list of listeners.");
            }
            this.listeners.remove(listener);
        }
    }

    boolean checkListenerPresent(IDeviceListener listener) {
        return this.listeners.contains(listener);
    }

    public void pingDevice() {
        this.sendDeviceTypeVersionReq();
    }

    void sendDeviceTypeVersionReq() {
        if (this.checkDeviceNumber() || !this.getEnabled()) {
            return;
        }
        try {
            Method m = BIsmaCommonIoDevice.class.getMethod("updateDeviceTypeVersion", ModbusMessage.class);
            ModbusReadRequest mrr = new ModbusReadRequest(this, m, this.devAddr, 3, 0, 1);
            this.addRequest(mrr);
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
        }
    }

    public boolean updateDeviceTypeVersion(ModbusMessage mm) {
        try {
            if (!mm.parseResponse()) {
                this.updateDeviceStatus(Statuses.DEVICE_DOWN);
                return false;
            }
            int typeVersionRegister = mm.getRegister(0);
            int deviceType = typeVersionRegister & 0x7F;
            String deviceName = DeviceTypes.getDeviceType(deviceType);
            if (deviceName == null) {
                this.updateDeviceStatus(Statuses.INVALID_DEVICE);
                this.setDeviceName("Unknown");
                this.setDeviceFirmwareVersion("Unknown");
                return false;
            }
            this.setDeviceFirmwareVersion(this.getFirmwareRevision(typeVersionRegister));
            this.setDeviceName(deviceName);
            this.setCapabilities(deviceType);
            this.updateDeviceStatus(Statuses.STATUS_UNKNOWN_YET);
            this.notifyObservers(x -> x.devicePinged());
            if (!this.deviceIsReady) {
                this.deviceIsReady = true;
                this.notifyObservers(x -> x.deviceConfirmed());
            }
            return true;
        }
        catch (Exception ex) {
            this.log.severe(ex.getLocalizedMessage());
            throw ex;
        }
    }

    private void setCapabilities(int deviceType) {
        this.deviceCapabilities = DeviceTypes.getDeviceCapabilities(deviceType);
    }

    private String getFirmwareRevision(int typeVersionRegister) {
        return Float.toString((float)(typeVersionRegister >> 8 & 0xFF) / 10.0f);
    }

    void setDeviceName(String name) {
    }

    void setDeviceFirmwareVersion(String version) {
    }

    abstract int getDevAddr();

    public void stopped() throws Exception {
        try {
            this.stopFastPollingThread();
            this.stopNormalPollingThread();
            this.stopSlowPollingThread();
            this.network.removeListener(this);
        }
        catch (Exception ex) {
            this.log.severe(ex.getLocalizedMessage());
        }
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.notifyObservers(x -> x.deviceStarted(this));
    }

    private void createFastPollingThread() {
        this.fastPollingThreadFailed = false;
        this.fastPollingThread = new Thread(this.pollingRunnable().apply(new PollingThreadModel(fastRate, BPollFreqConf.fast, this.fastPollingPoints)));
        this.fastPollingThread.start();
    }

    private void createNormalPollingThread() {
        this.normalPollingThreadFailed = false;
        this.normalPollingThread = new Thread(this.pollingRunnable().apply(new PollingThreadModel(normalRate, BPollFreqConf.normal, this.normalPollingPoints)));
        this.normalPollingThread.start();
    }

    private void createSlowPollingThread() {
        this.slowPollingThreadFailed = false;
        this.slowPollingThread = new Thread(this.pollingRunnable().apply(new PollingThreadModel(slowRate, BPollFreqConf.slow, this.slowPollingPoints)));
        this.slowPollingThread.start();
    }

    private void stopFastPollingThread() {
        if (this.fastPollingThread != null) {
            this.fastPollingThread.interrupt();
            this.fastPollingThread = null;
        }
    }

    private void stopNormalPollingThread() {
        if (this.normalPollingThread != null) {
            this.normalPollingThread.interrupt();
            this.normalPollingThread = null;
        }
    }

    private void stopSlowPollingThread() {
        if (this.slowPollingThread != null) {
            this.slowPollingThread.interrupt();
            this.slowPollingThread = null;
        }
    }

    public Function<PollingThreadModel, Runnable> pollingRunnable() {
        return model -> new Runnable((PollingThreadModel)model){
            final /* synthetic */ PollingThreadModel val$model;
            {
                this.val$model = pollingThreadModel;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        ArrayList<BIsmaIoProxyExt> modelListCopy;
                        long currentPollingRateMillis = ((BRelTime)BIsmaCommonIoDevice.this.get(this.val$model.rateProperty)).getMillis();
                        long start = System.nanoTime();
                        ArrayList<BIsmaIoProxyExt> arrayList = modelListCopy = new ArrayList<BIsmaIoProxyExt>(this.val$model.subscribedPoints);
                        synchronized (arrayList) {
                            for (BIsmaIoProxyExt point : modelListCopy) {
                                point.doPoll();
                            }
                        }
                        long end = System.nanoTime();
                        long millisElapsed = (end - start) / 1000000L;
                        if (millisElapsed > currentPollingRateMillis) continue;
                        long timeToSleep = currentPollingRateMillis - millisElapsed;
                        int timeSlept = 0;
                        int iteration = 15;
                        while (timeToSleep > (long)timeSlept && !Thread.currentThread().isInterrupted() && currentPollingRateMillis == ((BRelTime)BIsmaCommonIoDevice.this.get(this.val$model.rateProperty)).getMillis()) {
                            Thread.currentThread();
                            Thread.sleep(iteration);
                            timeSlept += iteration;
                        }
                    }
                    catch (InterruptedException ex) {
                        BIsmaCommonIoDevice.this.log.fine("Thread interrupted: " + ex.getLocalizedMessage());
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception ex) {
                        if (this.val$model.pollFrequency == BPollFreqConf.fast) {
                            BIsmaCommonIoDevice.this.fastPollingThreadFailed = true;
                        } else if (this.val$model.pollFrequency == BPollFreqConf.normal) {
                            BIsmaCommonIoDevice.this.normalPollingThreadFailed = true;
                        } else if (this.val$model.pollFrequency == BPollFreqConf.slow) {
                            BIsmaCommonIoDevice.this.slowPollingThreadFailed = true;
                        }
                        Thread.currentThread().interrupt();
                    }
                }
                BIsmaCommonIoDevice.this.log.fine("Polling " + this.val$model.pollFrequency.toString() + " thread ends.");
            }
        };
    }

    public abstract BIsmaNetwork getNetwork();

    @Override
    public void networkUpdated(Property property) {
        this.updateDeviceStatus(Statuses.STATUS_UNKNOWN_YET);
        this.notifyObservers(x -> x.deviceUpdated(property));
    }

    public void addRequest(ModbusMessage mm) {
        if (this.network != null) {
            this.network.addRequest(mm);
        }
    }

    void manageShadowDevice(boolean shouldBe) {
        this.shadowDevProp = null;
        for (Property myProp : this.getPropertiesArray()) {
            if (!myProp.getType().is(BShadowDevice.TYPE)) continue;
            this.shadowDevProp = myProp;
        }
        if (this.shadowDevProp == null && shouldBe) {
            this.shadowDevProp = this.add("shadowDevice?", (BValue)new BShadowDevice(), 6);
        } else if (this.shadowDevProp != null && !shouldBe) {
            this.remove(this.shadowDevProp);
        }
    }

    public void updateDeviceStatus(Statuses passedStatus) {
        this.inDeviceLimitRange = true;
        BStatus parentStatus = null;
        Statuses oldStatus = this.deviceStatus;
        this.manageShadowDevice(this.getType().is(BIsmaRemoteDevice.TYPE));
        if (this.shadowDevProp != null && ((BShadowDevice)this.get(this.shadowDevProp)).getStatus().isFault() && ((BShadowDevice)this.get(this.shadowDevProp)).getFaultCause().startsWith("Exceeded device limit for ")) {
            this.inDeviceLimitRange = false;
            this.deviceStatus = Statuses.EXCEEDED_DEVICE_LIMIT = new Statuses(((BShadowDevice)this.get(this.shadowDevProp)).getFaultCause(), BStatus.fault);
        } else {
            this.deviceStatus = this.network == null || (parentStatus = this.network.getStatus()) == null ? Statuses.BAD_PARENT : (this.checkDeviceNumber() ? Statuses.INVALID_NUMBER : (!this.getEnabled() ? Statuses.DISABLED : (parentStatus.equals((Object)BStatus.disabled) ? Statuses.PARENT_DISABLED : (parentStatus.equals((Object)BStatus.fault) ? Statuses.PARENT_NOT_OK : (parentStatus.equals((Object)BStatus.down) ? Statuses.PARENT_DOWN : (this.checkDuplicatedDevice() ? Statuses.DUPLICATED : (passedStatus != Statuses.STATUS_UNKNOWN_YET ? passedStatus : Statuses.OK)))))));
        }
        this.setStatus(this.deviceStatus.getStatus());
        this.setFaultCause(this.deviceStatus.getMessage());
        if (this.deviceStatus == Statuses.OK) {
            if (oldStatus == Statuses.DEVICE_DOWN) {
                this.notifyObservers(x -> x.deviceReturned());
                this.log.info("Device " + this.pathToNetwork + " is up");
            }
            if (oldStatus.getStatus().isFault() || oldStatus.getStatus().isDisabled()) {
                this.sendDeviceTypeVersionReq();
            }
        }
    }

    private boolean checkDuplicatedDevice() {
        if (this.network == null) {
            return false;
        }
        ArrayList<INetworkListener> networkListeners = this.network.getListeners();
        for (INetworkListener listener : networkListeners) {
            BIsmaCommonIoDevice device;
            if (!(listener instanceof BIsmaCommonIoDevice) || (device = (BIsmaCommonIoDevice)listener) == this || !device.getClass().getTypeName().equals(this.getClass().getTypeName()) || device.getDevAddr() != this.getDevAddr() || !device.getStatus().isOk()) continue;
            return true;
        }
        return false;
    }

    public int getDIQuantity() {
        return this.deviceCapabilities.DIQuantity;
    }

    public int getUIQuantity() {
        return this.deviceCapabilities.UIQuantity;
    }

    public int getDOQuantity() {
        return this.deviceCapabilities.DOQuantity;
    }

    public int getAOQuantity() {
        return this.deviceCapabilities.AOQuantity;
    }

    protected abstract boolean checkDeviceNumber();

    public void updateSubscribedPoint(BIsmaIoProxyExt point) {
        if (!(this.fastPollingPoints.contains(point) || this.normalPollingPoints.contains(point) || this.slowPollingPoints.contains(point))) {
            return;
        }
        this.stopPolling(point);
        this.startPolling(point);
    }

    public synchronized void addSubscribedPoint(BIsmaIoProxyExt point) {
        BPollFreqConf pollFrequency = point.getPollFrequency();
        if (pollFrequency == BPollFreqConf.fast && !this.fastPollingPoints.contains(point)) {
            this.fastPollingPoints.add(point);
        } else if (pollFrequency == BPollFreqConf.normal && !this.normalPollingPoints.contains(point)) {
            this.normalPollingPoints.add(point);
        } else if (pollFrequency == BPollFreqConf.slow && !this.slowPollingPoints.contains(point)) {
            this.slowPollingPoints.add(point);
        }
    }

    public synchronized void removeSubscribedPoint(BIsmaIoProxyExt point) {
        this.fastPollingPoints.remove(point);
        this.normalPollingPoints.remove(point);
        this.slowPollingPoints.remove(point);
    }

    private synchronized void startThreads() {
        if (!Sys.isStationStarted()) {
            return;
        }
        if (!this.fastPollingPoints.isEmpty() && (this.fastPollingThread == null || this.fastPollingThreadFailed)) {
            this.log.fine("Start fast polling thread in " + this.pathToNetwork);
            this.createFastPollingThread();
        }
        if (!this.normalPollingPoints.isEmpty() && (this.normalPollingThread == null || this.normalPollingThreadFailed)) {
            this.log.fine("Start normal polling thread in " + this.pathToNetwork);
            this.createNormalPollingThread();
        }
        if (!this.slowPollingPoints.isEmpty() && (this.slowPollingThread == null || this.slowPollingThreadFailed)) {
            this.log.fine("Start slow polling thread in " + this.pathToNetwork);
            this.createSlowPollingThread();
        }
    }

    private void stopThreads() {
        if (this.fastPollingPoints.isEmpty() && this.fastPollingThread != null) {
            this.log.fine("Stop fast polling thread in " + this.pathToNetwork);
            this.stopFastPollingThread();
        }
        if (this.normalPollingPoints.isEmpty() && this.normalPollingThread != null) {
            this.log.fine("Stop normal polling thread in " + this.pathToNetwork);
            this.stopNormalPollingThread();
        }
        if (this.slowPollingPoints.isEmpty() && this.slowPollingThread != null) {
            this.log.fine("Stop slow polling thread in " + this.pathToNetwork);
            this.stopSlowPollingThread();
        }
    }

    public void startPolling(BIsmaIoProxyExt bIsmaIoProxyExt) {
        this.addSubscribedPoint(bIsmaIoProxyExt);
        this.startThreads();
    }

    public void stopPolling(BIsmaIoProxyExt bIsmaIoProxyExt) {
        this.removeSubscribedPoint(bIsmaIoProxyExt);
        this.stopThreads();
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        this.startThreads();
    }

    private void setPathToNetwork() {
        try {
            if (this.network == null) {
                this.pathToNetwork = this.getName();
                return;
            }
            this.pathToNetwork = "\"" + this.toPathString().substring(this.toPathString().indexOf(this.network.getName())).replace("$20", " ") + "\"";
        }
        catch (Exception ex) {
            this.pathToNetwork = this.getName();
        }
    }

    public boolean isInDeviceLimitRange() {
        return this.inDeviceLimitRange;
    }
}

