/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_HDMI;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.baja.firewall.BServerPort;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BAutoLogoffSettings;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.web.BWebService;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3), @NiagaraProperty(name="screensaverEnabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="screensaverTime", type="BRelTime", defaultValue="BRelTime.make(2L*60L*1000L)"), @NiagaraProperty(name="screensaverPath", type="BOrd", defaultValue="BOrd.make(\"file:^\")", facets={@Facet(name="BFacets.TARGET_TYPE", value="\"baja:IFile\"")}), @NiagaraProperty(name="standbyEnabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="standbyTime", type="BRelTime", defaultValue="BRelTime.make(5L*60L*1000L)"), @NiagaraProperty(name="autoLogin", type="boolean", defaultValue="false"), @NiagaraProperty(name="autoLoginCredentials", type="BValue", defaultValue="new BUsernameAndPassword(\"\", BPassword.DEFAULT)"), @NiagaraProperty(name="autoLoginTime", type="BRelTime", defaultValue="BRelTime.make(15L*1000L)"), @NiagaraProperty(name="ismaPanel", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="resolution", type="BDynamicEnum", defaultValue="BDynamicEnum.make(0)", flags=4)})
public class BIsmaHdmi
extends BComponent
implements BIService,
BIStatus {
    public static final Property status = BIsmaHdmi.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BIsmaHdmi.newProperty((int)3, (String)"", null);
    public static final Property screensaverEnabled = BIsmaHdmi.newProperty((int)0, (boolean)true, null);
    public static final Property screensaverTime = BIsmaHdmi.newProperty((int)0, (BValue)BRelTime.make((long)120000L), null);
    public static final Property screensaverPath = BIsmaHdmi.newProperty((int)0, (BValue)BOrd.make((String)"file:^"), (BFacets)BFacets.make((String)"targetType", (String)"baja:IFile"));
    public static final Property standbyEnabled = BIsmaHdmi.newProperty((int)0, (boolean)true, null);
    public static final Property standbyTime = BIsmaHdmi.newProperty((int)0, (BValue)BRelTime.make((long)300000L), null);
    public static final Property autoLogin = BIsmaHdmi.newProperty((int)0, (boolean)false, null);
    public static final Property autoLoginCredentials = BIsmaHdmi.newProperty((int)0, (BValue)new BUsernameAndPassword("", BPassword.DEFAULT), null);
    public static final Property autoLoginTime = BIsmaHdmi.newProperty((int)0, (BValue)BRelTime.make((long)15000L), null);
    public static final Property ismaPanel = BIsmaHdmi.newProperty((int)4, (boolean)true, null);
    public static final Property resolution = BIsmaHdmi.newProperty((int)4, (BValue)BDynamicEnum.make((int)0), null);
    public static final Type TYPE = Sys.loadType(BIsmaHdmi.class);
    public static final Logger log = Logger.getLogger("iSMAHDMI");
    private boolean stopThread = false;
    private PortSubscriber subscriber;
    private int serverPort = 80;
    private Boolean duplicated = false;
    private static Socket sock;
    boolean settingsNeedToBeSent = true;
    boolean credNeedToBeSent = true;
    boolean resolutionNeedToBeRead = true;
    boolean resolutionNeedToBeSent = false;
    private Thread thread;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public boolean getScreensaverEnabled() {
        return this.getBoolean(screensaverEnabled);
    }

    public void setScreensaverEnabled(boolean v) {
        this.setBoolean(screensaverEnabled, v, null);
    }

    public BRelTime getScreensaverTime() {
        return (BRelTime)this.get(screensaverTime);
    }

    public void setScreensaverTime(BRelTime v) {
        this.set(screensaverTime, (BValue)v, null);
    }

    public BOrd getScreensaverPath() {
        return (BOrd)this.get(screensaverPath);
    }

    public void setScreensaverPath(BOrd v) {
        this.set(screensaverPath, (BValue)v, null);
    }

    public boolean getStandbyEnabled() {
        return this.getBoolean(standbyEnabled);
    }

    public void setStandbyEnabled(boolean v) {
        this.setBoolean(standbyEnabled, v, null);
    }

    public BRelTime getStandbyTime() {
        return (BRelTime)this.get(standbyTime);
    }

    public void setStandbyTime(BRelTime v) {
        this.set(standbyTime, (BValue)v, null);
    }

    public boolean getAutoLogin() {
        return this.getBoolean(autoLogin);
    }

    public void setAutoLogin(boolean v) {
        this.setBoolean(autoLogin, v, null);
    }

    public BValue getAutoLoginCredentials() {
        return this.get(autoLoginCredentials);
    }

    public void setAutoLoginCredentials(BValue v) {
        this.set(autoLoginCredentials, v, null);
    }

    public BRelTime getAutoLoginTime() {
        return (BRelTime)this.get(autoLoginTime);
    }

    public void setAutoLoginTime(BRelTime v) {
        this.set(autoLoginTime, (BValue)v, null);
    }

    public boolean getIsmaPanel() {
        return this.getBoolean(ismaPanel);
    }

    public void setIsmaPanel(boolean v) {
        this.setBoolean(ismaPanel, v, null);
    }

    public BDynamicEnum getResolution() {
        return (BDynamicEnum)this.get(resolution);
    }

    public void setResolution(BDynamicEnum v) {
        this.set(resolution, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    private void ensureSockClosed() {
        try {
            if (sock != null) {
                sock.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean sendMessage(byte[] buff, boolean closeSocket, int pos) {
        log.fine("sending " + ByteArrayUtil.toHexString((byte[])buff).substring(0, pos * 2));
        sock = new Socket();
        InetSocketAddress sockAddr = new InetSocketAddress("localhost", 25984);
        try {
            sock.connect(sockAddr, 500);
        }
        catch (IOException e) {
            log.severe("Couldn't connect to HDMI server. " + e.getMessage());
            this.setStatus(BStatus.fault);
            this.setFaultCause("Couldn't connect to HDMI server. " + e.getMessage());
            this.ensureSockClosed();
            return false;
        }
        if (sock.isClosed()) {
            log.severe("Couldn't send config. Socked closed");
            this.setStatus(BStatus.fault);
            this.setFaultCause("Couldn't send config. Socked closed");
            this.ensureSockClosed();
            return false;
        }
        try {
            OutputStream out = sock.getOutputStream();
            out.write(buff);
            out.flush();
        }
        catch (IOException e) {
            log.severe("Couldn't send to HDMI server. " + e.getMessage());
            this.setStatus(BStatus.fault);
            this.setFaultCause("Couldn't send to HDMI server. " + e.getMessage());
            this.ensureSockClosed();
            return false;
        }
        if (closeSocket) {
            try {
                sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
        return true;
    }

    private byte[] readMessage() {
        try {
            InputStream in = sock.getInputStream();
            byte[] recBuf = new byte[4096];
            int size = in.read(recBuf, 0, 4096);
            if (size < 0) {
                log.fine("No data received");
            } else if (size > 0) {
                log.fine("Received response (len: " + size + ") binary: " + ByteArrayUtil.toHexString((byte[])recBuf, (int)0, (int)size));
            } else {
                log.fine("This shouldn't happend");
            }
            this.ensureSockClosed();
            return Arrays.copyOfRange(recBuf, 0, size);
        }
        catch (Exception e) {
            log.severe("Socket closed Socket Timeout or Exception " + e);
            this.ensureSockClosed();
            return null;
        }
    }

    private boolean sendSettings(boolean enable, int time, String path, boolean standbyEnable, int standbyTime, int serverPort) {
        path = path.replaceFirst("file:\\^", Sys.getStationHome().getPath() + "/");
        byte[] buff = new byte[4096];
        int pos = 0;
        buff[pos++] = 0;
        buff[pos++] = enable ? (byte)1 : 0;
        System.arraycopy(BIsmaHdmi.intToByteArray(time), 0, buff, pos, 4);
        pos += 4;
        buff[pos++] = standbyEnable ? (byte)1 : 0;
        System.arraycopy(BIsmaHdmi.intToByteArray(standbyTime), 0, buff, pos, 4);
        System.arraycopy(BIsmaHdmi.intToByteArray(serverPort), 0, buff, pos += 4, 2);
        System.arraycopy(BIsmaHdmi.intToByteArray(path.length() + 1), 0, buff, pos += 2, 4);
        System.arraycopy(path.getBytes(), 0, buff, pos += 4, path.length());
        pos += path.length();
        buff[pos++] = 0;
        return this.sendMessage(buff, true, pos);
    }

    private boolean sendCredentials(boolean enable, String login, String password, int autoLoginTime) {
        byte[] buff = new byte[4096];
        int pos = 0;
        buff[pos++] = 1;
        buff[pos++] = enable ? (byte)1 : 0;
        System.arraycopy(BIsmaHdmi.intToByteArray(login.length() + 1), 0, buff, pos, 4);
        System.arraycopy(login.getBytes(), 0, buff, pos += 4, login.length());
        pos += login.length();
        buff[pos++] = 0;
        System.arraycopy(BIsmaHdmi.intToByteArray(password.length() + 1), 0, buff, pos, 4);
        System.arraycopy(password.getBytes(), 0, buff, pos += 4, password.length());
        pos += password.length();
        buff[pos++] = 0;
        System.arraycopy(BIsmaHdmi.intToByteArray(autoLoginTime), 0, buff, pos, 4);
        return this.sendMessage(buff, true, pos += 4);
    }

    private boolean sendResolution(byte[] resolution) {
        if (this.getResolution().getTag().length() < 5) {
            this.resolutionNeedToBeSent = false;
            this.resolutionNeedToBeRead = true;
            return false;
        }
        byte[] buff = new byte[4096];
        int pos = 0;
        buff[pos++] = 2;
        buff[pos++] = 1;
        System.arraycopy(BIsmaHdmi.intToByteArray(resolution.length + 1), 0, buff, pos, 4);
        System.arraycopy(resolution, 0, buff, pos += 4, resolution.length);
        buff[pos += resolution.length] = 10;
        log.fine("Sending resolution " + new String(buff, 6, pos - 6));
        return this.sendMessage(buff, true, pos);
    }

    private String[] getAvailableResolutions() {
        byte[] buff = new byte[4096];
        int pos = 0;
        buff[pos++] = 2;
        buff[pos++] = 0;
        this.sendMessage(buff, false, pos);
        byte[] resByteArray = this.readMessage();
        if (resByteArray != null) {
            String resolutionsString;
            try {
                resolutionsString = new String(resByteArray, "ASCII");
            }
            catch (Exception ex) {
                log.fine("Couldn't read resolution string " + ex.toString());
                return null;
            }
            resolutionsString = resolutionsString.replace(':', '_').replace('-', '_').replaceAll("RES_", "");
            String[] resolutions = resolutionsString.split("\n");
            ArrayList<String> resList = new ArrayList<String>();
            for (int i = 0; i < resolutions.length; ++i) {
                if (resList.contains(resolutions[i]) || resolutions[i].length() <= 1) continue;
                try {
                    String[] res = resolutions[i].split("x");
                    res[0] = res[0].substring(2);
                    res[1] = res[1].split("p")[0];
                    int resW = Integer.parseInt(res[0]);
                    int resH = Integer.parseInt(res[1]);
                    if (!this.getIsmaPanel() && resW > 0 && resH > 0 && resW * resH <= 921600) {
                        resList.add(resolutions[i]);
                        continue;
                    }
                    if (!this.getIsmaPanel() || !resolutions[i].matches("S_1280x720p_60")) continue;
                    log.fine("matched resolutions[i] " + resolutions[i]);
                    resList.add(resolutions[i]);
                    continue;
                }
                catch (Exception exn) {
                    log.fine("Couldn't recognise resolution string " + exn.toString());
                }
            }
            if (resList.size() >= 1) {
                boolean presentResOk = false;
                for (int i = 1; i < resolutions.length; ++i) {
                    if (!resolutions[i].matches((String)resList.get(0))) continue;
                    presentResOk = true;
                }
                if (!presentResOk) {
                    resList.remove(0);
                }
            }
            resList.remove(new String());
            for (String r : resList) {
                log.fine("Res: " + r);
            }
            return resList.toArray(new String[0]);
        }
        return null;
    }

    public static byte[] intToByteArray(int a) {
        byte[] ret = new byte[]{(byte)(a & 0xFF), (byte)(a >> 8 & 0xFF), (byte)(a >> 16 & 0xFF), (byte)(a >> 24 & 0xFF)};
        return ret;
    }

    private String getAutoLoginUsername() {
        BUsernameAndPassword uap = (BUsernameAndPassword)this.getAutoLoginCredentials();
        return uap.getUsername();
    }

    private String getAutoLoginPassword() {
        BUsernameAndPassword uap = (BUsernameAndPassword)this.getAutoLoginCredentials();
        try {
            return uap.getPassword().getValue();
        }
        catch (SecurityException se) {
            log.warning("Failed to decode password");
            return "";
        }
    }

    private int updateResolutionRange() {
        try {
            String[] availRes = this.getAvailableResolutions();
            if (!this.getStatus().isOk()) {
                return 2;
            }
            if (availRes.length == 0) {
                if (this.getIsmaPanel()) {
                    this.setIsmaPanel(false);
                    return this.updateResolutionRange();
                }
                return 1;
            }
            BEnumRange newEnumRange = BEnumRange.make((String[])availRes);
            BDynamicEnum newDynamicEnum = BDynamicEnum.make((int)0, (BEnumRange)newEnumRange);
            this.setResolution(newDynamicEnum);
            if (this.getIsmaPanel()) {
                this.setFlags((Slot)resolution, 1);
            } else {
                this.setFlags((Slot)resolution, 0);
            }
            return 0;
        }
        catch (Exception e) {
            log.severe("Resolution reading not possible: " + e);
            return 2;
        }
    }

    private void createThread() {
        if (this.thread != null && this.thread.isAlive()) {
            return;
        }
        this.thread = new Thread(){

            @Override
            public void run() {
                while (!BIsmaHdmi.this.stopThread) {
                    try {
                        if (BIsmaHdmi.this.settingsNeedToBeSent && !BIsmaHdmi.this.sendSettings(BIsmaHdmi.this.getScreensaverEnabled(), BIsmaHdmi.this.getScreensaverTime().getSeconds(), BIsmaHdmi.this.getScreensaverPath().encodeToString(), BIsmaHdmi.this.getStandbyEnabled(), BIsmaHdmi.this.getStandbyTime().getSeconds(), BIsmaHdmi.this.serverPort)) {
                            Thread.sleep(1000L);
                            continue;
                        }
                        if (BIsmaHdmi.this.credNeedToBeSent && !BIsmaHdmi.this.sendCredentials(BIsmaHdmi.this.getAutoLogin(), BIsmaHdmi.this.getAutoLoginUsername(), BIsmaHdmi.this.getAutoLoginPassword(), BIsmaHdmi.this.getAutoLoginTime().getSeconds())) {
                            Thread.sleep(1000L);
                            continue;
                        }
                        if (BIsmaHdmi.this.resolutionNeedToBeRead && BIsmaHdmi.this.updateResolutionRange() == 2) {
                            Thread.sleep(1000L);
                            continue;
                        }
                        if (BIsmaHdmi.this.resolutionNeedToBeSent) {
                            if (!BIsmaHdmi.this.sendResolution(BIsmaHdmi.this.encodeResolution())) {
                                Thread.sleep(1000L);
                                continue;
                            }
                            BIsmaHdmi.this.resolutionNeedToBeSent = false;
                            BIsmaHdmi.this.credNeedToBeSent = true;
                            continue;
                        }
                        BIsmaHdmi.this.settingsNeedToBeSent = false;
                        BIsmaHdmi.this.credNeedToBeSent = false;
                        BIsmaHdmi.this.resolutionNeedToBeRead = false;
                        BIsmaHdmi.this.resolutionNeedToBeSent = false;
                        BIsmaHdmi.this.stopThread = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.thread.start();
    }

    public void serviceStarted() {
        BComponent[] s = Sys.getServices((Type)this.getType());
        if (s != null && s.length > 1) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("Service is duplicated.");
            this.duplicated = true;
            return;
        }
        BComponent[] ws = Sys.getServices((Type)BWebService.TYPE);
        if (s != null && s.length >= 1) {
            BServerPort sP = ((BWebService)ws[0]).getHttpPort();
            this.serverPort = sP.getBindingPort();
            this.subscriber = new PortSubscriber(sP);
        }
        this.createThread();
    }

    public void serviceStopped() {
        this.stopThread = true;
        if (Sys.getStation().isRunning() && !this.duplicated.booleanValue()) {
            this.sendSettings(true, 120, "file:\\^", true, 300, 80);
        }
        this.subscriber.unsubscribeAll();
        this.subscriber = null;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (this.duplicated.booleanValue()) {
            return;
        }
        if (!(property != screensaverEnabled && property != screensaverTime && property != screensaverPath && property != standbyEnabled && property != standbyTime || this.sendSettings(this.getScreensaverEnabled(), this.getScreensaverTime().getSeconds(), this.getScreensaverPath().encodeToString(), this.getStandbyEnabled(), this.getStandbyTime().getSeconds(), this.serverPort))) {
            this.settingsNeedToBeSent = true;
            this.stopThread = false;
            this.createThread();
        }
        if (property == autoLogin || property == autoLoginCredentials || property == autoLoginTime) {
            if (this.getAutoLogin()) {
                this.disableAutoLogOff();
            }
            log.fine("Calling changed " + property.getName());
            if (!this.sendCredentials(this.getAutoLogin(), this.getAutoLoginUsername(), this.getAutoLoginPassword(), this.getAutoLoginTime().getSeconds())) {
                this.credNeedToBeSent = true;
                this.stopThread = false;
                this.createThread();
            }
        }
        if (property == resolution) {
            if (!this.sendResolution(this.encodeResolution())) {
                this.resolutionNeedToBeSent = true;
                this.stopThread = false;
                this.createThread();
            } else if (this.getAutoLogin() && !this.sendCredentials(this.getAutoLogin(), this.getAutoLoginUsername(), this.getAutoLoginPassword(), this.getAutoLoginTime().getSeconds())) {
                this.credNeedToBeSent = true;
                this.stopThread = false;
                this.createThread();
            }
        }
        if (property == ismaPanel) {
            int updateRes = this.updateResolutionRange();
            if (updateRes == 1) {
                this.setFlags((Slot)resolution, 0);
            } else if (updateRes == 2) {
                this.resolutionNeedToBeRead = true;
                this.stopThread = false;
                this.createThread();
            }
        }
    }

    private void disableAutoLogOff() {
        BUser bu;
        BComponent[] bc = Sys.getServices((Type)BUserService.TYPE);
        if (bc != null && bc.length > 0 && (bu = ((BUserService)bc[0]).getUser(this.getAutoLoginUsername())) != null) {
            BAutoLogoffSettings nal = bu.getAutoLogoffSettings();
            nal.setAutoLogoffEnabled(false);
            bu.setAutoLogoffSettings(nal);
        }
    }

    private byte[] encodeResolution() {
        String resolution = this.getResolution().getTag();
        resolution = resolution.replaceFirst("_", ":");
        resolution = resolution.replace("_", "-");
        return resolution.getBytes();
    }

    private class PortSubscriber
    extends Subscriber {
        private BServerPort sp;

        public PortSubscriber(BServerPort sp) {
            this.sp = sp;
            this.subscribe((BComponent)sp);
        }

        public void event(BComponentEvent event) {
            if (event.getId() == 0 && (event.getSlot().equals((Object)BServerPort.publicServerPort) || event.getSlot().equals((Object)BServerPort.localServerPort))) {
                BIsmaHdmi.this.serverPort = this.sp.getBindingPort();
                BIsmaHdmi.this.sendSettings(BIsmaHdmi.this.getScreensaverEnabled(), BIsmaHdmi.this.getScreensaverTime().getSeconds(), BIsmaHdmi.this.getScreensaverPath().encodeToString(), BIsmaHdmi.this.getStandbyEnabled(), BIsmaHdmi.this.getStandbyTime().getSeconds(), BIsmaHdmi.this.serverPort);
            }
        }
    }
}

