/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.analysis.ControlFlowGraph;
import sedonac.analysis.DeadCodeAnalysis;
import sedonac.analysis.DefiniteAssignmentAnalysis;
import sedonac.analysis.UnusedCodeAnalysis;
import sedonac.ast.MethodDef;
import sedonac.ast.TypeDef;

public class StaticAnalysis
extends CompilerStep {
    public void run() {
        this.log.debug("  Static Analysis");
        new UnusedCodeAnalysis(this.compiler).run();
        this.analyzeMethods();
        this.quitIfErrors();
    }

    private final void analyzeMethods() {
        TypeDef[] typeDefArray = this.compiler.ast.types;
        int n = 0;
        while (n < typeDefArray.length) {
            MethodDef[] methodDefArray = typeDefArray[n].methodDefs();
            int n2 = 0;
            while (n2 < methodDefArray.length) {
                ControlFlowGraph controlFlowGraph = ControlFlowGraph.make(methodDefArray[n2]);
                new DeadCodeAnalysis(this.compiler, controlFlowGraph).run();
                new DefiniteAssignmentAnalysis(this.compiler, controlFlowGraph).run();
                ++n2;
            }
            ++n;
        }
    }

    public StaticAnalysis(Compiler compiler) {
        super(compiler);
    }
}

