/*
 * Decompiled with CFR 0.152.
 */
package sedonac;

import java.io.File;
import java.util.zip.ZipEntry;
import sedona.xml.XElem;
import sedona.xml.XLocation;

public class Location
implements Comparable {
    public String file;
    public int line;
    public int col;

    public static String toString(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getAbsolutePath();
        }
        catch (Exception exception) {
            return file.toString();
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.col;
        int n2 = 0;
        if (this.file != null) {
            n2 = this.file.hashCode();
        }
        n = 31 * n + n2;
        n = 31 * n + this.line;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Location location = (Location)object;
        if (this.col != location.col) {
            return false;
        }
        if (this.file == null ? location.file != null : !this.file.equals(location.file)) {
            return false;
        }
        return this.line == location.line;
    }

    public int compareTo(Object object) {
        Location location = (Location)object;
        int n = 0;
        if (this.file == null) {
            if (location.file != null) {
                return -1;
            }
        } else {
            n = this.file.compareTo(location.file);
            if (n != 0) {
                return n;
            }
        }
        if ((n = this.line - location.line) != 0) {
            return n;
        }
        return this.col - location.col;
    }

    public String toFileName() {
        if (this.file == null) {
            return null;
        }
        String string = this.file;
        int n = string.lastIndexOf(47);
        if (n > 0) {
            return string.substring(n + 1);
        }
        n = string.lastIndexOf(92);
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public String toString() {
        if (this.file == null) {
            if (this.line == 0) {
                return "Unknown";
            }
            return "Line " + this.line;
        }
        if (this.line == 0) {
            return this.file;
        }
        if (this.col == 0) {
            return this.file + ':' + this.line;
        }
        return this.file + ':' + this.line + ':' + this.col;
    }

    public Location(String string, int n, int n2) {
        this.file = string;
        this.line = n;
        this.col = n2;
    }

    public Location(String string, int n) {
        this.file = string;
        this.line = n;
    }

    public Location(String string) {
        this.file = string;
    }

    public Location(File file) {
        this.file = Location.toString(file);
    }

    public Location(File file, ZipEntry zipEntry) {
        this.file = Location.toString(file) + '|' + zipEntry.getName();
    }

    public Location(XLocation xLocation) {
        this(xLocation.file, xLocation.line, xLocation.col);
    }

    public Location(XElem xElem) {
        this(xElem.location());
    }

    public Location() {
    }
}

