/*
 * Decompiled with CFR 0.152.
 */
package sedonac.translate;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import sedonac.Compiler;
import sedonac.ast.Block;
import sedonac.ast.Expr;
import sedonac.ast.FieldDef;
import sedonac.ast.MethodDef;
import sedonac.ast.ParamDef;
import sedonac.ast.SlotDef;
import sedonac.ast.Stmt;
import sedonac.ast.TypeDef;
import sedonac.namespace.Field;
import sedonac.namespace.Slot;
import sedonac.namespace.StubType;
import sedonac.namespace.Type;
import sedonac.translate.AbstractTranslator;

public class CTranslator
extends AbstractTranslator {
    public File toFile() {
        return new File(this.outDir, this.qname(this.type) + ".c");
    }

    public void doTranslate() {
        this.w("#include \"").w(this.qname(this.type)).w(".h\"").nl();
        this.includes();
        this.nl();
        this.w("extern bool approx(float a, float b);").nl();
        this.w("extern void doAssert(bool cond, const char* file, int line);").nl();
        this.w("#define assert(c) doAssert((c), __FILE__, __LINE__)").nl();
        this.nl();
        this.staticFields();
        this.nl();
        MethodDef[] methodDefArray = this.type.methodDefs();
        int n = 0;
        while (n < methodDefArray.length) {
            this.method(methodDefArray[n]);
            ++n;
        }
        if (this.type.qname.equals("sys::Obj")) {
            this.nl();
            this.w("bool approx(float a, float b)").nl();
            this.w("{").nl();
            this.w("  return a < b ? b-a < 0.001f : a-b < 0.001f;").nl();
            this.w("}").nl();
            this.nl();
            this.w("static int successes = 0;").nl();
            this.w("static int failures = 0;").nl();
            this.w("void doAssert(bool cond, const char* file, int line)").nl();
            this.w("{").nl();
            this.w("  if (cond) successes++;").nl();
            this.w("  else failures++;").nl();
            this.w("}").nl();
            this.nl();
            this.w("int main(int argc, char** argv)").nl();
            this.w("{").nl();
            this.w("  sys_FieldTest__staticInit();").nl();
            this.w("  sys_Sys_main();").nl();
            this.w("  printf(\"-- successes = %d\\n\", successes);").nl();
            this.w("  printf(\"-- failures  = %d\\n\", failures);").nl();
            this.w("}").nl();
        }
    }

    public void includes() {
        Type[] typeArray = this.findIncludes();
        int n = 0;
        while (n < typeArray.length) {
            this.w("#include \"").w(this.qname(typeArray[n])).w(".h\"").nl();
            ++n;
        }
    }

    public Type[] findIncludes() {
        HashMap hashMap = new HashMap();
        SlotDef[] slotDefArray = this.type.slotDefs();
        int n = 0;
        while (n < slotDefArray.length) {
            SlotDef slotDef = slotDefArray[n];
            if (slotDef.isField()) {
                this.findIncludes(hashMap, (FieldDef)slotDef);
            } else {
                this.findIncludes(hashMap, (MethodDef)slotDef);
            }
            ++n;
        }
        return hashMap.values().toArray(new Type[hashMap.size()]);
    }

    public void findIncludes(HashMap hashMap, FieldDef fieldDef) {
        this.addInclude(hashMap, fieldDef.type);
    }

    public void findIncludes(HashMap hashMap, MethodDef methodDef) {
        this.addInclude(hashMap, methodDef.ret);
        int n = 0;
        while (n < methodDef.params.length) {
            this.addInclude(hashMap, methodDef.params[n].type);
            ++n;
        }
    }

    public void addInclude(HashMap hashMap, Type type) {
        if (type.isPrimitive()) {
            return;
        }
        if (type.isArray()) {
            this.addInclude(hashMap, type.arrayOf());
            return;
        }
        if (type.qname().equals(this.type.qname)) {
            return;
        }
        hashMap.put(type.qname(), type);
    }

    public void staticFields() {
        FieldDef[] fieldDefArray = this.type.fieldDefs();
        int n = 0;
        while (n < fieldDefArray.length) {
            FieldDef fieldDef = fieldDefArray[n];
            if (fieldDef.isStatic()) {
                this.fieldSig(fieldDef);
                this.w(";").nl();
            }
            ++n;
        }
    }

    public void fieldSig(FieldDef fieldDef) {
        this.w(this.toType(fieldDef.type, fieldDef.isInline()));
        this.w(" ").w(this.qname(fieldDef));
        if (fieldDef.type.isArray() && fieldDef.isInline()) {
            this.w("[").w(fieldDef.type.arrayLength()).w("]");
        }
    }

    public void method(MethodDef methodDef) {
        this.methodSig(methodDef).nl();
        this.block(methodDef.code);
        this.nl();
    }

    public CTranslator methodSig(MethodDef methodDef) {
        this.wtype(methodDef.ret).w(" ").w(this.qname(methodDef)).w("(");
        int n = 0;
        while (n < methodDef.params.length) {
            ParamDef paramDef = methodDef.params[n];
            if (n > 0) {
                this.w(", ");
            }
            this.wtype(paramDef.type).w(" ").w(paramDef.name);
            ++n;
        }
        this.w(")");
        return this;
    }

    public void block(Block block) {
        this.indent().w("{").nl();
        ++this.indent;
        this.localDefs(block);
        this.stmts(block.stmts);
        --this.indent;
        this.indent().w("}").nl();
    }

    public void localDefs(Block block) {
        Stmt.LocalDef[] localDefArray = this.findLocalDefs(block);
        int n = 0;
        while (n < localDefArray.length) {
            Stmt.LocalDef localDef = localDefArray[n];
            this.indent().wtype(localDef.type).w(" ").w(localDef.name).w(";").nl();
            ++n;
        }
        if (localDefArray.length > 0) {
            this.nl();
        }
    }

    public Stmt.LocalDef[] findLocalDefs(Block block) {
        ArrayList<Stmt.LocalDef> arrayList = new ArrayList<Stmt.LocalDef>();
        HashMap<String, Stmt.LocalDef> hashMap = new HashMap<String, Stmt.LocalDef>();
        int n = 0;
        while (n < block.stmts.size()) {
            Stmt stmt = (Stmt)block.stmts.get(n);
            Stmt.LocalDef localDef = null;
            if (stmt instanceof Stmt.LocalDef) {
                localDef = (Stmt.LocalDef)stmt;
            } else if (stmt instanceof Stmt.For) {
                Stmt.For for_ = (Stmt.For)stmt;
                if (for_.init instanceof Stmt.LocalDef) {
                    localDef = (Stmt.LocalDef)for_.init;
                }
            }
            if (localDef != null) {
                int n2 = 1;
                while (hashMap.containsKey(localDef.name)) {
                    localDef.name = localDef.name + n2;
                    ++n2;
                }
                arrayList.add(localDef);
                hashMap.put(localDef.name, localDef);
            }
            ++n;
        }
        return arrayList.toArray(new Stmt.LocalDef[arrayList.size()]);
    }

    public void localDef(Stmt.LocalDef localDef, boolean bl) {
        if (localDef.init != null) {
            if (bl) {
                this.indent();
            }
            this.w(localDef.name).w(" = ");
            this.expr(localDef.init, true);
            if (bl) {
                this.w(";").nl();
            }
        }
    }

    public void trueLiteral() {
        this.w("TRUE");
    }

    public void falseLiteral() {
        this.w("FALSE");
    }

    public void nullLiteral() {
        this.w("NULL");
    }

    public void binary(Expr.Binary binary, boolean bl) {
        if (binary.id == 29 && binary.lhs.type.isFloat()) {
            this.w("approx(");
            this.expr(binary.lhs, true);
            this.w(", ");
            this.expr(binary.rhs, true);
            this.w(")");
        } else {
            super.binary(binary, bl);
        }
    }

    public void field(Expr.Field field) {
        Field field2 = field.field;
        this.w("(");
        if (field2.isStatic()) {
            if (field2.isInline() && !field2.type().isArray()) {
                this.w("(&").w(this.qname(field2)).w(")");
            } else {
                this.w(this.qname(field2));
            }
        } else {
            this.expr(field.target);
            this.w("->");
            this.w(field.name);
        }
        this.w(")");
    }

    public void call(Expr.Call call) {
        if (call.target != null && call.target.id != 70) {
            throw new IllegalStateException("Call targets not implemented: " + call);
        }
        this.w(this.qname(call.method));
        this.callArgs(call);
    }

    public void assignNarrow(Type type, Expr expr) {
        if (type.isByte()) {
            this.w("(uint8_t)(");
            this.expr(expr);
            this.w(")");
        } else if (type.isShort()) {
            this.w("(uint16_t)(");
            this.expr(expr);
            this.w(")");
        } else {
            this.expr(expr);
        }
    }

    public String qname(Type type) {
        return type.kit().name() + '_' + type.name();
    }

    public String qname(Slot slot) {
        return this.qname(slot.parent()) + '_' + slot.name();
    }

    public String toType(Type type) {
        return this.toType(type, false);
    }

    public String toType(Type type, boolean bl) {
        String string = this.toInlineType(type);
        if (type.isRef() && !bl) {
            string = string + '*';
        }
        return string;
    }

    public String toInlineType(Type type) {
        if (type.isArray()) {
            return this.toType(type.arrayOf());
        }
        if (type.isPrimitive()) {
            if (type.isBool()) {
                return "bool";
            }
            if (type.isByte()) {
                return "uint8_t";
            }
            if (type.isShort()) {
                return "uint16_t";
            }
            if (type.isInt()) {
                return "int32_t";
            }
            return type.signature();
        }
        if (type instanceof StubType) {
            return "sys_" + type.name();
        }
        return this.qname(type);
    }

    public CTranslator(Compiler compiler, TypeDef typeDef) {
        super(compiler, typeDef);
    }
}

