/*
 * Decompiled with CFR 0.152.
 */
package sedonac.asm;

import sedonac.CompilerSupport;
import sedonac.asm.CodeAsm;
import sedonac.asm.KitAsm;
import sedonac.ast.Expr;
import sedonac.ast.FieldDef;
import sedonac.ast.MethodDef;
import sedonac.ast.SlotDef;
import sedonac.ast.TypeDef;
import sedonac.ir.IrField;
import sedonac.ir.IrMethod;
import sedonac.ir.IrSlot;
import sedonac.ir.IrType;
import sedonac.namespace.Field;
import sedonac.namespace.TypeUtil;

public class TypeAsm
extends CompilerSupport {
    KitAsm parent;
    TypeDef ast;
    IrType ir;

    public IrType assemble(TypeDef typeDef) {
        this.init(typeDef);
        this.asmSlots();
        return this.ir;
    }

    private final void init(TypeDef typeDef) {
        this.ast = typeDef;
        this.ir = new IrType(this.parent.ir, typeDef.flags, typeDef.name, typeDef.facets());
        this.ir.loc = typeDef.loc;
        this.ir.base = TypeUtil.ir(typeDef.base);
    }

    private final void asmSlots() {
        SlotDef[] slotDefArray = this.ast.slotDefs();
        this.ir.declared = new IrSlot[slotDefArray.length];
        int n = 0;
        while (n < slotDefArray.length) {
            this.ir.declared[n] = this.asmSlot(slotDefArray[n]);
            ++n;
        }
    }

    private final IrSlot asmSlot(SlotDef slotDef) {
        if (slotDef instanceof MethodDef) {
            return this.asmMethod((MethodDef)slotDef);
        }
        return this.asmField((FieldDef)slotDef);
    }

    private final IrField asmField(FieldDef fieldDef) {
        Field field;
        IrField irField = new IrField(this.ir, fieldDef.flags, fieldDef.name, fieldDef.facets(), fieldDef.type);
        boolean bl = false;
        if (fieldDef.init != null && fieldDef.init.id == 67) {
            bl = true;
        }
        irField.arrayInit = bl;
        irField.ctorLengthParam = fieldDef.ctorLengthParam;
        if (fieldDef.isDefine()) {
            irField.define = (Expr.Literal)fieldDef.init;
        }
        if (fieldDef.ctorArgs != null && fieldDef.ctorArgs.length > 0 && (field = TypeUtil.getUnsizedArrayField(irField.type)) != null) {
            irField.ctorLengthArg = fieldDef.ctorArgs[field.ctorLengthParam() - 1];
        }
        return irField;
    }

    private final IrMethod asmMethod(MethodDef methodDef) {
        IrMethod irMethod = new IrMethod(this.ir, methodDef.flags, methodDef.name, methodDef.facets(), methodDef.ret, methodDef.paramTypes());
        irMethod.maxLocals = methodDef.maxLocals;
        irMethod.nativeId = methodDef.nativeId;
        if (methodDef.code != null) {
            irMethod.code = new CodeAsm(this).assemble(methodDef.code);
            irMethod.maxStack = methodDef.code.maxStack();
        }
        return irMethod;
    }

    public TypeAsm(KitAsm kitAsm) {
        super(kitAsm.compiler);
        this.parent = kitAsm;
    }
}

