define(function (require) {
  'use strict';

  var baja = require('baja!');
  var types = require('baja!nE2Link:NanoComponent');
  var lexs = require('lex!nE2Link');
  var MgrModel = require('nmodule/webEditors/rc/wb/mgr/model/MgrModel');
  var DeviceMgrModel = require('nmodule/driver/rc/wb/mgr/DeviceMgrModel');
  var NanoMgrModel = require('nmodule/nE2Link/rc/model/NanoMgrModel');
  var MgrTypeInfo = require('nmodule/webEditors/rc/wb/mgr/MgrTypeInfo');
  var NameMgrColumn = require('nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn');
  var NanoPropertyColumn = require('nmodule/nE2Link/rc/model/NanoPropertyColumn');
  var IconMgrColumn = require('nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn');
  var Column = require('nmodule/webEditors/rc/wb/table/model/Column');
  var PropertyMgrColumn = require('nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn');
  var TreeTableModel = require('nmodule/webEditors/rc/wb/table/tree/TreeTableModel');
  var folderMgrModelMixin = require('nmodule/webEditors/rc/wb/mgr/model/folderMgrModelMixin');
  var nanoLex = lexs[0],
    NANO_DEVICE_TYPE = 'nE2Link:NanoBaseComponent',
    NANO_FOLDER_TYPE = 'nE2Link:NanoFolder';
  function lex(key) {
    return nanoLex.get(key);
  }
  function getNewTypes(component) {
    return MgrTypeInfo.make({
      from: [NANO_DEVICE_TYPE]
    }).then(function (newTypes) {
      return newTypes;
    });
  }
  ;

  /**
   * API Status: **Private**
   * @exports nmodule/bacnet/rc/wb/mgr/model/NanoGenericUxViewModel
   */
  var exports = {};
  exports.make = function (component, cols) {
    console.log("CustomTableViewModel.make: component = " + component + "; cols = " + cols);
    return getNewTypes(component).then(function (newTypes) {
      var model = new TreeTableModel({
        columns: cols,
        //componentSource: component,
        component: component,
        newTypes: newTypes,
        folderType: NANO_FOLDER_TYPE
      });
    });

    //folderMgrModelMixin(model, { folderType: folderType });

    return model;
  };
  return exports;
});
