define(function (require) {
  'use strict';

  var baja = require('baja!');
  var lexs = require('lex!baja');
  var $ = require('jquery');
  var Promise = require('Promise');
  var _ = require('underscore');
  var Command = require('bajaux/commands/Command');
  var BaseEditor = require('nmodule/webEditors/rc/fe/baja/BaseEditor');
  var fe = require('nmodule/webEditors/rc/fe/fe');
  var feDialogs = require('nmodule/webEditors/rc/fe/feDialogs');
  var ListSelection = require('nmodule/webEditors/rc/util/ListSelection');
  var htmlUtils = require('nmodule/webEditors/rc/util/htmlUtils');
  var Column = require('nmodule/webEditors/rc/wb/table/model/Column');
  var Row = require('nmodule/webEditors/rc/wb/table/model/Row');
  var TableModel = require('nmodule/webEditors/rc/wb/table/model/TableModel');
  var Table = require('nmodule/webEditors/rc/wb/table/Table');
  var events = require('bajaux/events');
  var responsiveMixIn = require('bajaux/mixin/responsiveMixIn');
  var Properties = require('bajaux/Properties');
  var subscriberMixIn = require('bajaux/mixin/subscriberMixIn');
  var switchboard = require('nmodule/js/rc/switchboard/switchboard');
  var TabbedCompositeEditor = require('nmodule/webEditors/rc/fe/baja/TabbedCompositeEditor');
  var DepthSubscriber = require('nmodule/webEditors/rc/fe/baja/util/DepthSubscriber');
  var CompositeBuilder = require('nmodule/webEditors/rc/fe/config/CompositeBuilder');
  var ssc = require('nmodule/schedule/rc/servlets/ssc');
  var scheduleUtils = require('nmodule/schedule/rc/util/scheduleUtils');
  var TrendsChartWidget = require('nmodule/nE2Link/rc/TrendsChartWidget');
  var TrendsViewerTmpl = require('hbs!nmodule/nE2Link/rc/template/TrendsViewerTmpl');
  require('css!nmodule/nE2Link/rc/style/nE2Link');
  var scheduleLex = lexs[0],
    contextMenuOnLongPress = htmlUtils.contextMenuOnLongPress;
  var TrendsViewerColumn = function TrendsViewerColumn(name, displayName) {
    Column.apply(this, [name, {
      displayName: displayName
    }]);
    this.setSortable(false);
  };
  TrendsViewerColumn.prototype = Object.create(Column.prototype);
  TrendsViewerColumn.prototype.constructor = TrendsViewerColumn;
  /**
   * Access the data straight from the row.
   *
   * @param row The row to access the information from.
   * @returns {string} The value to display for the row and column.
   */

  TrendsViewerColumn.prototype.getValueFor = function (row) {
    var name = this.getName();
    if (name === "dataPoint") return row.getSubject().getDataPoint();
    if (name === "trendName") return row.getSubject().getTrendName();

    //if (name === "status")
    //return row.getSubject().getStatus();

    if (name === "enabled") return row.getSubject().getEnabled();
    if (name === "samplingMode") return row.getSubject().getSamplingMode();
    if (name === "exposeOnBacnet") return row.getSubject().getExposeOnBacnet();
    if (name === "bacnetObjectID") return row.getSubject().getBacnetObjectId();
    if (name === "stopWhenFull") return row.getSubject().getStopWhenFull();
  };
  var TrendsViewerEditor = function TrendsViewerEditor() {
    BaseEditor.apply(this, arguments);
    subscriberMixIn(this);
  };
  TrendsViewerEditor.prototype = Object.create(BaseEditor.prototype);
  TrendsViewerEditor.prototype.constructor = TrendsViewerEditor;
  TrendsViewerEditor.prototype.doInitialize = function (dom) {
    var that = this;
    dom.addClass('trends-viewer-manager-editor').html(TrendsViewerTmpl());
    var columns = [new TrendsViewerColumn('dataPoint', "DataPoint"), new TrendsViewerColumn('trendName', "TrendName"), new TrendsViewerColumn('status', "Status"), new TrendsViewerColumn('enabled', "Enabled"), new TrendsViewerColumn('samplingMode', "SamplingMode"), new TrendsViewerColumn('exposeOnBacnet', "ExposeOnBACnet"), new TrendsViewerColumn('bacnetObjectID', "BACnetObjectID"), new TrendsViewerColumn('stopWhenFull', "StopWhenFull")];
    that.$model = new TableModel({
      columns: columns
    });
  };
  TrendsViewerEditor.prototype.doLoad = function (value) {
    console.log("TrendsViewerEditor.doLoad: value = " + value);
    var that = this,
      $trendObject = value;
    return that.$removeAllTrendObjects().then(function () {
      //return that.$insertTrendObjects(value.getTrendObjectsList().getSlots().dynamic().is('nE2Link:TrendObject').toValueArray());
      //return that.$insertTrendObjects(value.getSlots().dynamic().is('nE2Link:TrendObject').toValueArray());
      return that.$insertTrendObjects(value);
    }).then(function () {
      return fe.buildFor({
        dom: that.jq().find('.trends-viewer-table'),
        type: Table,
        value: that.$getModel(),
        properties: {
          fixedHeaders: true
        }
      });
    });
    /*
    .then(function (table) {
      that.$table = table;
      var selection = table.$getSelection(); // Only one item at a time can be selected, so each item is "exclusive"
      selection.setExclusiveFilter(function () {
        return true;
      });
      selection.on('changed', function () {
        return that.$trendObjectSelected();
      });
    }).then(function() {
      return fe.buildFor({
        dom: that.jq().find('.trends-live-chart'),
        type: TrendsChartWidget,
        value: $trendObject, //
      });
    }).then(function (editor) {
        //TrendsChartWidget should be fully initialized and loaded here
    });
    */
  };
  TrendsViewerEditor.prototype.$insertTrendObjects = function (trendObjects) {
    var that = this;
    var batch = new baja.comm.Batch(),
      promises = trendObjects.map(function (trendObject, index) {
        var row = new Row(trendObject);
        row.data('dataPoint', trendObject.getDataPoint());
        row.data('trendName', trendObject.getTrendName());
        //row.data('status', trendObject.getStatus());
        row.data('enabled', trendObject.getEnabled());
        row.data('samplingMode', trendObject.getSamplingMode());
        row.data('exposeOnBacnet', trendObject.getExposeOnBacnet());
        row.data('bacnetObjectID', trendObject.getBacnetObjectId());
        row.data('stopWhenFull', trendObject.getStopWhenFull());
        row.data('index', index);
        return row;
      });
    batch.commit();
    return Promise.all(promises).then(function (rows) {
      return that.$getModel().insertRows(rows, 0);
    }).then(function () {
      return that.$reOrderIndices();
    });
  };
  TrendsViewerEditor.prototype.$removeAllTrendObjects = function () {
    return this.$getModel().removeRows(this.$getModel().getRows());
  };
  TrendsViewerEditor.prototype.$getTable = function () {
    return this.$table;
  };
  TrendsViewerEditor.prototype.$getModel = function () {
    return this.$model;
  };

  /**
   * @returns {module:nmodule/webEditors/rc/wb/table/model/Row} Currently selected Rows in the calendarEvents table
   */

  TrendsViewerEditor.prototype.$getSelectedTrendObject = function () {
    // Get selected calendar event
    return this.$getSelection().getSelectedElements(this.$getModel().getRows())[0];
  };
  TrendsViewerEditor.prototype.$getAllNames = function () {
    return _.map(this.value().getSlots().dynamic().toArray(), String);
  };
  TrendsViewerEditor.prototype.$reOrderIndices = function () {
    // Reorder the row indices
    this.$getModel().getRows().forEach(function (row, index) {
      row.data('index', index);
    });
  };
  TrendsViewerEditor.prototype.trendObjectSelectedDone = function () {// This implementation does not do anything; override if a derived class
    // needs to be notified when the calendarEvent selection has resolved
  };

  /**
   * Called when a calendar event in the calendar events table is selected.
   *
   * @returns {Promise}
   */

  TrendsViewerEditor.prototype.$trendObjectSelected = function () {
    var that = this,
      oldSelectedRow = that.$oldSelectedRow,
      selectedRow = that.$getSelectedTrendObject();
    that.$oldSelectedRow = selectedRow; // If nothing is selected, disable command buttons

    if (!selectedRow) {
      if (oldSelectedRow) {
        that.emit('selectedEventChanged', null);
      }
      return Promise.resolve(that.$disableCommandsRequiringSelection());
    }
    return Promise.resolve(that.doTrendObjectSelected(selectedRow)).then(function () {
      if (selectedRow !== oldSelectedRow) {
        that.emit('selectedEventChanged', selectedRow.getSubject());
      }
      return that.trendObjectSelectedDone();
    });
  };

  /**
   * Override this to inject additional logic when a calendar event is selected
   * @param {Row} selected - newly selected row
   * @return Promise that resolves when finished handling the selection event
   */

  TrendsViewerEditor.prototype.doTrendObjectSelected = function (selected) {};
  /**
   * @private
   * @returns {module:nmodule/webEditors/rc/util/ListSelection}
   */

  TrendsViewerEditor.prototype.$getSelection = function () {
    return this.$getTable().$getSelection();
  };
  TrendsViewerEditor.prototype.doDestroy = function () {
    this.jq().removeClass('trendsViewerEditor');
    return this.getChildWidgets().destroyAll();
  };
  function unescape(str) {
    return baja.SlotPath.unescapeFully(str);
  }
  return TrendsViewerEditor;
});
