define(function (require) {
  'use strict';

  var baja = require('baja!');
  var lexs = require('lex!baja');
  var $ = require('jquery');
  var Promise = require('Promise');
  var _ = require('underscore');
  var events = require('bajaux/events');
  var responsiveMixIn = require('bajaux/mixin/responsiveMixIn');
  var Properties = require('bajaux/Properties');
  var subscriberMixIn = require('bajaux/mixin/subscriberMixIn');
  var SaveCommand = require('bajaux/util/SaveCommand');
  var switchboard = require('nmodule/js/rc/switchboard/switchboard');
  var TabbedCompositeEditor = require('nmodule/webEditors/rc/fe/baja/TabbedCompositeEditor');
  var DepthSubscriber = require('nmodule/webEditors/rc/fe/baja/util/DepthSubscriber');
  var CompositeBuilder = require('nmodule/webEditors/rc/fe/config/CompositeBuilder');
  var ScheduleTranslator = require('nmodule/schedule/rc/baja/model/ScheduleTranslator');
  var BajaWeekEditor = require('nmodule/schedule/rc/baja/fe/BajaWeekEditor');
  var ScheduleSummaryView = require('nmodule/schedule/rc/fe/ScheduleSummaryView');
  var SpecialEventsEditor = require('nmodule/schedule/rc/fe/SpecialEventsEditor');
  var DayScheduleContextMenu = require('nmodule/schedule/rc/fe/menu/DayScheduleContextMenu');
  var WeekScheduleContextMenu = require('nmodule/schedule/rc/fe/menu/WeekScheduleContextMenu');
  var ssc = require('nmodule/schedule/rc/servlets/ssc');
  var scheduleUtils = require('nmodule/schedule/rc/util/scheduleUtils');
  var TrendsViewerEditor = require('nmodule/nE2Link/rc/TrendsViewerEditor');
  var TrendsManagerEditor = require('nmodule/nE2Link/rc/TrendsManagerEditor');
  var TrendsServiceTempl = require('hbs!nmodule/nE2Link/rc/template/TrendsService');
  require('css!nmodule/nE2Link/rc/style/nE2Link');
  var bajaLex = lexs[0],
    MODIFY_EVENT = events.MODIFY_EVENT;

  /**
   * TrendsService
   *
   * A Tabbed Editor that has three tabs (weekly schedule, special events, summary)
   *
   * @class
   * @alias module:nmodule/schedule/rc/fe/TrendsService
   * @extends module:nmodule/webEditors/rc/fe/baja/TabbedCompositeEditor
   * @param {Object} params
   */

  var TrendsService = function TrendsService(params) {
    var that = this;
    console.log("TrendsService");
    TabbedCompositeEditor.call(that, $.extend({}, {
      moduleName: 'nE2Link',
      keyName: 'TrendsService'
    }, params));

    //that.getCommandGroup().add(new SaveCommand());

    /*
    subscriberMixIn(this);
    this.$subscriber = new DepthSubscriber(7);
    responsiveMixIn(this, {
      'Scheduler-sm': {
        maxWidth: 760
      }
    });
    */
  };
  TrendsService.prototype = Object.create(TabbedCompositeEditor.prototype);
  TrendsService.prototype.constructor = TrendsService;
  var getTimeLabels = _.once(function () {
    return Promise.all([3, 6, 9, 12, 15, 18, 21].map(function (hour) {
      return baja.Time.make({
        hour: hour
      }).toTimeString();
    }));
  });
  TrendsService.prototype.doInitialize = function (dom) {
    var that = this;
    dom.addClass('Scheduler ux-fullscreen').html(TrendsServiceTempl());
    dom.on(MODIFY_EVENT, '.ux-tab-panel-container', function () {
      return false;
    });
    return TabbedCompositeEditor.prototype.doInitialize.call(that, dom.find('.ux-tab-bar-container'));
  };
  TrendsService.prototype.doLoad = function (trendsService) {
    var that = this;
    var orgArguments = arguments;
    trendsService.loadSlots().then(function () {
      that.$model = trendsService;
      return TabbedCompositeEditor.prototype.doLoad.apply(that, orgArguments);
    });
  };

  /**
   * Show the Tab Panel and if the is a pending reload summary request from a modification, reload the summary view.
   * @param {String} choice
   * @returns {Promise}
   * @private
   */

  TrendsService.prototype.$showTabPanel = function (choice) {
    var that = this;
    return Promise.resolve(TabbedCompositeEditor.prototype.$showTabPanel.apply(this, arguments)).then(function () {});
  };
  /**
   * When the TrendsService is modified, update the Schedule Summary after waiting
   * for the tab be be shown.
   * @returns {Promise}
   * @private
   */

  TrendsService.prototype.makeBuilder = function () {
    var that = this,
      builder = new CompositeBuilder();
    builder.getKeys = function () {
      return ['trends-viewer', 'trends-manager'];
    };
    builder.getDomFor = function (key) {
      return that.jq().find(".".concat(key, "-panel"));
    };
    builder.getValueFor = function (key) {
      console.log("Builder.getValueFor: key:" + key + "; model: " + that.$model);
      switch (key) {
        case 'trends-viewer':
          return that.$model.get("trendObjectsList").getSlots().dynamic().is('nE2Link:TrendObject').toValueArray();
        case 'trends-manager':
          return that.$model.get("trendObjectsList").getSlots().dynamic().is('nE2Link:TrendObject').toValueArray();
      }
    };

    /**
     * TabbedCompositeEditor - a composite editor where each child editor is on a
     * separate tab.
     *
     * When deriving from this class, you should implement `makeBuilder` in the same
     * way as any other `CompositeEditor`, with an additional method `getTabFor`,
     * which should return the params passed to a `ToggleCommand` / `Command` constructor.
     *
     * @example
     * builder.getTabFor = function(key) {
     *  return {
     *    displayName: getDisplayName(key)
     *  };
     * };
     *
     * builder.getTabFor = function(key) {
     *  return {
     *    module: "myModule",
     *    lex: "myCommand" + key
     *  };
     * };
     */

    builder.getTabFor = function (key) {
      switch (key) {
        case 'trends-viewer':
          return {
            module: 'nE2Link',
            lex: 'trends.trendsViewer'
          };
        case 'trends-manager':
          return {
            module: 'nE2Link',
            lex: 'trends.trendsManager'
          };
      }
    };
    builder.getConfigFor = function (key) {
      var model = that.$model;
      switch (key) {
        case 'trends-viewer':
          return {
            type: TrendsViewerEditor,
            properties: {}
          };
        case 'trends-manager':
          return {
            type: TrendsManagerEditor,
            properties: {}
          };
      }
    };
    return builder;
  };
  TrendsService.prototype.$getPropertiesElement = function () {
    return this.jq().find('.properties');
  };
  TrendsService.prototype.$getTabElement = function (key) {
    return this.jq().children('.ux-tab-panel-container').children('.' + key + '-panel');
  };
  TrendsService.prototype.$getTrendsViewerEditor = function () {
    return this.getBuilder().getEditorFor('trends-viewer');
  };
  TrendsService.prototype.$getTrendsManagerEditor = function () {
    return this.getBuilder().getEditorFor('trends-manager');
  };

  /**
   * Read the WeekSchedule and ignore any validation errors. This allows the
   * Summary Tab to get the current value of all valid changes without bothering
   * the user about any changes that are not yet valid.
   */

  TrendsService.prototype.$doReadWeekSchedule = function () {
    var that = this,
      weekEd = that.$getWeekEditor();
    return weekEd.read().then(function (weekSchedule) {
      return that.$translator.fromModel(weekSchedule);
    });
  };
  /**
   * Save the WeekSchedule and report any validation errors.
   */

  TrendsService.prototype.$doSaveWeekSchedule = function () {
    var that = this,
      weekEd = that.$getWeekEditor();
    return weekEd.save().then(function () {
      return weekEd.read();
    }).then(function (weekSchedule) {
      return that.$translator.fromModel(weekSchedule);
    });
  };
  TrendsService.prototype.$getSpecialEventsEditor = function () {
    return this.getBuilder().getEditorFor('trends-manager');
  };
  TrendsService.prototype.$doReadSpecialEvents = function () {
    return this.$getSpecialEventsEditor().read();
  };
  TrendsService.prototype.$doSaveSpecialEvents = function () {
    var specialEventsEd = this.$getSpecialEventsEditor();
    return specialEventsEd.save().then(function () {
      return specialEventsEd.read();
    });
  };
  TrendsService.prototype.$getScheduleSummaryView = function () {
    return this.getBuilder().getEditorFor('scheduleSummary');
  };
  /**
   * Collect the current state of the TrendsService for any field editors
   * that properly validate, but do not save them. This includes the weekly
   * schedule, special events, and any changes to facets so that the Summary Tab
   * can use this to display the current events as they are being edited.
   * @returns {Promise}
   */

  TrendsService.prototype.doRead = function () {
    var that = this;
    /*
    return Promise.all([that.$doReadWeekSchedule(), that.$doReadSpecialEvents(), that.$translator.facets()]).spread(function (weekSchedule, specialEvents, facets) {
      that.$snapshot.get('schedule').set({
        slot: 'week',
        value: weekSchedule
      });
      that.$snapshot.get('schedule').set({
        slot: 'specialEvents',
        value: specialEvents
      });
      that.$snapshot.set({
        slot: 'facets',
        value: facets
      });
      return that.$snapshot;
    });
    */
  };
  TrendsService.prototype.doSave = function () {
    var that = this;
    /*
    return Promise.all([that.$doSaveWeekSchedule(), that.$doSaveSpecialEvents(), that.getChildEditors().saveAll()]).spread(function (weekSchedule, specialEvents) {
      that.$snapshot.get('schedule').set({
        slot: 'week',
        value: weekSchedule
      });
      that.$snapshot.get('schedule').set({
        slot: 'specialEvents',
        value: specialEvents
      });
      return ssc.save(that.value().getNavOrd(), that.$snapshot);
    });
    */
  };
  TrendsService.prototype.doDestroy = function () {
    this.jq().removeClass('ux-fullscreen Scheduler');
    return TabbedCompositeEditor.prototype.doDestroy.apply(this, arguments);
  };
  TrendsService.prototype.doReadonly = function (readonly) {
    return this.getChildWidgets().setAllReadonly(readonly);
  };
  TrendsService.prototype.doEnabled = function (enabled) {
    return this.getChildWidgets().setAllEnabled(enabled);
  };
  return TrendsService;
});
