Viewed;
define(function (require) {
  'use strict';

  var baja = require('baja!');
  var Promise = require('Promise');
  var ChartWidget = require('nmodule/webChart/rc/ChartWidget');
  var Command = require('bajaux/commands/Command');
  var feDialogs = require('nmodule/webEditors/rc/fe/feDialogs');
  var SlotPath = require('bajaScript/baja/ord/SlotPath');
  var TrendsChartWidget = function TrendsChartWidget(params) {
    var that = this;
    ChartWidget.apply(this, arguments);
    this.$historyBase = null;
    this.$historyPoints = [];

    /*
    subscriberMixIn(this);
    this.$subscriber = new DepthSubscriber(7);
    responsiveMixIn(this, {
      'Scheduler-sm': {
        maxWidth: 760
      }
    });
    */
  };
  TrendsChartWidget.prototype = Object.create(ChartWidget.prototype);
  TrendsChartWidget.prototype.constructor = TrendsChartWidget;
  TrendsChartWidget.prototype.getHistoryPoints = function (trendsService) {
    var points = [];
    return points;
  };

  /**
   * Create the DOM elements that your chart will use to represent data.
   * @param element
   * @return {Promise}
   */
  TrendsChartWidget.prototype.doInitialize = function (element) {
    var that = this;
    console.log("TrendsChartWidget.prototype.doInitialize element = " + element);
    return ChartWidget.prototype.doInitialize.apply(that, arguments);
  };

  /**
   * Load a WebChart. Note that a ChartWidget will continue to load its data beyond the doLoad promise unless
   * params.fullLoad is true. This gives the user a chance to cancel the load if its taking too long.
   *
   * @param  {baja.Value} value The value for the item we are attempting to load
   * @param {Object} [params] Optional params object passed to `load()`
   * @param {Boolean} [params.fullLoad] if true, delays doLoad promise until all data is available.
   * @param {Boolean} [params.exporting] if true, this notifies the widget that it's being used in an exporting operation.
   * In this case, the widget will ensure all of its data is loaded before it finishes loading.
   * @return {Promise}
   */
  TrendsChartWidget.prototype.doLoad = function (value, params) {
    var that = this;
    console.log("TrendsChartWidget.prototype.doLoad: value = " + value);
    if (value === null) {
      return Promise.reject("Value cannot be null");
    }
    that.$historyPoints = value;
    return ChartWidget.prototype.doLoad.apply(that, arguments);
    /*
    .then(function() {
      if (that.$historyPoints.length > 0) {
        that.setPoints();
      }
    });
    */
  };
  TrendsChartWidget.prototype.setPoints = function () {
    var that = this;
    var model = that.model();
    var subscriber = that.getSubscriber();
    that.getHistoryPoints().then(function (seriesData) {
      model.addSeries(subscriber, seriesData).then(function () {
        return model.load(subscriber);
      });
    });
  };

  /*
  TrendsChartWidget.prototype.resolveValidSeriesData = function() {
    var that = this;
      var batchResolveOrds = [];
    that.$historyPoints.forEach(function(point) {
      batchResolveOrds.push(baja.Ord.make(point.ord));
    });
      return new baja.BatchResolve(batchResolveOrds).resolve()
    .then(function(batchResolve) {
      var objs = batchResolve.getTargetObjects();
      var seriesData = [];
      for (var j = 0; j < objs.length; ++j) {
        seriesData.push({
          ord: batchResolve.getOrd(j),
          value: isValidSeries(objs[j]) ? objs[j] : undefined
        });
      }
      return seriesData;
    })
    .catch(function(err) {
      baja.error(err);
      throw err;
    });
  };
  */
  TrendsChartWidget.prototype.initCommands = function (element, clearCmd) {
    var that = this,
      widgetBar = that.$widgetBar;
    return ChartWidget.prototype.initCommands.apply(that, arguments);
  };
  return TrendsChartWidget;
});
