function _regenerator() { /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/babel/babel/blob/main/packages/babel-helpers/LICENSE */ var e, t, r = "function" == typeof Symbol ? Symbol : {}, n = r.iterator || "@@iterator", o = r.toStringTag || "@@toStringTag"; function i(r, n, o, i) { var c = n && n.prototype instanceof Generator ? n : Generator, u = Object.create(c.prototype); return _regeneratorDefine2(u, "_invoke", function (r, n, o) { var i, c, u, f = 0, p = o || [], y = !1, G = { p: 0, n: 0, v: e, a: d, f: d.bind(e, 4), d: function d(t, r) { return i = t, c = 0, u = e, G.n = r, a; } }; function d(r, n) { for (c = r, u = n, t = 0; !y && f && !o && t < p.length; t++) { var o, i = p[t], d = G.p, l = i[2]; r > 3 ? (o = l === n) && (u = i[(c = i[4]) ? 5 : (c = 3, 3)], i[4] = i[5] = e) : i[0] <= d && ((o = r < 2 && d < i[1]) ? (c = 0, G.v = n, G.n = i[1]) : d < l && (o = r < 3 || i[0] > n || n > l) && (i[4] = r, i[5] = n, G.n = l, c = 0)); } if (o || r > 1) return a; throw y = !0, n; } return function (o, p, l) { if (f > 1) throw TypeError("Generator is already running"); for (y && 1 === p && d(p, l), c = p, u = l; (t = c < 2 ? e : u) || !y;) { i || (c ? c < 3 ? (c > 1 && (G.n = -1), d(c, u)) : G.n = u : G.v = u); try { if (f = 2, i) { if (c || (o = "next"), t = i[o]) { if (!(t = t.call(i, u))) throw TypeError("iterator result is not an object"); if (!t.done) return t; u = t.value, c < 2 && (c = 0); } else 1 === c && (t = i["return"]) && t.call(i), c < 2 && (u = TypeError("The iterator does not provide a '" + o + "' method"), c = 1); i = e; } else if ((t = (y = G.n < 0) ? u : r.call(n, G)) !== a) break; } catch (t) { i = e, c = 1, u = t; } finally { f = 1; } } return { value: t, done: y }; }; }(r, o, i), !0), u; } var a = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} t = Object.getPrototypeOf; var c = [][n] ? t(t([][n]())) : (_regeneratorDefine2(t = {}, n, function () { return this; }), t), u = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(c); function f(e) { return Object.setPrototypeOf ? Object.setPrototypeOf(e, GeneratorFunctionPrototype) : (e.__proto__ = GeneratorFunctionPrototype, _regeneratorDefine2(e, o, "GeneratorFunction")), e.prototype = Object.create(u), e; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, _regeneratorDefine2(u, "constructor", GeneratorFunctionPrototype), _regeneratorDefine2(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = "GeneratorFunction", _regeneratorDefine2(GeneratorFunctionPrototype, o, "GeneratorFunction"), _regeneratorDefine2(u), _regeneratorDefine2(u, o, "Generator"), _regeneratorDefine2(u, n, function () { return this; }), _regeneratorDefine2(u, "toString", function () { return "[object Generator]"; }), (_regenerator = function _regenerator() { return { w: i, m: f }; })(); }
function _regeneratorDefine2(e, r, n, t) { var i = Object.defineProperty; try { i({}, "", {}); } catch (e) { i = 0; } _regeneratorDefine2 = function _regeneratorDefine(e, r, n, t) { function o(r, n) { _regeneratorDefine2(e, r, function (e) { return this._invoke(r, n, e); }); } r ? i ? i(e, r, { value: n, enumerable: !t, configurable: !t, writable: !t }) : e[r] = n : (o("next", 0), o("throw", 1), o("return", 2)); }, _regeneratorDefine2(e, r, n, t); }
function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
/**
 * A module defining `NanoGenericView`.
 *
 * @module nmodule/nE2Link/rc/NanoGenericView
 */
define(function (require) {
  'use strict';

  var baja = require('baja!');
  var lexs = require('lex!nE2Link');
  var $ = require('jquery');
  var _ = require('underscore');
  var Promise = require('Promise');
  var dialogs = require('dialogs');
  var events = require('bajaux/events');
  var fe = require('nmodule/webEditors/rc/fe/fe');
  var BaseEditor = require('nmodule/webEditors/rc/fe/baja/BaseEditor');
  var NavTree = require('nmodule/webEditors/rc/wb/tree/NavTree');
  var TreeNode = require('nmodule/webEditors/rc/wb/tree/TreeNode');
  var BajaNavTreeNode = require('nmodule/webEditors/rc/wb/tree/BajaNavTreeNode');
  var JSONTreeNode = require('nmodule/webEditors/rc/wb/tree/JSONTreeNode');
  var BajaComplexTreeNode = require('nmodule/webEditors/rc/wb/tree/BajaComplexTreeNode');
  var htmlUtils = require('nmodule/webEditors/rc/util/htmlUtils');
  var Command = require('bajaux/commands/Command');
  var CommandButton = require('bajaux/util/CommandButton');
  var viewTemplate = require('hbs!nmodule/nE2Link/rc/template/trendMaintenanceView');
  var confirmClearDialog = require('hbs!nmodule/nE2Link/rc/template/ConfirmClearDialog');
  require('css!nmodule/nE2Link/rc/style/nE2Link');
  'use strict';
  var lex = lexs[0],
    escapeHtml = htmlUtils.escapeHtml,
    //helper css classes used to find different elements
    DATABASE_MAINTENANCE_CLASS = 'dbMaintenance',
    TRENDS_NAV_TREE_CLASS = 'historyTree',
    TRENDS_NAV_TREE_SELECTOR = '.' + TRENDS_NAV_TREE_CLASS,
    TRENDS_LIST_SELECTOR = '.historyList > ul',
    DATE_EDITOR_CLASS = 'dateEditor',
    DATE_EDITOR_SELECTOR = '.' + DATE_EDITOR_CLASS,
    RUN_COMMAND_BUTTON_CLASS = 'run',
    RUN_COMMAND_BUTTON_SELECTOR = '.' + RUN_COMMAND_BUTTON_CLASS,
    TRENDS_SELECTED_CLASS = 'history-selected',
    TRENDS_SELECTED_SELECTOR = '.' + TRENDS_SELECTED_CLASS,
    DELETE_ENTRY_COMMAND_CLASS = 'deleteEntryCmd',
    //icons
    DELETE_ICON = baja.Icon.make(lex.getSafe('trends.db.deleteIcon')).getImageUris()[0],
    WARNING_ICON = lex.getSafe('history.db.warningIcon'),
    //possible operation
    OPERATIONS = {
      clearOld: 'clearOldRecords',
      clearAll: 'clearAllRecords'
    };

  /**
   * TrendMaintenanceView allows for running maintenance operations on
   * trends (clearing old histories)
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/nE2Link/rc/TrendMaintenanceView
   */
  var TrendMaintenanceView = function TrendMaintenanceView() {
    BaseEditor.call(this, {
      moduleName: 'nE2Link',
      keyName: 'TrendMaintenanceView'
    });
  };

  //extend and set up prototype chain
  TrendMaintenanceView.prototype = Object.create(BaseEditor.prototype);
  TrendMaintenanceView.prototype.constructor = TrendMaintenanceView;
  function initNavTreeEditor(view, trendsService) {
    var that = this;
    trendsService.rpc("isStationOnMac").then(function (isStationOnMac) {
      return trendsService.rpc("getAllRecords").then(/*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
        var i, trendsObjectList;
        return _regenerator().w(function (_context) {
          while (1) switch (_context.n) {
            case 0:
              i = 0;
              trendsObjectList = trendsService.getTrendObjectsList();
              if (!isStationOnMac) {
                _context.n = 3;
                break;
              }
            case 1:
              trendsObjectList = trendsService.getTrendObjectsList();
              i++;
              _context.n = 2;
              return new Promise(function (r) {
                return setTimeout(r, 3000);
              });
            case 2:
              if (trendsObjectList === null && i < 5) {
                _context.n = 1;
                break;
              }
            case 3:
              trendsObjectList.loadSlots().then(function () {
                //var jsonObject = {"trend1":"TrendName-1", "trend2":"TrendName-2"};
                return fe.buildFor({
                  dom: $(TRENDS_NAV_TREE_SELECTOR, view.jq()),
                  //value: new JSONTreeNode("nE2 Device Trends", trendObjects),
                  value: new BajaNavTreeNode(trendsService.getTrendObjectsList()),
                  type: NavTree
                }).then(function (tree) {
                  function getParent(tree) {
                    var parent = tree.jq().parent().parent().data('widget');
                    return parent instanceof NavTree && parent || getParent(parent);
                  }
                  tree.expand();

                  //register event handler for double-clicking a tree node
                  tree.jq().on(NavTree.ACTIVATED_EVENT, null, view, nodeDblClicked);

                  //register batch select handler
                  var anchor,
                    //stores the anchor node in a shift + click operation
                    node; //stores the currently selected node,

                  tree.jq().on(NavTree.SELECTED_EVENT, function (e, root, modified) {
                    //single click
                    node = root; //cache the clicked node for use in 'mouseup'
                  }).on('mouseup', function (e) {
                    //batch selection using shift + click
                    if (e.shiftKey && anchor && node && anchor !== node) {
                      var anchorParent = getParent(anchor),
                        nodeParent = getParent(node);

                      //only permit batch selection for nodes with a common parent
                      if (anchorParent && anchorParent === nodeParent) {
                        var kids = anchorParent.$getKids(),
                          anchorIndex,
                          nodeIndex,
                          i,
                          startIndex,
                          endIndex;
                        for (i = 0; i < kids.length; i++) {
                          //locate the anchor index
                          if (kids[i] === anchor) {
                            anchorIndex = i;
                          }

                          //locate the node index
                          else if (kids[i] === node) {
                            nodeIndex = i;
                          }

                          //break if both indices have been found
                          if (anchorIndex && nodeIndex) {
                            break;
                          }
                        }
                        startIndex = anchorIndex < nodeIndex ? anchorIndex : nodeIndex;
                        endIndex = anchorIndex > nodeIndex ? anchorIndex : nodeIndex;
                        _.each(kids.slice(startIndex, endIndex + 1), function (kid) {
                          kid.setSelected(true, true);
                        });
                      }
                    } else {
                      anchor = node;
                    }
                  });

                  //arm drag/drop handler
                  var list = view.$getList();
                  list.on('dragover', function () {
                    return false;
                  }).on('drop', function (e) {
                    getNodes(tree, NavTree.prototype.isSelected).then(function (nodes) {
                      appendNodesToList(nodes, list);
                    });
                    return false;
                  });
                });
              });
            case 4:
              return _context.a(2);
          }
        }, _callee);
      })));
    });
  }
  function nodeDblClicked(event, node) {
    var view = event.data;
    appendNodesToList([node], view.$getList());
  }

  //node must be an instance of NavTree
  function isValid(node, list) {
    //a node is valid if it or one of it's ancestor's isn't already selected and it isn't list
    if (node.$oldNode.$display == "Trend Objects List") return false;
    return !(isDefault(node) || ancestorSelected(node));
  }
  function getSelectedOrds(list) {
    return list.children().map(function () {
      console.log("getSelectedOrds.list: " + $(this).data('ord'));
      return $(this).data('ord');
    }).get();
  }
  function ancestorSelected(node) {
    return node.jq().closest(TRENDS_SELECTED_SELECTOR).length;
  }
  function isDefault(node) {
    var ord = node.value().value().getNavOrd().toString(),
      DEFAULT_REGEX = /.*\/\/\//;
    return DEFAULT_REGEX.test(ord);
  }

  //DFS search of nodes from the specified root satisfying the filter
  function getNodes(root, filter) {
    if (filter.call(root, root)) {
      return Promise.resolve([root]);
    }
    return root.$setLoaded(true).then(function () {
      var kids = root.$getKids(),
        kidLoadingPromises = _.map(kids, function (kid) {
          return kid.$setLoaded(true);
        });
      return Promise.all(kidLoadingPromises).then(function () {
        var kidRetrievalPromises = _.map(kids, function (kid) {
          return getNodes(kid, filter);
        });
        return Promise.all(kidRetrievalPromises);
      });
    }).then(_.flatten);
  }

  //nodes must be NavTrees
  function appendNodesToList(nodes, list) {
    console.log("appendNodesToList");
    var parent = list.parent();
    list.detach();
    _.each(nodes, function (node) {
      if (isValid(node, list)) {
        var treeNode = node.value(),
          navNode = treeNode.value(),
          navOrd = navNode.getNavOrd().relativizeToSession(),
          text = baja.SlotPath.unescape(navOrd.toString().substring(navOrd.toString().lastIndexOf('/') + 1)),
          listItem;
        console.log("node.value() = " + text);
        node.jq().addClass(TRENDS_SELECTED_CLASS);

        //append list item
        listItem = $("<li><div class='historyId'>" + text + "</div></li>").data('ord', navOrd).appendTo(list);

        //append delete img
        $('<img>').attr('src', DELETE_ICON).addClass(DELETE_ENTRY_COMMAND_CLASS).prependTo(listItem).click(function () {
          //unmark the selected node
          node.jq().removeClass(TRENDS_SELECTED_CLASS);
          listItem.remove();
        });
      }
    });
    parent.append(list);
  }
  function clearList(view) {
    view.$getList().empty();
    view.jq().find(TRENDS_SELECTED_SELECTOR).removeClass(TRENDS_SELECTED_CLASS);
  }
  function initDateEditor(view) {
    var now = new Date(),
      year = now.getFullYear(),
      month = now.getMonth(),
      day = now.getDate(),
      hour = now.getHours(),
      min = now.getMinutes();
    return fe.buildFor({
      dom: $(DATE_EDITOR_SELECTOR, view.jq()),
      value: baja.AbsTime.make({
        jsDate: new Date(year, month, day, hour, min)
      }),
      formFactor: 'mini'
    }).then(function (editor) {
      editor.jq().on(events.MODIFY_EVENT, function () {
        return false;
      });
    });
  }
  function initRunCommand(view, trendsService) {
    return fe.buildFor({
      dom: $(RUN_COMMAND_BUTTON_SELECTOR, view.jq()),
      type: CommandButton,
      value: new Command({
        displayName: lex.get('trends.db.run.displayName'),
        description: lex.get('trends.db.run.description'),
        func: function func() {
          return runMaintenance(trendsService, view);
        }
      }),
      formFactor: 'mini'
    });
  }
  function runMaintenance(trendsService, view) {
    console.log("that.$trendsService = " + trendsService);
    function makeDialogContent(date) {
      var obj = {
          title: lex.getSafe('trends.db.dialog.confirmClear'),
          completionTitle: lex.get('trends.db.dialog.clearOld.title')
        },
        warningIcon = baja.Icon.make(WARNING_ICON).getImageUris()[0],
        op = view.$getSelectedOperation(),
        content = {
          icon: warningIcon
        },
        ords = view.$getSelectedOrds(),
        args = [ords];
      if (!ords.length) {
        obj.title = lex.getSafe('trends.db.noRecordsSelected');
        'No Records Selected';
        obj.content = lex.getSafe('trends.db.selectMessage');
      } else {
        switch (op) {
          case OPERATIONS.clearOld:
            obj.completionTitle = lex.get('trends.db.dialog.clearOld.title');
            content.time = date.getJsDate();
            content.operation = lex.getSafe({
              key: "trends.confirmClear.operation.clearOld",
              args: [date.getJsDate()]
            });
            args.push(date);
            break;
          case OPERATIONS.clearAll:
            obj.completionTitle = lex.get('trends.db.dialog.clearAll.title');
            content.operation = lex.getSafe("trends.confirmClear.operation.clearAll");
            break;
        }
        content.confirm = lex.getSafe("trends.confirmClear.confirm");
        content.question = lex.getSafe("trends.confirmClear.question");
        obj.content = confirmClearDialog(content);
        obj.func = function (view) {
          console.log("op.toString() = " + op.toString() + "; view.$getList() = " + view.$getList());
          _.each(args, function (arg) {
            console.log("arg = " + arg);
          });
          trendsService.rpc(op.toString(), args).then(function () {
            dialogs.showOk({
              title: obj.completionTitle,
              content: lex.getSafe('trends.db.successMessage')
            });
            clearList(view);
          })["catch"](function (err) {
            dialogs.showOk({
              title: obj.completionTitle,
              content: lex.getSafe('trends.db.errorMessage') + "<br/>(" + escapeHtml(err) + ")"
            });
          });
        };
      }
      return obj;
    }
    ;
    return view.$getDateEditor().read().then(function (date) {
      var obj = makeDialogContent(date);
      if (!obj.func) {
        dialogs.showOk({
          title: obj.title,
          content: obj.content
        });
      } else {
        var dlg = dialogs.showYesNo({
          title: obj.title,
          content: obj.content,
          yes: function yes() {
            dlg.close();
            obj.func(view);
          }
        });
      }
    })["catch"](function (err) {
      dialogs.showOk({
        title: lex.get('trends.db.dialog.invalidTime.title'),
        content: err
      });
    });
  }
  function resize(view) {
    var containerHeight = $('.bajaux-container').outerHeight(true),
      maintenanceDivHeight = $('.maintenance', view.jq()).outerHeight(true),
      toolbarHeight = $('.bajaux-toolbar-outer').outerHeight(true),
      historyChooserDivHeight = containerHeight - maintenanceDivHeight - toolbarHeight - 30;
    $('.historyChooser', view.jq()).outerHeight(historyChooserDivHeight);
  }

  /**
   * Initializes the DOM with the HistorySpace tree, history selection list and options
   * for running maintenance
   * @param dom
   * @returns {Promise} Promise resolved once initializtion is complete
   */
  TrendMaintenanceView.prototype.doInitialize = function (dom) {
    var that = this;
    dom.addClass(DATABASE_MAINTENANCE_CLASS).html(viewTemplate({
      clearOldId: this.generateId(),
      clearAllId: this.generateId(),
      clearOld: lex.get('trends.db.clearOld'),
      clearOldValue: OPERATIONS.clearOld,
      clearAll: lex.get('trends.db.clearAll'),
      clearAllValue: OPERATIONS.clearAll
    }));

    //handle the onclick event on selected option: Enable/Disable dateEditor accordingly
    _.each(OPERATIONS, function (operation) {
      that.jq().find('input[type=radio][value=' + operation + ']').on('click', function (event) {
        console.log(operation + " is clicked!");
        switch (operation) {
          case OPERATIONS.clearOld:
            that.jq().find(DATE_EDITOR_SELECTOR).removeClass('bajaux-readonly');
            break;
          case OPERATIONS.clearAll:
            that.jq().find(DATE_EDITOR_SELECTOR).addClass('bajaux-readonly');
            break;
        }
      });
    });

    //default selection: clearOldRecords
    that.jq().find(DATE_EDITOR_SELECTOR).removeClass('bajaux-readonly');
    this.$selectOperation(OPERATIONS.clearOld);

    /*global window*/
    $(window).resize(function () {
      resize(that);
    });
  };

  /**
   * Resizes the view once it's been initialized
   */
  TrendMaintenanceView.prototype.doLoad = function (trendsService) {
    console.log("TrendMaintenanceView.prototype.doLoad");
    var that = this;
    that.$trendsService = trendsService;
    trendsService.loadSlots().then(function () {
      return Promise.join(initNavTreeEditor(that, that.$trendsService), initDateEditor(that), initRunCommand(that, that.$trendsService));
      resize(this);
    });
  };

  /**
   * Destroys all child editors and clears the history selection list
   * @param params
   * @returns {Promise}
   */
  TrendMaintenanceView.prototype.doDestroy = function (params) {
    this.$getList().empty();
    return this.getChildEditors().destroyAll();
  };

  /**
   * Returns a reference to the HistorySpace NavTree editor
   * @private
   * @returns {NavTree}
   */
  TrendMaintenanceView.prototype.$getNavTree = function () {
    return this.jq().find(TRENDS_NAV_TREE_SELECTOR).data('widget');
  };

  /**
   * Returns a reference to the list containing the histories marked for maintenance
   * @private
   * @returns {jQuery}
   */
  TrendMaintenanceView.prototype.$getList = function () {
    return this.jq().find(TRENDS_LIST_SELECTOR);
  };

  /**
   * Returns a reference to the CompositeAbsTimeEditor for selecting dates
   * @private
   * @returns {CompositeAbsTimeEditor}
   */
  TrendMaintenanceView.prototype.$getDateEditor = function () {
    return this.jq().find(DATE_EDITOR_SELECTOR).data('widget');
  };

  /**
   * Returns a reference to the Command for selecting all histories in the dataase*
   * @private
   * @returns {Command}
   */
  TrendMaintenanceView.prototype.$getSelectAllCommand = function () {
    return this.getCommandGroup().get(0);
  };

  /**
   * Returns a reference to the Command for deselecting all histories from the selection list
   * @private
   * @returns {Command}
   */
  TrendMaintenanceView.prototype.$getDeselectAllCommand = function () {
    return this.getCommandGroup().get(1);
  };

  /**
   * Returns the value for the currently selected maintenance operation
   * @private
   * @returns {String} Value for current maintenance operation
   */
  TrendMaintenanceView.prototype.$getSelectedOperation = function () {
    console.log("$getSelectedOperation");
    return this.jq().find('input[type=radio]:checked').val();
  };

  /**
   * Selects the maintenance operation to run
   * @private
   * @param operation One of 'clearOld' or 'clearAll',
   */
  TrendMaintenanceView.prototype.$selectOperation = function (operation) {
    console.log("$selectOperation");
    this.jq().find('input[type=radio]:checked').prop('checked', false);
    this.jq().find('input[type=radio][value=' + operation + ']').prop('checked', true);
  };

  /**
   * Returns an arrray of baja.Ord for the currently selected histories marked for maintenance
   * @private
   * @returns {Array} Array of baja.Ord
   */
  TrendMaintenanceView.prototype.$getSelectedOrds = function () {
    return getSelectedOrds(this.$getList());
  };
  return TrendMaintenanceView;
});
