function _typeof2(o) { "@babel/helpers - typeof"; return _typeof2 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof2(o); }
function _typeof(obj) {
  "@babel/helpers - typeof";

  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof = function _typeof(obj) {
      return typeof obj;
    };
  } else {
    _typeof = function _typeof(obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    };
  }
  return _typeof(obj);
}

/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/tree/JSONTreeNode
 */
define(['underscore', 'nmodule/webEditors/rc/wb/tree/TreeNode'], function (_, TreeNode) {
  'use strict';

  function isObjectOrArray(v) {
    return v && _typeof(v) === 'object';
  }
  /**
   * @class
   * @alias module:nmodule/nE2Link/rc/JSONTreeNode
   * @extends module:nmodule/webEditors/rc/wb/tree/TreeNode
   * @param {String|Object} name the name of the tree node. Or, you can just
   * pass a single argument, an object or array, and the tree node hierarchy
   * will be built out from that value.
   * @param {*} obj the JSON value represented by this node
   */

  var JSONTreeNode = function JSONTreeNode(name, objects) {
    console.log("JSONTreeNode: name = " + name + "; objects = " + objects);
    var kids = [];
    /*
    if (isObjectOrArray(objects)) {
      kids = _.map(objects, function (value, key) {
        console.log("value = " + value.slots() + "; key = " + key);
          return new JSONTreeNode(value.getTrendName(), value);
      });
    } else {
      kids = [];
    }
    */

    _.each(objects, function (obj) {
      console.log("obj: " + obj + "; type = " + _typeof2(obj));
    });
    name = String(name);
    TreeNode.call(this, name, name, kids);
  };
  JSONTreeNode.prototype = Object.create(TreeNode.prototype);
  JSONTreeNode.prototype.constructor = JSONTreeNode;
  /**
   * The JSON value represented by this node.
   * @returns {*}
   */

  JSONTreeNode.prototype.value = function () {
    return this.$value;
  };
  /**
   * If this value does not represent an object or array, it cannot have child
   * nodes.
   * @returns {boolean} true iff the value is an object or array
   */

  JSONTreeNode.prototype.mayHaveKids = function () {
    return !!isObjectOrArray(this.value());
  };
  return JSONTreeNode;
});
