function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
define(function (require) {
  'use strict';

  var baja = require('baja!');
  var lexs = require('lex!nE2Link,webEditors');
  var $ = require('jquery');
  var Promise = require('Promise');
  var _ = require('underscore');
  var CustomTableViewModel = require('nmodule/nE2Link/rc/model/CustomTableViewModel');
  var NanoMgr = require('nmodule/nE2Link/rc/model/NanoMgr');
  var NanoMgrModel = require('nmodule/nE2Link/rc/model/NanoMgrModel');
  var Manager = require('nmodule/webEditors/rc/wb/mgr/Manager');
  var feDialogs = require('nmodule/webEditors/rc/fe/feDialogs');
  var compUtils = require('nmodule/webEditors/rc/fe/baja/util/compUtils');
  var PropertySheet = require('nmodule/webEditors/rc/wb/PropertySheet');
  var componentStatusUtils = require('nmodule/webEditors/rc/wb/mgr/componentStatusUtils');
  var MgrTypeInfo = require('nmodule/webEditors/rc/wb/mgr/MgrTypeInfo');
  var mgrUtils = require('nmodule/webEditors/rc/wb/mgr/mgrUtils');
  var addMgrLearnSupport = require('nmodule/webEditors/rc/wb/mgr/MgrLearn');
  var TreeTableModel = require('nmodule/webEditors/rc/wb/table/tree/TreeTableModel');
  var TreeNode = require('nmodule/webEditors/rc/wb/tree/TreeNode');
  var Column = require('nmodule/webEditors/rc/wb/table/model/Column');
  var MgrColumn = require('nmodule/webEditors/rc/wb/mgr/model/MgrColumn');
  var IconMgrColumn = require('nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn');
  var NanoPropertyColumn = require('nmodule/nE2Link/rc/model/NanoPropertyColumn');
  var NameMgrColumn = require('nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn');
  var DepthSubscriber = require('nmodule/webEditors/rc/fe/baja/util/DepthSubscriber');
  var dialogs = require('dialogs');
  var Log = require('nmodule/js/rc/log/Log');
  var CustomTableViewTempl = require('hbs!nmodule/nE2Link/rc/template/CustomTableView');
  require('css!nmodule/nE2Link/rc/style/nE2Link');

  //The icon
  var DATA_NODE_ICON = baja.Icon.make(['module://icons/x16/device.png']);
  var DISCOVERY_NODE_ICON = baja.Icon.make(['module://icons/x16/device.png']),
    getMainTableSelection = mgrUtils.getMainTableSelectedSubjects,
    addStatusCss = componentStatusUtils.addComponentStatusCss,
    nanoLex = lexs[0],
    webEditorsLex = lexs[1],
    NANO_DEVICE_TYPE = 'nE2Link:NanoBaseComponent',
    NANO_FOLDER_TYPE = 'nE2Link:NanoFolder',
    Level = Log.Level,
    nanoLex = lexs[0];
  function lex(key) {
    return nanoLex.get(key);
  }
  function filterDevices(comps) {
    return _.filter(comps, function (c) {
      return c.getType().is(NANO_DEVICE_TYPE);
    });
  }
  function getDeviceObjects(comps) {
    return _.map(filterDevices(comps), function (dev) {
      return dev.getConfig().getDeviceObject();
    });
  }

  ////////////////////////////////////////////////////////////////
  // CustomTableView
  ////////////////////////////////////////////////////////////////

  /**
   * CustomTableView constructor..
   *
   * @class
   * @alias module:nmodule/nE2Link/rc/CustomTableView
   * @extends module:nmodule/nE2Link/rc/model/NanoMgr
   * @param {Object} params
   */
  var CustomTableView = function CustomTableView(params) {
    var superFinishDiscoveryRow;
    this.$dataModel = null;
    var that = this;
    //Manager.call(that, params);
    NanoMgr.call(this, _.extend({
      moduleName: 'nE2Link',
      keyName: 'CustomTableView',
      folderType: NANO_FOLDER_TYPE,
      subscriptionDepth: 1
    }, params));
  };
  CustomTableView.prototype = Object.create(NanoMgr.prototype);
  CustomTableView.prototype.constructor = CustomTableView;

  /**
   * Overrides the NanoMgr doInitialize() function by registering to handle the 'jobcomplete' event
   * @param {JQuery} dom
   * @returns {*}
   */
  CustomTableView.prototype.doInitialize = function (dom) {
    var that = this;
    return NanoMgr.prototype.doInitialize.call(that, dom, {
      html: CustomTableView({
        viewName: ""
      })
    });
  };

  /**
   * Load the network or device folder into the widget.
   *
   * @returns {*}
   */
  CustomTableView.prototype.doLoad = function (comp) {
    var that = this,
      model = that.getModel(),
      comps = []; //model.getComponentSource().getComponents();
    that.$component = comp;
    console.log("that.$component: " + that.$component);
    NanoMgr.prototype.doLoad.call(that, comp);
    that.doGetData();
  };

  /**
   * Override of `doDestroy`, which will unsubscribe all the device config
   * objects we have subscribed to.
   */
  CustomTableView.prototype.doDestroy = function () {
    var that = this,
      selection;
    if (that.$tableSelectionHandler) {
      selection = mgrUtils.getMainTableSelection(that);
      selection.removeListener('changed', that.$tableSelectionHandler);
      delete that.$tableSelectionHandler;
    }
    if (that.$deviceAddedHandler) {
      //that.getSubscriber().detach('added', that.$deviceAddedHandler);
      delete that.$deviceAddedHandler;
    }
    return NanoMgr.prototype.doDestroy.apply(that, arguments);
  };

  /**
   * Function to return an array of types to be offered upon the execution
   * of the command to add new instances.
   *
   * @returns {Promise.<Array.<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>>}
   */
  CustomTableView.prototype.getNewTypes = function () {
    return [NANO_DEVICE_TYPE];
  };

  /**
   * Function to return the type of Folder offered upon the execution
   * of the command to add new folder.
   *
   * @returns {Promise.<Array.<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>>}
   */
  CustomTableView.prototype.getFolderType = function () {
    return NANO_FOLDER_TYPE;
  };

  /**
   * Function called when the list selection on the main db table is changed.
   * This will enable or disable the change device id command as appropriate, and
   * is also an override point for the network subclasses to enable or disable
   * their commands.
   *
   * @private
   * @param {module:nmodule/webEditors/rc/util/ListSelection} selection
   */
  CustomTableView.prototype.onMainTableSelectionChanged = function (selection) {
    //var changeIdCmd = mgrUtils.findCommand(this, ChangeIdCommand);
    //changeIdCmd.setEnabled(this.isSingleDeviceSelected());
  };

  /**
   * Test that we have a single item selected in the main database table,
   * and that it is a device, not a folder.
   *
   * @private
   * @returns {Boolean}
   */
  CustomTableView.prototype.isSingleDeviceSelected = function () {
    var subjects = getMainTableSelection(this);
    return subjects.length === 1; // && (subjects[0].getType().is('nE2Link:NanoGenericUxComponent'));
  };

  /**
   * Subscribe to the given array of devices/folders. Rather than use the depth subscriber
   * which will subscribe to too much, this will subscribe to the device and the
   * device objects of those devices. The base class depth subscriber is still used
   * to subscribe to the network.
   *
   * @param {module:nmodule/bacnet/rc/wb/mgr/CustomTableView} mgr
   * @param {Array.<baja.Component>} comps
   */
  function subscribeComponents(mgr, comps) {
    //var sub = mgr.getSubscriber();
    console.log("subscribeComponents");
    return Promise.resolve();

    /*
    if (!(mgr.getNetwork().isMounted()) || !(comps.length)) {
      return Promise.resolve();
    }
      return sub.subscribe(comps)
      .then(function () {
        var batch = new baja.comm.Batch(),
            promises;
          promises = Promise.map(filterDevices(comps), function (dev) {
          return dev.getConfig().loadSlots({ batch: batch })
            .then(function () {
              return dev.getConfig().getDeviceObject();
            });
        });
          batch.commit();
          return promises.then(function (objs) {
          return sub.subscribe(objs);
        });
      })
      .catch(function (err) {
        Log.logMessage('CustomTableView', Level.WARNING, 'Could not subscribe devices: ' + String(err));
      });
      */
  }

  /**
   * Override called when the 'all descendants' command is toggled. This will check the difference
   * between the model's current set of devices/device objects and folders, and the components that
   * are currently known to the subscriber, performing subscription and unsubscription as appropriate.
   *
   * @returns {Promise.<*>}
   */
  CustomTableView.prototype.resubscribeForNewFolderDepth = function () {
    /*
    var that = this,
        source = that.getModel().getComponentSource(),
        container = source.getContainer(),
        subscriber = that.getSubscriber(),
        modelComponents = source.getComponents(),
        currentlySubscribed = subscriber.getComponents(),
        toSubscribe = _.difference(modelComponents, currentlySubscribed);
      return subscribeComponents(that, toSubscribe)
      .then(function () {
        var toKeepSubscribed = modelComponents.concat(getDeviceObjects(modelComponents)).concat(container),
            toUnsubscribe = _.difference(currentlySubscribed, toKeepSubscribed);
          return (toUnsubscribe.length ? subscriber.unsubscribe(toUnsubscribe) : Promise.resolve());
      });
      */
  };

  /**
   * Override of the function called when the subscriber reports a component has
   * changed. This is overridden to avoid updating the table for certain properties
   * that have no significance for any of the columns in the table.
   *
   * @param {baja.Component} component
   * @param {baja.Property} prop
   */
  CustomTableView.prototype.componentChanged = function (component, prop) {
    // Filter out device time changes: these happen quite frequently and we
    // don't want the performance hit of updating the the table for those.

    if (prop.getName() !== 'localTime') {
      return Manager.prototype.componentChanged.apply(this, arguments);
    }
  };

  /**
   * Makes the model for the main database table.
   *
   * @param {baja.Component} component - current component instance.
   * @returns {Promise.<module:nmodule/driver/rc/wb/mgr/DeviceMgrModel>}
   */
  CustomTableView.prototype.makeModel = function (component) {
    console.log("CustomTableView.prototype.makeModel: component = " + component);
    var that = this;

    /*
    if (that.$dataModel === null) {
       //var params = { columns: [new IconMgrColumn(), new NameMgrColumn()] };
       var params = { columns: [] };
       return Promise["try"](function () {
            return new TreeTableModel(params);
       }).then(function (model) {
            that.$dataModel = model;
            return model.$expandForNode(model.$node, 0).then(_.constant(model));
       });
    }
    */

    if (that.$dataModel == null) {
      //that.$dataModel = CustomTableViewModel.make(component, [], NANO_DEVICE_TYPE, NANO_FOLDER_TYPE);
      that.$dataModel = TreeTableModel.make(component, [], NANO_DEVICE_TYPE, NANO_FOLDER_TYPE);
    }
    return that.$dataModel;
  };

  /*
  CustomTableView.prototype.getModel = function () {
    console.log("this.$dataModel = " + this.$dataModel);
    return this.$dataModel.then( function(model) {
        return model;
    });
      //return this.$dataModel;
  };
  */

  CustomTableView.prototype.getJob = function () {
    return this.$getDataJob;
  };
  CustomTableView.prototype.setJob = function (params) {
    var that = this,
      jobOrOrd,
      depth,
      isJob;
    params = baja.objectify(params, 'jobOrOrd');
    jobOrOrd = params.jobOrOrd;
    depth = params.depth || 1;

    // First, clean up any existing job that might already have been set on the manager.
    // After that, obtain the new job: we might have been passed one directly, or we might need to resolve an ord.
    return unsubscribeJob(that).then(function () {
      return baja.station.sync();
    }).then(function () {
      if (that.$getDataJob) {
        delete that.$getDataJob;
      }
      isJob = baja.hasType(jobOrOrd, 'baja:Job');
      return isJob ? Promise.resolve(jobOrOrd) : baja.Ord.make(String(jobOrOrd)).get();
    }).then(function (job) {
      //var getDataCmd = that.$getDataCommand(),
      //    cancelCmd = that.$getCancelDataCommand();

      // Now we have a reference to the job, keep track of it with some private
      // properties, then load it into the job bar.
      that.$getDataJob = job;
      that.$jobSubDepth = depth;

      /*
      if (getDataCmd) {
        getDataCmd.setEnabled(false);
      }
        if (cancelCmd) {
        cancelCmd.setEnabled(true);
      }
      */

      //Do we need a jobBar for the Generic Views?
      //return that.$getJobBar().load(job).then(function () {
      return job;
      //});
    }).then(function (job) {
      // Test if the job has already completed, if so, call the
      // job complete callback directly. Otherwise, subscribe and
      // wait for an event to notify us that the job has finished.
      if (isJobComplete(job)) {
        // The job has already completed, so subscribe to the job
        // and its children to the requested depth. We don't need
        // to pass in a change callback, as once it's complete we
        // don't care about changes.
        return subscribeJob(that, job, depth).then(function () {
          console.log("setJob: calling jobComplete");
          jobComplete(that, job);
        });
      } else {
        // The job is not yet complete, so subscribe to it with a
        // depth of 1. Once the job is complete, we'll resubscribe
        // to it and its children to the requested depth. We pass
        // a callback here, so we can get the change events.
        return subscribeJob(that, job, 1, function (p) {
          jobStateChanged(that, p);
        });
      }
    });
  };

  /**
   * Test for getData job completion.
   * @private
   */
  function isJobComplete(job) {
    return !baja.AbsTime.DEFAULT.equals(job.get('endTime'));
  }

  /**
   * Callback function used for receiving notifications of changes on the getData
   * job. This is used to listen for notification of the job completion, at which
   * point we will emit the 'jobcomplete' event.
   *
   * @private
   * @param mgr the manager instance
   * @param prop the property that has changed on the subscribed job.
   */
  function jobStateChanged(mgr, prop) {
    console.log("jobStateChanged: prop = " + prop);
    var job = mgr.$getDataJob;
    // If the end time has changed, we'll look to see whether the job is
    // now finished. If so, we'll emit the event on the manager. We'll
    // also re-subscribe to the requested depth provided in the setJob()
    // call. We'll previously have been subscribed at depth 1, but we can
    // now subscribe to the job's children.
    if (prop.getName() === 'endTime' && isJobComplete(job)) {
      unsubscribeJob(mgr).then(function () {
        return subscribeJob(mgr, job, mgr.$jobSubDepth);
      }).then(function () {
        console.log("jobStateChanged calling jobComplete");
        jobComplete(mgr, job);
      })["catch"](console.log("error") /*logError*/);
    }
  }

  /**
   * Function called when a job attached via `setJob()` has completed. This
   * will emit a 'jobcomplete' event to any registered handlers.
   *
   * @private
   * @param {module:nmodule/webEditors/rc/wb/mgr/MgrLearn} mgr
   * @param {baja.Component} job the completed job.
   */
  function jobComplete(mgr, job) {
    //var getDataCmd = mgr.$getDataCommand(),
    //    cancelCmd = mgr.$getCancelDataCommand();

    //if (getDataCmd) {
    //getDataCmd.setEnabled(true);
    //}

    //if (cancelCmd) {
    //cancelCmd.setEnabled(false);
    //}

    //This is the jobcomplete event
    console.log("jobComplete: emit the event to the manager");
    //mgr.emit('jobcomplete', job);

    mgr.$getDataJobComplete(job);
  }

  /**
   * Subscribe to the getData job that has been attached to the manager.
   * If the job has not yet completed, the depth parameter is expected to
   * be 1, to listen for changes to the job's properties. If the job is complete,
   * the depth will be the value specified during the call to setJob(), as at
   * that point we are in a position to be able to subscribe to the job's children,
   * if needed. There is an optional change callback parameter - this is used to get
   * our notification that the job has finished.
   *
   * @private
   * @param mgr
   * @param {baja.Component} job
   * @param {Number} depth
   * @param {Function} [changeCallback]
   * @returns {Promise}
   */
  function subscribeJob(mgr, job, depth, changeCallback) {
    var subscriber = new DepthSubscriber(depth);
    if (changeCallback) {
      subscriber.attach('changed', changeCallback);
    }
    mgr.$jobSubscriber = subscriber;
    return subscriber.subscribe(job);
  }
  /**
   * Unsubscribe from the job and remove the property on the manager.
   *
   * @private
   * @param mgr
   * @returns {Promise}
   */

  function unsubscribeJob(mgr) {
    var subscriber = mgr.$jobSubscriber;
    if (subscriber) {
      subscriber.detach();
      delete mgr.$jobSubscriber;
      return subscriber.unsubscribeAll();
    }
    return Promise.resolve();
  }

  /**
   * Called when the getData job completes, this will get the discovered
   * items from the job and reload the table.
   *
   * @private
   * @param {baja.Component} job - the getData job.
   */
  CustomTableView.prototype.$getDataJobComplete = function (job) {
    var that = this;
    console.log("getDataJobComplete");
    job.loadSlots().then(function () {
      if (job.isMounted()) {
        job.lease({
          comps: [job],
          time: baja.RelTime.make({
            minutes: 1
          })
        });
      }

      //Load Columns from job
      job.rpc("getColumns").then(function (columns) {
        var DEVICE_TYPE = baja.lt('nE2Link:NanoBaseComponent');
        that.$dataModel.then(function (dataModel) {
          var model = dataModel;
          var index = 0;
          _.each(columns.reverse(), function (c) {
            console.log(c);
            var column = new NanoPropertyColumn(c.slotName, c.slotCaption, {
              type: DEVICE_TYPE,
              flags: c.slotFlags,
              slotFormat: c.slotFormat,
              altSlotFormat: c.altSlotFormat,
              slotInfo: c.slotInfo
            });
            model.insertColumns([column], index).then(function () {
              console.log("inserted column " + index);
              index++;
            });
          });
        });
      }).then(function () {
        job.getResult().then(function (root) {
          console.log("job.getResult(): root " + root);
          root.loadSlots().then(function () {
            var props = root.getSlots().properties();
            that.$data = props.is('nE2Link:NanoBaseComponent').toValueArray();
            return reloadDataModel(that);
          });
        });
      });
    })["catch"](baja.error);
  };
  function reloadDataModel(mgr) {
    console.log("mgr.$dataModel = " + mgr.$dataModel);
    mgr.$dataModel.then(function (dataModel) {
      var model = dataModel;
      var currentCount = model.getRows().length,
        nodes,
        promise;
      nodes = _.map(mgr.$data || [], makeDataTableNode);
      promise = currentCount ? model.removeRows(0, currentCount) : Promise.resolve();
      console.log("nodes: " + nodes);
      console.log("columns: " + model.getColumns());
      return promise.then(function () {
        return model.insertRows(nodes, 0);
      });
    });
  }

  /**
   * Make a tree node for an item in the  table.
   *
   * @param  {Object} discovery - a discovered object.
   * @returns {module:nmodule/webEditors/rc/wb/tree/TreeNode}
   */
  function makeDataTableNode(item) {
    console.log("makeDataTableNode item type: " + _typeof(item));
    var name = String(item.getName()),
      node = new TreeNode(name, name);
    node.getIcon = _.constant(DATA_NODE_ICON);
    node.mayHaveKids = _.constant(true);
    node.value = _.constant(item);

    /*
    console.log("makeDataTableNode: node.name: " + String(item.getName()));
    console.log("makeDataTableNode: node.nanoName: " + String(item.get("nanoName")));
    console.log("makeDataTableNode: node.status: " + String(item.get("status")));
    console.log("makeDataTableNode: node.enabled: " + String(item.get("enabled")));
    */

    return node;
  }
  CustomTableView.prototype.doGetData = function () {
    var that = this,
      conf = baja.$('nE2Link:RetrieveGenericViewDataConfig');
    console.log("doGetData: that.$component: " + that.$component);
    return that.$component.submitGenericViewDataJob(conf).then(function (ord) {
      ord = baja.Ord.make({
        base: baja.Ord.make('station:'),
        child: ord.relativizeToSession()
      });
      return that.setJob(ord);
    });
  };

  /**
   * Save the state we require for restoring after a hyperlink or page reload.
   * In addition to the visible columns saved by the base type, this will save
   * the last set of discovered devices and the ord of any job we may be displaying
   * in the job bar.
   *
   * @returns {Object} an object with the state to be persisted
   */
  CustomTableView.prototype.saveStateForOrd = function () {
    var that = this,
      obj = {};
    /*
    if (that.$data) {
      obj.$data = _.map(that.$data, function (discovery) {
        return baja.bson.encodeValue(discovery);
      });
    }
    */
    return obj;
  };

  /**
   * Restore the state we saved in the call to saveStateForOrd(). This
   * will reinstate the learn model from any BDiscoveryDevice instances
   * we persisted.
   *
   * @param {Object} obj - an object with data retrieved from the browser storage.
   * @returns {Promise.<*>}
   */
  CustomTableView.prototype.restoreStateForOrd = function (obj) {
    /*
    if (obj.$data) {
      this.$data = _.map(obj.$data, function (items) {
        return baja.bson.decodeValue(items);
      });
      return reloadDataModel(this);
    } else {
      return Promise.resolve();
    }
    */
  };
  return CustomTableView;
});
