/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.wiresheet;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.ui.agents.BContextMenuAgent;
import com.ismacontrolli.nE2Link.ui.commands.NanoPasteCommand;
import com.ismacontrolli.nE2Link.ui.commands.NanoReorderCommand;
import com.ismacontrolli.nE2Link.ui.wiresheet.BWireSheet;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsCanvas;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.WsController;
import javax.baja.gx.Point;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.commands.CopyCommand;
import javax.baja.ui.commands.CutCommand;
import javax.baja.ui.commands.DeleteCommand;
import javax.baja.ui.commands.DuplicateCommand;
import javax.baja.ui.commands.RenameCommand;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.util.BWsAnnotation;

public class NanoWsController
extends WsController {
    public NanoWsController(BWireSheetPane ws) {
        super(ws);
        BWsOptions.make().setMaxHeight(255);
        BWsOptions.make().setMaxWidth(255);
    }

    public void doBackgroundPopup(double mx, double my) {
        BNanoBaseComponent baseComponent;
        this.dropPoint = new Point(mx, my);
        BMenu menu = new BMenu();
        int p = (int)(mx / (double)this.ws.grid.wixel);
        int q = (int)(my / (double)this.ws.grid.wixel);
        BWsAnnotation anno = BWsAnnotation.make((int)p, (int)q);
        BWsCanvas canvas = this.ws.getCanvas();
        BWireSheet ws = this.getWireSheet(this.ws);
        BNanoBaseComponent bNanoBaseComponent = baseComponent = null != ws ? (BNanoBaseComponent)ws.getCurrentValue() : null;
        if (null != baseComponent) {
            BContextMenuAgent.handleAddMenu(menu, (BWidget)this.ws, (BObject)this.container, anno);
            menu.add("sep0", (BValue)new BSeparator());
            if (baseComponent.isMoveSupported()) {
                menu.add("cut", (Command)new CutCommand((BTransferWidget)canvas));
            }
            menu.add("copy", (Command)new CopyCommand((BTransferWidget)canvas));
            menu.add("paste", (Command)new NanoPasteCommand((BTransferWidget)canvas));
            menu.add("duplicate", (Command)new DuplicateCommand((BTransferWidget)canvas));
            menu.add("sep1", (BValue)new BSeparator());
            menu.add("delete", (Command)new DeleteCommand((BTransferWidget)canvas));
            if (BWsOptions.make().getShowRelations() || BWsOptions.make().getShowLinks()) {
                menu.add("deleteRelationss", (Command)this.ws.commands.deleteRelations);
            }
            menu.add("rename", (Command)new RenameCommand((BTransferWidget)canvas));
            menu.add("sep2", (BValue)new BSeparator());
            if (this.addLinkSelection(menu, p, q)) {
                menu.add("sepLinkSep1", (BValue)new BSeparator());
            }
            menu.add("arrange", (Command)this.ws.commands.arrange);
            menu.add("selectAll", (Command)this.ws.commands.selectAll);
            if (baseComponent.isReorderSupported()) {
                menu.add("sep3", (BValue)new BSeparator());
                menu.add("reorder", (Command)new NanoReorderCommand((BWidget)this.ws, this.container));
            }
        }
        if ((menu = this.ws.getView().makeBackgroundPopup(menu)) != null) {
            menu.removeConsecutiveSeparators();
            menu.open((BWidget)canvas, mx, my);
        }
    }

    private BWireSheet getWireSheet(BWireSheetPane ws) {
        BComplex parent;
        for (parent = ws.getParent(); null != parent && !(parent instanceof BWireSheet); parent = parent.getParent()) {
        }
        return null != parent ? (BWireSheet)parent : null;
    }
}

