/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.viewManagers;

import com.ismacontrolli.nE2Link.jobs.BDiscoveredNanoObject;
import com.ismacontrolli.nE2Link.jobs.BDiscoveredNanoObjects;
import com.ismacontrolli.nE2Link.jobs.BNanoDiscoverJob;
import com.ismacontrolli.nE2Link.ui.viewManagers.BDeviceDiscoverManager;
import com.ismacontrolli.nE2Link.ui.viewManagers.BNanoLearnTable;
import com.ismacontrolli.nE2Link.ui.viewManagers.BSharedManager;
import com.tridium.workbench.job.BJobBar;
import javax.baja.job.BJob;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class NanoBacnetDeviceLearn
extends MgrLearn {
    BDeviceDiscoverManager mgr;
    protected boolean jobComplete;
    MgrColumn deviceName = new BSharedManager.NanoPropColumn("DeviceName", "DEVICENAME", "toString", 4);
    MgrColumn deviceId = new BSharedManager.NanoPropColumn("DeviceId", "DEVICEID", "toString", 4);
    MgrColumn deviceAddress = new BSharedManager.NanoPropColumn("Address", "ADDRESS", "toString", 4);
    MgrColumn deviceVendor = new BSharedManager.NanoPropColumn("Vendor", "VENDOR", "toString", 4);
    MgrColumn deviceModel = new BSharedManager.NanoPropColumn("Model", "MODEL", "toString", 4);
    MgrColumn[] dcols = new MgrColumn[]{this.deviceName, this.deviceId, this.deviceAddress, this.deviceVendor, this.deviceModel};

    public NanoBacnetDeviceLearn(BDeviceDiscoverManager mgr) {
        super((BAbstractManager)mgr);
        this.mgr = mgr;
    }

    protected final BWidget makeJobBar() {
        return new BJobBar();
    }

    protected MgrColumn[] makeColumns() {
        return this.dcols;
    }

    public void setColumns(MgrColumn[] columns) {
        this.dcols = columns;
    }

    public boolean isMatchable(Object discovery, BComponent database) {
        try {
            MgrTypeInfo[] types = this.toTypes(discovery);
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].isMatchable(database)) continue;
                return true;
            }
            return false;
        }
        catch (Exception var5) {
            var5.printStackTrace();
            return false;
        }
    }

    public MgrTypeInfo[] toTypes(Object o) throws Exception {
        TypeInfo[] typeInfos = new TypeInfo[]{BDiscoveredNanoObject.TYPE.getTypeInfo()};
        return MgrTypeInfo.makeArray((TypeInfo[])typeInfos);
    }

    public boolean isExisting(Object dis, BComponent comp) {
        return false;
    }

    public void toRow(Object dis, MgrEditRow row) throws Exception {
        BDiscoveredNanoObject object = (BDiscoveredNanoObject)dis;
        BDeviceDiscoverManager.DiscoverModel model = (BDeviceDiscoverManager.DiscoverModel)this.mgr.getModel();
        row.setCell((MgrColumn)model.name, object.get("DEVICENAME"));
    }

    public void jobComplete(BJob job) {
        super.jobComplete(job);
        Type jobType = job.getType();
        if (job instanceof BNanoDiscoverJob) {
            this.updateLearnColumns();
            this.updateLearnData();
        }
    }

    void updateLearnData() {
        BDiscoveredNanoObjects discoveredNanoObjects;
        BNanoDiscoverJob learnJob = (BNanoDiscoverJob)this.mgr.getLearn().getJob();
        if (learnJob != null && (discoveredNanoObjects = learnJob.getDiscoveredObjects()) != null) {
            Object[] objs = new BDiscoveredNanoObject[discoveredNanoObjects.length()];
            for (int i = 0; i < discoveredNanoObjects.length(); ++i) {
                objs[i] = discoveredNanoObjects.getItem(i);
            }
            this.mgr.getLearn().updateRoots(objs);
        }
    }

    void updateLearnColumns() {
        this.mgr.getLearn().updateTable();
        this.mgr.getLearn().init();
    }

    protected BLearnTable makeTable() {
        return new BNanoLearnTable(this);
    }

    public final int getColumnIndex(MgrColumn col) {
        MgrColumn[] cols = this.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (col != cols[i]) continue;
            return i;
        }
        throw new IllegalArgumentException("MgrColumn not found in getColumns()");
    }
}

