/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.viewManagers;

import com.ismacontrolli.nE2Link.BNanoApplication;
import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoComponent;
import com.ismacontrolli.nE2Link.BNanoContainer;
import com.ismacontrolli.nE2Link.BNanoEquipment;
import com.ismacontrolli.nE2Link.BNanoExtension;
import com.ismacontrolli.nE2Link.BNanoFolder;
import com.ismacontrolli.nE2Link.ui.viewManagers.BConfigurationDataServiceManager;
import com.ismacontrolli.nE2Link.ui.viewManagers.BSharedManager;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.component.table.ComponentTableModel;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.folder.FolderController;

@NiagaraType(agent={@AgentOn(types={"nE2Link:NanoComponent"}, defaultAgent=AgentOn.Preference.PREFERRED)})
public class BTrendsManager
extends BSharedManager {
    public static final Type TYPE = Sys.loadType(BTrendsManager.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BTrendsManager() {
        this.typeIdsList = new ArrayList();
        typeNanoNameForAdd = new String[0];
    }

    @Override
    protected MgrModel makeModel() {
        return new TrendsModel(this);
    }

    @Override
    protected MgrController makeController() {
        return new TrendController((BPointManager)this);
    }

    class TrendsModel
    extends BSharedManager.PointModel {
        HashMap<BComponent, BComponent> subscription;

        public TrendsModel(BTrendsManager manager) {
            super(manager);
            this.subscription = new HashMap();
            this.pointFolderType = BNanoContainer.TYPE;
        }

        @Override
        public Type[] getIncludeTypes() {
            return new Type[]{BNanoBaseComponent.TYPE, BNanoEquipment.TYPE, BNanoApplication.TYPE};
        }

        @Override
        protected String makeTableTitle() {
            return TYPE.getDisplayName((Context)null);
        }

        @Override
        public boolean accept(BComponent component) {
            return true;
        }

        @Override
        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new BSharedManager.NanoPropColumn("Name", "nanoName", "valueValueToString, valueToString, toString", 1, true), new BSharedManager.NanoPropColumn("Trend Name", "trendName", "valueToString", "Library\\.Trends\\.Trend", 4), new BSharedManager.NanoPropColumn("Status", "trendStatus", "valueValueToString, valueToString", "Library\\.Trends\\.Trend", 4), new BSharedManager.NanoPropColumn("Enabled", "enabled", "valueToString", "Library\\.Trends\\.Trend", 1), new BSharedManager.NanoPropColumn("Sampling Mode", "samplingMode", "valueValueToString, valueToString, toString", "Library\\.Trends\\.Trend", 1), new BSharedManager.NanoPropColumn("Expose on Bacnet", "expose", "valueToString", "Library\\.BACnet\\.BacnetTrendLog", 1), new BSharedManager.NanoPropColumn("Bacnet Object id", "objectId", "valueToString", "Library\\.BACnet\\.BacnetTrendLog", 4), new BSharedManager.NanoPropColumn("Stop When Full", "stopWhenFull", "valueToString", "Library\\.Trends\\.Trend", 1), new BSharedManager.NanoPropColumn("Sampling Interval", "samplingInterval", "valueToString", "Library\\.Trends\\.Trend", 3), new BSharedManager.NanoPropColumn("Deadband", "deadband", "valueToString", "Library\\.Trends\\.Trend", 3)};
        }

        @Override
        public void load(BComponent target) {
            BNanoBaseComponent baseComponent;
            Array accepted = new Array(BComponent.class);
            ComponentTableModel table = this.getTable().getComponentModel();
            this.getTable().setCellRenderer((TableCellRenderer)new BConfigurationDataServiceManager.ServiceCellRenderer(this.getManager()));
            ((FolderController)this.getManager().getController()).allDescendants.setSelected(true);
            if (!(target instanceof BNanoEquipment)) {
                baseComponent = (BNanoBaseComponent)((BNanoBaseComponent)target).getNe2DeviceExt().getNanoComponentByName(BString.make((String)"Applications"));
                baseComponent = (BNanoBaseComponent)baseComponent.getOrdInSpace().get(this.getManager().getCurrentValue());
            } else {
                this.pointFolderType = BNanoEquipment.TYPE;
                baseComponent = (BNanoBaseComponent)target;
            }
            BComponent[] rowsTable = this.resolveDeep((BComponent)baseComponent);
            for (int i = 0; i < rowsTable.length; ++i) {
                if (!this.accept(rowsTable[i]) || !rowsTable[i].getPermissions(this.getManager().getCurrentContext()).hasOperatorRead()) continue;
                accepted.add((Object)rowsTable[i]);
            }
            rowsTable = (BComponent[])accepted.trim();
            this.subscribe(rowsTable, (BComponent)baseComponent);
            this.getTable().getSelection().deselectAll();
            table.setRows(rowsTable);
        }

        @Override
        protected boolean isGoodComponent(BNanoBaseComponent temp) {
            if (temp instanceof BNanoApplication) {
                return true;
            }
            if (temp instanceof BNanoEquipment) {
                return true;
            }
            if (temp instanceof BNanoComponent) {
                BComponent[] extensions = temp.getChildComponents();
                for (int i = 0; i < extensions.length; ++i) {
                    if (!extensions[i].getName().contains("Trend")) continue;
                    return true;
                }
                return false;
            }
            return super.isGoodComponent(temp);
        }

        private BComponent[] resolveDeep(BComponent target) {
            String bql = "bql:select slotPath from ";
            for (int i = 0; i < this.getIncludeTypes().length; ++i) {
                if (i > 0) {
                    bql = bql + ", ";
                }
                bql = bql + this.getIncludeTypes()[i];
            }
            BITable result = (BITable)BOrd.make((String)bql).get((BObject)target);
            try (TableCursor cursor = result.cursor();){
                BComponent[] res;
                ArrayList<BOrd> ords = new ArrayList<BOrd>();
                Column colPath = result.getColumns().get(0);
                int skipCounter = 0;
                boolean lock = false;
                while (cursor.next()) {
                    BOrd ord = BOrd.make((String)cursor.cell(colPath).toString());
                    try {
                        BNanoBaseComponent temp = (BNanoBaseComponent)ord.resolve((BObject)target).getComponent();
                        if (temp instanceof BNanoExtension) continue;
                        if (skipCounter == 0) {
                            if (temp instanceof BNanoEquipment) {
                                skipCounter = ((BNanoBaseComponent[])temp.getChildren(BNanoBaseComponent.class)).length + 1;
                                lock = true;
                            }
                            if (!this.isGoodComponent(temp)) continue;
                            ords.add(ord);
                        }
                        if (skipCounter <= 0) continue;
                        if (!lock && (temp instanceof BNanoFolder || temp instanceof BNanoEquipment)) {
                            skipCounter += ((BNanoBaseComponent[])temp.getChildren(BNanoBaseComponent.class)).length;
                        }
                        --skipCounter;
                        lock = false;
                    }
                    catch (Exception exception) {}
                }
                BComponent[] bComponentArray = res = new BatchResolve(ords.toArray(new BOrd[ords.size()])).resolve((BObject)target).getTargetComponents();
                return bComponentArray;
            }
        }

        private void subscribe(BComponent[] rows, BComponent target) {
            BAbstractManager mgr = this.getManager();
            Array list = new Array(BComponent.class);
            if (this.subscription.get(target) == null && target != null) {
                list.add((Object)target);
                this.subscription.put(target, target);
            }
            for (int i = 0; i < rows.length; ++i) {
                BComponent p = (BComponent)rows[i].getParent();
                if (this.subscription.get(p) != null || p == null) continue;
                list.add((Object)p);
                this.subscription.put(p, p);
            }
            if (list.size() != 0) {
                BComponent[] toSub = (BComponent[])list.trim();
                int depth = this.getSubscribeDepth();
                mgr.registerForComponentEvents(toSub, depth);
            }
        }
    }

    class TrendController
    extends BSharedManager.PointController {
        public final MgrController.MgrCommand clearTrendsData;

        public TrendController(BPointManager manager) {
            super(manager);
            this.newCommand.setFlags(0);
            this.clearTrendsData = new MgrController.MgrCommand((BWidget)manager, "Clear Data Trends");
        }

        @Override
        public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
            BComponent component = table.getComponentAt(row);
            BWbShell shell = table.getManager().getWbShell();
            if (shell != null) {
                if (component instanceof BNanoEquipment) {
                    table.getManager().getModel().load(component);
                } else if (!(component instanceof BNanoApplication)) {
                    shell.hyperlink(new HyperlinkInfo(component.getNavOrd(), (BInputEvent)event));
                }
            }
        }
    }
}

