/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.viewManagers;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoComponent;
import com.ismacontrolli.nE2Link.BNanoContainer;
import com.ismacontrolli.nE2Link.BNanoEquipment;
import com.ismacontrolli.nE2Link.BNanoFolder;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.actions.BNanoPropertyChangedArg;
import com.ismacontrolli.nE2Link.jobs.BDiscoveredNanoObject;
import com.ismacontrolli.nE2Link.jobs.BNanoDiscoverJob;
import com.ismacontrolli.nE2Link.ui.fieldEditors.BNumericJsonListFE;
import com.tridium.workbench.fieldeditors.BStringFE;
import com.tridium.workbench.fieldeditors.BStringMgrColFE;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.baja.data.BIDataValue;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.Mark;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BMenu;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.component.table.BComponentTable;
import javax.baja.workbench.component.table.ComponentTableCellRenderer;
import javax.baja.workbench.component.table.ComponentTableSubject;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTagDictionary;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;
import javax.baja.workbench.mgr.folder.FolderModel;
import javax.baja.workbench.mgr.folder.FolderState;

@NiagaraType
public class BSharedManager
extends BPointManager {
    public static final Type TYPE = Sys.loadType(BSharedManager.class);
    protected static String[] typeNanoNameForAdd;
    protected List<Integer> typeIdsList = new ArrayList<Integer>();

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new PointModel(this);
    }

    protected MgrController makeController() {
        return new PointController(this);
    }

    protected MgrState makeState() {
        return new PointState();
    }

    protected MgrTagDictionary makeTagDictionary() {
        return null;
    }

    public Type getTargetType() {
        return BNanoBaseComponent.TYPE;
    }

    protected void selectMatchingTag(int learnRow) {
    }

    private static String formatString(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder formatted = new StringBuilder();
        formatted.append(Character.toUpperCase(input.charAt(0)));
        for (int i = 1; i < input.length(); ++i) {
            char currentChar = input.charAt(i);
            if (Character.isUpperCase(currentChar)) {
                formatted.append(" ");
            }
            formatted.append(currentChar);
        }
        return formatted.toString();
    }

    class NanoExtCol
    extends MgrColumn {
        BImage columnIcon;
        TableCellRenderer renderer;

        public NanoExtCol(String displayName, int flags) {
            super(displayName, flags);
            this.columnIcon = BImage.make((String)"module://icons/x16/navOnly/points.png");
            this.renderer = new NanoExtCellRenderer();
        }

        public NanoExtCol(String displayName, int flags, BImage columnIcon) {
            super(displayName, flags, columnIcon);
            this.columnIcon = BImage.make((String)"module://icons/x16/navOnly/points.png");
            this.renderer = new NanoExtCellRenderer();
        }

        public Object get(Object row) {
            return BString.make((String)"");
        }

        public TableCellRenderer getCellRenderer() {
            return this.renderer;
        }

        class NanoExtCellRenderer
        extends ComponentTableCellRenderer {
            NanoExtCellRenderer() {
            }

            public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
                this.paintCellBackground(g, cell);
                g.drawImage(NanoExtCol.this.columnIcon, 4.0, (cell.height - 16.0) / 2.0);
            }

            protected BComponentTable getComponentTable() {
                return NanoExtCol.this.getManager().getModel().getTable();
            }
        }
    }

    class NanoPointMgrColumnProp
    extends MgrColumn.Prop {
        boolean singleEdit;
        String slotName;
        boolean wasSet;

        NanoPointMgrColumnProp(Property[] props, int flags) {
            super(props[0], flags);
            this.singleEdit = false;
            this.wasSet = false;
            this.props = props;
        }

        NanoPointMgrColumnProp(String name, Property[] props, int flags) {
            super(BSharedManager.formatString(name), props[0], flags);
            this.singleEdit = false;
            this.wasSet = false;
            this.slotName = name;
            this.props = props;
        }

        NanoPointMgrColumnProp(String name, Property[] props, int flags, boolean singleEdit) {
            super(BSharedManager.formatString(name), props[0], flags);
            this.singleEdit = false;
            this.wasSet = false;
            this.slotName = name;
            this.props = props;
            this.singleEdit = singleEdit;
        }

        NanoPointMgrColumnProp(String slotName, String name, Property[] props, int flags, boolean singleEdit) {
            super(name, props[0], flags);
            this.singleEdit = false;
            this.wasSet = false;
            this.slotName = slotName;
            this.props = props;
            this.singleEdit = singleEdit;
        }

        boolean updatePropAndCheckProp(BComplex nanoComponent) {
            return nanoComponent.get(this.slotName) != null;
        }

        public Object get(Object row) {
            BNanoBaseComponent nanoComponent = (BNanoBaseComponent)row;
            if (!this.wasSet && row instanceof BNanoBaseComponent && this.updatePropAndCheckProp((BComplex)row)) {
                Property[] list = new Property[]{((BNanoBaseComponent)row).getProperty(this.slotName)};
                this.props = list;
                this.prop = list[0];
                this.wasSet = true;
            }
            if (this.updatePropAndCheckProp((BComplex)nanoComponent)) {
                return ((BNanoBaseComponent)row).get(this.prop.getName()).newCopy().toString().split("\\{|,00")[0];
            }
            return BString.make((String)"");
        }

        public BValue load(MgrEditRow row) {
            if (this.updatePropAndCheckProp((BComplex)row.getTarget())) {
                return ((BNanoBaseComponent)row.getTarget()).get(this.prop.getName()).newCopy();
            }
            return BString.make((String)"");
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            currentEditor = null;
            if (!this.updatePropAndCheckProp((BComplex)rows[0].getTarget())) {
                return null;
            }
            if (rows[0].getTarget().toString().contains("Library")) {
                return null;
            }
            return super.toEditor(rows, colIndex, currentEditor);
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BComponent target = row.getTarget();
            if (value == null) {
                return;
            }
            if (this.updatePropAndCheckProp((BComplex)row.getTarget())) {
                BValue old = target.get(this.prop).newCopy();
                BValue newVal = value.newCopy();
                BNe2DeviceExt controller = ((BNanoBaseComponent)target).getNe2DeviceExt();
                if (!old.equivalent((Object)newVal) && cx != null) {
                    BNanoPropertyChangedArg changedArg = new BNanoPropertyChangedArg((BNanoBaseComponent)target, this.prop, old, newVal, BSharedManager.this.getCurrentContext());
                    controller.handleNanoPropertyValueChange(changedArg);
                }
            }
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            if (!this.wasSet && row instanceof BNanoBaseComponent && this.updatePropAndCheckProp((BComplex)row)) {
                Property[] list = new Property[]{((BNanoBaseComponent)row).getProperty(this.slotName)};
                this.props = list;
                this.prop = list[0];
                this.wasSet = true;
            }
            try {
                BNanoBaseComponent nanoComponent = (BNanoBaseComponent)row;
                BValue res = nanoComponent.get(this.slotName);
                if (res instanceof BStatusEnum) {
                    String[] k = res.toString().split(" ");
                    String[] facets = nanoComponent.getProperty(this.slotName.toLowerCase()).getFacets().get("nano_attr_range").toString().split(",");
                    return facets[Integer.parseInt(k[0])];
                }
                return res.toString().split("\\{|,00")[0];
            }
            catch (Exception ex) {
                return "";
            }
        }
    }

    static class NanoPropColumn
    extends MgrColumn {
        private static String SLOT_CAPTION_FORMAT_LEX_KEY = "CustomTableView.%s.slotCaption%s";
        private static Lexicon LEX = Lexicon.make(BSharedManager.class);
        private static String DEFAULT_ICON = "module://nE2Link/rc/icons/mgr/object.png";
        String slotName;
        BFormat[] slotValueFormats;
        String extTypeRegEx;
        boolean hideEditor = false;

        NanoPropColumn(String slotCaption, String slotName, String slotInfo, int flags) {
            this(slotCaption, slotName, slotInfo, null, flags, BImage.make((String)DEFAULT_ICON));
        }

        NanoPropColumn(String slotCaption, String slotName, String slotInfo, int flags, boolean hideEditor) {
            this(slotCaption, slotName, slotInfo, null, flags, BImage.make((String)DEFAULT_ICON));
            this.hideEditor = hideEditor;
        }

        NanoPropColumn(String slotCaption, String slotName, String slotInfo, int flags, BImage colIcon) {
            this(slotCaption, slotName, slotInfo, null, flags, colIcon);
        }

        NanoPropColumn(String slotCaption, String slotName, String slotInfo, String extTypeRegEx, int flags) {
            this(slotCaption, slotName, slotInfo, extTypeRegEx, flags, BImage.make((String)DEFAULT_ICON));
        }

        NanoPropColumn(String slotCaption, String slotName, String slotInfo, String extTypeRegEx, int flags, BImage colIcon) {
            super(slotCaption, flags, colIcon);
            this.slotName = slotName;
            this.extTypeRegEx = extTypeRegEx;
            if (slotInfo != null && !slotInfo.isEmpty()) {
                String[] slotPaths = slotInfo.split(",");
                this.slotValueFormats = new BFormat[slotPaths.length];
                for (int i = 0; i < slotPaths.length; ++i) {
                    this.slotValueFormats[i] = BFormat.make((String)("%" + slotName + "." + slotPaths[i].trim() + "%"));
                }
            } else {
                this.slotValueFormats = new BFormat[]{BFormat.make((String)("%" + slotName + "%"))};
            }
        }

        public String getDisplayName() {
            String slotCaption = super.getDisplayName();
            return LEX.get(String.format(SLOT_CAPTION_FORMAT_LEX_KEY, SlotPath.escape((String)"SharedManagerView"), SlotPath.escape((String)slotCaption)), slotCaption);
        }

        public Object get(Object rowObject) {
            String effectiveSlotNameOnHost = this.getEffectiveSlotName(rowObject);
            return effectiveSlotNameOnHost != null ? ((BComplex)rowObject).get(effectiveSlotNameOnHost) : null;
        }

        public String toDisplayString(Object rowObject, Object value, Context cx) {
            String displayString = "--";
            if (value == null) {
                return displayString;
            }
            String effectiveSlotName = this.getEffectiveSlotName(rowObject);
            if (effectiveSlotName == null) {
                return displayString;
            }
            BFacets facets = null;
            if (value instanceof BStatusValue) {
                facets = ((BStatusValue)value).getStatusValueFacets();
            } else if (rowObject instanceof BComplex) {
                facets = ((BComplex)rowObject).getProperty(effectiveSlotName).getFacets();
            }
            if (facets != null) {
                cx = new BasicContext(cx, facets);
            }
            if (value instanceof BStatusBoolean && ((BStatusBoolean)value).getStatus().equals((Object)BStatus.nullStatus)) {
                return "null";
            }
            if (value instanceof BStatusString && ((BStatusString)value).getStatus().isNull()) {
                return "null";
            }
            for (BFormat slotFormat : this.slotValueFormats) {
                String resolvedFormat;
                if (!this.slotName.equals(effectiveSlotName)) {
                    String formatStr = slotFormat.getFormat();
                    slotFormat = BFormat.make((String)formatStr.replace(this.slotName, effectiveSlotName));
                }
                if ((resolvedFormat = slotFormat.format(rowObject, cx)).startsWith("%err:")) continue;
                displayString = resolvedFormat;
                break;
            }
            return displayString;
        }

        public String toDisplayStringLearn(Object rowObject, Object value, Context cx) {
            String displayString = "--";
            String effectiveSlotName = this.getEffectiveSlotName(rowObject);
            if (effectiveSlotName == null) {
                return displayString;
            }
            BDiscoveredNanoObject row = (BDiscoveredNanoObject)rowObject;
            value = row.get(effectiveSlotName);
            BFacets facets = null;
            if (value instanceof BStatusValue) {
                facets = ((BStatusValue)value).getStatusValueFacets();
            } else if (rowObject instanceof BComplex) {
                facets = ((BComplex)rowObject).getProperty(effectiveSlotName).getFacets();
            }
            if (facets != null) {
                cx = new BasicContext(cx, facets);
            }
            for (BFormat slotFormat : this.slotValueFormats) {
                String resolvedFormat;
                if (!this.slotName.equals(effectiveSlotName)) {
                    String formatStr = slotFormat.getFormat();
                    slotFormat = BFormat.make((String)formatStr.replace(this.slotName, effectiveSlotName));
                }
                if ((resolvedFormat = slotFormat.format(rowObject, cx)).startsWith("%err:")) continue;
                displayString = resolvedFormat;
                break;
            }
            return displayString;
        }

        protected String getEffectiveSlotName(Object rowObject) {
            if (this.extTypeRegEx == null || this.extTypeRegEx.isEmpty()) {
                return this.slotName;
            }
            if (rowObject instanceof BNanoBaseComponent) {
                return ((BNanoBaseComponent)rowObject).getHostNameForExtensionSlot(this.extTypeRegEx, this.slotName);
            }
            return null;
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) throws Exception {
            BWbFieldEditor editor;
            String readonly;
            if (this.hideEditor) {
                return null;
            }
            BComponent firstRowObject = rows[0].getTarget();
            String effectiveSlotName = this.getEffectiveSlotName(firstRowObject);
            BValue val = rows[0].getCell(colIndex);
            if (firstRowObject.get(effectiveSlotName) == null || !(firstRowObject instanceof BNanoBaseComponent)) {
                return null;
            }
            BNanoBaseComponent nanoBaseComponent = (BNanoBaseComponent)firstRowObject;
            BFacets slotFacets = nanoBaseComponent.getSlot(effectiveSlotName).getFacets();
            String visibility = slotFacets.get("nano_attr_visibility") == null ? "" : slotFacets.get("nano_attr_visibility").toString();
            String string = readonly = slotFacets.get("nano_attr_readonly") == null ? "" : slotFacets.get("nano_attr_readonly").toString();
            if (!nanoBaseComponent.getInitComplete() || visibility.equals("nowhere") || readonly.equals("true")) {
                return null;
            }
            for (int i = 1; i < rows.length; ++i) {
                BValue cellVal = rows[i].getCell(colIndex);
                if (cellVal == null || cellVal.getClass() == val.getClass()) continue;
                return null;
            }
            BFacets facets = BFacets.make((String)"suppressWrite", (BIDataValue)BBoolean.TRUE);
            Property propInTarget = firstRowObject.getProperty(effectiveSlotName);
            if (rows.length == 1) {
                if (propInTarget != null) {
                    facets = BFacets.make((BFacets)firstRowObject.getSlotFacets((Slot)propInTarget), (BFacets)facets);
                }
            } else {
                facets = BFacets.make((BFacets)propInTarget.getFacets(), (BFacets)facets);
            }
            Context cx = rows[0].getManager().getCurrentContext();
            if (!facets.isNull()) {
                cx = new BasicContext(cx, facets);
            }
            if ((editor = BWbFieldEditor.makeFor((BObject)val, (Context)cx)) instanceof BStringFE) {
                editor = new BStringMgrColFE(colIndex);
            }
            if (currentEditor != null && currentEditor.getClass() == editor.getClass()) {
                editor = (BWbFieldEditor)currentEditor;
            }
            if (editor instanceof BNumericJsonListFE) {
                cx = new BasicContext(cx, BFacets.make((String)"feFallbackValueType", (BIDataValue)BString.make((String)((BNanoBaseComponent)firstRowObject).getOriginNameFromLibrary()), (String)"feFallbackPropertyName", (BIDataValue)BString.make((String)effectiveSlotName)));
                ((BNumericJsonListFE)editor).setValueSession(firstRowObject.getSession());
            }
            editor.loadValue((BObject)val, cx);
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            BValue val = (BValue)editor.saveValue();
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, val);
            }
        }

        public BValue load(MgrEditRow row) throws Exception {
            BComponent rowObject = row.getTarget();
            String slotNameOnHost = this.getEffectiveSlotName(rowObject);
            Property targetProperty = slotNameOnHost != null ? rowObject.getProperty(slotNameOnHost) : null;
            return targetProperty != null ? rowObject.get(slotNameOnHost).newCopy() : null;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            if (value == null) {
                return;
            }
            BComponent target = row.getTarget();
            String slotNameOnHost = this.getEffectiveSlotName(target);
            if (slotNameOnHost == null) {
                return;
            }
            Property propInTarget = target.getProperty(slotNameOnHost);
            if (propInTarget == null) {
                return;
            }
            BValue oldVal = target.get(slotNameOnHost).newCopy();
            BValue newVal = value.newCopy();
            if (oldVal == null) {
                return;
            }
            if (!oldVal.equivalent((Object)newVal)) {
                if (target instanceof BNanoBaseComponent && ((BNanoBaseComponent)target).isNanoSlot((Slot)propInTarget)) {
                    BNe2DeviceExt ne2DeviceExt = ((BNanoBaseComponent)target).getNe2DeviceExt();
                    BNanoPropertyChangedArg changedArg = new BNanoPropertyChangedArg((BNanoBaseComponent)target, propInTarget, oldVal, newVal, cx);
                    ne2DeviceExt.handleNanoPropertyValueChange(changedArg);
                } else {
                    target.set(propInTarget, newVal, cx);
                }
            }
        }
    }

    class NanoConDataSerMgrColumnString
    extends MgrColumn.ToString {
        protected NanoConDataSerMgrColumnString(String displayName, int flags) {
            super(displayName, flags);
        }

        public Object get(Object row) {
            if (row instanceof BNanoComponent && !(row instanceof BNanoEquipment)) {
                BComponent[] checkExtensions;
                BValue tmpSlot = ((BComponent)row).get(this.getDisplayName());
                for (BComponent ext : checkExtensions = ((BComponent)row).getChildComponents()) {
                    if (!ext.toString().contains("ConfigurationData")) continue;
                    return BString.make((String)"Yes");
                }
                return BString.make((String)"N/A");
            }
            return BString.make((String)"");
        }
    }

    class NanoPointMgrColumnString
    extends MgrColumn.ToString {
        protected NanoPointMgrColumnString(String displayName, int flags) {
            super(displayName, flags);
        }

        public Object get(Object row) {
            if (row instanceof BNanoBaseComponent) {
                BValue tmpSlot = ((BComponent)row).get(this.getDisplayName());
                if (tmpSlot instanceof BStatusEnum) {
                    List<String> list = Arrays.asList(((BComponent)row).getProperty("status").getFacets().get("nano_attr_range").toString().split(","));
                    return list.get(Integer.parseInt(tmpSlot.toString().split(" ")[0]));
                }
                return ((BComponent)row).get(this.getDisplayName());
            }
            return BString.make((String)"");
        }
    }

    class PointState
    extends FolderState {
    }

    class PointType {
        protected MgrTypeInfo mgrTypeInfo;
        protected String name;

        PointType(MgrTypeInfo mgrTypeInfo, String name) {
            this.mgrTypeInfo = mgrTypeInfo;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public MgrTypeInfo getMgrTypeInfo() {
            return this.mgrTypeInfo;
        }
    }

    class PointModel
    extends FolderModel {
        protected int selectedIndex;
        Type pointFolderType;
        Type[] pointFolderTypes;

        public PointModel(BSharedManager manager) {
            super((BFolderManager)manager);
            this.selectedIndex = -1;
            this.pointFolderType = BNanoContainer.TYPE;
            this.pointFolderTypes = new Type[]{BNanoContainer.TYPE, BNanoEquipment.TYPE};
        }

        public boolean accept(BComponent component) {
            BNanoBaseComponent nanoComponent = (BNanoBaseComponent)component;
            int type = nanoComponent.getTypeId();
            for (int i = 0; i < BSharedManager.this.typeIdsList.size(); ++i) {
                if (type != BSharedManager.this.typeIdsList.get(i)) continue;
                return true;
            }
            return false;
        }

        protected boolean isGoodComponent(BNanoBaseComponent temp) {
            return !(temp instanceof BNanoFolder);
        }

        protected String makeTableTitle() {
            return TYPE.getDisplayName((Context)null);
        }

        public Type getFolderType() {
            return this.pointFolderType;
        }

        public Type[] getFolderTypes() {
            return this.pointFolderTypes;
        }

        public Type getBaseNewType() {
            return BNanoBaseComponent.TYPE;
        }

        public int getSubscribeDepth() {
            return 2;
        }

        public int getSelectedIndex() {
            return this.selectedIndex;
        }

        public void setSelectedIndex(int selectedIndex) {
            this.selectedIndex = selectedIndex;
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Name(), new NanoPointMgrColumnProp("status", new Property[]{BStatusEnum.value}, 4, true)};
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BNanoBaseComponent.TYPE, BNanoEquipment.TYPE};
        }

        public void load(BComponent target) {
            super.load(target);
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BNanoBaseComponent pt = null;
            BNe2DeviceExt controller = ((BNanoBaseComponent)this.getTarget()).getNe2DeviceExt();
            pt = (BNanoBaseComponent)controller.getLibraries().getComponentByTypeId(BInteger.make((int)BSharedManager.this.typeIdsList.get(this.getSelectedIndex()))).newCopy();
            return pt;
        }

        public MgrTypeInfo[] getNewTypes() {
            ArrayList<MgrTypeInfo> list = new ArrayList<MgrTypeInfo>();
            BNe2DeviceExt controller = ((BNanoBaseComponent)this.getTarget()).getNe2DeviceExt();
            for (int i : BSharedManager.this.typeIdsList) {
                list.add(MgrTypeInfo.make((BComponent)((BNanoBaseComponent)controller.getLibraries().getComponentByTypeId(BInteger.make((int)i)).newCopy())));
            }
            return list.toArray(new MgrTypeInfo[list.size()]);
        }

        void mapPointFacets(MgrEditRow row, MgrColumn col, Object source) {
            BFacets orig = (BFacets)row.getCell(col);
            BFacets facets = this.mapPointFacets(orig, source);
            row.setCell(col, (BValue)facets);
        }

        BFacets mapPointFacets(BFacets orig, Object source) {
            if (source instanceof BIBoolean) {
                return ((BIBoolean)source).getBooleanFacets();
            }
            if (source instanceof BINumeric) {
                return ((BINumeric)source).getNumericFacets();
            }
            return source instanceof BIEnum ? ((BIEnum)source).getEnumFacets() : BFacets.make((BFacets)orig);
        }
    }

    class CustomMark
    extends Mark {
        private final String ord;

        public CustomMark(BObject value, String name, String ord) {
            super(value, name);
            this.ord = ord;
        }

        public String toStringFormat() {
            return SlotPath.escape((String)this.ord);
        }
    }

    class PointController
    extends FolderController {
        String errorMsg;
        BNanoDiscoverJob job;

        public BNanoDiscoverJob getJob() {
            return this.job;
        }

        public PointController(BPointManager manager) {
            super((BFolderManager)manager);
            this.newFolder.setFlags(0);
            this.allDescendants.setFlags(0);
            this.errorMsg = "unknown";
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return PointController.append((MgrController.IMgrCommand[])new MgrController.IMgrCommand[0], (MgrController.IMgrCommand[])super.makeCommands());
        }

        public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
            FolderModel model = (FolderModel)this.getManager().getModel();
            Type[] folderTypes = ((PointModel)model).getFolderTypes();
            BComponent comp = this.getTable().getComponentAt(row);
            BWbShell shell = this.getManager().getWbShell();
            if (comp != null && Arrays.stream(folderTypes).anyMatch(type -> comp.getType().is(type)) && shell != null) {
                shell.hyperlink(new HyperlinkInfo(comp.getNavOrd(), (BInputEvent)event));
            } else {
                super.cellDoubleClicked(table, event, row, col);
            }
        }

        public MgrEdit promptForNew(Context cx) throws Exception {
            BNe2DeviceExt controller = ((BNanoBaseComponent)this.getTarget()).getNe2DeviceExt();
            ArrayList<BNanoBaseComponent> componentsForAdd = new ArrayList<BNanoBaseComponent>();
            for (int i : BSharedManager.this.typeIdsList) {
                BNanoBaseComponent child = (BNanoBaseComponent)controller.getLibraries().getComponentByTypeId(BInteger.make((int)i)).newCopy();
                if (null == child) continue;
                componentsForAdd.add(child);
            }
            MgrTypeInfo[] types = this.getManager().getModel().getNewTypes();
            if (types == null) {
                BDialog.error((BWidget)this.getManager(), (Object)"Must override BAbstractManager.getNewTypes()");
                return null;
            }
            BListDropDown typeField = new BListDropDown();
            if (this.getManager().getModel() instanceof PointModel) {
                for (int i = 0; i < componentsForAdd.size(); ++i) {
                    typeField.getList().addItem((Object)((BNanoBaseComponent)componentsForAdd.get(i)).getNanoName().toString().split("\\.")[2]);
                }
            }
            typeField.setSelectedIndex(0);
            BTextField countField = new BTextField("1", 6);
            BListDropDown dataType = new BListDropDown();
            dataType.setSelectedIndex(0);
            BGridPane grid = new BGridPane(2);
            grid.add((String)null, (BValue)new BLabel("Type"));
            grid.add((String)null, (BValue)typeField);
            grid.add((String)null, (BValue)new BLabel("Count"));
            grid.add((String)null, (BValue)countField);
            String title = this.newCommand.getLabel();
            int count = 0;
            boolean done = false;
            while (!done) {
                int r = BDialog.open((BWidget)this.getManager(), (String)title, (Object)grid, (int)3);
                if (r == 2) {
                    return null;
                }
                if (this.getManager().getModel() instanceof PointModel) {
                    ((PointModel)this.getManager().getModel()).setSelectedIndex(typeField.getSelectedIndex());
                }
                count = Integer.parseInt(countField.getText());
                done = true;
            }
            MgrEdit edit = this.makeEdit(title);
            for (int ixx = 0; ixx < count; ++ixx) {
                ArrayList<MgrTypeInfo> list = new ArrayList<MgrTypeInfo>();
                BNanoBaseComponent newComponent = (BNanoBaseComponent)controller.getLibraries().getComponentByTypeId(BInteger.make((int)BSharedManager.this.typeIdsList.get(typeField.getSelectedIndex()))).newCopy();
                list.add(MgrTypeInfo.make((BComponent)newComponent));
                BComponent comp = this.getManager().getModel().newInstance(MgrTypeInfo.make((BComponent)newComponent));
                MgrEditRow row = new MgrEditRow(comp, null, list.toArray(new MgrTypeInfo[list.size()]));
                edit.addRow(row);
            }
            return edit;
        }

        public BMenu makePopup(BMgrTable table, ComponentTableSubject subject, BMenu menu) {
            BMenu createdMenu = super.makePopup(table, subject, menu);
            createdMenu.removeItem("pasteSpecial");
            return createdMenu;
        }

        public CommandArtifact drop(BMgrTable table, TransferContext cx) throws Exception {
            String compName;
            BNe2DeviceExt controller = ((BNanoBaseComponent)this.getTarget()).getNe2DeviceExt();
            if (cx.getEnvelope().getData(TransferFormat.string).toString().contains(controller.getName()) || !cx.getEnvelope().getData(TransferFormat.string).toString().contains("Libraries")) {
                return super.drop(table, cx);
            }
            String[] splitCompName = cx.getEnvelope().getData(TransferFormat.string).toString().split("/");
            String libName = splitCompName[splitCompName.length - 2];
            String libraryCompName = String.join((CharSequence)".", "Library", libName, compName = splitCompName[splitCompName.length - 1]);
            BNanoComponent componentFromLibrary = (BNanoComponent)controller.getNanoComponentByName(BString.make((String)libraryCompName));
            if (componentFromLibrary == null) {
                return super.drop(table, cx);
            }
            String libraryVersion = componentFromLibrary.getAssemblyInfo().split("=")[1];
            String newOrd = "station:|" + controller.getSlotPathOrd() + "/libraries/Library." + libName + " (" + libraryVersion + ")/" + compName;
            CustomMark mark = new CustomMark((BObject)componentFromLibrary, compName, newOrd);
            TransferEnvelope transferEnvelope = TransferEnvelope.make((Mark)mark);
            TransferContext newCx = new TransferContext((Context)cx, cx.getAction(), transferEnvelope);
            return super.drop(table, newCx);
        }

        protected void createLibraryIdsList() {
            BNanoBaseComponent child;
            BNe2DeviceExt controller = ((BNanoBaseComponent)this.getTarget()).getNe2DeviceExt();
            for (int i = 0; i < typeNanoNameForAdd.length && (child = controller.getLibraries().getComponentByTypeName(BString.make((String)typeNanoNameForAdd[i]))) != null; ++i) {
                BSharedManager.this.typeIdsList.add(child.getTypeId());
            }
        }
    }
}

