/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.viewManagers;

import com.ismacontrolli.nE2Link.jobs.BDiscoveredNanoObject;
import com.ismacontrolli.nE2Link.jobs.BIdentifyingValues;
import com.ismacontrolli.nE2Link.jobs.BNanoDiscoverJob;
import com.ismacontrolli.nE2Link.jobs.BNanoRecipe;
import com.ismacontrolli.nE2Link.jobs.BNanoRecipeAction;
import com.ismacontrolli.nE2Link.jobs.BNanoRecipes;
import com.ismacontrolli.nE2Link.ui.viewManagers.BSharedManager;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.treetable.TreeTableCellRenderer;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.MgrLearn;

@NiagaraType
public class BNanoLearnTable
extends BLearnTable {
    public static final Type TYPE = Sys.loadType(BNanoLearnTable.class);
    BAbstractManager manager;
    MgrLearn learn;

    public Type getType() {
        return TYPE;
    }

    public BNanoLearnTable(MgrLearn learn) {
        super(learn);
        this.manager = learn.getManager();
        this.learn = learn;
        this.setCellRenderer((TableCellRenderer)new Renderer((BSharedManager)this.manager));
    }

    public class Renderer
    extends TreeTableCellRenderer {
        BSharedManager manager;

        Renderer(BSharedManager manager) {
            this.manager = manager;
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            if (this.getTreeTableModel().rowToNode(cell.row).isGroup()) {
                return Theme.treeTable().getGroupBackground();
            }
            TreeTableNode ttn = this.getTreeTableModel().rowToNode(cell.row);
            BComponent discoveredComponent = (BComponent)ttn.getSubject();
            BNanoDiscoverJob job = ((BSharedManager.PointController)this.manager.getController()).getJob();
            BNanoRecipes recipes = job.getRecipes();
            BComponent[] databaseComponents = this.manager.getModel().getTable().getComponentModel().getRows();
            boolean grayOut = this.isExisting(databaseComponents, discoveredComponent, recipes);
            return (grayOut |= this.isInvalidType(discoveredComponent, recipes)) ? BBrush.makeSolid((BColor)BColor.dimGray) : Theme.table().getSelectionForeground((IStylable)this.getTable());
        }

        public String getCellText(TableCellRenderer.Cell cell) {
            try {
                Object obj = BNanoLearnTable.this.getObjectAt(cell.row);
                BSharedManager.NanoPropColumn col = (BSharedManager.NanoPropColumn)BNanoLearnTable.this.columnIndexToMgrColumn(cell.column);
                return col.toDisplayStringLearn(obj, cell.value, BNanoLearnTable.this.manager.getCurrentContext());
            }
            catch (Exception var4) {
                return "";
            }
        }

        boolean isInvalidType(BComponent toCheck, BNanoRecipes recipes) {
            if (toCheck instanceof BDiscoveredNanoObject) {
                for (int i = 0; i < recipes.length(); ++i) {
                    BNanoRecipe recipe = recipes.getItem(i);
                    if (!recipe.isValidFor((BDiscoveredNanoObject)toCheck)) continue;
                    return false;
                }
            }
            return true;
        }

        boolean isExisting(BComponent[] listOfExisting, BComponent toCheck, BNanoRecipes recipes) {
            if (!(toCheck instanceof BDiscoveredNanoObject)) {
                return false;
            }
            BIdentifyingValues identifyingValues = null;
            for (int i = 0; i < recipes.length(); ++i) {
                BNanoRecipe recipe = recipes.getItem(i);
                if (recipe.isValidFor((BDiscoveredNanoObject)toCheck)) {
                    BNanoRecipeAction recipeAction;
                    for (int j = 0; j < recipe.getRecipeActions().length() && (identifyingValues = (recipeAction = recipe.getRecipeActions().getItem(j)).getIdentifyingValues()) == null; ++j) {
                    }
                }
                if (identifyingValues != null) break;
            }
            if (identifyingValues == null) {
                return false;
            }
            return identifyingValues.exists(listOfExisting, toCheck);
        }
    }
}

