/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.viewManagers;

import com.ismacontrolli.nE2Link.BNanoContainer;
import com.ismacontrolli.nE2Link.ui.viewManagers.BSharedManager;
import java.util.ArrayList;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;

@NiagaraType(agent={@AgentOn(types={"nE2Link:NanoComponent"}, defaultAgent=AgentOn.Preference.PREFERRED)})
public class BDeviceManager
extends BSharedManager {
    public static final Type TYPE = Sys.loadType(BDeviceManager.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BDeviceManager() {
        this.typeIdsList = new ArrayList();
    }

    @Override
    protected MgrModel makeModel() {
        return new DeviceModel(this);
    }

    @Override
    protected MgrController makeController() {
        return new NetworkController((BPointManager)this);
    }

    class DeviceModel
    extends BSharedManager.PointModel {
        public DeviceModel(BDeviceManager manager) {
            super(BDeviceManager.this, manager);
            this.pointFolderType = BNanoContainer.TYPE;
        }

        @Override
        protected String makeTableTitle() {
            return TYPE.getDisplayName((Context)null);
        }

        @Override
        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Name(), new BSharedManager.NanoExtCol(BDeviceManager.this, "Exts", 4, BImage.make((String)"module://nE2Link/rc/icons/navOnly/points.png")), new BSharedManager.NanoPropColumn("Status", "status", "valueValueToString, valueToString", 4), new BSharedManager.NanoPropColumn("Address", "address", "valueToString", 1), new BSharedManager.NanoPropColumn("Enabled", "enabled", "valueToString", 1)};
        }
    }

    class NetworkController
    extends BSharedManager.PointController {
        public NetworkController(BPointManager manager) {
            super(BDeviceManager.this, manager);
            BSharedManager.typeNanoNameForAdd = new String[]{"Library.Modbus.Device"};
            this.createLibraryIdsList();
        }

        @Override
        public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
            BComponent comp = this.getTable().getComponentAt(row);
            BWbShell shell = this.getManager().getWbShell();
            if (comp != null && col == 1 && shell != null) {
                shell.hyperlink(new HyperlinkInfo(comp.getNavOrd(), (BInputEvent)event));
            } else {
                super.cellDoubleClicked(table, event, row, col);
            }
        }
    }
}

