/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.viewManagers;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoBaseNamed;
import com.ismacontrolli.nE2Link.BNanoContainer;
import com.ismacontrolli.nE2Link.BNanoDiscoverExtension;
import com.ismacontrolli.nE2Link.BNanoStatusNumeric;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.jobs.BDiscoveredNanoObject;
import com.ismacontrolli.nE2Link.jobs.BDiscoveredNanoObjects;
import com.ismacontrolli.nE2Link.jobs.BNanoDiscoverJob;
import com.ismacontrolli.nE2Link.jobs.BNanoDiscoverJobParam;
import com.ismacontrolli.nE2Link.jobs.BNanoRecipeExecutorJobParam;
import com.ismacontrolli.nE2Link.jobs.BNanoRecipes;
import com.ismacontrolli.nE2Link.jobs.IJobProgressTracker;
import com.ismacontrolli.nE2Link.ui.discover.BDiscoverParamsDialog;
import com.ismacontrolli.nE2Link.ui.viewManagers.BDeviceManager;
import com.ismacontrolli.nE2Link.ui.viewManagers.BSharedManager;
import com.ismacontrolli.nE2Link.ui.viewManagers.NanoBacnetDeviceLearn;
import com.tridium.workbench.job.BJobBar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"nE2Link:NanoComponent"})})
public class BDeviceDiscoverManager
extends BSharedManager {
    public static final Type TYPE = Sys.loadType(BDeviceDiscoverManager.class);
    protected BJobBar jobBar;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BDeviceDiscoverManager() {
        this.typeIdsList = new ArrayList();
    }

    @Override
    protected MgrModel makeModel() {
        return new DiscoverModel(this);
    }

    @Override
    protected MgrController makeController() {
        return new DiscoverController(this);
    }

    protected MgrLearn makeLearn() {
        return new NanoBacnetDeviceLearn(this);
    }

    protected NanoBacnetDeviceLearn discoverLearn() {
        return (NanoBacnetDeviceLearn)this.getLearn();
    }

    protected DiscoverController discoverController() {
        return (DiscoverController)this.getController();
    }

    public void doLoadValue(BObject value, Context cx) {
        super.doLoadValue(value, cx);
        if (this.jobBar == null) {
            this.jobBar = new BJobBar();
            this.attach((BWbComponentView.Attachable)this.jobBar);
        }
    }

    public void handleComponentEvent(BComponentEvent event) {
        if (this.discoverController().getJob() == null) {
            return;
        }
        if (event.getSourceComponent().equals((Object)this.discoverController().job)) {
            BNanoDiscoverJob discoverJob = (BNanoDiscoverJob)event.getSourceComponent().as(BNanoDiscoverJob.class);
            if (event.getId() == 0 && event.getSlot().equals((Object)BNanoDiscoverJob.jobState)) {
                if (discoverJob.getJobState().isComplete()) {
                    if (discoverJob.getJobState().equals((Object)BJobState.success)) {
                        System.out.println("Job succeeded");
                        this.discoverLearn().jobComplete = true;
                        this.discoverLearn().jobComplete((BJob)discoverJob);
                    }
                    if (discoverJob.getJobState().equals((Object)BJobState.failed)) {
                        System.out.println("Job failed");
                    }
                }
                BDiscoveredNanoObjects discoveredNanoObjects = discoverJob.getDiscoveredObjects();
                System.out.println(String.format("Discovered Objects Dump: %s", discoveredNanoObjects.getDebugString()));
            }
        }
        super.handleComponentEvent(event);
    }

    class DiscoverModel
    extends BSharedManager.PointModel {
        MgrColumn.Name name;
        public BSharedManager.NanoExtCol ext;
        public BSharedManager.NanoPropColumn status;
        public BSharedManager.NanoPropColumn deviceName;
        public BSharedManager.NanoPropColumn deviceId;
        public BSharedManager.NanoPropColumn enabled;

        public DiscoverModel(BDeviceDiscoverManager manager) {
            super(BDeviceDiscoverManager.this, manager);
            this.pointFolderType = BNanoContainer.TYPE;
        }

        @Override
        protected String makeTableTitle() {
            return BDeviceManager.TYPE.getDisplayName((Context)null);
        }

        @Override
        protected MgrColumn[] makeColumns() {
            this.name = new MgrColumn.Name();
            this.ext = new BSharedManager.NanoExtCol(BDeviceDiscoverManager.this, "Exts", 4, BImage.make((String)"local:|module://icons/x16/navOnly/points.png"));
            this.status = new BSharedManager.NanoPropColumn("Status", "status", "valueValueToString, valueToString, toString", 4);
            this.deviceName = new BSharedManager.NanoPropColumn("Device Name", "deviceName", "valueValueToString, valueToString, toString", 4);
            this.deviceId = new BSharedManager.NanoPropColumn("Device Id", "deviceId", "valueValueToString, valueToString, toString", 1);
            this.enabled = new BSharedManager.NanoPropColumn("Enabled", "enabled", "valueValueToString, valueToString, toString", 1);
            return new MgrColumn[]{this.name, this.ext, this.status, this.deviceName, this.deviceId, this.enabled};
        }

        @Override
        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BNanoBaseComponent pt = null;
            BNe2DeviceExt controller = ((BNanoBaseComponent)this.getTarget()).getNe2DeviceExt();
            pt = (BNanoBaseComponent)controller.getLibraries().getComponentByTypeId(BInteger.make((int)((Integer)BDeviceDiscoverManager.this.typeIdsList.get(0)))).newCopy();
            return pt;
        }
    }

    class DiscoverController
    extends BSharedManager.PointController
    implements IJobProgressTracker {
        private int OK_VALUE;
        BDeviceDiscoverManager mgr;

        public DiscoverController(BDeviceDiscoverManager manager) {
            super(BDeviceDiscoverManager.this, manager);
            this.OK_VALUE = 8;
            this.mgr = manager;
            this.match.setFlags(0);
            BSharedManager.typeNanoNameForAdd = new String[]{"Library.BACnet.Device"};
            this.createLibraryIdsList();
        }

        public void updateCommands() {
            super.updateCommands();
        }

        public CommandArtifact doCancel(Context cx) throws Exception {
            if (this.job != null) {
                this.job.cancel();
            }
            return null;
        }

        public CommandArtifact doAdd(Context cx) {
            Object[] templates;
            if (this.mgr.getLearn() != null && this.getLearnTable().getSelectedObjects().length > 0 && (templates = this.getLearnTable().getSelectedObjects()).length > 0) {
                BNanoBaseComponent network = (BNanoBaseComponent)this.getManager().getTarget();
                List existingDevices = Arrays.stream(network.getChildren(BNanoBaseComponent.class)).filter(comp -> comp.get("originNameFromLibrary").toString().equals("Library.BACnet.Device")).collect(Collectors.toList());
                List existingDeviceIds = existingDevices.stream().map(device -> ((BNanoStatusNumeric)device.get("deviceId")).getValue()).collect(Collectors.toList());
                List<String> existingDeviceNames = existingDevices.stream().map(BNanoBaseNamed::getNanoName).collect(Collectors.toList());
                BNanoDiscoverExtension discoverExtension = network.hasDiscoverExtension() ? ((BNanoDiscoverExtension[])network.getChildren(BNanoDiscoverExtension.class))[0] : null;
                BNanoRecipes recipes = this.getJob().getRecipes();
                BDiscoveredNanoObjects objectsToCreate = new BDiscoveredNanoObjects();
                for (int i = 0; i < templates.length; ++i) {
                    BDiscoveredNanoObject newObject = (BDiscoveredNanoObject)templates[i];
                    if (existingDeviceIds.contains(((BInteger)newObject.get("DEVICEID")).getDouble())) continue;
                    String proposedName = newObject.get("DEVICENAME").toString();
                    String newName = this.createComponentName(existingDeviceNames, proposedName);
                    newObject.set("DEVICENAME", (BValue)BString.make((String)newName));
                    existingDeviceNames.add(newName);
                    objectsToCreate.add((BDiscoveredNanoObject)templates[i]);
                }
                BNanoRecipeExecutorJobParam param = new BNanoRecipeExecutorJobParam(objectsToCreate, recipes);
                discoverExtension.submitRecipeExecutorJob(param);
            }
            return null;
        }

        private String createComponentName(List<String> existing, String proposedNew) {
            if (proposedNew == null || proposedNew.isEmpty()) {
                return "UndefinedName";
            }
            while (existing.contains(proposedNew)) {
                Pattern pattern = Pattern.compile("([0-9]+)$");
                Matcher matcher = pattern.matcher(proposedNew);
                if (!matcher.find()) {
                    proposedNew = proposedNew + "1";
                    continue;
                }
                int number = Integer.parseInt(matcher.group()) + 1;
                proposedNew = matcher.replaceAll(String.valueOf(number));
            }
            return proposedNew;
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            int ok_value;
            super.doDiscover(cx);
            int result = BDiscoverParamsDialog.open((BWidget)this.getManager(), BDeviceDiscoverManager.this.getLexicon().get("DiscoverDialog.title"), (BNanoBaseComponent)this.getManager().getTarget(), this.getManager().getCurrentContext());
            if (result != 1) {
                return null;
            }
            BNanoBaseComponent network = (BNanoBaseComponent)this.getManager().getTarget();
            Property statusProp = network.getProperty("status");
            BEnumRange range = statusProp != null ? (BEnumRange)network.getSlotFacets((Slot)statusProp).getFacet("range") : null;
            int n = ok_value = range != null && range.isTag("OK") ? range.tagToOrdinal("OK") : -1;
            if (network != null && statusProp != null && ((BStatusEnum)network.get(statusProp).as(BStatusEnum.class)).getEnum().getOrdinal() == ok_value) {
                BNanoDiscoverExtension discoverExtension;
                BNanoDiscoverExtension bNanoDiscoverExtension = discoverExtension = network.hasDiscoverExtension() ? ((BNanoDiscoverExtension[])network.getChildren(BNanoDiscoverExtension.class))[0] : null;
                if (discoverExtension != null) {
                    BNanoDiscoverJob nanoDiscoverJob;
                    BNanoDiscoverJobParam param = new BNanoDiscoverJobParam(network.getHandleOrd());
                    BOrd jobOrd = discoverExtension.submitDiscoverJob(param);
                    BComponentSpace space = network.getComponentSpace();
                    if (space.isProxyComponentSpace()) {
                        space.sync();
                    }
                    this.job = nanoDiscoverJob = (BNanoDiscoverJob)jobOrd.resolve((BObject)network.getNe2DeviceExt()).get();
                    this.getManager().registerForComponentEvents((BComponent)nanoDiscoverJob);
                    BDeviceDiscoverManager.this.getLearn().setJob((BJob)this.job);
                }
            } else {
                BDialog.open((BWidget)this.getManager(), (String)BDeviceDiscoverManager.this.getLexicon().get("DiscoverDialog.Unavailable.title"), (Object)BDeviceDiscoverManager.this.getLexicon().get("DiscoverDialog.Unavailable.Network.text"), (int)1);
            }
            return null;
        }

        @Override
        public BNanoDiscoverJob getJob() {
            return this.job;
        }

        public void job_changed(BJob job, Property property, BValue value, Context context) {
        }

        @Override
        public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
            BComponent comp = this.getTable().getComponentAt(row);
            BWbShell shell = this.getManager().getWbShell();
            if (comp != null && col == 1 && shell != null) {
                shell.hyperlink(new HyperlinkInfo(comp.getNavOrd(), (BInputEvent)event));
            } else {
                super.cellDoubleClicked(table, event, row, col);
            }
        }
    }
}

