/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.viewManagers;

import com.ismacontrolli.nE2Link.BNanoApplication;
import com.ismacontrolli.nE2Link.BNanoApplicationContainer;
import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoComponent;
import com.ismacontrolli.nE2Link.BNanoContainer;
import com.ismacontrolli.nE2Link.BNanoEquipment;
import com.ismacontrolli.nE2Link.BNanoExtension;
import com.ismacontrolli.nE2Link.BNanoFolder;
import com.ismacontrolli.nE2Link.ui.viewManagers.BSharedManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.component.table.ComponentTableModel;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.folder.FolderController;
import javax.baja.workbench.mgr.folder.FolderModel;

@NiagaraType(agent={@AgentOn(types={"nE2Link:NanoContainer", "nE2Link:NanoComponent"})})
public class BDataPointManager
extends BSharedManager {
    public static final Type TYPE = Sys.loadType(BDataPointManager.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BDataPointManager() {
        this.typeIdsList = new ArrayList();
        typeNanoNameForAdd = new String[]{"Library.Core.Application", "Library.Core.Equipment", "Library.Core.BinaryDataPoint", "Library.Core.AnalogDataPoint", "Library.Core.MultistateDataPoint"};
    }

    public void doLoadValue(BObject obj, Context cx) {
        super.doLoadValue(obj, cx);
        this.getModel().getTable().setContainer(this.getTarget());
    }

    @Override
    protected MgrModel makeModel() {
        return new DataPointModel(this);
    }

    @Override
    protected MgrController makeController() {
        return new DataPointController((BPointManager)this);
    }

    class DataPointModel
    extends BSharedManager.PointModel {
        HashMap<BComponent, BComponent> subscription;

        public DataPointModel(BDataPointManager manager) {
            super(BDataPointManager.this, manager);
            this.subscription = new HashMap();
            this.pointFolderType = BNanoContainer.TYPE;
            this.pointFolderTypes = new Type[]{BNanoContainer.TYPE, BNanoEquipment.TYPE};
        }

        @Override
        protected String makeTableTitle() {
            return TYPE.getDisplayName((Context)null);
        }

        @Override
        public Type getBaseNewType() {
            return BNanoApplication.TYPE;
        }

        @Override
        public Type[] getIncludeTypes() {
            return new Type[]{BNanoFolder.TYPE, BNanoComponent.TYPE, BNanoApplication.TYPE};
        }

        @Override
        public void load(BComponent target) {
            BNanoBaseComponent baseComponent;
            if (target instanceof BNanoApplicationContainer) {
                this.pointFolderType = BNanoContainer.TYPE;
                baseComponent = (BNanoBaseComponent)((BNanoBaseComponent)target).getNe2DeviceExt().getNanoComponentByName(BString.make((String)"Applications"));
                baseComponent = (BNanoBaseComponent)target.getOrdInSpace().get(this.getManager().getCurrentValue());
            } else {
                this.pointFolderType = BNanoEquipment.TYPE;
                baseComponent = (BNanoBaseComponent)target;
            }
            ((FolderController)this.getManager().getController()).allDescendants.setSelected(true);
            Array accepted = new Array(BComponent.class);
            ComponentTableModel table = this.getTable().getComponentModel();
            BComponent[] rowsTable = this.resolveDeep((BComponent)baseComponent);
            this.subscribe(rowsTable, (BComponent)baseComponent);
            for (int i = 0; i < rowsTable.length; ++i) {
                if (!this.accept(rowsTable[i]) || !rowsTable[i].getPermissions(this.getManager().getCurrentContext()).hasOperatorRead()) continue;
                accepted.add((Object)rowsTable[i]);
            }
            rowsTable = (BComponent[])accepted.trim();
            this.getTable().getSelection().deselectAll();
            table.setRows(rowsTable);
        }

        private BComponent[] resolveChilds(BComponent target) {
            Array acc = new Array(BComponent.class);
            SlotCursor c = target.getProperties();
            while (c.nextComponent()) {
                Property prop = c.property();
                BComponent comp = (BComponent)c.get();
                if (Flags.isHidden((BComplex)target, (Slot)prop)) continue;
                acc.add((Object)comp);
            }
            return (BComponent[])acc.trim();
        }

        private BComponent[] resolveDeep(BComponent target) {
            String bql = "bql:select slotPath from ";
            for (int i = 0; i < this.getIncludeTypes().length; ++i) {
                if (i > 0) {
                    bql = bql + ", ";
                }
                bql = bql + this.getIncludeTypes()[i];
            }
            BITable result = (BITable)BOrd.make((String)bql).get((BObject)target);
            try (TableCursor cursor = result.cursor();){
                BComponent[] res;
                ArrayList<BOrd> ords = new ArrayList<BOrd>();
                Column colPath = result.getColumns().get(0);
                int skipCounter = 0;
                boolean lock = false;
                while (cursor.next()) {
                    BOrd ord = BOrd.make((String)cursor.cell(colPath).toString());
                    try {
                        BNanoBaseComponent temp = (BNanoBaseComponent)ord.resolve((BObject)target).getComponent();
                        if (temp instanceof BNanoExtension) continue;
                        if (skipCounter == 0) {
                            if (temp instanceof BNanoEquipment) {
                                skipCounter = ((BNanoBaseComponent[])temp.getChildren(BNanoBaseComponent.class)).length + 1;
                                lock = true;
                            }
                            if (!this.isGoodComponent(temp)) continue;
                            ords.add(ord);
                        }
                        if (skipCounter <= 0) continue;
                        if (!lock && (temp instanceof BNanoFolder || temp instanceof BNanoEquipment)) {
                            skipCounter += ((BNanoBaseComponent[])temp.getChildren(BNanoBaseComponent.class)).length;
                        }
                        --skipCounter;
                        lock = false;
                    }
                    catch (Exception exception) {}
                }
                BComponent[] bComponentArray = res = new BatchResolve(ords.toArray(new BOrd[ords.size()])).resolve((BObject)target).getTargetComponents();
                return bComponentArray;
            }
        }

        private void subscribe(BComponent[] rows, BComponent target) {
            BAbstractManager mgr = this.getManager();
            Array list = new Array(BComponent.class);
            if (this.subscription.get(target) == null && target != null) {
                list.add((Object)target);
                this.subscription.put(target, target);
            }
            for (int i = 0; i < rows.length; ++i) {
                BComponent p = (BComponent)rows[i].getParent();
                if (this.subscription.get(p) != null || p == null) continue;
                list.add((Object)p);
                this.subscription.put(p, p);
            }
            if (list.size() != 0) {
                BComponent[] toSub = (BComponent[])list.trim();
                int depth = this.getSubscribeDepth();
                mgr.registerForComponentEvents(toSub, depth);
            }
        }

        @Override
        protected MgrColumn[] makeColumns() {
            if (((BNanoBaseComponent)this.getTarget()).getNe2DeviceExt().getSoftwareManager().versionGreaterThan("1.7.0.9381")) {
                return new MgrColumn[]{new MgrColumn.Name(), new BSharedManager.NanoPropColumn("Description", "description", "valueValueToString, valueToString, toString", 4), new BSharedManager.NanoPropColumn("Out", "out", "valueValueToString, valueToString, toString", 4), new BSharedManager.NanoPropColumn("Enabled", "enabled", "valueToString", 1), new BSharedManager.NanoPropColumn("Bacnet Expose", "expose", "valueToString", "Library\\.BACnet\\.Bacnet.*Point", 1), new BSharedManager.NanoPropColumn("Bacnet Object Id", "objectId", "valueToString", "Library\\.BACnet\\.Bacnet.*Point", 4), new BSharedManager.NanoPropColumn("Modbus Expose", "expose", "valueToString", "Library\\.Modbus\\.Modbus.*Point", 1), new BSharedManager.NanoPropColumn("Modbus Address", "address", "valueToString", "Library\\.Modbus\\.Modbus.*Point", 4), new BSharedManager.NanoConDataSerMgrColumnString(BDataPointManager.this, "Configuration Data", 4)};
            }
            return new MgrColumn[]{new MgrColumn.Name(), new BSharedManager.NanoPropColumn("Description", "description", "valueValueToString, valueToString, toString", 4), new BSharedManager.NanoPropColumn("Out", "out", "valueValueToString, valueToString, toString", 4), new BSharedManager.NanoPropColumn("Enabled", "enabled", "valueToString", 1), new BSharedManager.NanoPropColumn("Bacnet Expose", "expose", "valueToString", "Library\\.BACnet\\.Bacnet.*Point", 1), new BSharedManager.NanoPropColumn("Bacnet Object Id", "objectId", "valueToString", "Library\\.BACnet\\.Bacnet.*Point", 4), new BSharedManager.NanoPropColumn("Modbus Expose", "expose", "valueToString", "Library\\.Modbus\\.Modbus.*Point", 1), new BSharedManager.NanoPropColumn("Modbus Address", "address", "valueToString", "Library\\.Modbus\\.Modbus.*Point", 4)};
        }
    }

    class DataPointController
    extends BSharedManager.PointController {
        public DataPointController(BPointManager manager) {
            super(BDataPointManager.this, manager);
            this.newCommand.setFlags(0);
            this.createLibraryIdsList();
        }

        @Override
        public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
            FolderModel model = (FolderModel)this.getManager().getModel();
            Type[] folderTypes = ((BSharedManager.PointModel)model).getFolderTypes();
            BComponent comp = this.getTable().getComponentAt(row);
            BWbShell shell = this.getManager().getWbShell();
            if (comp != null && Arrays.stream(folderTypes).anyMatch(type -> comp.getType().is(type)) && shell != null) {
                BOrd ord = BOrd.make((String)(comp.getNavOrd().toString() + "|view:nE2Link:DataPointManager"));
                shell.hyperlink(new HyperlinkInfo(ord, (BInputEvent)event));
            } else {
                super.cellDoubleClicked(table, event, row, col);
            }
        }
    }
}

