/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.viewManagers;

import com.ismacontrolli.nE2Link.BNanoApplication;
import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoComponent;
import com.ismacontrolli.nE2Link.BNanoContainer;
import com.ismacontrolli.nE2Link.BNanoEquipment;
import com.ismacontrolli.nE2Link.BNanoExtension;
import com.ismacontrolli.nE2Link.BNanoFolder;
import com.ismacontrolli.nE2Link.ui.viewManagers.BSharedManager;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.gx.BBrush;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.component.table.ComponentTableCellRenderer;
import javax.baja.workbench.component.table.ComponentTableModel;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;

@NiagaraType(agent={@AgentOn(types={"nE2Link:NanoComponent"}, defaultAgent=AgentOn.Preference.PREFERRED)})
public class BConfigurationDataServiceManager
extends BSharedManager {
    public static final Type TYPE = Sys.loadType(BConfigurationDataServiceManager.class);
    protected BObject reloadComponent;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BConfigurationDataServiceManager() {
        this.typeIdsList = new ArrayList();
        typeNanoNameForAdd = new String[]{"Library.Core.Application", "Library.Core.Equipment", "Library.Core.BinaryDataPoint", "Library.Core.AnalogDataPoint", "Library.Core.MultistateDataPoint"};
    }

    @Override
    protected MgrModel makeModel() {
        return new ConfigurationDataPointModel(this);
    }

    @Override
    protected MgrController makeController() {
        return new ConfigurationDataServiceController((BPointManager)this);
    }

    public void doLoadValue(BObject obj, Context cx) {
        super.doLoadValue(obj, cx);
        this.registerForComponentEvents((BComponent)obj);
    }

    public void handleComponentEvent(BComponentEvent event) {
        if (event.getValue() instanceof BNanoExtension) {
            this.getModel().load(null);
        } else {
            super.handleComponentEvent(event);
        }
    }

    public static class ServiceCellRenderer
    extends ComponentTableCellRenderer {
        private BAbstractManager mgr;

        public ServiceCellRenderer(BAbstractManager manager) {
            this.mgr = manager;
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            BComponent row = ((BMgrTable)this.getTable()).getComponentAt(cell.row);
            if (row.getType().is(BNanoContainer.TYPE) || row.getType().is(BNanoEquipment.TYPE)) {
                return Theme.table().getGridBrush();
            }
            return super.getBackground(cell);
        }

        public String getCellText(TableCellRenderer.Cell cell) {
            try {
                BComponent component = this.getComponentTable().getComponentModel().getComponentAt(cell.row);
                MgrColumn col = ((BMgrTable)this.getTable()).columnIndexToMgrColumn(cell.column);
                return col.toDisplayString((Object)component, cell.value, this.mgr.getCurrentContext());
            }
            catch (Exception var4) {
                return "";
            }
        }
    }

    class ConfigurationDataPointModel
    extends BSharedManager.PointModel {
        HashMap<BComponent, BComponent> subscription;

        public ConfigurationDataPointModel(BConfigurationDataServiceManager manager) {
            super(BConfigurationDataServiceManager.this, manager);
            this.subscription = new HashMap();
        }

        @Override
        protected String makeTableTitle() {
            return TYPE.getDisplayName((Context)null);
        }

        @Override
        public Type getBaseNewType() {
            return BNanoApplication.TYPE;
        }

        @Override
        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Name(), new BSharedManager.NanoPropColumn("Description", "description", "valueValueToString, valueToString, toString", 1), new BSharedManager.NanoPropColumn("Out", "out", "valueValueToString, valueToString, toString", 4), new BSharedManager.NanoConDataSerMgrColumnString(BConfigurationDataServiceManager.this, "Configuration Data", 4)};
        }

        @Override
        public Type[] getIncludeTypes() {
            return new Type[]{BNanoFolder.TYPE, BNanoComponent.TYPE, BNanoApplication.TYPE};
        }

        @Override
        public void load(BComponent target) {
            BNanoBaseComponent baseComponent;
            Array accepted = new Array(BComponent.class);
            ComponentTableModel table = this.getTable().getComponentModel();
            this.getTable().setCellRenderer((TableCellRenderer)new ServiceCellRenderer(this.getManager()));
            ((FolderController)this.getManager().getController()).allDescendants.setSelected(true);
            if (!(target instanceof BNanoEquipment)) {
                baseComponent = (BNanoBaseComponent)((BNanoBaseComponent)target).getNe2DeviceExt().getNanoComponentByName(BString.make((String)"Applications"));
                baseComponent = (BNanoBaseComponent)baseComponent.getOrdInSpace().get(this.getManager().getCurrentValue());
            } else {
                this.pointFolderType = BNanoEquipment.TYPE;
                baseComponent = (BNanoBaseComponent)target;
            }
            BComponent[] rowsTable = this.resolveDeep((BComponent)baseComponent);
            for (int i = 0; i < rowsTable.length; ++i) {
                if (!this.accept(rowsTable[i]) || !rowsTable[i].getPermissions(this.getManager().getCurrentContext()).hasOperatorRead()) continue;
                accepted.add((Object)rowsTable[i]);
            }
            rowsTable = (BComponent[])accepted.trim();
            this.subscribe(rowsTable, (BComponent)baseComponent);
            this.getTable().getSelection().deselectAll();
            table.setRows(rowsTable);
        }

        private BComponent[] resolveFlat(BComponent target) {
            Array acc = new Array(BComponent.class);
            SlotCursor c = target.getProperties();
            while (c.nextComponent()) {
                Property prop = c.property();
                BComponent comp = (BComponent)c.get();
                if (Flags.isHidden((BComplex)target, (Slot)prop)) continue;
                acc.add((Object)comp);
            }
            return (BComponent[])acc.trim();
        }

        private BComponent[] resolveDeep(BComponent target) {
            String bql = "bql:select slotPath from ";
            for (int i = 0; i < this.getIncludeTypes().length; ++i) {
                if (i > 0) {
                    bql = bql + ", ";
                }
                bql = bql + this.getIncludeTypes()[i];
            }
            BITable result = (BITable)BOrd.make((String)bql).get((BObject)target);
            try (TableCursor cursor = result.cursor();){
                BComponent[] res;
                ArrayList<BOrd> ords = new ArrayList<BOrd>();
                Column colPath = result.getColumns().get(0);
                int skipCounter = 0;
                boolean lock = false;
                while (cursor.next()) {
                    BOrd ord = BOrd.make((String)cursor.cell(colPath).toString());
                    try {
                        BNanoBaseComponent temp = (BNanoBaseComponent)ord.resolve((BObject)target).getComponent();
                        if (temp instanceof BNanoExtension) continue;
                        if (skipCounter == 0) {
                            if (temp instanceof BNanoEquipment) {
                                skipCounter = ((BNanoBaseComponent[])temp.getChildren(BNanoBaseComponent.class)).length + 1;
                                lock = true;
                            }
                            if (!this.isGoodComponent(temp)) continue;
                            ords.add(ord);
                        }
                        if (skipCounter <= 0) continue;
                        if (!lock && (temp instanceof BNanoFolder || temp instanceof BNanoEquipment)) {
                            skipCounter += ((BNanoBaseComponent[])temp.getChildren(BNanoBaseComponent.class)).length;
                        }
                        --skipCounter;
                        lock = false;
                    }
                    catch (Exception exception) {}
                }
                BComponent[] bComponentArray = res = new BatchResolve(ords.toArray(new BOrd[ords.size()])).resolve((BObject)target).getTargetComponents();
                return bComponentArray;
            }
        }

        private void subscribe(BComponent[] rows, BComponent target) {
            BAbstractManager mgr = this.getManager();
            Array list = new Array(BComponent.class);
            if (this.subscription.get(target) == null && target != null) {
                list.add((Object)target);
                this.subscription.put(target, target);
            }
            for (int i = 0; i < rows.length; ++i) {
                BComponent p = (BComponent)rows[i].getParent();
                if (this.subscription.get(p) != null || p == null) continue;
                list.add((Object)p);
                this.subscription.put(p, p);
            }
            if (list.size() != 0) {
                BComponent[] toSub = (BComponent[])list.trim();
                int depth = this.getSubscribeDepth();
                mgr.registerForComponentEvents(toSub, depth);
            }
        }
    }

    class ConfigurationDataServiceController
    extends BSharedManager.PointController {
        Lexicon lex;
        public final MgrController.MgrCommand clearConfiguration;
        public final MgrController.MgrCommand saveConfiguration;
        public final MgrController.MgrCommand loadConfiguration;

        public ConfigurationDataServiceController(BPointManager manager) {
            super(BConfigurationDataServiceManager.this, manager);
            this.lex = Lexicon.make(BFolderManager.class);
            this.newCommand.setFlags(0);
            this.edit.setFlags(0);
            this.clearConfiguration = new ClearConfiguration((BWidget)manager);
            this.clearConfiguration.setFlags(15);
            this.saveConfiguration = new SaveConfiguration((BWidget)manager);
            this.saveConfiguration.setFlags(15);
            this.loadConfiguration = new LoadConfiguration((BWidget)manager);
            this.loadConfiguration.setFlags(15);
            this.createLibraryIdsList();
        }

        @Override
        public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
            BComponent component = table.getComponentAt(row);
            BWbShell shell = table.getManager().getWbShell();
            if (shell != null) {
                if (component instanceof BNanoEquipment) {
                    table.getManager().getModel().load(component);
                    BConfigurationDataServiceManager.this.reloadComponent = component;
                } else if (!(component instanceof BNanoApplication)) {
                    shell.hyperlink(new HyperlinkInfo(component.getNavOrd(), (BInputEvent)event));
                }
            }
        }

        @Override
        protected MgrController.IMgrCommand[] makeCommands() {
            return ConfigurationDataServiceController.append((MgrController.IMgrCommand[])new MgrController.IMgrCommand[]{this.allDescendants, this.loadConfiguration, this.saveConfiguration, this.clearConfiguration}, (MgrController.IMgrCommand[])super.makeCommands());
        }

        public CommandArtifact doClearConfiguration() throws Exception {
            this.invokeDynamicActions("ClearConfigurationData");
            return null;
        }

        public CommandArtifact doSaveConfiguration() throws Exception {
            this.invokeDynamicActions("SaveConfigurationData");
            return null;
        }

        public CommandArtifact doLoadConfiguration() throws Exception {
            this.invokeDynamicActions("LoadConfigurationData");
            return null;
        }

        private void invokeDynamicActions(String actionsName) {
            try {
                Action dynamicAction = this.getManager().getTarget().getAction(actionsName);
                this.getTarget().invoke(dynamicAction, null);
            }
            catch (Exception e) {
                System.err.println("Error invoking action: " + e.getMessage());
                e.printStackTrace();
            }
        }

        class LoadConfiguration
        extends MgrController.MgrCommand {
            LoadConfiguration(BWidget owner) {
                super(owner, ((BNanoComponent)((BConfigurationDataServiceManager)owner).getTarget()).getNe2DeviceExt().getLexicon(), "ConfigurationLoad");
            }

            public CommandArtifact doInvoke() throws Exception {
                return ConfigurationDataServiceController.this.doLoadConfiguration();
            }

            public Command doMerge(Command c) {
                return this;
            }
        }

        class SaveConfiguration
        extends MgrController.MgrCommand {
            SaveConfiguration(BWidget owner) {
                super(owner, ((BNanoComponent)((BConfigurationDataServiceManager)owner).getTarget()).getNe2DeviceExt().getLexicon(), "ConfigurationSave");
            }

            public CommandArtifact doInvoke() throws Exception {
                return ConfigurationDataServiceController.this.doSaveConfiguration();
            }

            public Command doMerge(Command c) {
                return this;
            }
        }

        class ClearConfiguration
        extends MgrController.MgrCommand {
            ClearConfiguration(BWidget owner) {
                super(owner, ((BNanoComponent)((BConfigurationDataServiceManager)owner).getTarget()).getNe2DeviceExt().getLexicon(), "ConfigurationClear");
            }

            public CommandArtifact doInvoke() throws Exception {
                return ConfigurationDataServiceController.this.doClearConfiguration();
            }
        }
    }
}

