/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.viewManagers;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoContainer;
import com.ismacontrolli.nE2Link.BNanoDiscoverExtension;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.jobs.BDiscoveredNanoObject;
import com.ismacontrolli.nE2Link.jobs.BDiscoveredNanoObjects;
import com.ismacontrolli.nE2Link.jobs.BNanoDiscoverJob;
import com.ismacontrolli.nE2Link.jobs.BNanoDiscoverJobParam;
import com.ismacontrolli.nE2Link.jobs.BNanoRecipeExecutorJobParam;
import com.ismacontrolli.nE2Link.jobs.BNanoRecipes;
import com.ismacontrolli.nE2Link.jobs.IJobProgressTracker;
import com.ismacontrolli.nE2Link.ui.viewManagers.BSharedManager;
import com.ismacontrolli.nE2Link.ui.viewManagers.NanoBacnetDeviceLearn;
import com.ismacontrolli.nE2Link.ui.viewManagers.NanoBacnetObjectLearn;
import com.tridium.workbench.job.BJobBar;
import java.util.ArrayList;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"nE2Link:NanoComponent"}, defaultAgent=AgentOn.Preference.PREFERRED)})
public class BBacnetPointManager
extends BSharedManager {
    public static final Type TYPE = Sys.loadType(BBacnetPointManager.class);
    protected BJobBar jobBar;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BBacnetPointManager() {
        this.typeIdsList = new ArrayList();
        typeNanoNameForAdd = new String[]{"Library.BACnet.AnalogCustomPoint", "Library.BACnet.AnalogPoint", "Library.BACnet.BinaryCustomPoint", "Library.BACnet.StringCustomPoint", "Library.BACnet.BinaryPoint", "Library.BACnet.MultistatePoint"};
    }

    @Override
    protected MgrModel makeModel() {
        return new BacnetPointModel(this);
    }

    @Override
    protected MgrController makeController() {
        return new BacnetPointController((BPointManager)this);
    }

    protected MgrLearn makeLearn() {
        return new NanoBacnetObjectLearn(this);
    }

    protected NanoBacnetDeviceLearn discoverLearn() {
        return (NanoBacnetDeviceLearn)this.getLearn();
    }

    BacnetPointController BacnetPointController() {
        return (BacnetPointController)this.getController();
    }

    public void doLoadValue(BObject value, Context cx) {
        super.doLoadValue(value, cx);
        if (this.jobBar == null) {
            this.jobBar = new BJobBar();
            this.attach((BWbComponentView.Attachable)this.jobBar);
        }
    }

    public void handleComponentEvent(BComponentEvent event) {
        if (this.BacnetPointController().getJob() == null) {
            return;
        }
        if (event.getSourceComponent().equals((Object)this.BacnetPointController().job)) {
            BNanoDiscoverJob discoverJob = (BNanoDiscoverJob)event.getSourceComponent().as(BNanoDiscoverJob.class);
            if (event.getId() == 0 && event.getSlot().equals((Object)BNanoDiscoverJob.jobState)) {
                if (discoverJob.getJobState().isComplete()) {
                    if (discoverJob.getJobState().equals((Object)BJobState.success)) {
                        System.out.println("Job succeeded");
                        this.discoverLearn().jobComplete = true;
                        this.discoverLearn().jobComplete((BJob)discoverJob);
                    }
                    if (discoverJob.getJobState().equals((Object)BJobState.failed)) {
                        System.out.println("Job failed");
                    }
                }
                BDiscoveredNanoObjects discoveredNanoObjects = discoverJob.getDiscoveredObjects();
                System.out.println(String.format("Discovered Objects Dump: %s", discoveredNanoObjects.getDebugString()));
            }
        }
        super.handleComponentEvent(event);
    }

    class BacnetPointModel
    extends BSharedManager.PointModel {
        public MgrColumn.Name name;
        public BSharedManager.NanoPropColumn out;
        public BSharedManager.NanoPropColumn status;
        public BSharedManager.NanoPropColumn objectName;
        public BSharedManager.NanoPropColumn objectId;
        public BSharedManager.NanoPropColumn pollingMode;
        public BSharedManager.NanoPropColumn enabled;
        public BSharedManager.NanoPropColumn objectType;
        public BSharedManager.NanoPropColumn mode;
        public BSharedManager.NanoPropColumn property;

        public BacnetPointModel(BBacnetPointManager manager) {
            super(BBacnetPointManager.this, manager);
            this.pointFolderType = BNanoContainer.TYPE;
        }

        @Override
        protected String makeTableTitle() {
            return TYPE.getDisplayName((Context)null);
        }

        @Override
        protected MgrColumn[] makeColumns() {
            this.name = new MgrColumn.Name();
            this.out = new BSharedManager.NanoPropColumn("Out", "out", "valueValueToString, valueToString, toString", 4);
            this.status = new BSharedManager.NanoPropColumn("Status", "status", "valueValueToString, valueToString", 4);
            this.objectName = new BSharedManager.NanoPropColumn("Object Name", "objectName", "valueValueToString, valueToString, toString", 4);
            this.objectId = new BSharedManager.NanoPropColumn("Object Id", "objectId", "valueValueToString, valueToString, toString", 1);
            this.pollingMode = new BSharedManager.NanoPropColumn("Polling Mode", "pollingMode", "valueValueToString, valueToString, toString", 1);
            this.enabled = new BSharedManager.NanoPropColumn("Enabled", "enabled", "valueValueToString, valueToString, toString", 1);
            this.objectType = new BSharedManager.NanoPropColumn("Object Type", "objectType", "valueValueToString, valueToString, toString", 3);
            this.property = new BSharedManager.NanoPropColumn("Property", "property", "valueValueToString, valueToString, toString", 3);
            this.mode = new BSharedManager.NanoPropColumn("Mode", "mode", "valueValueToString, valueToString, toString", 3);
            return new MgrColumn[]{this.name, this.out, this.status, this.objectName, this.objectId, this.pollingMode, this.enabled, this.objectType, this.property, this.mode};
        }

        @Override
        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BNanoBaseComponent comp = (BNanoBaseComponent)type.newInstance();
            BNanoBaseComponent pt = null;
            BNe2DeviceExt controller = ((BNanoBaseComponent)this.getTarget()).getNe2DeviceExt();
            pt = (BNanoBaseComponent)controller.getLibraries().getComponentByTypeId(BInteger.make((int)comp.getTypeId())).newCopy();
            return pt;
        }
    }

    class BacnetPointController
    extends BSharedManager.PointController
    implements IJobProgressTracker {
        BNanoDiscoverJob job;
        BPointManager mgr;

        public BacnetPointController(BPointManager manager) {
            super(BBacnetPointManager.this, manager);
            this.mgr = manager;
            this.match.setFlags(0);
            this.createLibraryIdsList();
        }

        public CommandArtifact doCancel(Context cx) throws Exception {
            if (this.job != null) {
                this.job.cancel();
            }
            return null;
        }

        public CommandArtifact doAdd(Context cx) {
            if (this.mgr.getLearn() != null && this.getLearnTable().getSelectedObjects().length > 0) {
                BNanoDiscoverExtension discoverExtension;
                Object[] templates = this.getLearnTable().getSelectedObjects();
                BNanoBaseComponent network = (BNanoBaseComponent)this.getManager().getTarget();
                BNanoDiscoverExtension bNanoDiscoverExtension = discoverExtension = network.hasDiscoverExtension() ? ((BNanoDiscoverExtension[])network.getChildren(BNanoDiscoverExtension.class))[0] : null;
                if (templates.length > 0) {
                    BNanoRecipes recipes = this.getJob().getRecipes();
                    BDiscoveredNanoObjects objectsToCreate = new BDiscoveredNanoObjects();
                    for (int i = 0; i < templates.length; ++i) {
                        objectsToCreate.add((BDiscoveredNanoObject)templates[i]);
                    }
                    BNanoRecipeExecutorJobParam param = new BNanoRecipeExecutorJobParam(objectsToCreate, recipes);
                    discoverExtension.submitRecipeExecutorJob(param);
                }
            }
            return null;
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            int ok_value;
            super.doDiscover(cx);
            BNanoBaseComponent component = (BNanoBaseComponent)this.getManager().getTarget();
            Property statusProp = component.getProperty("status");
            BEnumRange range = statusProp != null ? (BEnumRange)component.getSlotFacets((Slot)statusProp).getFacet("range") : null;
            int n = ok_value = range != null && range.isTag("OK") ? range.tagToOrdinal("OK") : -1;
            if (component != null && statusProp != null && ((BStatusEnum)component.get(statusProp).as(BStatusEnum.class)).getEnum().getOrdinal() == ok_value) {
                BNanoDiscoverExtension discoverExtension;
                BNanoDiscoverExtension bNanoDiscoverExtension = discoverExtension = component.hasDiscoverExtension() ? ((BNanoDiscoverExtension[])component.getChildren(BNanoDiscoverExtension.class))[0] : null;
                if (discoverExtension != null) {
                    BNanoDiscoverJob nanoDiscoverJob;
                    BNanoDiscoverJobParam param = new BNanoDiscoverJobParam(component.getHandleOrd());
                    BOrd jobOrd = discoverExtension.submitDiscoverJob(param);
                    BComponentSpace space = component.getComponentSpace();
                    if (space.isProxyComponentSpace()) {
                        space.sync();
                    }
                    this.job = nanoDiscoverJob = (BNanoDiscoverJob)jobOrd.resolve((BObject)component.getNe2DeviceExt()).get();
                    this.getManager().registerForComponentEvents((BComponent)nanoDiscoverJob);
                    BBacnetPointManager.this.getLearn().setJob((BJob)this.job);
                }
            } else {
                BDialog.open((BWidget)this.getManager(), (String)BBacnetPointManager.this.getLexicon().get("DiscoverDialog.Unavailable.title"), (Object)BBacnetPointManager.this.getLexicon().get("DiscoverDialog.Unavailable.Device.text"), (int)1);
            }
            return null;
        }

        @Override
        public BNanoDiscoverJob getJob() {
            return this.job;
        }

        public void job_changed(BJob job, Property property, BValue value, Context context) {
        }
    }
}

