/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.schedules;

import com.ismacontrolli.nE2Link.schedules.BNanoDateRangeSchedule;
import com.ismacontrolli.nE2Link.schedules.BNanoDateSchedule;
import com.ismacontrolli.nE2Link.schedules.BNanoWeekAndDaySchedule;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.Clock;
import javax.baja.util.Lexicon;

public final class NanoScheduleValidator {
    private NanoScheduleValidator() {
    }

    public static void validate(BAbstractSchedule schedule, Lexicon lex) throws Exception {
        if (schedule instanceof BNanoDateRangeSchedule) {
            BNanoDateRangeSchedule sch = (BNanoDateRangeSchedule)schedule;
            NanoScheduleValidator.verify(sch.getStart(), lex);
            NanoScheduleValidator.verify(sch.getEnd(), lex);
            int start = sch.getStart().getYear();
            int end = sch.getEnd().getYear();
            if (start >= 0 && end >= 0) {
                if (start > end) {
                    throw new RuntimeException(lex.getText("NanoScheduleValidator.daterange.startAfterEnd"));
                }
                if (start == end) {
                    start = sch.getStart().getMonth();
                    end = sch.getEnd().getMonth();
                    if (start >= 0 && end >= 0) {
                        if (start > end) {
                            throw new RuntimeException(lex.getText("NanoScheduleValidator.daterange.startAfterEnd"));
                        }
                        if (start == end) {
                            start = sch.getStart().getDay();
                            end = sch.getEnd().getDay();
                            if (start >= 0 && end >= 0 && start > end) {
                                throw new RuntimeException(lex.getText("NanoScheduleValidator.daterange.startAfterEnd"));
                            }
                        }
                    }
                }
            }
        } else if (!(schedule instanceof BNanoWeekAndDaySchedule) && schedule instanceof BNanoDateSchedule) {
            NanoScheduleValidator.verify((BNanoDateSchedule)schedule, lex);
        }
    }

    private static void verify(BNanoDateSchedule sch, Lexicon lex) {
        BAbsTime t;
        int d = sch.getDay();
        if (d > 31) {
            return;
        }
        int m = sch.getMonth();
        int y = sch.getYear();
        int w = sch.getWeekday();
        if (w >= 0 && d > 0 && m >= 0 && y >= 0 && (t = BAbsTime.make((int)sch.getYear(), (BMonth)BMonth.make((int)sch.getMonth()), (int)sch.getDay())).getWeekday().getOrdinal() != sch.getWeekday()) {
            throw new RuntimeException(lex.getText("NanoScheduleValidator.date.invalidDate") + ": " + sch);
        }
        if (d > 0 && m >= 0) {
            int dim;
            if (y < 0) {
                y = Clock.time().getYear();
            }
            if (m < 12 && d > (dim = BAbsTime.getDaysInMonth((int)y, (BMonth)BMonth.make((int)m)))) {
                throw new RuntimeException(lex.getText("NanoScheduleValidator.date.invalidDate") + ": " + sch);
            }
        }
    }
}

