/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.schedules;

import com.ismacontrolli.nE2Link.ui.schedules.BNanoDaySlider;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

@NiagaraType
public class BNanoSliderLabels
extends BWidget {
    public static final Type TYPE = Sys.loadType(BNanoSliderLabels.class);
    private double left = 0.0;
    private double right = 0.0;
    private BNanoDaySlider slider;

    public Type getType() {
        return TYPE;
    }

    public BNanoSliderLabels(BNanoDaySlider slider, double leftInset, double rightInset) {
        this.slider = slider;
        this.left = leftInset;
        this.right = rightInset;
    }

    public void computePreferredSize() {
        int[] unitLines = this.slider.unitLines;
        double pw = 0.0;
        int i = unitLines.length;
        while (true) {
            if (--i < 0) {
                this.slider.computePreferredSize();
                this.setPreferredSize(pw, this.slider.getPreferredHeight());
                return;
            }
            int unit = unitLines[i];
            String label = this.slider.getUnitLabel(unit);
            pw = Math.max(pw, BNanoDaySlider.font.width(label) + this.left + this.right);
        }
    }

    public void paint(Graphics g) {
        int[] unitLines = this.slider.unitLines;
        g.setBrush(BNanoDaySlider.widgetTheme.getTextBrush());
        g.setFont(BNanoDaySlider.font);
        if (unitLines != null) {
            double h = this.getHeight();
            double w = this.getWidth();
            double diff = h - this.slider.getHeight();
            double x = this.getX() + w - this.right;
            double offset = BNanoDaySlider.font.getMaxDescent() + diff / 2.0;
            int i = unitLines.length;
            while (--i >= 0) {
                int unit = unitLines[i];
                double y = this.slider.nanoUnitToY(unit);
                String label = this.slider.getUnitLabel(unit);
                g.drawString(label, x - BNanoDaySlider.font.width(label), y + offset + 10.0);
            }
        }
    }
}

