/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.schedules;

import com.ismacontrolli.nE2Link.BNanoComponent;
import com.ismacontrolli.nE2Link.BNanoConfig;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.actions.BDynamicChoiceRangeChangedArg;
import com.ismacontrolli.nE2Link.actions.BNanoScheduleChangedArg;
import com.ismacontrolli.nE2Link.datatypes.BUInt64;
import com.ismacontrolli.nE2Link.datatypes.choice.BDynamicChoiceRange;
import com.ismacontrolli.nE2Link.schedules.BNanoSchedule;
import com.ismacontrolli.nE2Link.ui.fieldEditors.BDynamicChoiceRangeDialog;
import com.ismacontrolli.nE2Link.ui.schedules.BNanoAbstractScheduleView;
import com.ismacontrolli.nE2Link.ui.schedules.BNanoCompositeEd;
import com.ismacontrolli.nE2Link.ui.schedules.BNanoDayEd;
import com.ismacontrolli.nE2Link.ui.schedules.BNanoDaySlider;
import com.ismacontrolli.nE2Link.ui.schedules.Utils;
import com.tridium.schedule.ui.BAbstractScheduleWidget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BAlign;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

@NiagaraType(agent={@AgentOn(types={"nE2Link:NanoComponent"}, defaultAgent=AgentOn.Preference.PREFERRED)})
@NiagaraActions(value={@NiagaraAction(name="scheduleModified"), @NiagaraAction(name="tabSelectionModified"), @NiagaraAction(name="editLabels"), @NiagaraAction(name="dragStarted"), @NiagaraAction(name="dragFinished")})
public class BNanoScheduleView
extends BNanoAbstractScheduleView {
    public static final Action scheduleModified = BNanoScheduleView.newAction((int)0, null);
    public static final Action tabSelectionModified = BNanoScheduleView.newAction((int)0, null);
    public static final Action editLabels = BNanoScheduleView.newAction((int)0, null);
    public static final Action dragStarted = BNanoScheduleView.newAction((int)0, null);
    public static final Action dragFinished = BNanoScheduleView.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BNanoScheduleView.class);
    private static String tabName = "";
    BNanoDayEd dayEd;
    BNanoCompositeEd specialEventsEd;
    BEdgePane contentPane;
    BTabbedPane tabbedPane;
    BGridPane headerPane;
    BNanoComponent currentValue;
    private final Lexicon lex = this.getLexicon();
    BButton editLabelsBtn = new BButton(this.lex.get("NanoScheduler.labels.editLabels"));
    private static Object syncObject = new Object();
    private boolean isDragging = false;

    public void scheduleModified() {
        this.invoke(scheduleModified, null, null);
    }

    public void tabSelectionModified() {
        this.invoke(tabSelectionModified, null, null);
    }

    public void editLabels() {
        this.invoke(editLabels, null, null);
    }

    public void dragStarted() {
        this.invoke(dragStarted, null, null);
    }

    public void dragFinished() {
        this.invoke(dragFinished, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BNanoScheduleView() {
        int i;
        this.tabbedPane = new BTabbedPane();
        this.tabbedPane.setTabPlacement(BAlign.bottom);
        this.dayEd = new BNanoDayEd(false);
        this.tabbedPane.addPane(new BLabel(Utils.imgSchedule, this.lex.get("NanoScheduler.weeklySchedule")), (BWidget)new BBorderPane((BWidget)this.dayEd, 10.0, 10.0, 10.0, 10.0));
        this.specialEventsEd = new BNanoCompositeEd(this, true, false);
        this.tabbedPane.addPane(new BLabel(Utils.imgCalendar, this.lex.get("NanoScheduler.specialEvents")), (BWidget)new BBorderPane((BWidget)this.specialEventsEd, 10.0, 10.0, 10.0, 10.0));
        this.contentPane = new BEdgePane();
        this.contentPane.setCenter((BWidget)new BBorderPane((BWidget)this.tabbedPane, 0.0, 0.0, 10.0, 0.0));
        BGridPane gp = new BGridPane(2);
        gp.setRowAlign(BValign.fill);
        gp.setColumnAlign(BHalign.fill);
        gp.setUniformColumnWidth(true);
        gp.setUniformRowHeight(true);
        this.contentPane.setBottom((BWidget)gp);
        this.linkTo((BComponent)this.dayEd, (Slot)BAbstractScheduleWidget.modified, (Slot)scheduleModified);
        for (i = 0; i < this.dayEd.sliders.length; ++i) {
            this.linkTo((BComponent)this.dayEd.sliders[i], (Slot)BNanoDaySlider.dragStarted, (Slot)dragStarted);
            this.linkTo((BComponent)this.dayEd.sliders[i], (Slot)BNanoDaySlider.dragFinished, (Slot)dragFinished);
        }
        this.linkTo((BComponent)this.specialEventsEd, (Slot)BAbstractScheduleWidget.modified, (Slot)scheduleModified);
        for (i = 0; i < this.specialEventsEd.daySlider.sliders.length; ++i) {
            this.linkTo((BComponent)this.specialEventsEd.daySlider.sliders[i], (Slot)BNanoDaySlider.dragStarted, (Slot)dragStarted);
            this.linkTo((BComponent)this.specialEventsEd.daySlider.sliders[i], (Slot)BNanoDaySlider.dragFinished, (Slot)dragFinished);
        }
        this.linkTo((BComponent)this.tabbedPane, (Slot)BTabbedPane.selectionModified, (Slot)tabSelectionModified);
        this.setContent((BWidget)this.contentPane);
        BLabelPane selectedPane = (BLabelPane)this.tabbedPane.get(tabName);
        if (selectedPane != null) {
            this.tabbedPane.selectLabelPane(selectedPane);
        }
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) throws Exception {
        super.doLoadValue(value, cx);
        this.currentValue = (BNanoComponent)this.getCurrentValue();
        this.currentValue.lease(3);
        this.currentValue.requestNanoSubscription();
        if (null != this.nanoSchedule && null != this.currentValue) {
            this.dayEd.setWeekSchedule(this.nanoSchedule, ((BNanoSchedule)this.nanoSchedule).getWeekSchedule());
            this.dayEd.setReadonly(this.readonly());
            this.specialEventsEd.setAbsSchedule((BAbstractSchedule)this.currentValue.get("NanoWeeklySchedule"));
            this.specialEventsEd.setSchedule(((BNanoSchedule)this.nanoSchedule).getSpecialEvents());
            this.specialEventsEd.setReadonly(!this.getExceptionalDaysWritable(cx));
            if (this.specialEventsEd.table.getModel().getRowCount() > 0) {
                this.specialEventsEd.table.getSelection().select(0);
            } else {
                this.specialEventsEd.selected();
            }
            ((BNanoSchedule)this.nanoSchedule).getSpecialEvents().loadSlots();
            ((BNanoSchedule)this.nanoSchedule).getSpecialEvents().lease(10);
        }
        BNe2DeviceExt ne2DeviceExt = this.getNe2DeviceExt();
        StringBuilder titleLabel = new StringBuilder("").append(ne2DeviceExt.getSoftwareManager().getIpAddress()).append(":").append(ne2DeviceExt.getSoftwareManager().getIFnetPort()).append(" - ").append(this.currentValue.getNanoName());
        this.headerPane = new BGridPane(3);
        this.headerPane.setRowAlign(BValign.center);
        this.headerPane.setColumnAlign(BHalign.center);
        this.headerPane.setUniformColumnWidth(true);
        this.headerPane.add("empty", (BValue)new BLabel(""), 4);
        this.headerPane.add("title", (BValue)new BLabel(titleLabel.toString()));
        this.headerPane.add("btn", (BValue)this.editLabelsBtn);
        switch (((BNanoSchedule)this.nanoSchedule).getScheduleType().getOrdinal()) {
            case 0: {
                this.editLabelsBtn.setVisible(false);
                break;
            }
            case 1: 
            case 2: {
                this.linkTo((BComponent)this.editLabelsBtn, (Slot)BAbstractButton.actionPerformed, (Slot)editLabels);
                break;
            }
        }
        this.contentPane.setTop((BWidget)this.headerPane);
        this.registerForComponentEvents((BComponent)this.currentValue);
        this.isDragging = false;
    }

    private boolean getExceptionalDaysWritable(Context cx) {
        return !this.readonly() || ((BNanoSchedule)this.getCurrentValue()).getSpecialEvents().getPermissions(cx).hasOperatorWrite();
    }

    public void doDragStarted() {
        this.isDragging = true;
    }

    public void doDragFinished() {
        this.isDragging = false;
    }

    public void doScheduleModified() {
        BNanoConfig config;
        this.validateSchedule(this.nanoSchedule, null);
        BUInt64 persistentId = this.currentValue.getPersistentId();
        BNanoScheduleChangedArg scheduleChangedArg = new BNanoScheduleChangedArg(persistentId, (BAbstractSchedule)this.nanoSchedule.newCopy());
        BNe2DeviceExt ne2DeviceExt = this.getNe2DeviceExt();
        if (!ne2DeviceExt.isSubscribed()) {
            this.lease();
        }
        if (!(config = ne2DeviceExt.getConfig()).isSubscribed()) {
            config.lease(1);
        }
        if (config.getCommunicationSettings().getStatus().getOrdinal() == 0) {
            ne2DeviceExt.handleNanoScheduleChanged(scheduleChangedArg);
        } else {
            BDialog.error((BWidget)this, (Object)this.lex.get("deviceStatus.warning.notconnected"));
            ((BWbShell)this.getShell()).getRefreshCommand().invoke();
        }
    }

    public void doTabSelectionModified() {
        if (this.tabbedPane != null && this.tabbedPane.getSelectedLabelPane() != null) {
            tabName = this.tabbedPane.getSelectedLabelPane().getName();
        }
    }

    public void doEditLabels() {
        BasicContext cx;
        BDynamicChoiceRange value = ((BNanoSchedule)this.nanoSchedule).getLabels();
        BDynamicChoiceRangeChangedArg result = BDynamicChoiceRangeDialog.open((BWidget)this, value, true, (Context)(cx = new BasicContext(null, this.nanoSchedule.getSlotFacets(this.nanoSchedule.getSlot("labels")))));
        if (result != null && !result.getOldValue().equals((Object)result.getPendingValue())) {
            this.nanoSchedule.set("labels", (BValue)result.getPendingValue());
            this.scheduleModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleComponentEvent(BComponentEvent event) {
        Object object = syncObject;
        synchronized (object) {
            if (!this.isDragging && event.getSlotName().equals("NanoWeeklySchedule")) {
                try {
                    super.doLoadValue((BObject)this.currentValue, this.getCurrentContext());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (null != this.nanoSchedule && null != this.currentValue) {
                    this.dayEd.setWeekSchedule(this.nanoSchedule, ((BNanoSchedule)this.nanoSchedule).getWeekSchedule());
                    this.dayEd.setReadonly(this.readonly());
                    this.specialEventsEd.setAbsSchedule((BAbstractSchedule)this.currentValue.get("NanoWeeklySchedule"));
                    this.specialEventsEd.setSchedule(((BNanoSchedule)this.nanoSchedule).getSpecialEvents());
                    this.specialEventsEd.setReadonly(!this.getExceptionalDaysWritable(this.getCurrentContext()));
                    this.specialEventsEd.selected();
                    this.specialEventsEd.filterActionPerformed();
                    ((BNanoSchedule)this.nanoSchedule).getSpecialEvents().lease(3);
                }
            }
        }
    }

    private BNe2DeviceExt getNe2DeviceExt() {
        return this.currentValue.getNe2DeviceExt();
    }
}

