/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.schedules;

import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.schedules.BNanoDateRangeSchedule;
import com.ismacontrolli.nE2Link.schedules.BNanoDateSchedule;
import com.ismacontrolli.nE2Link.schedules.BNanoWeekAndDaySchedule;
import com.ismacontrolli.nE2Link.ui.schedules.BNanoDateEd;
import com.ismacontrolli.nE2Link.ui.schedules.BNanoDateRangeEd;
import com.ismacontrolli.nE2Link.ui.schedules.BNanoScheduleReferenceEd;
import com.ismacontrolli.nE2Link.ui.schedules.BNanoWeekAndDayEd;
import com.ismacontrolli.nE2Link.ui.schedules.NanoScheduleValidator;
import com.tridium.schedule.ui.BAbstractScheduleWidget;
import com.tridium.schedule.ui.BScheduleFE;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BScheduleReference;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

@NiagaraType
public class BNanoScheduleFE
extends BScheduleFE {
    public static final Type TYPE = Sys.loadType(BNanoScheduleFE.class);
    BAbstractScheduleWidget ed;
    BAbstractSchedule schedule;
    BAbstractSchedule base;
    BNe2DeviceExt ne2DeviceExt;
    protected static Logger LOGGER = Logger.getLogger(TYPE.getTypeSpec().getModuleName());

    public Type getType() {
        return TYPE;
    }

    public BNanoScheduleFE(BAbstractSchedule base, boolean resize, Context cx) {
        super(base, resize);
        this.base = base;
        this.ne2DeviceExt = this.getNe2DeviceExt();
    }

    private BAbstractScheduleWidget makeFor(BAbstractSchedule sch) {
        if (sch instanceof BNanoDateSchedule) {
            BNanoDateEd ed = new BNanoDateEd();
            ed.load(sch, (BNanoDateSchedule)sch);
            return ed;
        }
        if (sch instanceof BNanoDateRangeSchedule) {
            boolean check = ((BNanoDateRangeSchedule)sch).getStart().getYear() == -1;
            BNanoDateRangeEd ed = new BNanoDateRangeEd(true, check);
            ed.load((BNanoDateRangeSchedule)sch);
            return ed;
        }
        if (sch instanceof BNanoWeekAndDaySchedule) {
            BNanoWeekAndDayEd ed = new BNanoWeekAndDayEd((BNanoWeekAndDaySchedule)sch);
            ed.load((BNanoWeekAndDaySchedule)sch);
            return ed;
        }
        if (sch instanceof BScheduleReference) {
            BNanoScheduleReferenceEd ed = new BNanoScheduleReferenceEd(this.ne2DeviceExt, this.base, (BScheduleReference)sch);
            return ed;
        }
        return null;
    }

    public void doLoadValue(BObject value, Context cx) {
        this.schedule = (BAbstractSchedule)value;
        this.ed = this.makeFor(this.schedule);
        if (null != this.ed) {
            this.ed.setReadonly(this.isReadonly());
            this.setContent((BWidget)this.ed);
        }
    }

    public BObject doSaveValue(BObject value, Context cx) {
        return this.schedule;
    }

    void validate() throws Exception {
        NanoScheduleValidator.validate(this.schedule, this.getLexicon());
    }

    private BNe2DeviceExt getNe2DeviceExt() {
        BComplex parent;
        for (parent = this.base.getParent(); null != parent && !(parent instanceof BNe2DeviceExt); parent = parent.getParent()) {
        }
        return null != parent ? (BNe2DeviceExt)parent : null;
    }
}

