/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.schedules;

import com.ismacontrolli.nE2Link.ui.schedules.BNanoAddEventEd;
import com.ismacontrolli.nE2Link.ui.schedules.BNanoEditEventEd;
import com.ismacontrolli.nE2Link.ui.schedules.Utils;
import com.tridium.schedule.ui.BDaySlider;
import com.tridium.schedule.ui.ScheduleColors;
import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.WidgetTheme;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

@NiagaraType
@NiagaraTopics(value={@NiagaraTopic(name="clearWholeWeek"), @NiagaraTopic(name="applyToWeekDays"), @NiagaraTopic(name="applyToWholeWeek"), @NiagaraTopic(name="dragStarted"), @NiagaraTopic(name="dragFinished")})
public class BNanoDaySlider
extends BDaySlider {
    public static final Topic clearWholeWeek = BNanoDaySlider.newTopic((int)0, null);
    public static final Topic applyToWeekDays = BNanoDaySlider.newTopic((int)0, null);
    public static final Topic applyToWholeWeek = BNanoDaySlider.newTopic((int)0, null);
    public static final Topic dragStarted = BNanoDaySlider.newTopic((int)0, null);
    public static final Topic dragFinished = BNanoDaySlider.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BNanoDaySlider.class);
    private static int RANGE_BORDER = 4;
    static WidgetTheme widgetTheme = Theme.widget();
    private BDaySlider.Clipboard clipboard;
    private BStatusValue defaultValue;
    private Range dragging;
    private int dragType;
    private BFacets facets;
    private Range first;
    static BFont font = widgetTheme.getTextFont();
    static double fontOffset = font.getMaxAscent() + 1.0;
    private final int maxU = 48;
    private final int minU = 0;
    private int dragstart = 0;
    private int dragfinish = 0;
    private double pressedOffset;
    private double pressedY;
    BDaySchedule schedule;
    private Range selected;
    private boolean week;
    int units = 48;
    int[] unitLines = new int[]{0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46};
    private int[] unitY;
    private boolean dragHappened = false;
    private final Lexicon lex = this.getLexicon();
    private static final int MAX_TIME_SCHEDULES = 12;

    public void fireClearWholeWeek(BValue event) {
        this.fire(clearWholeWeek, event, null);
    }

    public void fireApplyToWeekDays(BValue event) {
        this.fire(applyToWeekDays, event, null);
    }

    public void fireApplyToWholeWeek(BValue event) {
        this.fire(applyToWholeWeek, event, null);
    }

    public void fireDragStarted(BValue event) {
        this.fire(dragStarted, event, null);
    }

    public void fireDragFinished(BValue event) {
        this.fire(dragFinished, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNanoDaySlider() {
    }

    public BNanoDaySlider(BDaySlider.Clipboard clipboard, boolean week) {
        this.clipboard = clipboard;
        this.week = week;
    }

    public void fireModified(BValue event) {
        if (null == event) {
            return;
        }
        super.fireModified(event);
    }

    public Range addRange(Object value, BTime start, BTime finish) {
        BTimeSchedule sch = new BTimeSchedule();
        sch.setStart(start);
        sch.setFinish(finish);
        sch.setEffectiveValue((BStatusValue)value);
        this.schedule.add(sch);
        Range r = new Range(this, sch);
        this.addRange(r);
        return r;
    }

    public Range addRange(Object value, int startUnit, int finishUnit) {
        if (startUnit == finishUnit && startUnit == 0) {
            finishUnit = startUnit + 1;
            this.fireModified(null);
        }
        BTimeSchedule sch = new BTimeSchedule();
        sch.setStart(BTime.make((BRelTime)BRelTime.make((long)this.unitToMillis(startUnit, true))));
        sch.setFinish(BTime.make((BRelTime)BRelTime.make((long)this.unitToMillis(finishUnit, false))));
        sch.setEffectiveValue((BStatusValue)value);
        this.schedule.add(sch);
        Range r = new Range(this, sch, startUnit, finishUnit);
        this.addRange(r);
        return r;
    }

    private void addRange(Range r) {
        Range pred = this.predecessor(r.start);
        if (pred == null) {
            r.next = this.first;
            if (r.next != null) {
                this.first.prev = r;
            }
            this.first = r;
        } else {
            r.next = pred.next;
            if (r.next != null) {
                r.next.prev = r;
            }
            r.prev = pred;
            pred.next = r;
        }
    }

    public void clearDay() {
        this.clearDay(null, false);
    }

    public void clearDay(BMouseEvent event, Boolean fireModified) {
        while (this.first != null) {
            this.remove(this.first);
        }
        if (fireModified.booleanValue()) {
            this.fireModified((BValue)event);
        }
    }

    public void copy(BDaySchedule sch) {
        this.clearDay();
        this.schedule.removeAll((Context)null);
        for (BTimeSchedule t : sch.getTimesInOrder()) {
            t = (BTimeSchedule)t.newCopy(true);
            this.schedule.add(t);
            Range r = new Range(this, t, this.millisToUnit(t.getStart().getTimeOfDayMillis(), true), this.millisToUnit(t.getFinish().getTimeOfDayMillis(), false));
            this.addRange(r);
        }
    }

    public void deselect() {
        this.selected = null;
        this.repaint();
    }

    public void doLayout(BWidget[] kids) {
        if (this.schedule != null) {
            BAbstractSchedule root = this.schedule.getRootSchedule();
            this.facets = (BFacets)root.get("facets");
        }
        if (this.unitY == null) {
            this.unitY = new int[this.units + 1];
        }
        double h = this.getHeight();
        double ppu = h / (double)this.units;
        for (int i = 0; i < this.units; ++i) {
            this.unitY[i] = (int)Math.round((double)i * ppu);
        }
        this.unitY[this.units] = (int)h - 1;
    }

    public BTimeSchedule getSelectedSchedule() {
        return this.selected == null ? null : this.selected.sch;
    }

    public Range getSelectedRange() {
        return this.selected;
    }

    public String getUnitLabel(int unit) {
        long millis = this.unitToMillis(unit, false);
        BTime t = BTime.make((BRelTime)BRelTime.make((long)millis));
        return t.toString((Context)null);
    }

    public void load(BDaySchedule schedule, BStatusValue defaultValue) {
        this.schedule = schedule;
        this.defaultValue = defaultValue;
        this.first = null;
        this.dragging = null;
        this.selected = null;
        BAbstractSchedule root = schedule.getRootSchedule();
        this.facets = (BFacets)root.get("facets");
        for (BTimeSchedule t : schedule.getTimesInOrder()) {
            int start = this.millisToUnit(t.getStart().getTimeOfDayMillis(), true);
            int finish = this.millisToUnit(t.getFinish().getTimeOfDayMillis(), false);
            Range r = new Range(this, t, start, finish);
            this.addRange(r);
        }
    }

    public void keyPressed(BKeyEvent e) {
        if (!this.isEnabled() || this.isReadonly()) {
            return;
        }
        switch (e.getKeyCode()) {
            case 8: 
            case 127: {
                if (this.selected == null) {
                    return;
                }
                e.consume();
                this.remove(this.selected);
                this.repaint();
                break;
            }
            case 9: {
                if (this.selected == null) {
                    if (this.first == null) break;
                    this.select(this.first);
                    e.consume();
                    break;
                }
                if (this.selected.next == null) break;
                this.select(this.selected.next);
                e.consume();
            }
        }
    }

    public int millisToUnit(long millis, boolean isStart) {
        if (millis == 0L) {
            return isStart ? 0 : this.units;
        }
        float mpu = 86400000 / this.units;
        return Math.round((float)millis / mpu);
    }

    public int millisToRangeUnit(long millis, boolean isStart) {
        if (millis == 0L) {
            return isStart ? 0 : this.units;
        }
        float mpu = 86400000 / this.units;
        return isStart ? Math.round((float)millis / mpu - 0.49999f) : Math.round((float)millis / mpu + 0.49999f);
    }

    public void mouseDragged(BMouseEvent e) {
        this.processMouseMotionEvent(e);
    }

    public void mouseEntered(BMouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseExited(BMouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseMoved(BMouseEvent e) {
        this.processMouseMotionEvent(e);
    }

    public void mousePressed(BMouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mousePulsed(BMouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseReleased(BMouseEvent e) {
        this.processMouseEvent(e);
        if (this.dragHappened) {
            this.dragHappened = false;
            if (this.isValidRange(this.dragging)) {
                this.updateSelectedSchedule();
                this.fireModified((BValue)e);
            } else {
                if (null != this.dragging) {
                    this.dragging.start = this.dragstart;
                    this.dragging.finish = this.dragfinish;
                    this.dragging.updateStartTime();
                    this.dragging.updateFinishTime();
                    this.dragging.width = this.getWidth();
                }
                ((BWbShell)this.getShell()).getRefreshCommand().invoke();
            }
            this.dragging = null;
        }
        this.fireDragFinished((BValue)e);
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintForeground(g);
    }

    public void popup(BMouseEvent e) {
        if (this.isReadonly()) {
            return;
        }
        BMenu menu = new BMenu();
        this.pressedY = e.getY();
        Range r = this.nanoYToRange(this.pressedY);
        if (r != null) {
            if (this.selected != r) {
                this.select(r);
            }
            menu.add((String)null, (Command)new CmdEditEvent(this, e));
            menu.add((String)null, (Command)new CmdDeleteEvent(this, e));
        } else {
            Object[] kids = this.schedule.getChildren(BAbstractSchedule.class);
            if (this.clipboard != null && this.clipboard.get() != null && this.clipboard.get() != this.schedule) {
                menu.add((String)null, (Command)new CmdPasteDay(this, e));
            }
            menu.add((String)null, (Command)new CmdAddEvent(this, e));
            if (!this.week) {
                menu.add((String)null, (Command)new CmdRemoveAllEvents(this, e));
            } else {
                if (kids.length > 0) {
                    menu.add((String)null, (Command)new CmdCopyDay(this, e));
                }
                menu.add((String)null, (Command)new CmdApplyToWeekDays(this, e));
                menu.add((String)null, (Command)new CmdApplyToWholeWeek(this, e));
                menu.add((String)null, (Command)new CmdClearDay(this, e));
                menu.add((String)null, (Command)new CmdClearWholeWeek(this, e));
            }
        }
        menu.open((BWidget)this, e.getX(), e.getY());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processMouseEvent(BMouseEvent e) {
        try {
            if (e.isPopupTrigger()) {
                this.popup(e);
                return;
            } else {
                switch (e.getId()) {
                    case 501: {
                        this.pressedY = e.getY();
                        if (e.isButton1Down()) {
                            this.dragging = this.nanoYToRange(this.pressedY);
                            if (null != this.dragging) {
                                this.dragstart = this.dragging.start;
                                this.dragfinish = this.dragging.finish;
                            }
                        }
                        if (null == this.dragging) {
                            int oneHourLater;
                            if (e.isButton1Down() && this.schedule.getTimesInOrder().length >= 12) {
                                BDialog.error((BWidget)this, (Object)this.lex.get("NanoScheduler.day.eventLimitExceeded"));
                                return;
                            }
                            if (UiEnv.get().hasMouse() || !e.isButton1Down()) {
                                return;
                            }
                            int pressedUnit = this.yToUnit(this.pressedY);
                            if (pressedUnit == (oneHourLater = Math.min(this.units, pressedUnit + 2))) {
                                return;
                            }
                            if (this.nanoYToRange(this.unitToY(pressedUnit + 1)) != null) {
                                return;
                            }
                            this.dragging = this.addRange((Object)this.newEffectiveValue(), pressedUnit, oneHourLater);
                        }
                        this.select(this.dragging);
                        if (!this.isEnabled() || this.isReadonly()) return;
                        this.startDrag(this.pressedY, false);
                        this.requestFocus();
                        return;
                    }
                    case 502: {
                        if (!this.isEnabled() || this.isReadonly()) {
                            return;
                        }
                        this.checkCursor(e.getY());
                    }
                    default: {
                        return;
                    }
                    case 504: {
                        if (!this.isEnabled() || this.isReadonly()) return;
                        if (this.dragging != null) return;
                        this.checkCursor(e.getY());
                        return;
                    }
                    case 505: {
                        if (!this.isEnabled() || this.isReadonly()) {
                            return;
                        }
                        if (this.dragging != null) return;
                        this.setMouseCursor(MouseCursor.normal);
                    }
                }
            }
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processMouseMotionEvent(BMouseEvent e) {
        if (this.isEnabled() && !this.isReadonly()) {
            switch (e.getId()) {
                case 503: {
                    this.checkCursor(e.getY());
                    break;
                }
                case 506: {
                    if (!e.isButton1Down()) {
                        return;
                    }
                    double y = e.getY();
                    if (null != this.dragging) {
                        this.handleDrag(y);
                        break;
                    }
                    if (!(y - this.pressedY >= 2.0)) break;
                    int unit = this.yToUnit(this.pressedY);
                    int roundedY = this.unitToY(unit);
                    Range range = this.nanoYToRange(roundedY);
                    if (range != null && range.finishRange > unit) {
                        return;
                    }
                    this.dragging = this.addRange((Object)this.newEffectiveValue(), this.yToUnit(this.pressedY), this.yToUnit(y));
                    this.select(this.dragging);
                    this.startDrag(y, true);
                }
            }
        }
    }

    public void remove(Range r) {
        if (r == this.first) {
            this.first = r.next;
            if (this.first != null) {
                this.first.prev = null;
            }
        } else {
            r.prev.next = r.next;
            if (r.prev.next != null) {
                r.next.prev = r.prev;
            }
        }
        if (r == this.selected) {
            this.selected = null;
        }
        this.schedule.remove((BComplex)r.sch);
    }

    public final void select(Range r) {
        if (this.selected != r) {
            this.selected = r;
            this.repaint();
            if (r != null) {
                this.fireSchSelected(this);
            }
        }
    }

    public void updateSelectedSchedule() {
        this.updateSelectedSchedule(this.selected);
    }

    public void updateSelectedSchedule(Range range) {
        if (null != range) {
            range.updateUnits();
            range.updateColors();
        }
        this.repaint();
    }

    public long unitToMillis(int unit, boolean isStart) {
        if (unit == 0) {
            return isStart ? 0L : 86400000L;
        }
        float mpu = 86400000 / this.units;
        return (long)(mpu * (float)unit);
    }

    public final int nanoUnitToY(int unit) {
        return this.unitY == null ? 0 : (unit > this.units ? this.unitY[this.units] : this.unitY[unit]);
    }

    public final Range nanoYToRange(double y) {
        Range r = this.first;
        while (r != null) {
            if (y >= r.startY() && y <= r.finishY()) {
                return r;
            }
            r = r.next;
        }
        return null;
    }

    public final int nanoYToUnit(double y) {
        double f = y / this.getHeight();
        f = (double)this.units * f;
        return (int)Math.min(Math.round(f), (long)this.units);
    }

    protected void paintBackground(Graphics g) {
        double w = this.getWidth();
        double h = this.getHeight();
        if (!this.isReadonly() && this.isEnabled()) {
            g.setBrush(Utils.clrBg);
        } else {
            g.setBrush(Utils.clrRoBg);
        }
        g.fillRect(0.0, 0.0, w, h);
        if (this.unitLines != null) {
            g.setBrush(Utils.clrFg);
            int i = this.unitLines.length;
            while (--i >= 0) {
                double y = this.nanoUnitToY(this.unitLines[i]);
                g.strokeLine(0.0, y, w, y);
            }
        }
        if (this.defaultValue != null) {
            g.setFont(font);
            g.setBrush(Utils.clrFg);
            if (this.week) {
                g.drawString(this.valueText(this.defaultValue), 2.0, 2.0 + fontOffset);
            } else {
                g.drawString(this.lex.get("NanoScheduler.day.unscheduled"), 2.0, 2.0 + fontOffset);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintForeground(Graphics g) {
        g.setFont(font);
        Range r = this.first;
        while (r != null) {
            boolean isSelected = r == this.selected;
            double w = r.width() != 0.0 ? r.width() : this.getWidth();
            double x = r.startX();
            double y = r.startY();
            double h = r.height() + 1.0;
            g.push();
            try {
                ScheduleColors sc = r.getColors();
                g.clip(x, y, w, h);
                g.setBrush(isSelected ? (this.isValidRange(r) ? Utils.clrSelCurBg : Utils.clrRoBg) : sc.getBackground((Context)null));
                g.fillRect(x, y, w, h);
                g.setBrush(Utils.clrFg);
                double tmp = y + h - 1.0;
                g.strokeLine(x, y, w, y);
                g.strokeLine(x, tmp, w, tmp);
                String text = this.rangeText(r);
                if (text != null) {
                    g.setBrush(isSelected ? Utils.clrSelFg : sc.getForeground((Context)null));
                    g.drawString(text, x + 2.0, y + fontOffset);
                    BTimeSchedule sch = r.sch;
                    if (sch != null) {
                        StringBuilder sb = new StringBuilder("(").append(sch.getStart().toString()).append(" - ").append(sch.getFinish().toString()).append(")");
                        g.drawString(sb.toString(), x + 2.0, y + font.getHeight() + fontOffset);
                    }
                }
            }
            finally {
                g.pop();
            }
            r = r.next;
        }
    }

    private void checkCursor(double y) {
        if (this.isEnabled() && !this.isReadonly()) {
            Range r = this.nanoYToRange(y);
            if (r == null) {
                this.setMouseCursor(MouseCursor.normal);
            } else if (y <= r.startY() + (double)RANGE_BORDER) {
                this.setMouseCursor(MouseCursor.nResize);
            } else if (y >= r.finishY() - (double)RANGE_BORDER) {
                this.setMouseCursor(MouseCursor.sResize);
            } else if (y > r.startY() && y < r.finishY()) {
                this.setMouseCursor(MouseCursor.openHand);
            } else {
                this.setMouseCursor(MouseCursor.normal);
            }
        }
    }

    private void handleDrag(double y) {
        boolean repaint = false;
        switch (this.dragType) {
            case 0: {
                int unit = this.yToUnit(y);
                unit = unit < this.minU ? this.minU : (unit > this.maxU ? this.maxU : unit);
                repaint = unit != this.dragging.finish;
                int h = unit - this.dragging.start;
                if (this.dragging.finish == unit || h < 1) {
                    return;
                }
                this.fireDragStarted(null);
                this.dragging.finish = unit;
                this.dragging.updateFinishTime();
                break;
            }
            case 1: {
                int h = this.dragging.finish - this.dragging.start;
                int unit = this.yToUnit(y -= this.pressedOffset);
                unit = unit < this.minU ? this.minU : (unit > this.maxU ? this.maxU : unit);
                boolean bl = repaint = unit != this.dragging.start;
                if (this.dragging.start == unit || unit + h > this.maxU) {
                    return;
                }
                this.dragging.start = unit;
                this.dragging.finish = unit + h;
                this.dragging.updateStartTime();
                this.dragging.updateFinishTime();
                break;
            }
            case 2: {
                int unit = this.yToUnit(y);
                unit = unit < this.minU ? this.minU : (unit > this.maxU ? this.maxU : unit);
                repaint = unit != this.dragging.start;
                int h = this.dragging.finish - unit;
                if (this.dragging.start == unit || h < 1) {
                    return;
                }
                this.dragging.start = unit;
                this.dragging.updateStartTime();
            }
        }
        if (repaint) {
            this.repaint();
        }
        this.dragHappened = true;
        this.fireSchDragged(null);
    }

    private void startDrag(double y, boolean create) {
        Range r = this.dragging;
        if (r != null) {
            if (y < r.finishY() - (double)RANGE_BORDER && !create) {
                if (y <= r.startY() + (double)RANGE_BORDER) {
                    this.setMouseCursor(MouseCursor.nResize);
                    this.dragType = 2;
                } else {
                    this.setMouseCursor(MouseCursor.grabHand);
                    this.dragType = 1;
                    this.pressedOffset = y - r.startY();
                    int n = this.dragging.finish - this.dragging.start;
                }
            } else {
                this.dragType = 0;
                this.setMouseCursor(MouseCursor.sResize);
            }
        } else {
            this.setMouseCursor(MouseCursor.sResize);
        }
        this.fireDragStarted(null);
    }

    private BStatusValue newEffectiveValue() {
        BStatus s;
        if (this.clipboard != null) {
            return this.clipboard.newEffectiveValue();
        }
        BStatusValue ret = (BStatusValue)this.defaultValue.newCopy(true);
        if (ret instanceof BStatusBoolean) {
            BStatusBoolean b;
            b.setValue(!(b = (BStatusBoolean)ret).getValue());
        }
        if ((s = ret.getStatus()).isNull()) {
            ret.setStatus(BStatus.makeNull((BStatus)s, (boolean)false));
        }
        return ret;
    }

    private Range predecessor(double y) {
        Range r = this.first;
        Range prev = null;
        while (r != null) {
            if (y <= (double)r.start) {
                return prev;
            }
            prev = r;
            r = r.next;
        }
        return prev;
    }

    private String rangeText(Range r) {
        try {
            BTimeSchedule t = r.sch;
            if (t == null) {
                return "???";
            }
            BStatusValue e = t.getEffectiveValue();
            return e == null ? "" : this.valueText(e);
        }
        catch (Exception e) {
            Utils.error((BWidget)this, e);
            return "-";
        }
    }

    private String valueText(BStatusValue v) {
        return v.getStatus().isNull() ? this.lex.get("NanoScheduler.day.null") : v.getValueValue().toString((Context)this.facets);
    }

    private boolean isValidRange(Range range) {
        boolean ok = false;
        if (null != range) {
            ok = true;
            Range r = this.first;
            if (r.equals(range)) {
                r = r.next;
            }
            while (r != null) {
                if (range.getStart() >= r.getStart() & range.getStart() < r.getFinish() || range.getFinish() > r.getStart() & range.getFinish() <= r.getFinish() || range.getStart() <= r.getStart() & range.getFinish() >= r.getFinish()) {
                    ok = false;
                    range.startX = this.getWidth() / 2.0 + 1.0;
                    range.width = this.getWidth() / 2.0 - 1.0;
                    r.startX = 0.0;
                    r.width = this.getWidth() / 2.0 - 1.0;
                    break;
                }
                range.startX = (r.startX = 0.0);
                range.width = (r.width = range.getSlider().getWidth());
                r = r.next;
                if (r == null || !r.equals(range)) continue;
                r = r.next;
            }
        }
        return ok;
    }

    public class Range {
        Range next;
        Range prev;
        BTimeSchedule sch;
        BNanoDaySlider slider;
        private int start;
        private int finish;
        private double startX;
        private double width;
        int startRange;
        int finishRange;
        private ScheduleColors colors;

        Range(BNanoDaySlider slider, BTimeSchedule sch) {
            this.slider = slider;
            this.sch = sch;
            this.startX = 0.0;
            this.width = this.slider.getWidth();
            this.updateUnits();
            this.updateColors();
        }

        Range(BNanoDaySlider slider, BTimeSchedule sch, int start, int finish) {
            this.slider = slider;
            this.sch = sch;
            this.start = start;
            this.finish = finish;
            this.startX = 0.0;
            this.width = this.slider.getWidth();
            this.updateRangeUnits();
            this.updateColors();
        }

        public int getStart() {
            return this.start;
        }

        public int getFinish() {
            return this.finish;
        }

        final double height() {
            double f = this.slider.nanoUnitToY(this.finish);
            double s = this.slider.nanoUnitToY(this.start);
            return Math.max(f - s, 1.0);
        }

        final double startY() {
            return this.slider.nanoUnitToY(this.start);
        }

        final double finishY() {
            return this.slider.nanoUnitToY(this.finish);
        }

        final double startX() {
            return this.startX;
        }

        final double width() {
            return this.width;
        }

        public Object getValue() {
            return this.sch.getEffectiveValue();
        }

        public ScheduleColors getColors() {
            return this.colors;
        }

        public BNanoDaySlider getSlider() {
            return this.slider;
        }

        final void updateFinishTime() {
            this.sch.setFinish(BTime.make((BRelTime)BRelTime.make((long)BNanoDaySlider.this.unitToMillis(this.finish, false))));
            this.updateRangeUnits();
        }

        final void updateStartTime() {
            this.sch.setStart(BTime.make((BRelTime)BRelTime.make((long)BNanoDaySlider.this.unitToMillis(this.start, true))));
            this.updateRangeUnits();
        }

        final void updateUnits() {
            this.start = BNanoDaySlider.this.millisToUnit(this.sch.getStart().getTimeOfDayMillis(), true);
            this.finish = BNanoDaySlider.this.millisToUnit(this.sch.getFinish().getTimeOfDayMillis(), false);
            this.updateRangeUnits();
        }

        final void updateRangeUnits() {
            this.startRange = BNanoDaySlider.this.millisToRangeUnit(this.sch.getStart().getTimeOfDayMillis(), true);
            this.finishRange = BNanoDaySlider.this.millisToRangeUnit(this.sch.getFinish().getTimeOfDayMillis(), false);
        }

        void updateColors() {
            this.colors = new ScheduleColors(this.sch.getEffectiveValue());
        }
    }

    private class CmdApplyToWholeWeek
    extends Command {
        private BNanoDaySlider owner;
        private BMouseEvent event;

        CmdApplyToWholeWeek(BNanoDaySlider owner, BMouseEvent event) {
            super((BWidget)owner, BNanoDaySlider.this.lex.get("NanoScheduler.day.applyWholeWeek"));
            this.owner = owner;
            this.event = event;
        }

        public CommandArtifact doInvoke() {
            this.owner.fireApplyToWholeWeek((BValue)this.owner.schedule);
            return null;
        }
    }

    private class CmdApplyToWeekDays
    extends Command {
        private BNanoDaySlider owner;
        private BMouseEvent event;

        CmdApplyToWeekDays(BNanoDaySlider owner, BMouseEvent event) {
            super((BWidget)owner, BNanoDaySlider.this.lex.get("NanoScheduler.day.applyWeekdays"));
            this.owner = owner;
            this.event = event;
        }

        public CommandArtifact doInvoke() {
            this.owner.fireApplyToWeekDays((BValue)this.owner.schedule);
            return null;
        }
    }

    private class CmdClearDay
    extends Command {
        private BNanoDaySlider owner;
        private BMouseEvent event;

        CmdClearDay(BNanoDaySlider owner, BMouseEvent event) {
            super((BWidget)owner, BNanoDaySlider.this.lex.get("NanoScheduler.day.clearDay"));
            this.owner = owner;
            this.event = event;
        }

        public CommandArtifact doInvoke() {
            this.owner.clearDay(this.event, true);
            this.owner.repaint();
            return null;
        }
    }

    private class CmdClearWholeWeek
    extends Command {
        private BNanoDaySlider owner;
        private BMouseEvent event;

        CmdClearWholeWeek(BNanoDaySlider owner, BMouseEvent event) {
            super((BWidget)owner, BNanoDaySlider.this.lex.get("NanoScheduler.day.clearWeek"));
            this.owner = owner;
            this.event = event;
        }

        public CommandArtifact doInvoke() {
            this.owner.fireClearWholeWeek(null);
            return null;
        }
    }

    private class CmdPasteDay
    extends Command {
        private BNanoDaySlider owner;
        private BMouseEvent event;

        CmdPasteDay(BNanoDaySlider owner, BMouseEvent event) {
            super((BWidget)owner, BNanoDaySlider.this.lex.get("NanoScheduler.day.pasteDay"));
            this.owner = owner;
            this.event = event;
        }

        public CommandArtifact doInvoke() {
            if (this.owner.clipboard != null) {
                this.owner.clearDay();
                this.owner.copy(this.owner.clipboard.get());
            }
            this.owner.repaint();
            this.owner.fireModified((BValue)this.event);
            return null;
        }
    }

    private class CmdCopyDay
    extends Command {
        private BNanoDaySlider owner;
        private BMouseEvent event;

        CmdCopyDay(BNanoDaySlider owner, BMouseEvent event) {
            super((BWidget)owner, BNanoDaySlider.this.lex.get("NanoScheduler.day.copyDay"));
            this.owner = owner;
            this.event = event;
        }

        public CommandArtifact doInvoke() {
            if (this.owner.clipboard != null) {
                this.owner.clipboard.set((BDaySchedule)this.owner.schedule.newCopy(true));
            }
            return null;
        }
    }

    private class CmdEditEvent
    extends Command {
        private BNanoDaySlider owner;
        private BMouseEvent event;

        CmdEditEvent(BNanoDaySlider owner, BMouseEvent event) {
            super((BWidget)owner, BNanoDaySlider.this.lex.get("NanoScheduler.editEvent"));
            this.owner = owner;
            this.event = event;
        }

        public CommandArtifact doInvoke() {
            Range selectedRange = this.owner.getSelectedRange();
            if (null == selectedRange) {
                return null;
            }
            BTimeSchedule selectedSchedule = selectedRange.sch;
            BNanoEditEventEd ed = new BNanoEditEventEd(BNanoDaySlider.this.schedule, selectedSchedule);
            while (1 == BDialog.open((BWidget)this.owner, (String)BNanoDaySlider.this.lex.get("NanoScheduler.editEvent"), (Object)((Object)ed), (int)3, (BImage)null)) {
                try {
                    if (!this.isValidInput(ed, this.owner, selectedSchedule)) {
                        BDialog.error((BWidget)this.owner, (Object)BNanoDaySlider.this.lex.get("NanoScheduler.invalidInput"));
                        continue;
                    }
                    selectedSchedule.setStart(ed.getStartFE());
                    selectedSchedule.setFinish(ed.getFinishFE());
                    selectedSchedule.setEffectiveValue(ed.getEffectiveValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.owner.updateSelectedSchedule(selectedRange);
                this.owner.repaint();
                this.owner.fireModified((BValue)this.event);
                break;
            }
            return null;
        }

        private boolean isValidInput(BNanoEditEventEd ed, BNanoDaySlider owner, BTimeSchedule selectedSchedule) throws Exception {
            boolean ok = true;
            if (!ed.getFinishFE().equals((Object)BTime.MIDNIGHT) && ed.getFinishFE().isBefore(ed.getStartFE())) {
                ok = false;
            }
            if (ok) {
                Range r = owner.first;
                if (this.areEqualSchedules(r.sch, selectedSchedule)) {
                    r = r.next;
                }
                BTime midnight = BTime.make((int)0, (int)0, (int)0);
                while (r != null) {
                    if ((ed.getStartFE().equals((Object)r.sch.getStart()) || ed.getStartFE().isAfter(r.sch.getStart())) & ed.getStartFE().isBefore(r.sch.getFinish()) || ed.getFinishFE().isAfter(r.sch.getStart()) & (ed.getFinishFE().equals((Object)r.sch.getFinish()) || ed.getFinishFE().isBefore(r.sch.getFinish()))) {
                        ok = false;
                        break;
                    }
                    if (r.sch.getFinish().equals((Object)midnight)) {
                        if ((ed.getStartFE().equals((Object)r.sch.getStart()) || ed.getStartFE().isBefore(r.sch.getStart())) & ed.getFinishFE().equals((Object)r.sch.getFinish())) {
                            ok = false;
                            break;
                        }
                    } else if ((ed.getStartFE().equals((Object)r.sch.getStart()) || ed.getStartFE().isBefore(r.sch.getStart())) & (ed.getFinishFE().equals((Object)r.sch.getFinish()) || ed.getFinishFE().isAfter(r.sch.getFinish()))) {
                        ok = false;
                        break;
                    }
                    if ((r = r.next) == null || !this.areEqualSchedules(r.sch, selectedSchedule)) continue;
                    r = r.next;
                }
            }
            return ok;
        }

        private boolean areEqualSchedules(BTimeSchedule ts1, BTimeSchedule ts2) {
            if (ts1.equals((Object)ts2)) {
                return true;
            }
            return ts1.getStart().equals((Object)ts2.getStart()) && ts1.getFinish().equals((Object)ts2.getFinish()) && ts1.getName().equals(ts2.getName());
        }
    }

    private class CmdRemoveAllEvents
    extends Command {
        private BNanoDaySlider owner;
        private BMouseEvent event;

        CmdRemoveAllEvents(BNanoDaySlider owner, BMouseEvent event) {
            super((BWidget)owner, BNanoDaySlider.this.lex.get("NanoScheduler.removeAllEvents"));
            this.owner = owner;
            this.event = event;
        }

        public CommandArtifact doInvoke() {
            while (this.owner.first != null) {
                this.owner.remove(BNanoDaySlider.this.first);
                this.owner.repaint();
            }
            this.owner.fireModified((BValue)this.event);
            return null;
        }
    }

    private class CmdDeleteEvent
    extends Command {
        private BNanoDaySlider owner;
        private BMouseEvent event;

        CmdDeleteEvent(BNanoDaySlider owner, BMouseEvent event) {
            super((BWidget)owner, BNanoDaySlider.this.lex.get("NanoScheduler.deleteEvent"));
            this.owner = owner;
            this.event = event;
        }

        public CommandArtifact doInvoke() {
            this.owner.remove(this.owner.selected);
            this.owner.repaint();
            this.owner.fireModified((BValue)this.event);
            return null;
        }
    }

    private class CmdAddEvent
    extends Command {
        private BNanoDaySlider owner;
        private BMouseEvent event;

        CmdAddEvent(BNanoDaySlider owner, BMouseEvent event) {
            super((BWidget)owner, BNanoDaySlider.this.lex.get("NanoScheduler.addEvent"));
            this.owner = owner;
            this.event = event;
        }

        public CommandArtifact doInvoke() {
            if (this.owner.schedule.getTimesInOrder().length >= 12) {
                BDialog.error((BWidget)this.owner, (Object)BNanoDaySlider.this.lex.get("NanoScheduler.day.eventLimitExceeded"));
                return null;
            }
            BTime start = BTime.make((BRelTime)BRelTime.make((long)this.owner.unitToMillis(this.owner.nanoYToUnit(this.event.getY()), true)));
            BTime finish = start.add(BRelTime.makeHours((int)1));
            BNanoAddEventEd ed = new BNanoAddEventEd(BNanoDaySlider.this.schedule, start, finish);
            while (1 == BDialog.open((BWidget)this.owner, (String)BNanoDaySlider.this.lex.get("NanoScheduler.event"), (Object)((Object)ed), (int)3, (BImage)null)) {
                try {
                    if (!this.isValidInput(ed, this.owner)) {
                        BDialog.error((BWidget)this.owner, (Object)BNanoDaySlider.this.lex.get("NanoScheduler.invalidInput"));
                        continue;
                    }
                    this.owner.addRange((Object)ed.getEffectiveValue(), ed.getStartFE(), ed.getFinishFE());
                    this.owner.repaint();
                    this.owner.fireModified((BValue)this.event);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            return null;
        }

        private boolean isValidInput(BNanoAddEventEd ed, BNanoDaySlider owner) throws Exception {
            boolean ok = true;
            if (!ed.getFinishFE().equals((Object)BTime.MIDNIGHT) && ed.getFinishFE().isBefore(ed.getStartFE())) {
                ok = false;
            }
            if (ok) {
                Range r = owner.first;
                while (r != null) {
                    if ((ed.getStartFE().equals((Object)r.sch.getStart()) || ed.getStartFE().isAfter(r.sch.getStart())) & ed.getStartFE().isBefore(r.sch.getFinish()) || ed.getFinishFE().isAfter(r.sch.getStart()) & (ed.getFinishFE().equals((Object)r.sch.getFinish()) || ed.getFinishFE().isBefore(r.sch.getFinish())) || (ed.getStartFE().equals((Object)r.sch.getStart()) || ed.getStartFE().isBefore(r.sch.getStart())) & (ed.getFinishFE().equals((Object)r.sch.getFinish()) || ed.getFinishFE().isAfter(r.sch.getFinish()))) {
                        ok = false;
                        break;
                    }
                    r = r.next;
                }
            }
            return ok;
        }
    }
}

