/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.schedules;

import com.ismacontrolli.nE2Link.schedules.BNanoDateRangeSchedule;
import com.ismacontrolli.nE2Link.schedules.BNanoDateSchedule;
import com.ismacontrolli.nE2Link.schedules.BNanoWeekAndDaySchedule;
import com.ismacontrolli.nE2Link.schedules.utils.BNanoBacnetPriorityEnum;
import com.ismacontrolli.nE2Link.schedules.utils.ScheduleUtils;
import com.ismacontrolli.nE2Link.ui.schedules.BNanoCompositeEd;
import com.ismacontrolli.nE2Link.ui.schedules.BNanoScheduleFE;
import com.ismacontrolli.nE2Link.ui.schedules.NanoSelectionItem;
import com.tridium.schedule.ui.BAbstractScheduleWidget;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BScheduleReference;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="selectionChanged"), @NiagaraAction(name="bacPriorityChanged")})
public class BNanoAddEditEventDlg
extends BAbstractScheduleWidget {
    public static final Action selectionChanged = BNanoAddEditEventDlg.newAction((int)0, null);
    public static final Action bacPriorityChanged = BNanoAddEditEventDlg.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BNanoAddEditEventDlg.class);
    Context cx;
    BNanoCompositeEd ed;
    BEdgePane edgePane;
    BNanoScheduleFE fe;
    BTextField name;
    boolean resize;
    BListDropDown bacnetPriority;
    BAbstractSchedule selected;
    BAbstractSchedule sch;
    BListDropDown typesList;
    private final Lexicon lex = this.getLexicon();

    public void selectionChanged() {
        this.invoke(selectionChanged, null, null);
    }

    public void bacPriorityChanged() {
        this.invoke(bacPriorityChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNanoAddEditEventDlg(BNanoCompositeEd ed, String defaultName, BAbstractSchedule sch, boolean resize, Context cx) {
        this.ed = ed;
        this.cx = cx;
        this.resize = resize;
        this.sch = sch;
        this.typesList = new BListDropDown();
        BList list = this.typesList.getList();
        list.setMultipleSelection(false);
        this.loadList(list);
        this.linkTo((BComponent)this.typesList, (Slot)BListDropDown.listActionPerformed, (Slot)selectionChanged);
        this.bacnetPriority = new BListDropDown();
        BList priorityList = this.bacnetPriority.getList();
        priorityList.setMultipleSelection(false);
        this.loadPriorityList(priorityList);
        this.name = new BTextField(defaultName);
        BGridPane gp = new BGridPane(3);
        gp.setValign(BValign.center);
        gp.setHalign(BHalign.left);
        BGridPane gp1 = new BGridPane(1);
        gp1.setValign(BValign.center);
        gp1.setHalign(BHalign.left);
        gp1.add(null, (BValue)new BLabel(this.lex.get("NanoScheduler.bacnetPriority")));
        gp1.add(null, (BValue)this.bacnetPriority);
        BGridPane gp2 = new BGridPane(1);
        gp2.setValign(BValign.center);
        gp2.setHalign(BHalign.left);
        gp2.add(null, (BValue)new BLabel(this.lex.get("NanoScheduler.scheduleType")));
        gp2.add(null, (BValue)this.typesList);
        BGridPane gp3 = new BGridPane(1);
        gp3.setValign(BValign.center);
        gp3.setHalign(BHalign.left);
        gp3.add(null, (BValue)new BLabel(this.lex.get("NanoScheduler.name")));
        gp3.add(null, (BValue)this.name);
        gp.add("gp1", (BValue)gp1);
        gp.add("gp2", (BValue)gp2);
        gp.add("gp3", (BValue)gp3);
        this.edgePane = new BEdgePane();
        this.edgePane.setTop((BWidget)gp);
        this.setContent((BWidget)this.edgePane);
        if (sch != null) {
            if (sch instanceof BNanoDateSchedule) {
                this.typesList.setSelectedIndex(0);
            } else if (sch instanceof BNanoDateRangeSchedule) {
                this.typesList.setSelectedIndex(1);
            } else if (sch instanceof BNanoWeekAndDaySchedule) {
                this.typesList.setSelectedIndex(2);
            } else if (sch instanceof BScheduleReference) {
                this.typesList.setSelectedIndex(3);
            }
            this.bacnetPriority.setSelectedIndex(((BNanoBacnetPriorityEnum)sch.get(ScheduleUtils.BACNET_PRIORITY)).getOrdinal() - 1);
        } else {
            this.typesList.setSelectedIndex(0);
            this.bacnetPriority.setSelectedIndex(15);
        }
        this.linkTo((BComponent)this.bacnetPriority, (Slot)BListDropDown.listActionPerformed, (Slot)bacPriorityChanged);
        this.doSelectionChanged();
    }

    public void doSelectionChanged() {
        NanoSelectionItem item = (NanoSelectionItem)this.typesList.getSelectedItem();
        this.selected = (BAbstractSchedule)item.value;
        this.fe = new BNanoScheduleFE(this.ed.getView().getBase(), this.resize, this.cx);
        if (null != this.sch && this.selected.getType().equals(this.sch.getType())) {
            this.fe.loadValue((BObject)this.sch, this.cx);
        } else {
            this.fe.loadValue((BObject)this.selected, this.cx);
            this.sch = this.selected;
        }
        BBorderPane bp = new BBorderPane((BWidget)this.fe);
        this.edgePane.setCenter((BWidget)bp);
        BWidgetShell shell = this.getShell();
        if (shell instanceof BDialog) {
            BDialog d = (BDialog)shell;
            this.computePreferredSize();
            d.setScreenSizeToPreferredSize();
            d.relayout();
        }
    }

    public void doBacPriorityChanged() {
        if (this.sch.get(ScheduleUtils.BACNET_PRIORITY) == null) {
            this.sch.add(ScheduleUtils.BACNET_PRIORITY, (BValue)BNanoBacnetPriorityEnum.DEFAULT, 4);
        }
        this.sch.set(ScheduleUtils.BACNET_PRIORITY, (BValue)BNanoBacnetPriorityEnum.make((int)(this.bacnetPriority.getSelectedIndex() + 1)));
    }

    public BAbstractSchedule getSchedule() {
        BAbstractSchedule schedule = (BAbstractSchedule)(null != this.sch ? this.sch.newCopy(true) : this.selected.newCopy(true));
        return schedule instanceof BScheduleReference ? schedule : new BDailySchedule(schedule);
    }

    public String name() {
        return this.name.getText();
    }

    public void validate() throws Exception {
        if (this.fe != null) {
            this.fe.validate();
        }
    }

    void loadList(BList list) {
        String str = this.lex.get("NanoScheduler.datePattern");
        list.addItem((Object)new NanoSelectionItem(str, new BNanoDateSchedule()));
        str = this.lex.get("NanoScheduler.dateRangeSchedule");
        list.addItem((Object)new NanoSelectionItem(str, new BNanoDateRangeSchedule()));
        str = this.lex.get("NanoScheduler.weekAndDaySchedule");
        list.addItem((Object)new NanoSelectionItem(str, new BNanoWeekAndDaySchedule()));
        if (this.ed.controlSchedule) {
            str = this.lex.get("NanoScheduler.calendar");
            list.addItem((Object)new NanoSelectionItem(str, new BScheduleReference()));
        }
    }

    void loadPriorityList(BList list) {
        for (int i = 1; i <= 16; ++i) {
            list.addItem((Object)i);
        }
    }
}

