/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.schedules;

import com.ismacontrolli.nE2Link.BNanoComponent;
import com.ismacontrolli.nE2Link.ui.schedules.BNanoScheduleLoadingDialog;
import com.tridium.schedule.ui.BAbstractScheduleView;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BIScheduleValidator;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.util.BIValidator;
import javax.baja.util.Lexicon;
import org.jetbrains.annotations.NotNull;

@NiagaraType
public abstract class BNanoAbstractScheduleView
extends BAbstractScheduleView {
    public static final Type TYPE = Sys.loadType(BNanoAbstractScheduleView.class);
    protected BNanoComponent currentValue;
    private BAbstractSchedule base;
    protected BAbstractSchedule nanoSchedule;
    protected final Lexicon lex = this.getLexicon();
    private boolean loading = false;

    public Type getType() {
        return TYPE;
    }

    protected BNanoAbstractScheduleView() {
    }

    protected void doLoadValue(@NotNull BObject value, Context cx) throws Exception {
        try {
            this.currentValue = (BNanoComponent)this.getCurrentValue();
            String nanoName = this.currentValue.getOriginNameFromLibrary();
            boolean isCalendar = nanoName.equals("Library.Schedules.Calendar");
            this.base = isCalendar ? (BAbstractSchedule)this.currentValue.get("NanoCalendar") : (BAbstractSchedule)this.currentValue.get("NanoWeeklySchedule");
            if (null != this.base) {
                this.nanoSchedule = (BAbstractSchedule)this.base.newCopy(true);
            } else {
                this.showLoadingDialog();
            }
            this.context = cx;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showLoadingDialog() {
        if (!this.loading) {
            this.loading = true;
            int confirm = BNanoScheduleLoadingDialog.show((BWidget)this, this.currentValue);
            if (confirm == 3) {
                this.refresh();
            }
        }
    }

    public boolean readonly() {
        return false;
    }

    public BAbstractSchedule getBase() {
        return this.base;
    }

    protected void validateSchedule(BAbstractSchedule schedule, Context cx) {
        schedule.loadSlots();
        SlotCursor sc = schedule.getProperties();
        while (sc.next(BIScheduleValidator.class)) {
            BIValidator v = (BIValidator)sc.get();
            v.validate((BObject)schedule, cx);
        }
    }
}

