/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.notifications;

import com.ismacontrolli.nE2Link.notifications.BRefreshTargets;
import com.ismacontrolli.nE2Link.ui.BNanoBackupManager;
import com.ismacontrolli.nE2Link.ui.BNanoSystemDateTimeEd;
import com.ismacontrolli.nE2Link.ui.schedules.BNanoScheduleView;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.workbench.propsheet.BFieldEditorSheet;
import com.tridium.workbench.propsheet.BPropertySheet;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BSideBarPane;
import com.tridium.workbench.sidebars.BNavSideBar;
import com.tridium.workbench.slotsheet.BSlotSheet;
import com.tridium.workbench.util.WbUtil;
import java.util.logging.Logger;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.Command;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.BNotification;
import javax.baja.wiresheet.BWireSheet;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.NavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeNode;
import javax.baja.workbench.sidebar.BIWbSideBar;
import javax.baja.workbench.util.BNotificationHandler;
import javax.baja.workbench.view.BWbComponentView;
import javax.baja.workbench.view.BWbView;
import org.jetbrains.annotations.NotNull;

@NiagaraType(agent={@AgentOn(types={"nE2Link:RefreshNotification"}, requiredPermissions="ri")})
public class BRefreshNotificationHandler
extends BNotificationHandler {
    public static final Type TYPE = Sys.loadType(BRefreshNotificationHandler.class);
    private static Logger LOGGER = Logger.getLogger(TYPE.getTypeSpec().getModuleName());
    private static final Type[] BLACKLISTED_VIEWS = new Type[]{BNanoSystemDateTimeEd.TYPE, BNanoBackupManager.TYPE, BNanoScheduleView.TYPE};

    public Type getType() {
        return TYPE;
    }

    private boolean isBlacklistedView(BWbView activeView) {
        if (activeView == null) {
            return true;
        }
        for (Type blacklistedType : BLACKLISTED_VIEWS) {
            if (!activeView.getType().is(blacklistedType)) continue;
            return true;
        }
        return false;
    }

    private boolean refreshPropertySheet(BWbView activeView, BRefreshTargets refreshTargets) {
        return activeView.getType().is(BPropertySheet.TYPE) && (refreshTargets.isPropertySheet() || refreshTargets.isActiveView());
    }

    private boolean refreshWireSheet(BWbView activeView, BRefreshTargets refreshTargets) {
        return activeView.getType().is(BWireSheet.TYPE) && (refreshTargets.isPropertySheet() || refreshTargets.isActiveView());
    }

    private boolean refreshSlotSheet(BWbView activeView, BRefreshTargets refreshTargets) {
        return activeView.getType().is(BSlotSheet.TYPE) && (refreshTargets.isSlotSheet() || refreshTargets.isActiveView());
    }

    private boolean refreshActiveView(BWbView activeView, BRefreshTargets refreshTargets) {
        return !this.refreshPropertySheet(activeView, refreshTargets) && !this.refreshWireSheet(activeView, refreshTargets) && !this.refreshSlotSheet(activeView, refreshTargets) && activeView.getType().is(BWbComponentView.TYPE) && refreshTargets.isActiveView();
    }

    public void handle(BWbShell shell, @NotNull BNotification notification, Context context) {
        BISession session;
        BObject notifyingObject;
        if (shell == null) {
            return;
        }
        BRefreshTargets refreshTargets = (BRefreshTargets)notification.get("refreshTargets");
        if (refreshTargets == null || refreshTargets.isEmpty()) {
            return;
        }
        BWbView activeView = shell.getActiveView();
        if (this.isBlacklistedView(activeView)) {
            return;
        }
        String debugMessage = notification.get("debugMessage").toString();
        BOrd notifyingComponentOrd = (BOrd)notification.get("componentOrd");
        BComponent notifyingComponent = null;
        if (notifyingComponentOrd != null && (notifyingObject = (notifyingComponentOrd = BOrd.make((BOrd)BOrd.make((BOrd)(session = WbUtil.findSession((BWbEditor)activeView)).getAbsoluteOrd(), (String)"station:"), (BOrd)notifyingComponentOrd)).get()).isComponent()) {
            notifyingComponent = (BComponent)notifyingObject;
        }
        BComponent componentInView = activeView.getCurrentValue() instanceof BComponent ? activeView.getCurrentValue().asComponent() : null;
        Command refreshCommand = shell.getRefreshCommand();
        if (this.refreshPropertySheet(activeView, refreshTargets)) {
            BPropertySheet propSheet = (BPropertySheet)activeView;
            if (refreshCommand != null && (notifyingComponent == null || notifyingComponent.equals((Object)componentInView) || notifyingComponent.isDescendentOf(componentInView))) {
                BTitlePane titlePane = (BTitlePane)propSheet.getChildWidgets()[0];
                BEdgePane mainContent = (BEdgePane)titlePane.getContent();
                BFieldEditorSheet fieldEditorSheet = (BFieldEditorSheet)mainContent.getCenter();
                BScrollPane scrollPane = (BScrollPane)fieldEditorSheet.getContent();
                refreshCommand.invoke();
                LOGGER.finest(String.format("Refreshed Property Sheet: %s\nComponent in current view: %s\nComponent in notification: %s", debugMessage, componentInView != null ? componentInView.getSlotPathOrd().toString() : "null", notifyingComponent != null ? notifyingComponent.getSlotPathOrd().toString() : "null"));
                scrollPane.relayout();
            }
        }
        if (this.refreshWireSheet(activeView, refreshTargets)) {
            boolean isSummary;
            BWireSheet wireSheet = (BWireSheet)activeView;
            BWireSheetPane wireSheetPane = wireSheet.getWireSheetPane();
            BComponent parent = notifyingComponent != null ? (BComponent)notifyingComponent.getParent() : null;
            BComponent grandParent = parent != null ? (BComponent)parent.getParent() : null;
            int notifyingComponentFlags = parent != null ? parent.getFlags((Slot)notifyingComponent.getPropertyInParent()) : 0;
            boolean isHidden = (notifyingComponentFlags & 4) != 0;
            boolean bl = isSummary = (notifyingComponentFlags & 8) != 0;
            if (refreshCommand != null && componentInView != null && (notifyingComponent == null || componentInView.equals((Object)parent) || componentInView.equals((Object)grandParent) && isSummary && !isHidden)) {
                try {
                    refreshCommand.doInvoke();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                wireSheetPane.relayout();
                LOGGER.finest(String.format("Refreshed Wiresheet: %s\nComponent in current view: %s\nComponent in notification: %s", debugMessage, componentInView != null ? componentInView.getSlotPathOrd().toString() : "null", notifyingComponent != null ? notifyingComponent.getSlotPathOrd().toString() : "null"));
            }
        }
        if (this.refreshSlotSheet(activeView, refreshTargets) && refreshCommand != null && (notifyingComponent == null || notifyingComponent.equals((Object)componentInView))) {
            refreshCommand.invoke();
            LOGGER.finest(String.format("Refreshed Slot Sheet: %s\nComponent in current view: %s\nComponent in notification: %s", debugMessage, componentInView != null ? componentInView.getSlotPathOrd().toString() : "null", notifyingComponent != null ? notifyingComponent.getSlotPathOrd().toString() : "null"));
        }
        if (this.refreshActiveView(activeView, refreshTargets) && refreshCommand != null && (notifyingComponent == null || notifyingComponent.equals((Object)componentInView))) {
            refreshCommand.invoke();
            LOGGER.finest(String.format("Refreshed Active View: %s\nComponent in current view: %s\nComponent in notification: %s", debugMessage, componentInView != null ? componentInView.getSlotPathOrd().toString() : "null", notifyingComponent != null ? notifyingComponent.getSlotPathOrd().toString() : "null"));
        }
        if (refreshTargets.isTreeNode() && shell instanceof BNiagaraWbShell && notifyingComponent != null) {
            BSideBarPane sideBarPane = ((BNiagaraWbShell)shell).pane.getSideBar();
            for (BIWbSideBar sideBar : sideBarPane.list()) {
                BOrd navOrd;
                BNavSideBar navSideBar;
                BNavTree navTree;
                NavTreeModel model;
                NavTreeNode navTreeNode;
                if (!sideBar.getType().is(BNavSideBar.TYPE) || (navTreeNode = (model = (NavTreeModel)(navTree = (navSideBar = (BNavSideBar)sideBar).getTree()).getModel()).lookup(navOrd = notifyingComponent.getNavOrd())) == null) continue;
                NavTreeNode parentNode = (NavTreeNode)navTreeNode.getParent();
                parentNode.refresh();
                LOGGER.finest(String.format("NavTreeNode %s refreshed: %s\ntree node nav ord: %s", navTreeNode.getText(), debugMessage, navOrd));
            }
        }
    }
}

