/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.notifications;

import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.notifications.BPasswordChangeNotification;
import com.ismacontrolli.nE2Link.security.BNanoUser;
import com.tridium.workbench.util.WbUtil;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.commands.InvokeActionCommand;
import javax.baja.util.BNotification;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.util.BNotificationHandler;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"nE2Link:PasswordChangeNotification"}, requiredPermissions="ri")})
public class BPasswordChangeNotificationHandler
extends BNotificationHandler {
    public static final Type TYPE = Sys.loadType(BPasswordChangeNotificationHandler.class);

    public Type getType() {
        return TYPE;
    }

    public void handle(BWbShell shell, BNotification notify, Context cx) {
        BNanoUser user;
        BOrd absoluteOrd;
        if (shell == null || !(notify instanceof BPasswordChangeNotification)) {
            return;
        }
        BPasswordChangeNotification passwordChangeNotification = (BPasswordChangeNotification)notify;
        BOrd sourceOrd = passwordChangeNotification.getSourceOrd();
        BWbView activeView = shell.getActiveView();
        if (activeView != null) {
            BISession viewSession = WbUtil.findSession((BWbEditor)activeView);
            absoluteOrd = viewSession.getAbsoluteOrd();
        } else {
            String[] sessionOrd = shell.getActiveOrd().toString().split("\\|station");
            absoluteOrd = sessionOrd.length > 0 ? BOrd.make((String)sessionOrd[0]) : BOrd.make((String)"local:|foxs:");
        }
        sourceOrd = BOrd.make((BOrd)BOrd.make((BOrd)absoluteOrd, (String)"station:"), (BOrd)sourceOrd);
        try {
            user = (BNanoUser)sourceOrd.get();
        }
        catch (Exception e) {
            sourceOrd = BOrd.make((BOrd)BOrd.make((String)"local:|fox:|station:"), (BOrd)sourceOrd);
            user = (BNanoUser)sourceOrd.get();
        }
        if (user == null) {
            throw new RuntimeException("Could not resolve session ORD");
        }
        InvokeActionCommand actionCommand = new InvokeActionCommand((BWidget)shell, (BComponent)user, BNanoUser.cp);
        try {
            actionCommand.doInvoke();
            user.getNe2DeviceExt().invoke(BNe2DeviceExt.verifyPasswordChange, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

