/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.logs;

import com.ismacontrolli.nE2Link.jobs.BLogFilter;
import com.ismacontrolli.nE2Link.jobs.BRetrieveLogDataJob;
import com.tridium.workbench.util.WbUtil;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

@NiagaraType
@NiagaraAction(name="closePressed", flags=4)
public class BLogProgressDialog
extends BDialog {
    public static final Action closePressed = BLogProgressDialog.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BLogProgressDialog.class);
    BButton btnClose = new BButton();
    Context callContext;
    BTextEditorPane textPane;
    BTextEditor textEditor;
    BLogFilter filter;
    int result;
    private static final Lexicon LEX = Lexicon.make(BLogProgressDialog.class);
    private static final int CLOSE = 16;

    public void closePressed() {
        this.invoke(closePressed, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static int open(BWidget owner, String title, String initialText, BLogFilter filter, Context callContext) {
        BLogProgressDialog dialog = new BLogProgressDialog(owner, title, initialText, filter, callContext);
        dialog.setBoundsCenteredOnOwner();
        dialog.open();
        return dialog.result;
    }

    private BLogProgressDialog(BWidget owner, String title, String initialText, BLogFilter filter, Context callContext) {
        super(owner, title, true);
        this.filter = filter;
        this.callContext = callContext;
        this.textEditor = new BTextEditor(initialText, false);
        this.textPane = new BTextEditorPane(this.textEditor, 20, 110);
        this.btnClose.setText(LEX.get("LogProgressDialog.close", "Close"));
        this.btnClose.setEnabled(false);
        BGridPane buttonGrid = new BGridPane(1);
        buttonGrid.setValign(BValign.center);
        buttonGrid.add("Close", (BValue)this.btnClose);
        BEdgePane edgePane = new BEdgePane();
        edgePane.setCenter((BWidget)this.textPane);
        edgePane.setBottom((BWidget)buttonGrid);
        this.setContent((BWidget)edgePane);
        this.linkTo("lkClose", (BComponent)this.btnClose, (Slot)BButton.actionPerformed, (Slot)closePressed);
        this.doProcess();
    }

    public void setText(String text) {
        this.textEditor.setText(text);
    }

    public BButton getDefaultButton() {
        return this.btnClose;
    }

    public void doClosePressed() {
        this.result = 16;
        this.close();
    }

    private void doProcess() {
        Thread dialogThread = new Thread(() -> {
            BRetrieveLogDataJob logDataJob = new BRetrieveLogDataJob((BLogFilter)this.filter.newCopy());
            BJobService jobService = null;
            jobService = this.getOwner() instanceof BWbShell ? (BJobService)WbUtil.findService(null, (Type)BJobService.TYPE, (BWbShell)((BWbShell)this.getOwner())) : (BJobService)WbUtil.findService((BWidget)this.getOwner(), (Type)BJobService.TYPE);
            if (jobService == null) {
                this.setText(LEX.get("LogData.noService"));
                this.btnClose.setEnabled(true);
                return;
            }
            BOrd jobOrd = jobService.submit((BJob)logDataJob, this.callContext);
            BOrd runningJobOrd = BOrd.make((BOrd)jobService.getSpace().getAbsoluteOrd(), (BOrd)jobOrd);
            BRetrieveLogDataJob runningJob = null;
            int retries = 0;
            do {
                try {
                    runningJob = (BRetrieveLogDataJob)runningJobOrd.get();
                }
                catch (UnresolvedException ignore) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            } while (runningJob == null && ++retries <= 10);
            if (runningJob != null) {
                runningJob.lease();
                while (runningJob.isAlive() && !runningJob.getJobState().isComplete()) {
                    try {
                        Thread.sleep(250L);
                        String jobLog = runningJob.readLog().getString();
                        this.setText(LEX.getText("LogData.progressMessage", new Object[]{runningJob.getProgress()}) + "\n" + jobLog);
                    }
                    catch (InterruptedException jobLog) {}
                }
                String errorMessage = "";
                String jobLog = runningJob.readLog().getString();
                if (runningJob.getJobState().equals((Object)BJobState.success)) {
                    try {
                        BString file = runningJob.dumpToFile();
                        this.setText(LEX.getText("LogData.progressMessage", new Object[]{runningJob.getProgress()}) + "\n" + jobLog + "\n" + LEX.getText("LogData.success", new Object[]{file.getString()}));
                    }
                    catch (Exception e) {
                        errorMessage = e.getMessage();
                    }
                }
                if (!runningJob.getJobState().equals((Object)BJobState.success) || !errorMessage.isEmpty()) {
                    this.setText(LEX.getText("LogData.progressMessage", new Object[]{runningJob.getProgress()}) + "\n" + jobLog + (!errorMessage.isEmpty() ? '\n' + errorMessage : "") + "\n" + LEX.get("LogData.failure"));
                }
                try {
                    jobService.remove((BComplex)runningJob);
                }
                catch (Exception exception) {}
            } else {
                this.setText(LEX.getText("LogData.nullJob", new Object[]{jobOrd}));
            }
            this.btnClose.setEnabled(true);
        });
        dialogThread.start();
    }
}

