/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.fieldEditors;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.actions.BNanoPropertyChangedArg;
import com.ismacontrolli.nE2Link.datatypes.choice.BDynamicChoice;
import com.ismacontrolli.nE2Link.ui.fieldEditors.BDynamicChoiceFE;
import com.tridium.workbench.fieldeditors.BStatusValueFE;
import com.tridium.workbench.util.WbUtil;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.ToggleCommand;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BNanoStatusValueFE
extends BStatusValueFE {
    public static final Type TYPE = Sys.loadType(BNanoStatusValueFE.class);
    protected static Lexicon LEX = Lexicon.make(BNanoStatusValueFE.class);
    protected static String LEX_KEY_CANNOT_SAVE_NO_PARENT = "NanoStatusValueFE.cannotSaveNoParent";
    protected static String LEX_KEY_CANNOT_SAVE_NO_SLOT = "NanoStatusValueFE.cannotSaveNoSlot";
    protected ToggleCommand nullToggle = new NullToggle((BWidget)this);

    public Type getType() {
        return TYPE;
    }

    public BNanoStatusValueFE() {
        this.isNull.setCommand((Command)this.nullToggle, false, false);
    }

    protected void doLoadValue(BObject raw, Context cx) throws Exception {
        BStatusValue sv = (BStatusValue)raw;
        BComponent parent = this.getValueParentComponent(raw);
        BStatusValue se = (BStatusValue)raw;
        BValue v = se.getValueValue();
        if (this.valueEditor == null) {
            this.valueEditor = BWbFieldEditor.makeFor((BObject)v);
            this.linkTo("lk0", (BComponent)this.valueEditor, (Slot)BWbFieldEditor.pluginModified, (Slot)setModified);
            this.linkTo("lk1", (BComponent)this.valueEditor, (Slot)BWbFieldEditor.actionPerformed, (Slot)actionPerformed);
            this.linkTo("lk2", (BComponent)this.isNull, (Slot)BCheckBox.selected, (Slot)setModified);
            this.editPane.add("null", (BValue)this.isNull);
            this.editPane.add("editor", (BValue)this.valueEditor);
        }
        this.valueEditor.loadValue((BObject)v, cx);
        this.isNull.setSelected(se.getStatus().isNull());
        String displayValue = se.toString(cx);
        this.summary.setText(displayValue);
        this.nullToggle.setSelected(this.isNull.isSelected());
        boolean allowNull = true;
        if (cx != null) {
            allowNull = cx.getFacets().getb("allowNull", true);
        }
        if (!allowNull) {
            this.isNull.setEnabled(false);
            this.isNull.setSelected(false);
        }
    }

    protected BObject doSaveValue(BObject raw, Context cx) throws Exception {
        boolean shouldWriteToNano;
        BComponent parent = this.getValueParentComponent(raw);
        if (parent == null || !(parent instanceof BNanoBaseComponent)) {
            throw new LocalizableRuntimeException(BNanoStatusValueFE.LEX.module.getModuleName(), LEX_KEY_CANNOT_SAVE_NO_PARENT);
        }
        BNanoBaseComponent sourceComponent = (BNanoBaseComponent)parent;
        Context callContext = this.getCurrentContext();
        boolean isProxyComponent = sourceComponent.getComponentSpace() != null && sourceComponent.getComponentSpace().isProxyComponentSpace();
        BFacets facets = callContext.getFacets();
        if (isProxyComponent) {
            sourceComponent.lease(1);
        }
        BStatusValue statusValue = (BStatusValue)raw;
        BStatusValue oldValue = (BStatusValue)statusValue.newCopy();
        BValue value = (BValue)this.valueEditor.saveValue(cx);
        BStatus status = this.isNull.isSelected() ? BStatus.nullStatus : BStatus.ok;
        statusValue.set(statusValue.getValueProperty(), value, null);
        statusValue.set(BStatusValue.status, (BValue)status, null);
        boolean bl = shouldWriteToNano = callContext != null && facets != null && !facets.getb("suppressWrite", false);
        if (shouldWriteToNano) {
            Integer slotId = BNanoBaseComponent.getNanoSlotId((BFacets)facets);
            Property changedProperty = sourceComponent.getNanoSlot(slotId);
            if (changedProperty == null) {
                throw new LocalizableRuntimeException(BNanoStatusValueFE.LEX.module.getModuleName(), LEX_KEY_CANNOT_SAVE_NO_SLOT, new Object[]{slotId});
            }
            BStatusValue pendingValue = (BStatusValue)statusValue.newCopy();
            pendingValue.set(pendingValue.getValueProperty(), value, null);
            pendingValue.set(BStatusValue.status, (BValue)status, null);
            if (changedProperty != null && !pendingValue.equivalent((Object)oldValue) && cx != null) {
                BNe2DeviceExt ne2DeviceExt = sourceComponent.getNe2DeviceExt();
                BNanoPropertyChangedArg changedArg = new BNanoPropertyChangedArg(sourceComponent, changedProperty, (BValue)oldValue, (BValue)pendingValue, this.getCurrentContext());
                ne2DeviceExt.handleNanoPropertyValueChange(changedArg);
            }
        }
        return statusValue;
    }

    public BComponent getValueParentComponent(BObject currentValue) {
        BComplex parent;
        BComplex bComplex = parent = currentValue instanceof BComplex ? ((BComplex)currentValue).getParent() : null;
        if (parent != null) {
            return parent.asComponent();
        }
        return (BNanoBaseComponent)WbUtil.findAncenstorViaWidgetTree((BWidget)this, (Type)BNanoBaseComponent.TYPE, (boolean)true);
    }

    class NullToggle
    extends ToggleCommand {
        NullToggle(BWidget owner) {
            super(owner, "null");
        }

        public void setSelected(boolean s) {
            super.setSelected(s);
            BWbFieldEditor valueEditor = BNanoStatusValueFE.this.valueEditor;
            if (valueEditor != null) {
                valueEditor.setReadonly(s);
            }
            if (valueEditor instanceof BDynamicChoiceFE) {
                BDynamicChoiceFE dynamicChoiceEditor = (BDynamicChoiceFE)valueEditor;
                BDynamicChoice currentChoice = (BDynamicChoice)((BStatusValue)BNanoStatusValueFE.this.getCurrentValue()).getValueValue().as(BDynamicChoice.class);
                if (currentChoice.getRange().length() == 0) {
                    if (!s) {
                        dynamicChoiceEditor.getFEWidget().setDropDownEnabled(false);
                        dynamicChoiceEditor.getFEWidget().getEditor().setEditable(true);
                    } else if (s) {
                        dynamicChoiceEditor.getFEWidget().setDropDownEnabled(false);
                        dynamicChoiceEditor.getFEWidget().getEditor().setEditable(false);
                    }
                }
            }
        }
    }
}

