/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.fieldEditors;

import com.ismacontrolli.nE2Link.datatypes.BBigInteger;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Locale;
import javax.baja.gx.BBrush;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextRenderer;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"nE2Link:BigInteger"})})
public class BBigIntegerFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BBigIntegerFE.class);
    BTextEditor textEditor;
    BigInteger min;
    BigInteger max;
    boolean mustBeSlotName = false;
    BBrush fg = BBrush.NULL;
    BBrush bg = BBrush.NULL;

    public Type getType() {
        return TYPE;
    }

    protected void doSetReadonly(boolean readonly) {
        if (this.textEditor != null) {
            this.textEditor.setEditable(!readonly);
        }
    }

    protected void doLoadValue(BObject value, Context cx) {
        if (!(value instanceof BBigInteger)) {
            return;
        }
        BBigInteger bigInt = (BBigInteger)value;
        this.min = bigInt.getMinValue();
        this.max = bigInt.getMaxValue();
        if (this.textEditor == null) {
            BInteger fw;
            int fieldWidth = 40;
            if (cx != null && (fw = (BInteger)cx.getFacet("fieldWidth")) != null) {
                fieldWidth = Math.max(fw.getInt(), 1);
            }
            BTextField field = new BTextField("", fieldWidth);
            this.linkTo((BComponent)field, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
            this.textEditor = field;
            this.textEditor.setRenderer((TextRenderer)new Renderer());
            this.setEditor((BWidget)this.textEditor);
            this.linkTo((BComponent)this.textEditor, (Slot)BTextEditor.textModified, (Slot)setModified);
            this.textEditor.setEditable(!this.isReadonly());
        }
        this.textEditor.setText(bigInt.toString(cx));
    }

    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException {
        String s;
        Lexicon lex = Lexicon.make((BModule)TYPE.getModule(), (Context)cx);
        String number = s = this.textEditor.getText();
        int xPos = s.toLowerCase(Locale.ROOT).indexOf("x");
        if (xPos != -1) {
            number = xPos < s.length() - 1 ? s.substring(xPos + 1) : "0";
            String sign = s.length() > 1 && (s.charAt(0) == '+' || s.charAt(0) == '-') ? s.substring(0, 1) : "";
            number = sign + number;
        }
        BigInteger bigInteger = null;
        try {
            bigInteger = new BigInteger(number);
        }
        catch (NumberFormatException e) {
            throw new CannotSaveException(lex.getText("BigIntegerFE.wrongFormat", new Object[]{e.toString()}));
        }
        if (bigInteger.compareTo(this.max) > 0) {
            throw new CannotSaveException(lex.getText("BigIntegerFE.tooLarge", new Object[]{bigInteger, this.max}));
        }
        if (bigInteger.compareTo(this.min) < 0) {
            throw new CannotSaveException(lex.getText("BigIntegerFE.tooSmall", new Object[]{bigInteger, this.min}));
        }
        Type type = Sys.getType(this.getCurrentValue().getClass());
        BBigInteger niagaraBigInt = (BBigInteger)type.getInstance();
        try {
            niagaraBigInt = (BBigInteger)niagaraBigInt.decodeFromString(bigInteger.toString());
        }
        catch (IOException e) {
            throw new CannotSaveException(lex.getText("BigIntegerFE.cannotDecode", new Object[]{bigInteger, this.getCurrentValue().getType().getTypeName()}));
        }
        return niagaraBigInt;
    }

    protected void setEditor(BWidget editor) {
        this.setContent(editor);
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 306: {
                this.fg = (BBrush)a;
                this.bg = (BBrush)b;
                this.repaint();
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    class Renderer
    extends TextRenderer {
        Renderer() {
        }

        public BBrush getBackground() {
            return BBigIntegerFE.this.bg.isNull() ? super.getBackground() : BBigIntegerFE.this.bg;
        }

        public BBrush getForeground(Segment seg) {
            return BBigIntegerFE.this.fg.isNull() ? super.getForeground(seg) : BBigIntegerFE.this.fg;
        }
    }
}

