/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.discover;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoDiscoverExtension;
import java.util.Objects;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;

public class DiscoverSlotEntry {
    private String slotName;
    private String resolvedSlotName;
    private Property resolvedProperty;
    private BValue originalValue;
    private BFacets originalFacets;

    public DiscoverSlotEntry(BNanoBaseComponent target, String slotName) {
        this(target, target.getDiscoveryExtensionOfType(null), slotName);
    }

    public DiscoverSlotEntry(BNanoBaseComponent target, BNanoDiscoverExtension discoverExtension, String slotName) {
        this.slotName = slotName;
        this.resolvedSlotName = discoverExtension.getHostNameForExtensionSlot(slotName);
        this.resolvedProperty = target.getProperty(this.resolvedSlotName);
        this.originalValue = target.get(this.resolvedProperty);
        this.originalFacets = target.getSlotFacets((Slot)this.resolvedProperty);
    }

    public String getSlotName() {
        return this.slotName;
    }

    public String getResolvedSlotName() {
        return this.resolvedSlotName;
    }

    public Property getResolvedProperty() {
        return this.resolvedProperty;
    }

    public BValue getOriginalValue() {
        return this.originalValue;
    }

    public BFacets getOriginalFacets() {
        return this.originalFacets;
    }

    public Context getOriginalContext(Context context) {
        return new BasicContext(context, this.originalFacets);
    }

    public Context getSuppressWriteContext(Context context) {
        return new BasicContext(context, BFacets.make((BFacets)this.originalFacets, (String)"suppressWrite", (BIDataValue)BBoolean.TRUE));
    }

    public String toString() {
        return "DiscoverSlotEntry{slotName='" + this.slotName + '\'' + ", resolvedSlotName='" + this.resolvedSlotName + '\'' + ", originalValue=" + this.originalValue + ", originalFacets=" + this.originalFacets + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoverSlotEntry that = (DiscoverSlotEntry)o;
        return this.slotName.equals(that.slotName) && Objects.equals(this.resolvedSlotName, that.resolvedSlotName) && Objects.equals(this.resolvedProperty, that.resolvedProperty) && Objects.equals(this.originalValue, that.originalValue) && Objects.equals(this.originalFacets, that.originalFacets);
    }

    public int hashCode() {
        return Objects.hash(this.slotName, this.resolvedSlotName, this.resolvedProperty, this.originalValue, this.originalFacets);
    }
}

